SET ANSI_NULLS ON

SET QUOTED_IDENTIFIER ON

SET ANSI_PADDING ON

CREATE TABLE [agents] (
  [UUID] [varchar](36) NOT NULL,
  [sessionID] [varchar](36) NOT NULL,
  [secureSessionID] [varchar](36) NOT NULL,
  [agentIP] [varchar](16) NOT NULL,
  [agentPort] [int] NOT NULL,
  [agentOnline] [tinyint] NOT NULL,
  [loginTime] [int] NOT NULL,
  [logoutTime] [int] NOT NULL,
  [currentRegion] [varchar](36) NOT NULL,
  [currentHandle] [bigint] NOT NULL,
  [currentPos] [varchar](64) NOT NULL,
  PRIMARY KEY CLUSTERED
(
	[UUID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]


CREATE NONCLUSTERED INDEX [session] ON [agents]
(
	[sessionID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]

CREATE NONCLUSTERED INDEX [ssession] ON [agents]
(
	[secureSessionID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]

SET ANSI_PADDING OFF

