using System;using Tools;
namespace OpenSim.Region.ScriptEngine.Shared.CodeTools {
//%+LSLProgramRoot+97
public class LSLProgramRoot : SYMBOL{
 public  LSLProgramRoot (Parser yyp, States  s ):base(((LSLSyntax
)yyp)){ while (0< s . kids . Count ) kids . Add ( s . kids . Pop ());
}
 public  LSLProgramRoot (Parser yyp, GlobalDefinitions  gd , States  s ):base(((LSLSyntax
)yyp)){ while (0< gd . kids . Count ) kids . Add ( gd . kids . Pop ());
 while (0< s . kids . Count ) kids . Add ( s . kids . Pop ());
}

public override string yyname { get { return "LSLProgramRoot"; }}
public override int yynum { get { return 97; }}
public LSLProgramRoot(Parser yyp):base(yyp){}}
//%+GlobalDefinitions+98
public class GlobalDefinitions : SYMBOL{
 public  GlobalDefinitions (Parser yyp, GlobalVariableDeclaration  gvd ):base(((LSLSyntax
)yyp)){ kids . Add ( gvd );
}
 public  GlobalDefinitions (Parser yyp, GlobalDefinitions  gd , GlobalVariableDeclaration  gvd ):base(((LSLSyntax
)yyp)){ while (0< gd . kids . Count ) kids . Add ( gd . kids . Pop ());
 kids . Add ( gvd );
}
 public  GlobalDefinitions (Parser yyp, GlobalFunctionDefinition  gfd ):base(((LSLSyntax
)yyp)){ kids . Add ( gfd );
}
 public  GlobalDefinitions (Parser yyp, GlobalDefinitions  gd , GlobalFunctionDefinition  gfd ):base(((LSLSyntax
)yyp)){ while (0< gd . kids . Count ) kids . Add ( gd . kids . Pop ());
 kids . Add ( gfd );
}

public override string yyname { get { return "GlobalDefinitions"; }}
public override int yynum { get { return 98; }}
public GlobalDefinitions(Parser yyp):base(yyp){}}
//%+GlobalVariableDeclaration+99
public class GlobalVariableDeclaration : SYMBOL{
 public  GlobalVariableDeclaration (Parser yyp, Declaration  d ):base(((LSLSyntax
)yyp)){ kids . Add ( d );
}
 public  GlobalVariableDeclaration (Parser yyp, Assignment  a ):base(((LSLSyntax
)yyp)){ kids . Add ( a );
}

public override string yyname { get { return "GlobalVariableDeclaration"; }}
public override int yynum { get { return 99; }}
public GlobalVariableDeclaration(Parser yyp):base(yyp){}}
//%+GlobalFunctionDefinition+100
public class GlobalFunctionDefinition : SYMBOL{
 private  string  m_returnType ;
 private  string  m_name ;
 public  GlobalFunctionDefinition (Parser yyp, string  returnType , string  name , ArgumentDeclarationList  adl , CompoundStatement  cs ):base(((LSLSyntax
)yyp)){ m_returnType = returnType ;
 m_name = name ;
 kids . Add ( adl );
 kids . Add ( cs );
}
 public  string  ReturnType { get { return  m_returnType ;
}
 set { m_returnType = value ;
}
}
 public  string  Name { get { return  m_name ;
}
}

public override string yyname { get { return "GlobalFunctionDefinition"; }}
public override int yynum { get { return 100; }}
public GlobalFunctionDefinition(Parser yyp):base(yyp){}}
//%+States+101
public class States : SYMBOL{
 public  States (Parser yyp, State  ds ):base(((LSLSyntax
)yyp)){ kids . Add ( ds );
}
 public  States (Parser yyp, States  s , State  us ):base(((LSLSyntax
)yyp)){ while (0< s . kids . Count ) kids . Add ( s . kids . Pop ());
 kids . Add ( us );
}

public override string yyname { get { return "States"; }}
public override int yynum { get { return 101; }}
public States(Parser yyp):base(yyp){}}
//%+State+102
public class State : SYMBOL{
 private  string  m_name ;
 public  State (Parser yyp, string  name , StateBody  sb ):base(((LSLSyntax
)yyp)){ m_name = name ;
 while (0< sb . kids . Count ) kids . Add ( sb . kids . Pop ());
}
 public  override  string  ToString (){ return "STATE<"+ m_name +">";
}
 public  string  Name { get { return  m_name ;
}
}

public override string yyname { get { return "State"; }}
public override int yynum { get { return 102; }}
public State(Parser yyp):base(yyp){}}
//%+StateBody+103
public class StateBody : SYMBOL{
 public  StateBody (Parser yyp, StateBody  sb , StateEvent  se ):base(((LSLSyntax
)yyp)){ while (0< sb . kids . Count ) kids . Add ( sb . kids . Pop ());
 kids . Add ( se );
}
 public  StateBody (Parser yyp, StateEvent  se ):base(((LSLSyntax
)yyp)){ kids . Add ( se );
}

public override string yyname { get { return "StateBody"; }}
public override int yynum { get { return 103; }}
public StateBody(Parser yyp):base(yyp){}}
//%+StateEvent+104
public class StateEvent : SYMBOL{
 private  string  m_name ;
 public  StateEvent (Parser yyp, string  name , CompoundStatement  cs ):base(((LSLSyntax
)yyp)){ m_name = name ;
 kids . Add ( cs );
}
 public  StateEvent (Parser yyp, string  name , ArgumentDeclarationList  adl , CompoundStatement  cs ):base(((LSLSyntax
)yyp)){ m_name = name ;
 if (0< adl . kids . Count ) kids . Add ( adl );
 kids . Add ( cs );
}
 public  override  string  ToString (){ return "EVENT<"+ m_name +">";
}
 public  string  Name { get { return  m_name ;
}
}

public override string yyname { get { return "StateEvent"; }}
public override int yynum { get { return 104; }}
public StateEvent(Parser yyp):base(yyp){}}
//%+VoidArgStateEvent+105
public class VoidArgStateEvent : StateEvent{
 public  VoidArgStateEvent (Parser yyp, string  name , CompoundStatement  cs ):base(((LSLSyntax
)yyp), name , cs ){}

public override string yyname { get { return "VoidArgStateEvent"; }}
public override int yynum { get { return 105; }}
public VoidArgStateEvent(Parser yyp):base(yyp){}}
//%+KeyArgStateEvent+106
public class KeyArgStateEvent : StateEvent{
 public  KeyArgStateEvent (Parser yyp, string  name , KeyArgumentDeclarationList  adl , CompoundStatement  cs ):base(((LSLSyntax
)yyp), name , adl , cs ){}

public override string yyname { get { return "KeyArgStateEvent"; }}
public override int yynum { get { return 106; }}
public KeyArgStateEvent(Parser yyp):base(yyp){}}
//%+IntArgStateEvent+107
public class IntArgStateEvent : StateEvent{
 public  IntArgStateEvent (Parser yyp, string  name , IntArgumentDeclarationList  adl , CompoundStatement  cs ):base(((LSLSyntax
)yyp), name , adl , cs ){}

public override string yyname { get { return "IntArgStateEvent"; }}
public override int yynum { get { return 107; }}
public IntArgStateEvent(Parser yyp):base(yyp){}}
//%+VectorArgStateEvent+108
public class VectorArgStateEvent : StateEvent{
 public  VectorArgStateEvent (Parser yyp, string  name , VectorArgumentDeclarationList  adl , CompoundStatement  cs ):base(((LSLSyntax
)yyp), name , adl , cs ){}

public override string yyname { get { return "VectorArgStateEvent"; }}
public override int yynum { get { return 108; }}
public VectorArgStateEvent(Parser yyp):base(yyp){}}
//%+IntRotRotArgStateEvent+109
public class IntRotRotArgStateEvent : StateEvent{
 public  IntRotRotArgStateEvent (Parser yyp, string  name , IntRotRotArgumentDeclarationList  adl , CompoundStatement  cs ):base(((LSLSyntax
)yyp), name , adl , cs ){}

public override string yyname { get { return "IntRotRotArgStateEvent"; }}
public override int yynum { get { return 109; }}
public IntRotRotArgStateEvent(Parser yyp):base(yyp){}}
//%+IntVecVecArgStateEvent+110
public class IntVecVecArgStateEvent : StateEvent{
 public  IntVecVecArgStateEvent (Parser yyp, string  name , IntVecVecArgumentDeclarationList  adl , CompoundStatement  cs ):base(((LSLSyntax
)yyp), name , adl , cs ){}

public override string yyname { get { return "IntVecVecArgStateEvent"; }}
public override int yynum { get { return 110; }}
public IntVecVecArgStateEvent(Parser yyp):base(yyp){}}
//%+KeyIntIntArgStateEvent+111
public class KeyIntIntArgStateEvent : StateEvent{
 public  KeyIntIntArgStateEvent (Parser yyp, string  name , KeyIntIntArgumentDeclarationList  adl , CompoundStatement  cs ):base(((LSLSyntax
)yyp), name , adl , cs ){}

public override string yyname { get { return "KeyIntIntArgStateEvent"; }}
public override int yynum { get { return 111; }}
public KeyIntIntArgStateEvent(Parser yyp):base(yyp){}}
//%+ArgumentDeclarationList+112
public class ArgumentDeclarationList : SYMBOL{
 public  ArgumentDeclarationList (Parser yyp, Declaration  d ):base(((LSLSyntax
)yyp)){ kids . Add ( d );
}
 public  ArgumentDeclarationList (Parser yyp, Declaration  d , Declaration  d2 ):base(((LSLSyntax
)yyp)){ kids . Add ( d );
 kids . Add ( d2 );
}
 public  ArgumentDeclarationList (Parser yyp, Declaration  d , Declaration  d2 , Declaration  d3 ):base(((LSLSyntax
)yyp)){ kids . Add ( d );
 kids . Add ( d2 );
 kids . Add ( d3 );
}
 public  ArgumentDeclarationList (Parser yyp, ArgumentDeclarationList  adl , Declaration  d ):base(((LSLSyntax
)yyp)){ while (0< adl . kids . Count ) kids . Add ( adl . kids . Pop ());
 kids . Add ( d );
}

public override string yyname { get { return "ArgumentDeclarationList"; }}
public override int yynum { get { return 112; }}
public ArgumentDeclarationList(Parser yyp):base(yyp){}}
//%+KeyArgumentDeclarationList+113
public class KeyArgumentDeclarationList : ArgumentDeclarationList{
 public  KeyArgumentDeclarationList (Parser yyp, KeyDeclaration  d ):base(((LSLSyntax
)yyp), d ){}

public override string yyname { get { return "KeyArgumentDeclarationList"; }}
public override int yynum { get { return 113; }}
public KeyArgumentDeclarationList(Parser yyp):base(yyp){}}
//%+IntArgumentDeclarationList+114
public class IntArgumentDeclarationList : ArgumentDeclarationList{
 public  IntArgumentDeclarationList (Parser yyp, IntDeclaration  d ):base(((LSLSyntax
)yyp), d ){}

public override string yyname { get { return "IntArgumentDeclarationList"; }}
public override int yynum { get { return 114; }}
public IntArgumentDeclarationList(Parser yyp):base(yyp){}}
//%+VectorArgumentDeclarationList+115
public class VectorArgumentDeclarationList : ArgumentDeclarationList{
 public  VectorArgumentDeclarationList (Parser yyp, VecDeclaration  d ):base(((LSLSyntax
)yyp), d ){}

public override string yyname { get { return "VectorArgumentDeclarationList"; }}
public override int yynum { get { return 115; }}
public VectorArgumentDeclarationList(Parser yyp):base(yyp){}}
//%+IntRotRotArgumentDeclarationList+116
public class IntRotRotArgumentDeclarationList : ArgumentDeclarationList{
 public  IntRotRotArgumentDeclarationList (Parser yyp, Declaration  d1 , Declaration  d2 , Declaration  d3 ):base(((LSLSyntax
)yyp), d1 , d2 , d3 ){}

public override string yyname { get { return "IntRotRotArgumentDeclarationList"; }}
public override int yynum { get { return 116; }}
public IntRotRotArgumentDeclarationList(Parser yyp):base(yyp){}}
//%+IntVecVecArgumentDeclarationList+117
public class IntVecVecArgumentDeclarationList : ArgumentDeclarationList{
 public  IntVecVecArgumentDeclarationList (Parser yyp, Declaration  d1 , Declaration  d2 , Declaration  d3 ):base(((LSLSyntax
)yyp), d1 , d2 , d3 ){}

public override string yyname { get { return "IntVecVecArgumentDeclarationList"; }}
public override int yynum { get { return 117; }}
public IntVecVecArgumentDeclarationList(Parser yyp):base(yyp){}}
//%+KeyIntIntArgumentDeclarationList+118
public class KeyIntIntArgumentDeclarationList : ArgumentDeclarationList{
 public  KeyIntIntArgumentDeclarationList (Parser yyp, Declaration  d1 , Declaration  d2 , Declaration  d3 ):base(((LSLSyntax
)yyp), d1 , d2 , d3 ){}

public override string yyname { get { return "KeyIntIntArgumentDeclarationList"; }}
public override int yynum { get { return 118; }}
public KeyIntIntArgumentDeclarationList(Parser yyp):base(yyp){}}
//%+Declaration+119
public class Declaration : SYMBOL{
 private  string  m_datatype ;
 private  string  m_id ;
 public  Declaration (Parser yyp, string  type , string  id ):base(((LSLSyntax
)yyp)){ m_datatype = type ;
 m_id = id ;
}
 public  override  string  ToString (){ return "Declaration<"+ m_datatype +":"+ m_id +">";
}
 public  string  Datatype { get { return  m_datatype ;
}
 set { m_datatype = value ;
}
}
 public  string  Id { get { return  m_id ;
}
}

public override string yyname { get { return "Declaration"; }}
public override int yynum { get { return 119; }}
public Declaration(Parser yyp):base(yyp){}}
//%+KeyDeclaration+120
public class KeyDeclaration : Declaration{
 public  KeyDeclaration (Parser yyp, string  type , string  id ):base(((LSLSyntax
)yyp), type , id ){}

public override string yyname { get { return "KeyDeclaration"; }}
public override int yynum { get { return 120; }}
public KeyDeclaration(Parser yyp):base(yyp){}}
//%+IntDeclaration+121
public class IntDeclaration : Declaration{
 public  IntDeclaration (Parser yyp, string  type , string  id ):base(((LSLSyntax
)yyp), type , id ){}

public override string yyname { get { return "IntDeclaration"; }}
public override int yynum { get { return 121; }}
public IntDeclaration(Parser yyp):base(yyp){}}
//%+VecDeclaration+122
public class VecDeclaration : Declaration{
 public  VecDeclaration (Parser yyp, string  type , string  id ):base(((LSLSyntax
)yyp), type , id ){}

public override string yyname { get { return "VecDeclaration"; }}
public override int yynum { get { return 122; }}
public VecDeclaration(Parser yyp):base(yyp){}}
//%+RotDeclaration+123
public class RotDeclaration : Declaration{
 public  RotDeclaration (Parser yyp, string  type , string  id ):base(((LSLSyntax
)yyp), type , id ){}

public override string yyname { get { return "RotDeclaration"; }}
public override int yynum { get { return 123; }}
public RotDeclaration(Parser yyp):base(yyp){}}
//%+Typename+124
public class Typename : SYMBOL{
 public  string  yytext ;
 public  Typename (Parser yyp, string  text ):base(((LSLSyntax
)yyp)){ yytext = text ;
}

public override string yyname { get { return "Typename"; }}
public override int yynum { get { return 124; }}
public Typename(Parser yyp):base(yyp){}}
//%+Event+125
public class Event : SYMBOL{
 public  string  yytext ;
 public  Event (Parser yyp, string  text ):base(((LSLSyntax
)yyp)){ yytext = text ;
}

public override string yyname { get { return "Event"; }}
public override int yynum { get { return 125; }}
public Event(Parser yyp):base(yyp){}}
//%+VoidArgEvent+126
public class VoidArgEvent : Event{
 public  VoidArgEvent (Parser yyp, string  text ):base(((LSLSyntax
)yyp), text ){}

public override string yyname { get { return "VoidArgEvent"; }}
public override int yynum { get { return 126; }}
public VoidArgEvent(Parser yyp):base(yyp){}}
//%+KeyArgEvent+127
public class KeyArgEvent : Event{
 public  KeyArgEvent (Parser yyp, string  text ):base(((LSLSyntax
)yyp), text ){}

public override string yyname { get { return "KeyArgEvent"; }}
public override int yynum { get { return 127; }}
public KeyArgEvent(Parser yyp):base(yyp){}}
//%+IntArgEvent+128
public class IntArgEvent : Event{
 public  IntArgEvent (Parser yyp, string  text ):base(((LSLSyntax
)yyp), text ){}

public override string yyname { get { return "IntArgEvent"; }}
public override int yynum { get { return 128; }}
public IntArgEvent(Parser yyp):base(yyp){}}
//%+VectorArgEvent+129
public class VectorArgEvent : Event{
 public  VectorArgEvent (Parser yyp, string  text ):base(((LSLSyntax
)yyp), text ){}

public override string yyname { get { return "VectorArgEvent"; }}
public override int yynum { get { return 129; }}
public VectorArgEvent(Parser yyp):base(yyp){}}
//%+IntRotRotArgEvent+130
public class IntRotRotArgEvent : Event{
 public  IntRotRotArgEvent (Parser yyp, string  text ):base(((LSLSyntax
)yyp), text ){}

public override string yyname { get { return "IntRotRotArgEvent"; }}
public override int yynum { get { return 130; }}
public IntRotRotArgEvent(Parser yyp):base(yyp){}}
//%+IntVecVecArgEvent+131
public class IntVecVecArgEvent : Event{
 public  IntVecVecArgEvent (Parser yyp, string  text ):base(((LSLSyntax
)yyp), text ){}

public override string yyname { get { return "IntVecVecArgEvent"; }}
public override int yynum { get { return 131; }}
public IntVecVecArgEvent(Parser yyp):base(yyp){}}
//%+KeyIntIntArgEvent+132
public class KeyIntIntArgEvent : Event{
 public  KeyIntIntArgEvent (Parser yyp, string  text ):base(((LSLSyntax
)yyp), text ){}

public override string yyname { get { return "KeyIntIntArgEvent"; }}
public override int yynum { get { return 132; }}
public KeyIntIntArgEvent(Parser yyp):base(yyp){}}
//%+CompoundStatement+133
public class CompoundStatement : SYMBOL{
 public  CompoundStatement (Parser yyp):base(((LSLSyntax
)yyp)){}
 public  CompoundStatement (Parser yyp, StatementList  sl ):base(((LSLSyntax
)yyp)){ while (0< sl . kids . Count ) kids . Add ( sl . kids . Pop ());
}

public override string yyname { get { return "CompoundStatement"; }}
public override int yynum { get { return 133; }}
}
//%+StatementList+134
public class StatementList : SYMBOL{
 private  void  AddStatement ( Statement  s ){ if ( s . kids . Top  is  IfStatement || s . kids . Top  is  WhileStatement || s . kids . Top  is  DoWhileStatement || s . kids . Top  is  ForLoop ) kids . Add ( s . kids . Pop ());
 else  kids . Add ( s );
}
 public  StatementList (Parser yyp, Statement  s ):base(((LSLSyntax
)yyp)){ AddStatement ( s );
}
 public  StatementList (Parser yyp, StatementList  sl , Statement  s ):base(((LSLSyntax
)yyp)){ while (0< sl . kids . Count ) kids . Add ( sl . kids . Pop ());
 AddStatement ( s );
}

public override string yyname { get { return "StatementList"; }}
public override int yynum { get { return 134; }}
public StatementList(Parser yyp):base(yyp){}}
//%+Statement+135
public class Statement : SYMBOL{
 public  Statement (Parser yyp, Declaration  d ):base(((LSLSyntax
)yyp)){ kids . Add ( d );
}
 public  Statement (Parser yyp, CompoundStatement  cs ):base(((LSLSyntax
)yyp)){ kids . Add ( cs );
}
 public  Statement (Parser yyp, FunctionCall  fc ):base(((LSLSyntax
)yyp)){ kids . Add ( fc );
}
 public  Statement (Parser yyp, Assignment  a ):base(((LSLSyntax
)yyp)){ kids . Add ( a );
}
 public  Statement (Parser yyp, Expression  e ):base(((LSLSyntax
)yyp)){ kids . Add ( e );
}
 public  Statement (Parser yyp, ReturnStatement  rs ):base(((LSLSyntax
)yyp)){ kids . Add ( rs );
}
 public  Statement (Parser yyp, StateChange  sc ):base(((LSLSyntax
)yyp)){ kids . Add ( sc );
}
 public  Statement (Parser yyp, IfStatement  ifs ):base(((LSLSyntax
)yyp)){ kids . Add ( ifs );
}
 public  Statement (Parser yyp, WhileStatement  ifs ):base(((LSLSyntax
)yyp)){ kids . Add ( ifs );
}
 public  Statement (Parser yyp, DoWhileStatement  ifs ):base(((LSLSyntax
)yyp)){ kids . Add ( ifs );
}
 public  Statement (Parser yyp, ForLoop  fl ):base(((LSLSyntax
)yyp)){ kids . Add ( fl );
}
 public  Statement (Parser yyp, JumpLabel  jl ):base(((LSLSyntax
)yyp)){ kids . Add ( jl );
}
 public  Statement (Parser yyp, JumpStatement  js ):base(((LSLSyntax
)yyp)){ kids . Add ( js );
}
 public  Statement (Parser yyp, EmptyStatement  es ):base(((LSLSyntax
)yyp)){ kids . Add ( es );
}

public override string yyname { get { return "Statement"; }}
public override int yynum { get { return 135; }}
public Statement(Parser yyp):base(yyp){}}
//%+EmptyStatement+136
public class EmptyStatement : SYMBOL{
 public  EmptyStatement (Parser yyp):base(((LSLSyntax
)yyp)){}
 public  override  string  ToString (){ return  base . ToString ();
}

public override string yyname { get { return "EmptyStatement"; }}
public override int yynum { get { return 136; }}
}
//%+Assignment+137
public class Assignment : SYMBOL{
 protected  string  m_assignmentType ;
 public  Assignment (Parser yyp, SYMBOL  lhs , SYMBOL  rhs , string  assignmentType ):base(((LSLSyntax
)yyp)){ m_assignmentType = assignmentType ;
 kids . Add ( lhs );
 if ( rhs  is  ConstantExpression ) while (0< rhs . kids . Count ) kids . Add ( rhs . kids . Pop ());
 else  kids . Add ( rhs );
}
 public  Assignment (Parser yyp, SimpleAssignment  sa ):base(((LSLSyntax
)yyp)){ m_assignmentType = sa . AssignmentType ;
 while (0< sa . kids . Count ) kids . Add ( sa . kids . Pop ());
}
 public  string  AssignmentType { get { return  m_assignmentType ;
}
}
 public  override  string  ToString (){ return  base . ToString ()+"<"+ m_assignmentType +">";
}

public override string yyname { get { return "Assignment"; }}
public override int yynum { get { return 137; }}
public Assignment(Parser yyp):base(yyp){}}
//%+SimpleAssignment+138
public class SimpleAssignment : Assignment{
 public  SimpleAssignment (Parser yyp, SYMBOL  lhs , SYMBOL  rhs , string  assignmentType ):base(((LSLSyntax
)yyp)){ m_assignmentType = assignmentType ;
 kids . Add ( lhs );
 if ( rhs  is  ConstantExpression ) while (0< rhs . kids . Count ) kids . Add ( rhs . kids . Pop ());
 else  kids . Add ( rhs );
}

public override string yyname { get { return "SimpleAssignment"; }}
public override int yynum { get { return 138; }}
public SimpleAssignment(Parser yyp):base(yyp){}}
//%+ReturnStatement+139
public class ReturnStatement : SYMBOL{
 public  ReturnStatement (Parser yyp):base(((LSLSyntax
)yyp)){}
 public  ReturnStatement (Parser yyp, Expression  e ):base(((LSLSyntax
)yyp)){ if ( e  is  ConstantExpression ) while (0< e . kids . Count ) kids . Add ( e . kids . Pop ());
 else  kids . Add ( e );
}

public override string yyname { get { return "ReturnStatement"; }}
public override int yynum { get { return 139; }}
}
//%+JumpLabel+140
public class JumpLabel : SYMBOL{
 private  string  m_labelName ;
 public  JumpLabel (Parser yyp, string  labelName ):base(((LSLSyntax
)yyp)){ m_labelName = labelName ;
}
 public  string  LabelName { get { return  m_labelName ;
}
}
 public  override  string  ToString (){ return  base . ToString ()+"<"+ m_labelName +">";
}

public override string yyname { get { return "JumpLabel"; }}
public override int yynum { get { return 140; }}
public JumpLabel(Parser yyp):base(yyp){}}
//%+JumpStatement+141
public class JumpStatement : SYMBOL{
 private  string  m_targetName ;
 public  JumpStatement (Parser yyp, string  targetName ):base(((LSLSyntax
)yyp)){ m_targetName = targetName ;
}
 public  string  TargetName { get { return  m_targetName ;
}
}
 public  override  string  ToString (){ return  base . ToString ()+"<"+ m_targetName +">";
}

public override string yyname { get { return "JumpStatement"; }}
public override int yynum { get { return 141; }}
public JumpStatement(Parser yyp):base(yyp){}}
//%+StateChange+142
public class StateChange : SYMBOL{
 private  string  m_newState ;
 public  StateChange (Parser yyp, string  newState ):base(((LSLSyntax
)yyp)){ m_newState = newState ;
}
 public  string  NewState { get { return  m_newState ;
}
}

public override string yyname { get { return "StateChange"; }}
public override int yynum { get { return 142; }}
public StateChange(Parser yyp):base(yyp){}}
//%+IfStatement+143
public class IfStatement : SYMBOL{
 private  void  AddStatement ( Statement  s ){ if (0< s . kids . Count && s . kids . Top  is  CompoundStatement ) kids . Add ( s . kids . Pop ());
 else  kids . Add ( s );
}
 public  IfStatement (Parser yyp, SYMBOL  s , Statement  ifs ):base(((LSLSyntax
)yyp)){ kids . Add ( s );
 AddStatement ( ifs );
}
 public  IfStatement (Parser yyp, SYMBOL  s , Statement  ifs , Statement  es ):base(((LSLSyntax
)yyp)){ kids . Add ( s );
 AddStatement ( ifs );
 if (0< es . kids . Count && es . kids . Top  is  IfStatement ) kids . Add ( es . kids . Pop ());
 else  AddStatement ( es );
}

public override string yyname { get { return "IfStatement"; }}
public override int yynum { get { return 143; }}
public IfStatement(Parser yyp):base(yyp){}}
//%+WhileStatement+144
public class WhileStatement : SYMBOL{
 public  WhileStatement (Parser yyp, SYMBOL  s , Statement  st ):base(((LSLSyntax
)yyp)){ kids . Add ( s );
 if (0< st . kids . Count && st . kids . Top  is  CompoundStatement ) kids . Add ( st . kids . Pop ());
 else  kids . Add ( st );
}

public override string yyname { get { return "WhileStatement"; }}
public override int yynum { get { return 144; }}
public WhileStatement(Parser yyp):base(yyp){}}
//%+DoWhileStatement+145
public class DoWhileStatement : SYMBOL{
 public  DoWhileStatement (Parser yyp, SYMBOL  s , Statement  st ):base(((LSLSyntax
)yyp)){ if (0< st . kids . Count && st . kids . Top  is  CompoundStatement ) kids . Add ( st . kids . Pop ());
 else  kids . Add ( st );
 kids . Add ( s );
}

public override string yyname { get { return "DoWhileStatement"; }}
public override int yynum { get { return 145; }}
public DoWhileStatement(Parser yyp):base(yyp){}}
//%+ForLoop+146
public class ForLoop : SYMBOL{
 public  ForLoop (Parser yyp, ForLoopStatement  flsa , Expression  e , ForLoopStatement  flsb , Statement  s ):base(((LSLSyntax
)yyp)){ kids . Add ( flsa );
 kids . Add ( e );
 kids . Add ( flsb );
 if (0< s . kids . Count && s . kids . Top  is  CompoundStatement ) kids . Add ( s . kids . Pop ());
 else  kids . Add ( s );
}

public override string yyname { get { return "ForLoop"; }}
public override int yynum { get { return 146; }}
public ForLoop(Parser yyp):base(yyp){}}
//%+ForLoopStatement+147
public class ForLoopStatement : SYMBOL{
 public  ForLoopStatement (Parser yyp, Expression  e ):base(((LSLSyntax
)yyp)){ kids . Add ( e );
}
 public  ForLoopStatement (Parser yyp, SimpleAssignment  sa ):base(((LSLSyntax
)yyp)){ kids . Add ( sa );
}
 public  ForLoopStatement (Parser yyp, ForLoopStatement  fls , Expression  e ):base(((LSLSyntax
)yyp)){ while (0< fls . kids . Count ) kids . Add ( fls . kids . Pop ());
 kids . Add ( e );
}
 public  ForLoopStatement (Parser yyp, ForLoopStatement  fls , SimpleAssignment  sa ):base(((LSLSyntax
)yyp)){ while (0< fls . kids . Count ) kids . Add ( fls . kids . Pop ());
 kids . Add ( sa );
}

public override string yyname { get { return "ForLoopStatement"; }}
public override int yynum { get { return 147; }}
public ForLoopStatement(Parser yyp):base(yyp){}}
//%+FunctionCall+148
public class FunctionCall : SYMBOL{
 private  string  m_id ;
 public  FunctionCall (Parser yyp, string  id , ArgumentList  al ):base(((LSLSyntax
)yyp)){ m_id = id ;
 kids . Add ( al );
}
 public  override  string  ToString (){ return  base . ToString ()+"<"+ m_id +">";
}
 public  string  Id { get { return  m_id ;
}
}

public override string yyname { get { return "FunctionCall"; }}
public override int yynum { get { return 148; }}
public FunctionCall(Parser yyp):base(yyp){}}
//%+ArgumentList+149
public class ArgumentList : SYMBOL{
 public  ArgumentList (Parser yyp, Argument  a ):base(((LSLSyntax
)yyp)){ AddArgument ( a );
}
 public  ArgumentList (Parser yyp, ArgumentList  al , Argument  a ):base(((LSLSyntax
)yyp)){ while (0< al . kids . Count ) kids . Add ( al . kids . Pop ());
 AddArgument ( a );
}
 private  void  AddArgument ( Argument  a ){ if ( a  is  ExpressionArgument ) while (0< a . kids . Count ) kids . Add ( a . kids . Pop ());
 else  kids . Add ( a );
}

public override string yyname { get { return "ArgumentList"; }}
public override int yynum { get { return 149; }}
public ArgumentList(Parser yyp):base(yyp){}}
//%+Argument+150
public class Argument : SYMBOL{
public override string yyname { get { return "Argument"; }}
public override int yynum { get { return 150; }}
public Argument(Parser yyp):base(yyp){}}
//%+ExpressionArgument+151
public class ExpressionArgument : Argument{
 public  ExpressionArgument (Parser yyp, Expression  e ):base(((LSLSyntax
)yyp)){ if ( e  is  ConstantExpression ) while (0< e . kids . Count ) kids . Add ( e . kids . Pop ());
 else  kids . Add ( e );
}

public override string yyname { get { return "ExpressionArgument"; }}
public override int yynum { get { return 151; }}
public ExpressionArgument(Parser yyp):base(yyp){}}
//%+Constant+152
public class Constant : SYMBOL{
 private  string  m_type ;
 private  string  m_val ;
 public  Constant (Parser yyp, string  type , string  val ):base(((LSLSyntax
)yyp)){ m_type = type ;
 m_val = val ;
}
 public  override  string  ToString (){ return  base . ToString ()+"<"+ m_type +":"+ m_val +">";
}
 public  string  Value { get { return  m_val ;
}
 set { m_val = value ;
}
}
 public  string  Type { get { return  m_type ;
}
 set { m_type = value ;
}
}

public override string yyname { get { return "Constant"; }}
public override int yynum { get { return 152; }}
public Constant(Parser yyp):base(yyp){}}
//%+VectorConstant+153
public class VectorConstant : Constant{
 public  VectorConstant (Parser yyp, Expression  valX , Expression  valY , Expression  valZ ):base(((LSLSyntax
)yyp),"vector", null ){ kids . Add ( valX );
 kids . Add ( valY );
 kids . Add ( valZ );
}

public override string yyname { get { return "VectorConstant"; }}
public override int yynum { get { return 153; }}
public VectorConstant(Parser yyp):base(yyp){}}
//%+RotationConstant+154
public class RotationConstant : Constant{
 public  RotationConstant (Parser yyp, Expression  valX , Expression  valY , Expression  valZ , Expression  valS ):base(((LSLSyntax
)yyp),"rotation", null ){ kids . Add ( valX );
 kids . Add ( valY );
 kids . Add ( valZ );
 kids . Add ( valS );
}

public override string yyname { get { return "RotationConstant"; }}
public override int yynum { get { return 154; }}
public RotationConstant(Parser yyp):base(yyp){}}
//%+ListConstant+155
public class ListConstant : Constant{
 public  ListConstant (Parser yyp, ArgumentList  al ):base(((LSLSyntax
)yyp),"list", null ){ kids . Add ( al );
}

public override string yyname { get { return "ListConstant"; }}
public override int yynum { get { return 155; }}
public ListConstant(Parser yyp):base(yyp){}}
//%+Expression+156
public class Expression : SYMBOL{
 protected  void  AddExpression ( Expression  e ){ if ( e  is  ConstantExpression ) while (0< e . kids . Count ) kids . Add ( e . kids . Pop ());
 else  kids . Add ( e );
}

public override string yyname { get { return "Expression"; }}
public override int yynum { get { return 156; }}
public Expression(Parser yyp):base(yyp){}}
//%+ConstantExpression+157
public class ConstantExpression : Expression{
 public  ConstantExpression (Parser yyp, Constant  c ):base(((LSLSyntax
)yyp)){ kids . Add ( c );
}

public override string yyname { get { return "ConstantExpression"; }}
public override int yynum { get { return 157; }}
public ConstantExpression(Parser yyp):base(yyp){}}
//%+IdentExpression+158
public class IdentExpression : Expression{
 protected  string  m_name ;
 public  IdentExpression (Parser yyp, string  name ):base(((LSLSyntax
)yyp)){ m_name = name ;
}
 public  override  string  ToString (){ return  base . ToString ()+"<"+ m_name +">";
}
 public  string  Name { get { return  m_name ;
}
}

public override string yyname { get { return "IdentExpression"; }}
public override int yynum { get { return 158; }}
public IdentExpression(Parser yyp):base(yyp){}}
//%+IdentDotExpression+159
public class IdentDotExpression : IdentExpression{
 private  string  m_member ;
 public  IdentDotExpression (Parser yyp, string  name , string  member ):base(((LSLSyntax
)yyp), name ){ m_member = member ;
}
 public  override  string  ToString (){ string  baseToString = base . ToString ();
 return  baseToString . Substring (0, baseToString . Length -1)+"."+ m_member +">";
}
 public  string  Member { get { return  m_member ;
}
}

public override string yyname { get { return "IdentDotExpression"; }}
public override int yynum { get { return 159; }}
public IdentDotExpression(Parser yyp):base(yyp){}}
//%+FunctionCallExpression+160
public class FunctionCallExpression : Expression{
 public  FunctionCallExpression (Parser yyp, FunctionCall  fc ):base(((LSLSyntax
)yyp)){ kids . Add ( fc );
}

public override string yyname { get { return "FunctionCallExpression"; }}
public override int yynum { get { return 160; }}
public FunctionCallExpression(Parser yyp):base(yyp){}}
//%+BinaryExpression+161
public class BinaryExpression : Expression{
 private  string  m_expressionSymbol ;
 public  BinaryExpression (Parser yyp, Expression  lhs , Expression  rhs , string  expressionSymbol ):base(((LSLSyntax
)yyp)){ m_expressionSymbol = expressionSymbol ;
 AddExpression ( lhs );
 AddExpression ( rhs );
}
 public  string  ExpressionSymbol { get { return  m_expressionSymbol ;
}
}
 public  override  string  ToString (){ return  base . ToString ()+"<"+ m_expressionSymbol +">";
}

public override string yyname { get { return "BinaryExpression"; }}
public override int yynum { get { return 161; }}
public BinaryExpression(Parser yyp):base(yyp){}}
//%+UnaryExpression+162
public class UnaryExpression : Expression{
 private  string  m_unarySymbol ;
 public  UnaryExpression (Parser yyp, string  unarySymbol , Expression  e ):base(((LSLSyntax
)yyp)){ m_unarySymbol = unarySymbol ;
 AddExpression ( e );
}
 public  string  UnarySymbol { get { return  m_unarySymbol ;
}
}
 public  override  string  ToString (){ return  base . ToString ()+"<"+ m_unarySymbol +">";
}

public override string yyname { get { return "UnaryExpression"; }}
public override int yynum { get { return 162; }}
public UnaryExpression(Parser yyp):base(yyp){}}
//%+TypecastExpression+163
public class TypecastExpression : Expression{
 private  string  m_typecastType ;
 public  TypecastExpression (Parser yyp, string  typecastType , SYMBOL  rhs ):base(((LSLSyntax
)yyp)){ m_typecastType = typecastType ;
 kids . Add ( rhs );
}
 public  string  TypecastType { get { return  m_typecastType ;
}
 set { m_typecastType = value ;
}
}

public override string yyname { get { return "TypecastExpression"; }}
public override int yynum { get { return 163; }}
public TypecastExpression(Parser yyp):base(yyp){}}
//%+ParenthesisExpression+164
public class ParenthesisExpression : Expression{
 public  ParenthesisExpression (Parser yyp, SYMBOL  s ):base(((LSLSyntax
)yyp)){ kids . Add ( s );
}

public override string yyname { get { return "ParenthesisExpression"; }}
public override int yynum { get { return 164; }}
public ParenthesisExpression(Parser yyp):base(yyp){}}
//%+IncrementDecrementExpression+165
public class IncrementDecrementExpression : Expression{
 private  string  m_name ;
 private  string  m_operation ;
 private  bool  m_postOperation ;
 public  IncrementDecrementExpression (Parser yyp, string  name , string  operation , bool  postOperation ):base(((LSLSyntax
)yyp)){ m_name = name ;
 m_operation = operation ;
 m_postOperation = postOperation ;
}
 public  IncrementDecrementExpression (Parser yyp, IdentDotExpression  ide , string  operation , bool  postOperation ):base(((LSLSyntax
)yyp)){ m_operation = operation ;
 m_postOperation = postOperation ;
 kids . Add ( ide );
}
 public  override  string  ToString (){ return  base . ToString ()+"<"+( m_postOperation ? m_name + m_operation : m_operation + m_name )+">";
}
 public  string  Name { get { return  m_name ;
}
}
 public  string  Operation { get { return  m_operation ;
}
}
 public  bool  PostOperation { get { return  m_postOperation ;
}
}

public override string yyname { get { return "IncrementDecrementExpression"; }}
public override int yynum { get { return 165; }}
public IncrementDecrementExpression(Parser yyp):base(yyp){}}

public class LSLProgramRoot_1 : LSLProgramRoot {
  public LSLProgramRoot_1(Parser yyq):base(yyq,
	((GlobalDefinitions)(yyq.StackAt(1).m_value))
	, 
	((States)(yyq.StackAt(0).m_value))
	){}}

public class LSLProgramRoot_2 : LSLProgramRoot {
  public LSLProgramRoot_2(Parser yyq):base(yyq,
	((States)(yyq.StackAt(0).m_value))
	){}}

public class GlobalDefinitions_1 : GlobalDefinitions {
  public GlobalDefinitions_1(Parser yyq):base(yyq,
	((GlobalVariableDeclaration)(yyq.StackAt(0).m_value))
	){}}

public class GlobalDefinitions_2 : GlobalDefinitions {
  public GlobalDefinitions_2(Parser yyq):base(yyq,
	((GlobalDefinitions)(yyq.StackAt(1).m_value))
	, 
	((GlobalVariableDeclaration)(yyq.StackAt(0).m_value))
	){}}

public class GlobalDefinitions_3 : GlobalDefinitions {
  public GlobalDefinitions_3(Parser yyq):base(yyq,
	((GlobalFunctionDefinition)(yyq.StackAt(0).m_value))
	){}}

public class GlobalDefinitions_4 : GlobalDefinitions {
  public GlobalDefinitions_4(Parser yyq):base(yyq,
	((GlobalDefinitions)(yyq.StackAt(1).m_value))
	, 
	((GlobalFunctionDefinition)(yyq.StackAt(0).m_value))
	){}}

public class GlobalVariableDeclaration_1 : GlobalVariableDeclaration {
  public GlobalVariableDeclaration_1(Parser yyq):base(yyq,
	((Declaration)(yyq.StackAt(1).m_value))
	){}}

public class GlobalVariableDeclaration_2 : GlobalVariableDeclaration {
  public GlobalVariableDeclaration_2(Parser yyq):base(yyq,new Assignment(((LSLSyntax
)yyq), 
	((Declaration)(yyq.StackAt(3).m_value))
	, 
	((Expression)(yyq.StackAt(1).m_value))
	, 
	((EQUALS)(yyq.StackAt(2).m_value))
	.yytext)){}}

public class GlobalFunctionDefinition_1 : GlobalFunctionDefinition {
  public GlobalFunctionDefinition_1(Parser yyq):base(yyq,"void", 
	((IDENT)(yyq.StackAt(4).m_value))
	.yytext, 
	((ArgumentDeclarationList)(yyq.StackAt(2).m_value))
	, 
	((CompoundStatement)(yyq.StackAt(0).m_value))
	){}}

public class GlobalFunctionDefinition_2 : GlobalFunctionDefinition {
  public GlobalFunctionDefinition_2(Parser yyq):base(yyq,
	((Typename)(yyq.StackAt(5).m_value))
	.yytext, 
	((IDENT)(yyq.StackAt(4).m_value))
	.yytext, 
	((ArgumentDeclarationList)(yyq.StackAt(2).m_value))
	, 
	((CompoundStatement)(yyq.StackAt(0).m_value))
	){}}

public class States_1 : States {
  public States_1(Parser yyq):base(yyq,
	((State)(yyq.StackAt(0).m_value))
	){}}

public class States_2 : States {
  public States_2(Parser yyq):base(yyq,
	((States)(yyq.StackAt(1).m_value))
	, 
	((State)(yyq.StackAt(0).m_value))
	){}}

public class State_1 : State {
  public State_1(Parser yyq):base(yyq,
	((DEFAULT_STATE)(yyq.StackAt(3).m_value))
	.yytext, 
	((StateBody)(yyq.StackAt(1).m_value))
	){}}

public class State_2 : State {
  public State_2(Parser yyq):base(yyq,
	((IDENT)(yyq.StackAt(3).m_value))
	.yytext, 
	((StateBody)(yyq.StackAt(1).m_value))
	){}}

public class StateBody_1 : StateBody {
  public StateBody_1(Parser yyq):base(yyq,
	((StateEvent)(yyq.StackAt(0).m_value))
	){}}

public class StateBody_2 : StateBody {
  public StateBody_2(Parser yyq):base(yyq,
	((StateBody)(yyq.StackAt(1).m_value))
	, 
	((StateEvent)(yyq.StackAt(0).m_value))
	){}}

public class StateBody_3 : StateBody {
  public StateBody_3(Parser yyq):base(yyq,
	((VoidArgStateEvent)(yyq.StackAt(0).m_value))
	){}}

public class StateBody_4 : StateBody {
  public StateBody_4(Parser yyq):base(yyq,
	((StateBody)(yyq.StackAt(1).m_value))
	, 
	((VoidArgStateEvent)(yyq.StackAt(0).m_value))
	){}}

public class StateBody_5 : StateBody {
  public StateBody_5(Parser yyq):base(yyq,
	((KeyArgStateEvent)(yyq.StackAt(0).m_value))
	){}}

public class StateBody_6 : StateBody {
  public StateBody_6(Parser yyq):base(yyq,
	((StateBody)(yyq.StackAt(1).m_value))
	, 
	((KeyArgStateEvent)(yyq.StackAt(0).m_value))
	){}}

public class StateBody_7 : StateBody {
  public StateBody_7(Parser yyq):base(yyq,
	((IntArgStateEvent)(yyq.StackAt(0).m_value))
	){}}

public class StateBody_8 : StateBody {
  public StateBody_8(Parser yyq):base(yyq,
	((StateBody)(yyq.StackAt(1).m_value))
	, 
	((IntArgStateEvent)(yyq.StackAt(0).m_value))
	){}}

public class StateBody_9 : StateBody {
  public StateBody_9(Parser yyq):base(yyq,
	((VectorArgStateEvent)(yyq.StackAt(0).m_value))
	){}}

public class StateBody_10 : StateBody {
  public StateBody_10(Parser yyq):base(yyq,
	((StateBody)(yyq.StackAt(1).m_value))
	, 
	((VectorArgStateEvent)(yyq.StackAt(0).m_value))
	){}}

public class StateBody_11 : StateBody {
  public StateBody_11(Parser yyq):base(yyq,
	((IntRotRotArgStateEvent)(yyq.StackAt(0).m_value))
	){}}

public class StateBody_12 : StateBody {
  public StateBody_12(Parser yyq):base(yyq,
	((StateBody)(yyq.StackAt(1).m_value))
	, 
	((IntRotRotArgStateEvent)(yyq.StackAt(0).m_value))
	){}}

public class StateBody_13 : StateBody {
  public StateBody_13(Parser yyq):base(yyq,
	((IntVecVecArgStateEvent)(yyq.StackAt(0).m_value))
	){}}

public class StateBody_14 : StateBody {
  public StateBody_14(Parser yyq):base(yyq,
	((StateBody)(yyq.StackAt(1).m_value))
	, 
	((IntVecVecArgStateEvent)(yyq.StackAt(0).m_value))
	){}}

public class StateBody_15 : StateBody {
  public StateBody_15(Parser yyq):base(yyq,
	((KeyIntIntArgStateEvent)(yyq.StackAt(0).m_value))
	){}}

public class StateBody_16 : StateBody {
  public StateBody_16(Parser yyq):base(yyq,
	((StateBody)(yyq.StackAt(1).m_value))
	, 
	((KeyIntIntArgStateEvent)(yyq.StackAt(0).m_value))
	){}}

public class StateEvent_1 : StateEvent {
  public StateEvent_1(Parser yyq):base(yyq,
	((Event)(yyq.StackAt(4).m_value))
	.yytext, 
	((ArgumentDeclarationList)(yyq.StackAt(2).m_value))
	, 
	((CompoundStatement)(yyq.StackAt(0).m_value))
	){}}

public class VoidArgStateEvent_1 : VoidArgStateEvent {
  public VoidArgStateEvent_1(Parser yyq):base(yyq,
	((VoidArgEvent)(yyq.StackAt(3).m_value))
	.yytext, 
	((CompoundStatement)(yyq.StackAt(0).m_value))
	){}}

public class KeyArgStateEvent_1 : KeyArgStateEvent {
  public KeyArgStateEvent_1(Parser yyq):base(yyq,
	((KeyArgEvent)(yyq.StackAt(4).m_value))
	.yytext, 
	((KeyArgumentDeclarationList)(yyq.StackAt(2).m_value))
	, 
	((CompoundStatement)(yyq.StackAt(0).m_value))
	){}}

public class IntArgStateEvent_1 : IntArgStateEvent {
  public IntArgStateEvent_1(Parser yyq):base(yyq,
	((IntArgEvent)(yyq.StackAt(4).m_value))
	.yytext, 
	((IntArgumentDeclarationList)(yyq.StackAt(2).m_value))
	, 
	((CompoundStatement)(yyq.StackAt(0).m_value))
	){}}

public class VectorArgStateEvent_1 : VectorArgStateEvent {
  public VectorArgStateEvent_1(Parser yyq):base(yyq,
	((VectorArgEvent)(yyq.StackAt(4).m_value))
	.yytext, 
	((VectorArgumentDeclarationList)(yyq.StackAt(2).m_value))
	, 
	((CompoundStatement)(yyq.StackAt(0).m_value))
	){}}

public class IntRotRotArgStateEvent_1 : IntRotRotArgStateEvent {
  public IntRotRotArgStateEvent_1(Parser yyq):base(yyq,
	((IntRotRotArgEvent)(yyq.StackAt(4).m_value))
	.yytext, 
	((IntRotRotArgumentDeclarationList)(yyq.StackAt(2).m_value))
	, 
	((CompoundStatement)(yyq.StackAt(0).m_value))
	){}}

public class IntVecVecArgStateEvent_1 : IntVecVecArgStateEvent {
  public IntVecVecArgStateEvent_1(Parser yyq):base(yyq,
	((IntVecVecArgEvent)(yyq.StackAt(4).m_value))
	.yytext, 
	((IntVecVecArgumentDeclarationList)(yyq.StackAt(2).m_value))
	, 
	((CompoundStatement)(yyq.StackAt(0).m_value))
	){}}

public class KeyIntIntArgStateEvent_1 : KeyIntIntArgStateEvent {
  public KeyIntIntArgStateEvent_1(Parser yyq):base(yyq,
	((KeyIntIntArgEvent)(yyq.StackAt(4).m_value))
	.yytext, 
	((KeyIntIntArgumentDeclarationList)(yyq.StackAt(2).m_value))
	, 
	((CompoundStatement)(yyq.StackAt(0).m_value))
	){}}

public class ArgumentDeclarationList_1 : ArgumentDeclarationList {
  public ArgumentDeclarationList_1(Parser yyq):base(yyq,
	((Declaration)(yyq.StackAt(0).m_value))
	){}}

public class ArgumentDeclarationList_2 : ArgumentDeclarationList {
  public ArgumentDeclarationList_2(Parser yyq):base(yyq,
	((ArgumentDeclarationList)(yyq.StackAt(2).m_value))
	, 
	((Declaration)(yyq.StackAt(0).m_value))
	){}}

public class KeyArgumentDeclarationList_1 : KeyArgumentDeclarationList {
  public KeyArgumentDeclarationList_1(Parser yyq):base(yyq,
	((KeyDeclaration)(yyq.StackAt(0).m_value))
	){}}

public class IntArgumentDeclarationList_1 : IntArgumentDeclarationList {
  public IntArgumentDeclarationList_1(Parser yyq):base(yyq,
	((IntDeclaration)(yyq.StackAt(0).m_value))
	){}}

public class VectorArgumentDeclarationList_1 : VectorArgumentDeclarationList {
  public VectorArgumentDeclarationList_1(Parser yyq):base(yyq,
	((VecDeclaration)(yyq.StackAt(0).m_value))
	){}}

public class IntRotRotArgumentDeclarationList_1 : IntRotRotArgumentDeclarationList {
  public IntRotRotArgumentDeclarationList_1(Parser yyq):base(yyq,
	((IntDeclaration)(yyq.StackAt(4).m_value))
	, 
	((RotDeclaration)(yyq.StackAt(2).m_value))
	, 
	((RotDeclaration)(yyq.StackAt(0).m_value))
	){}}

public class IntVecVecArgumentDeclarationList_1 : IntVecVecArgumentDeclarationList {
  public IntVecVecArgumentDeclarationList_1(Parser yyq):base(yyq,
	((IntDeclaration)(yyq.StackAt(4).m_value))
	, 
	((VecDeclaration)(yyq.StackAt(2).m_value))
	, 
	((VecDeclaration)(yyq.StackAt(0).m_value))
	){}}

public class KeyIntIntArgumentDeclarationList_1 : KeyIntIntArgumentDeclarationList {
  public KeyIntIntArgumentDeclarationList_1(Parser yyq):base(yyq,
	((KeyDeclaration)(yyq.StackAt(4).m_value))
	, 
	((IntDeclaration)(yyq.StackAt(2).m_value))
	, 
	((IntDeclaration)(yyq.StackAt(0).m_value))
	){}}

public class Declaration_1 : Declaration {
  public Declaration_1(Parser yyq):base(yyq,
	((Typename)(yyq.StackAt(1).m_value))
	.yytext, 
	((IDENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class KeyDeclaration_1 : KeyDeclaration {
  public KeyDeclaration_1(Parser yyq):base(yyq,
	((KEY_TYPE)(yyq.StackAt(1).m_value))
	.yytext, 
	((IDENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class IntDeclaration_1 : IntDeclaration {
  public IntDeclaration_1(Parser yyq):base(yyq,
	((INTEGER_TYPE)(yyq.StackAt(1).m_value))
	.yytext, 
	((IDENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class VecDeclaration_1 : VecDeclaration {
  public VecDeclaration_1(Parser yyq):base(yyq,
	((VECTOR_TYPE)(yyq.StackAt(1).m_value))
	.yytext, 
	((IDENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class RotDeclaration_1 : RotDeclaration {
  public RotDeclaration_1(Parser yyq):base(yyq,
	((ROTATION_TYPE)(yyq.StackAt(1).m_value))
	.yytext, 
	((IDENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class CompoundStatement_1 : CompoundStatement {
  public CompoundStatement_1(Parser yyq):base(yyq){}}

public class CompoundStatement_2 : CompoundStatement {
  public CompoundStatement_2(Parser yyq):base(yyq,
	((StatementList)(yyq.StackAt(1).m_value))
	){}}

public class StatementList_1 : StatementList {
  public StatementList_1(Parser yyq):base(yyq,
	((Statement)(yyq.StackAt(0).m_value))
	){}}

public class StatementList_2 : StatementList {
  public StatementList_2(Parser yyq):base(yyq,
	((StatementList)(yyq.StackAt(1).m_value))
	, 
	((Statement)(yyq.StackAt(0).m_value))
	){}}

public class EmptyStatement_1 : EmptyStatement {
  public EmptyStatement_1(Parser yyq):base(yyq){}}

public class Statement_1 : Statement {
  public Statement_1(Parser yyq):base(yyq,
	((EmptyStatement)(yyq.StackAt(1).m_value))
	){}}

public class Statement_2 : Statement {
  public Statement_2(Parser yyq):base(yyq,
	((Declaration)(yyq.StackAt(1).m_value))
	){}}

public class Statement_3 : Statement {
  public Statement_3(Parser yyq):base(yyq,
	((Assignment)(yyq.StackAt(1).m_value))
	){}}

public class Statement_4 : Statement {
  public Statement_4(Parser yyq):base(yyq,
	((Expression)(yyq.StackAt(1).m_value))
	){}}

public class Statement_5 : Statement {
  public Statement_5(Parser yyq):base(yyq,
	((ReturnStatement)(yyq.StackAt(1).m_value))
	){}}

public class Statement_6 : Statement {
  public Statement_6(Parser yyq):base(yyq,
	((JumpLabel)(yyq.StackAt(1).m_value))
	){}}

public class Statement_7 : Statement {
  public Statement_7(Parser yyq):base(yyq,
	((JumpStatement)(yyq.StackAt(1).m_value))
	){}}

public class Statement_8 : Statement {
  public Statement_8(Parser yyq):base(yyq,
	((StateChange)(yyq.StackAt(1).m_value))
	){}}

public class Statement_9 : Statement {
  public Statement_9(Parser yyq):base(yyq,
	((IfStatement)(yyq.StackAt(0).m_value))
	){}}

public class Statement_10 : Statement {
  public Statement_10(Parser yyq):base(yyq,
	((WhileStatement)(yyq.StackAt(0).m_value))
	){}}

public class Statement_11 : Statement {
  public Statement_11(Parser yyq):base(yyq,
	((DoWhileStatement)(yyq.StackAt(0).m_value))
	){}}

public class Statement_12 : Statement {
  public Statement_12(Parser yyq):base(yyq,
	((ForLoop)(yyq.StackAt(0).m_value))
	){}}

public class Statement_13 : Statement {
  public Statement_13(Parser yyq):base(yyq,
	((CompoundStatement)(yyq.StackAt(0).m_value))
	){}}

public class JumpLabel_1 : JumpLabel {
  public JumpLabel_1(Parser yyq):base(yyq,
	((IDENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class JumpStatement_1 : JumpStatement {
  public JumpStatement_1(Parser yyq):base(yyq,
	((IDENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class StateChange_1 : StateChange {
  public StateChange_1(Parser yyq):base(yyq,
	((IDENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class StateChange_2 : StateChange {
  public StateChange_2(Parser yyq):base(yyq,
	((DEFAULT_STATE)(yyq.StackAt(0).m_value))
	.yytext){}}

public class IfStatement_1 : IfStatement {
  public IfStatement_1(Parser yyq):base(yyq,
	((Expression)(yyq.StackAt(2).m_value))
	, 
	((Statement)(yyq.StackAt(0).m_value))
	){}}

public class IfStatement_2 : IfStatement {
  public IfStatement_2(Parser yyq):base(yyq,
	((Expression)(yyq.StackAt(4).m_value))
	, 
	((Statement)(yyq.StackAt(2).m_value))
	, 
	((Statement)(yyq.StackAt(0).m_value))
	){}}

public class IfStatement_3 : IfStatement {
  public IfStatement_3(Parser yyq):base(yyq,
	((SimpleAssignment)(yyq.StackAt(2).m_value))
	, 
	((Statement)(yyq.StackAt(0).m_value))
	){}}

public class IfStatement_4 : IfStatement {
  public IfStatement_4(Parser yyq):base(yyq,
	((SimpleAssignment)(yyq.StackAt(4).m_value))
	, 
	((Statement)(yyq.StackAt(2).m_value))
	, 
	((Statement)(yyq.StackAt(0).m_value))
	){}}

public class WhileStatement_1 : WhileStatement {
  public WhileStatement_1(Parser yyq):base(yyq,
	((Expression)(yyq.StackAt(2).m_value))
	, 
	((Statement)(yyq.StackAt(0).m_value))
	){}}

public class WhileStatement_2 : WhileStatement {
  public WhileStatement_2(Parser yyq):base(yyq,
	((SimpleAssignment)(yyq.StackAt(2).m_value))
	, 
	((Statement)(yyq.StackAt(0).m_value))
	){}}

public class DoWhileStatement_1 : DoWhileStatement {
  public DoWhileStatement_1(Parser yyq):base(yyq,
	((Expression)(yyq.StackAt(2).m_value))
	, 
	((Statement)(yyq.StackAt(5).m_value))
	){}}

public class DoWhileStatement_2 : DoWhileStatement {
  public DoWhileStatement_2(Parser yyq):base(yyq,
	((SimpleAssignment)(yyq.StackAt(2).m_value))
	, 
	((Statement)(yyq.StackAt(5).m_value))
	){}}

public class ForLoop_1 : ForLoop {
  public ForLoop_1(Parser yyq):base(yyq,
	((ForLoopStatement)(yyq.StackAt(6).m_value))
	, 
	((Expression)(yyq.StackAt(4).m_value))
	, 
	((ForLoopStatement)(yyq.StackAt(2).m_value))
	, 
	((Statement)(yyq.StackAt(0).m_value))
	){}}

public class ForLoop_2 : ForLoop {
  public ForLoop_2(Parser yyq):base(yyq,null, 
	((Expression)(yyq.StackAt(4).m_value))
	, 
	((ForLoopStatement)(yyq.StackAt(2).m_value))
	, 
	((Statement)(yyq.StackAt(0).m_value))
	){}}

public class ForLoopStatement_1 : ForLoopStatement {
  public ForLoopStatement_1(Parser yyq):base(yyq,
	((Expression)(yyq.StackAt(0).m_value))
	){}}

public class ForLoopStatement_2 : ForLoopStatement {
  public ForLoopStatement_2(Parser yyq):base(yyq,
	((SimpleAssignment)(yyq.StackAt(0).m_value))
	){}}

public class ForLoopStatement_3 : ForLoopStatement {
  public ForLoopStatement_3(Parser yyq):base(yyq,
	((ForLoopStatement)(yyq.StackAt(2).m_value))
	, 
	((Expression)(yyq.StackAt(0).m_value))
	){}}

public class ForLoopStatement_4 : ForLoopStatement {
  public ForLoopStatement_4(Parser yyq):base(yyq,
	((ForLoopStatement)(yyq.StackAt(2).m_value))
	, 
	((SimpleAssignment)(yyq.StackAt(0).m_value))
	){}}

public class Assignment_1 : Assignment {
  public Assignment_1(Parser yyq):base(yyq,
	((Declaration)(yyq.StackAt(2).m_value))
	, 
	((Expression)(yyq.StackAt(0).m_value))
	, 
	((EQUALS)(yyq.StackAt(1).m_value))
	.yytext){}}

public class Assignment_2 : Assignment {
  public Assignment_2(Parser yyq):base(yyq,
	((SimpleAssignment)(yyq.StackAt(0).m_value))
	){}}

public class SimpleAssignment_1 : SimpleAssignment {
  public SimpleAssignment_1(Parser yyq):base(yyq,
	((IDENT)(yyq.StackAt(2).m_value))
	, 
	((Expression)(yyq.StackAt(0).m_value))
	, 
	((EQUALS)(yyq.StackAt(1).m_value))
	.yytext){}}

public class SimpleAssignment_2 : SimpleAssignment {
  public SimpleAssignment_2(Parser yyq):base(yyq,
	((IDENT)(yyq.StackAt(2).m_value))
	, 
	((Expression)(yyq.StackAt(0).m_value))
	, 
	((PLUS_EQUALS)(yyq.StackAt(1).m_value))
	.yytext){}}

public class SimpleAssignment_3 : SimpleAssignment {
  public SimpleAssignment_3(Parser yyq):base(yyq,
	((IDENT)(yyq.StackAt(2).m_value))
	, 
	((Expression)(yyq.StackAt(0).m_value))
	, 
	((MINUS_EQUALS)(yyq.StackAt(1).m_value))
	.yytext){}}

public class SimpleAssignment_4 : SimpleAssignment {
  public SimpleAssignment_4(Parser yyq):base(yyq,
	((IDENT)(yyq.StackAt(2).m_value))
	, 
	((Expression)(yyq.StackAt(0).m_value))
	, 
	((STAR_EQUALS)(yyq.StackAt(1).m_value))
	.yytext){}}

public class SimpleAssignment_5 : SimpleAssignment {
  public SimpleAssignment_5(Parser yyq):base(yyq,
	((IDENT)(yyq.StackAt(2).m_value))
	, 
	((Expression)(yyq.StackAt(0).m_value))
	, 
	((SLASH_EQUALS)(yyq.StackAt(1).m_value))
	.yytext){}}

public class SimpleAssignment_6 : SimpleAssignment {
  public SimpleAssignment_6(Parser yyq):base(yyq,
	((IDENT)(yyq.StackAt(2).m_value))
	, 
	((Expression)(yyq.StackAt(0).m_value))
	, 
	((PERCENT_EQUALS)(yyq.StackAt(1).m_value))
	.yytext){}}

public class SimpleAssignment_7 : SimpleAssignment {
  public SimpleAssignment_7(Parser yyq):base(yyq,new IdentDotExpression(((LSLSyntax
)yyq), 
	((IDENT)(yyq.StackAt(4).m_value))
	.yytext, 
	((IDENT)(yyq.StackAt(2).m_value))
	.yytext), 
	((Expression)(yyq.StackAt(0).m_value))
	, 
	((EQUALS)(yyq.StackAt(1).m_value))
	.yytext){}}

public class SimpleAssignment_8 : SimpleAssignment {
  public SimpleAssignment_8(Parser yyq):base(yyq,new IdentDotExpression(((LSLSyntax
)yyq), 
	((IDENT)(yyq.StackAt(4).m_value))
	.yytext, 
	((IDENT)(yyq.StackAt(2).m_value))
	.yytext), 
	((Expression)(yyq.StackAt(0).m_value))
	, 
	((PLUS_EQUALS)(yyq.StackAt(1).m_value))
	.yytext){}}

public class SimpleAssignment_9 : SimpleAssignment {
  public SimpleAssignment_9(Parser yyq):base(yyq,new IdentDotExpression(((LSLSyntax
)yyq), 
	((IDENT)(yyq.StackAt(4).m_value))
	.yytext, 
	((IDENT)(yyq.StackAt(2).m_value))
	.yytext), 
	((Expression)(yyq.StackAt(0).m_value))
	, 
	((MINUS_EQUALS)(yyq.StackAt(1).m_value))
	.yytext){}}

public class SimpleAssignment_10 : SimpleAssignment {
  public SimpleAssignment_10(Parser yyq):base(yyq,new IdentDotExpression(((LSLSyntax
)yyq), 
	((IDENT)(yyq.StackAt(4).m_value))
	.yytext, 
	((IDENT)(yyq.StackAt(2).m_value))
	.yytext), 
	((Expression)(yyq.StackAt(0).m_value))
	, 
	((STAR_EQUALS)(yyq.StackAt(1).m_value))
	.yytext){}}

public class SimpleAssignment_11 : SimpleAssignment {
  public SimpleAssignment_11(Parser yyq):base(yyq,new IdentDotExpression(((LSLSyntax
)yyq), 
	((IDENT)(yyq.StackAt(4).m_value))
	.yytext, 
	((IDENT)(yyq.StackAt(2).m_value))
	.yytext), 
	((Expression)(yyq.StackAt(0).m_value))
	, 
	((SLASH_EQUALS)(yyq.StackAt(1).m_value))
	.yytext){}}

public class SimpleAssignment_12 : SimpleAssignment {
  public SimpleAssignment_12(Parser yyq):base(yyq,new IdentDotExpression(((LSLSyntax
)yyq), 
	((IDENT)(yyq.StackAt(4).m_value))
	.yytext, 
	((IDENT)(yyq.StackAt(2).m_value))
	.yytext), 
	((Expression)(yyq.StackAt(0).m_value))
	, 
	((PERCENT_EQUALS)(yyq.StackAt(1).m_value))
	.yytext){}}

public class SimpleAssignment_13 : SimpleAssignment {
  public SimpleAssignment_13(Parser yyq):base(yyq,
	((IDENT)(yyq.StackAt(2).m_value))
	, 
	((SimpleAssignment)(yyq.StackAt(0).m_value))
	, 
	((EQUALS)(yyq.StackAt(1).m_value))
	.yytext){}}

public class SimpleAssignment_14 : SimpleAssignment {
  public SimpleAssignment_14(Parser yyq):base(yyq,
	((IDENT)(yyq.StackAt(2).m_value))
	, 
	((SimpleAssignment)(yyq.StackAt(0).m_value))
	, 
	((PLUS_EQUALS)(yyq.StackAt(1).m_value))
	.yytext){}}

public class SimpleAssignment_15 : SimpleAssignment {
  public SimpleAssignment_15(Parser yyq):base(yyq,
	((IDENT)(yyq.StackAt(2).m_value))
	, 
	((SimpleAssignment)(yyq.StackAt(0).m_value))
	, 
	((MINUS_EQUALS)(yyq.StackAt(1).m_value))
	.yytext){}}

public class SimpleAssignment_16 : SimpleAssignment {
  public SimpleAssignment_16(Parser yyq):base(yyq,
	((IDENT)(yyq.StackAt(2).m_value))
	, 
	((SimpleAssignment)(yyq.StackAt(0).m_value))
	, 
	((STAR_EQUALS)(yyq.StackAt(1).m_value))
	.yytext){}}

public class SimpleAssignment_17 : SimpleAssignment {
  public SimpleAssignment_17(Parser yyq):base(yyq,
	((IDENT)(yyq.StackAt(2).m_value))
	, 
	((SimpleAssignment)(yyq.StackAt(0).m_value))
	, 
	((SLASH_EQUALS)(yyq.StackAt(1).m_value))
	.yytext){}}

public class SimpleAssignment_18 : SimpleAssignment {
  public SimpleAssignment_18(Parser yyq):base(yyq,
	((IDENT)(yyq.StackAt(2).m_value))
	, 
	((SimpleAssignment)(yyq.StackAt(0).m_value))
	, 
	((PERCENT_EQUALS)(yyq.StackAt(1).m_value))
	.yytext){}}

public class SimpleAssignment_19 : SimpleAssignment {
  public SimpleAssignment_19(Parser yyq):base(yyq,new IdentDotExpression(((LSLSyntax
)yyq), 
	((IDENT)(yyq.StackAt(4).m_value))
	.yytext, 
	((IDENT)(yyq.StackAt(2).m_value))
	.yytext), 
	((SimpleAssignment)(yyq.StackAt(0).m_value))
	, 
	((EQUALS)(yyq.StackAt(1).m_value))
	.yytext){}}

public class SimpleAssignment_20 : SimpleAssignment {
  public SimpleAssignment_20(Parser yyq):base(yyq,new IdentDotExpression(((LSLSyntax
)yyq), 
	((IDENT)(yyq.StackAt(4).m_value))
	.yytext, 
	((IDENT)(yyq.StackAt(2).m_value))
	.yytext), 
	((SimpleAssignment)(yyq.StackAt(0).m_value))
	, 
	((PLUS_EQUALS)(yyq.StackAt(1).m_value))
	.yytext){}}

public class SimpleAssignment_21 : SimpleAssignment {
  public SimpleAssignment_21(Parser yyq):base(yyq,new IdentDotExpression(((LSLSyntax
)yyq), 
	((IDENT)(yyq.StackAt(4).m_value))
	.yytext, 
	((IDENT)(yyq.StackAt(2).m_value))
	.yytext), 
	((SimpleAssignment)(yyq.StackAt(0).m_value))
	, 
	((MINUS_EQUALS)(yyq.StackAt(1).m_value))
	.yytext){}}

public class SimpleAssignment_22 : SimpleAssignment {
  public SimpleAssignment_22(Parser yyq):base(yyq,new IdentDotExpression(((LSLSyntax
)yyq), 
	((IDENT)(yyq.StackAt(4).m_value))
	.yytext, 
	((IDENT)(yyq.StackAt(2).m_value))
	.yytext), 
	((SimpleAssignment)(yyq.StackAt(0).m_value))
	, 
	((STAR_EQUALS)(yyq.StackAt(1).m_value))
	.yytext){}}

public class SimpleAssignment_23 : SimpleAssignment {
  public SimpleAssignment_23(Parser yyq):base(yyq,new IdentDotExpression(((LSLSyntax
)yyq), 
	((IDENT)(yyq.StackAt(4).m_value))
	.yytext, 
	((IDENT)(yyq.StackAt(2).m_value))
	.yytext), 
	((SimpleAssignment)(yyq.StackAt(0).m_value))
	, 
	((SLASH_EQUALS)(yyq.StackAt(1).m_value))
	.yytext){}}

public class SimpleAssignment_24 : SimpleAssignment {
  public SimpleAssignment_24(Parser yyq):base(yyq,new IdentDotExpression(((LSLSyntax
)yyq), 
	((IDENT)(yyq.StackAt(4).m_value))
	.yytext, 
	((IDENT)(yyq.StackAt(2).m_value))
	.yytext), 
	((SimpleAssignment)(yyq.StackAt(0).m_value))
	, 
	((PERCENT_EQUALS)(yyq.StackAt(1).m_value))
	.yytext){}}

public class ReturnStatement_1 : ReturnStatement {
  public ReturnStatement_1(Parser yyq):base(yyq,
	((Expression)(yyq.StackAt(0).m_value))
	){}}

public class ReturnStatement_2 : ReturnStatement {
  public ReturnStatement_2(Parser yyq):base(yyq){}}

public class Constant_1 : Constant {
  public Constant_1(Parser yyq):base(yyq,"integer", 
	((INTEGER_CONSTANT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class Constant_2 : Constant {
  public Constant_2(Parser yyq):base(yyq,"integer", 
	((HEX_INTEGER_CONSTANT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class Constant_3 : Constant {
  public Constant_3(Parser yyq):base(yyq,"float", 
	((FLOAT_CONSTANT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class Constant_4 : Constant {
  public Constant_4(Parser yyq):base(yyq,"string", 
	((STRING_CONSTANT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class ListConstant_1 : ListConstant {
  public ListConstant_1(Parser yyq):base(yyq,
	((ArgumentList)(yyq.StackAt(1).m_value))
	){}}

public class VectorConstant_1 : VectorConstant {
  public VectorConstant_1(Parser yyq):base(yyq,
	((Expression)(yyq.StackAt(5).m_value))
	, 
	((Expression)(yyq.StackAt(3).m_value))
	, 
	((Expression)(yyq.StackAt(1).m_value))
	){}}

public class RotationConstant_1 : RotationConstant {
  public RotationConstant_1(Parser yyq):base(yyq,
	((Expression)(yyq.StackAt(7).m_value))
	, 
	((Expression)(yyq.StackAt(5).m_value))
	, 
	((Expression)(yyq.StackAt(3).m_value))
	, 
	((Expression)(yyq.StackAt(1).m_value))
	){}}

public class ConstantExpression_1 : ConstantExpression {
  public ConstantExpression_1(Parser yyq):base(yyq,
	((Constant)(yyq.StackAt(0).m_value))
	){}}

public class IdentExpression_1 : IdentExpression {
  public IdentExpression_1(Parser yyq):base(yyq,
	((IDENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class IdentDotExpression_1 : IdentDotExpression {
  public IdentDotExpression_1(Parser yyq):base(yyq,
	((IDENT)(yyq.StackAt(2).m_value))
	.yytext, 
	((IDENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class IncrementDecrementExpression_1 : IncrementDecrementExpression {
  public IncrementDecrementExpression_1(Parser yyq):base(yyq,
	((IDENT)(yyq.StackAt(1).m_value))
	.yytext, 
	((INCREMENT)(yyq.StackAt(0).m_value))
	.yytext, true){}}

public class IncrementDecrementExpression_2 : IncrementDecrementExpression {
  public IncrementDecrementExpression_2(Parser yyq):base(yyq,
	((IDENT)(yyq.StackAt(1).m_value))
	.yytext, 
	((DECREMENT)(yyq.StackAt(0).m_value))
	.yytext, true){}}

public class IncrementDecrementExpression_3 : IncrementDecrementExpression {
  public IncrementDecrementExpression_3(Parser yyq):base(yyq,new IdentDotExpression(((LSLSyntax
)yyq), 
	((IDENT)(yyq.StackAt(3).m_value))
	.yytext, 
	((IDENT)(yyq.StackAt(1).m_value))
	.yytext), 
	((INCREMENT)(yyq.StackAt(0).m_value))
	.yytext, true){}}

public class IncrementDecrementExpression_4 : IncrementDecrementExpression {
  public IncrementDecrementExpression_4(Parser yyq):base(yyq,new IdentDotExpression(((LSLSyntax
)yyq), 
	((IDENT)(yyq.StackAt(3).m_value))
	.yytext, 
	((IDENT)(yyq.StackAt(1).m_value))
	.yytext), 
	((DECREMENT)(yyq.StackAt(0).m_value))
	.yytext, true){}}

public class IncrementDecrementExpression_5 : IncrementDecrementExpression {
  public IncrementDecrementExpression_5(Parser yyq):base(yyq,
	((IDENT)(yyq.StackAt(0).m_value))
	.yytext, 
	((INCREMENT)(yyq.StackAt(1).m_value))
	.yytext, false){}}

public class IncrementDecrementExpression_6 : IncrementDecrementExpression {
  public IncrementDecrementExpression_6(Parser yyq):base(yyq,
	((IDENT)(yyq.StackAt(0).m_value))
	.yytext, 
	((DECREMENT)(yyq.StackAt(1).m_value))
	.yytext, false){}}

public class IncrementDecrementExpression_7 : IncrementDecrementExpression {
  public IncrementDecrementExpression_7(Parser yyq):base(yyq,new IdentDotExpression(((LSLSyntax
)yyq), 
	((IDENT)(yyq.StackAt(2).m_value))
	.yytext, 
	((IDENT)(yyq.StackAt(0).m_value))
	.yytext), 
	((INCREMENT)(yyq.StackAt(3).m_value))
	.yytext, false){}}

public class IncrementDecrementExpression_8 : IncrementDecrementExpression {
  public IncrementDecrementExpression_8(Parser yyq):base(yyq,new IdentDotExpression(((LSLSyntax
)yyq), 
	((IDENT)(yyq.StackAt(2).m_value))
	.yytext, 
	((IDENT)(yyq.StackAt(0).m_value))
	.yytext), 
	((DECREMENT)(yyq.StackAt(3).m_value))
	.yytext, false){}}

public class FunctionCallExpression_1 : FunctionCallExpression {
  public FunctionCallExpression_1(Parser yyq):base(yyq,
	((FunctionCall)(yyq.StackAt(0).m_value))
	){}}

public class BinaryExpression_1 : BinaryExpression {
  public BinaryExpression_1(Parser yyq):base(yyq,
	((Expression)(yyq.StackAt(2).m_value))
	, 
	((Expression)(yyq.StackAt(0).m_value))
	, 
	((PLUS)(yyq.StackAt(1).m_value))
	.yytext){}}

public class BinaryExpression_2 : BinaryExpression {
  public BinaryExpression_2(Parser yyq):base(yyq,
	((Expression)(yyq.StackAt(2).m_value))
	, 
	((Expression)(yyq.StackAt(0).m_value))
	, 
	((MINUS)(yyq.StackAt(1).m_value))
	.yytext){}}

public class BinaryExpression_3 : BinaryExpression {
  public BinaryExpression_3(Parser yyq):base(yyq,
	((Expression)(yyq.StackAt(2).m_value))
	, 
	((Expression)(yyq.StackAt(0).m_value))
	, 
	((STAR)(yyq.StackAt(1).m_value))
	.yytext){}}

public class BinaryExpression_4 : BinaryExpression {
  public BinaryExpression_4(Parser yyq):base(yyq,
	((Expression)(yyq.StackAt(2).m_value))
	, 
	((Expression)(yyq.StackAt(0).m_value))
	, 
	((SLASH)(yyq.StackAt(1).m_value))
	.yytext){}}

public class BinaryExpression_5 : BinaryExpression {
  public BinaryExpression_5(Parser yyq):base(yyq,
	((Expression)(yyq.StackAt(2).m_value))
	, 
	((Expression)(yyq.StackAt(0).m_value))
	, 
	((PERCENT)(yyq.StackAt(1).m_value))
	.yytext){}}

public class BinaryExpression_6 : BinaryExpression {
  public BinaryExpression_6(Parser yyq):base(yyq,
	((Expression)(yyq.StackAt(2).m_value))
	, 
	((Expression)(yyq.StackAt(0).m_value))
	, 
	((AMP)(yyq.StackAt(1).m_value))
	.yytext){}}

public class BinaryExpression_7 : BinaryExpression {
  public BinaryExpression_7(Parser yyq):base(yyq,
	((Expression)(yyq.StackAt(2).m_value))
	, 
	((Expression)(yyq.StackAt(0).m_value))
	, 
	((STROKE)(yyq.StackAt(1).m_value))
	.yytext){}}

public class BinaryExpression_8 : BinaryExpression {
  public BinaryExpression_8(Parser yyq):base(yyq,
	((Expression)(yyq.StackAt(2).m_value))
	, 
	((Expression)(yyq.StackAt(0).m_value))
	, 
	((CARET)(yyq.StackAt(1).m_value))
	.yytext){}}

public class BinaryExpression_9 : BinaryExpression {
  public BinaryExpression_9(Parser yyq):base(yyq,
	((Expression)(yyq.StackAt(2).m_value))
	, 
	((Expression)(yyq.StackAt(0).m_value))
	, 
	((RIGHT_ANGLE)(yyq.StackAt(1).m_value))
	.yytext){}}

public class BinaryExpression_10 : BinaryExpression {
  public BinaryExpression_10(Parser yyq):base(yyq,
	((Expression)(yyq.StackAt(2).m_value))
	, 
	((Expression)(yyq.StackAt(0).m_value))
	, 
	((LEFT_ANGLE)(yyq.StackAt(1).m_value))
	.yytext){}}

public class BinaryExpression_11 : BinaryExpression {
  public BinaryExpression_11(Parser yyq):base(yyq,
	((Expression)(yyq.StackAt(2).m_value))
	, 
	((Expression)(yyq.StackAt(0).m_value))
	, 
	((EQUALS_EQUALS)(yyq.StackAt(1).m_value))
	.yytext){}}

public class BinaryExpression_12 : BinaryExpression {
  public BinaryExpression_12(Parser yyq):base(yyq,
	((Expression)(yyq.StackAt(2).m_value))
	, 
	((Expression)(yyq.StackAt(0).m_value))
	, 
	((EXCLAMATION_EQUALS)(yyq.StackAt(1).m_value))
	.yytext){}}

public class BinaryExpression_13 : BinaryExpression {
  public BinaryExpression_13(Parser yyq):base(yyq,
	((Expression)(yyq.StackAt(2).m_value))
	, 
	((Expression)(yyq.StackAt(0).m_value))
	, 
	((LESS_EQUALS)(yyq.StackAt(1).m_value))
	.yytext){}}

public class BinaryExpression_14 : BinaryExpression {
  public BinaryExpression_14(Parser yyq):base(yyq,
	((Expression)(yyq.StackAt(2).m_value))
	, 
	((Expression)(yyq.StackAt(0).m_value))
	, 
	((GREATER_EQUALS)(yyq.StackAt(1).m_value))
	.yytext){}}

public class BinaryExpression_15 : BinaryExpression {
  public BinaryExpression_15(Parser yyq):base(yyq,
	((Expression)(yyq.StackAt(2).m_value))
	, 
	((Expression)(yyq.StackAt(0).m_value))
	, 
	((AMP_AMP)(yyq.StackAt(1).m_value))
	.yytext){}}

public class BinaryExpression_16 : BinaryExpression {
  public BinaryExpression_16(Parser yyq):base(yyq,
	((Expression)(yyq.StackAt(2).m_value))
	, 
	((Expression)(yyq.StackAt(0).m_value))
	, 
	((STROKE_STROKE)(yyq.StackAt(1).m_value))
	.yytext){}}

public class BinaryExpression_17 : BinaryExpression {
  public BinaryExpression_17(Parser yyq):base(yyq,
	((Expression)(yyq.StackAt(2).m_value))
	, 
	((Expression)(yyq.StackAt(0).m_value))
	, 
	((LEFT_SHIFT)(yyq.StackAt(1).m_value))
	.yytext){}}

public class BinaryExpression_18 : BinaryExpression {
  public BinaryExpression_18(Parser yyq):base(yyq,
	((Expression)(yyq.StackAt(2).m_value))
	, 
	((Expression)(yyq.StackAt(0).m_value))
	, 
	((RIGHT_SHIFT)(yyq.StackAt(1).m_value))
	.yytext){}}

public class UnaryExpression_1 : UnaryExpression {
  public UnaryExpression_1(Parser yyq):base(yyq,
	((EXCLAMATION)(yyq.StackAt(1).m_value))
	.yytext, 
	((Expression)(yyq.StackAt(0).m_value))
	){}}

public class UnaryExpression_2 : UnaryExpression {
  public UnaryExpression_2(Parser yyq):base(yyq,
	((MINUS)(yyq.StackAt(1).m_value))
	.yytext, 
	((Expression)(yyq.StackAt(0).m_value))
	){}}

public class UnaryExpression_3 : UnaryExpression {
  public UnaryExpression_3(Parser yyq):base(yyq,
	((TILDE)(yyq.StackAt(1).m_value))
	.yytext, 
	((Expression)(yyq.StackAt(0).m_value))
	){}}

public class ParenthesisExpression_1 : ParenthesisExpression {
  public ParenthesisExpression_1(Parser yyq):base(yyq,
	((Expression)(yyq.StackAt(1).m_value))
	){}}

public class ParenthesisExpression_2 : ParenthesisExpression {
  public ParenthesisExpression_2(Parser yyq):base(yyq,
	((SimpleAssignment)(yyq.StackAt(1).m_value))
	){}}

public class TypecastExpression_1 : TypecastExpression {
  public TypecastExpression_1(Parser yyq):base(yyq,
	((Typename)(yyq.StackAt(2).m_value))
	.yytext, 
	((Constant)(yyq.StackAt(0).m_value))
	){}}

public class TypecastExpression_2 : TypecastExpression {
  public TypecastExpression_2(Parser yyq):base(yyq,
	((Typename)(yyq.StackAt(2).m_value))
	.yytext, new IdentExpression(((LSLSyntax
)yyq), 
	((IDENT)(yyq.StackAt(0).m_value))
	.yytext)){}}

public class TypecastExpression_3 : TypecastExpression {
  public TypecastExpression_3(Parser yyq):base(yyq,
	((Typename)(yyq.StackAt(4).m_value))
	.yytext, new IdentDotExpression(((LSLSyntax
)yyq), 
	((IDENT)(yyq.StackAt(2).m_value))
	.yytext, 
	((IDENT)(yyq.StackAt(0).m_value))
	.yytext)){}}

public class TypecastExpression_4 : TypecastExpression {
  public TypecastExpression_4(Parser yyq):base(yyq,
	((Typename)(yyq.StackAt(3).m_value))
	.yytext, new IncrementDecrementExpression(((LSLSyntax
)yyq), 
	((IDENT)(yyq.StackAt(1).m_value))
	.yytext, 
	((INCREMENT)(yyq.StackAt(0).m_value))
	.yytext, true)){}}

public class TypecastExpression_5 : TypecastExpression {
  public TypecastExpression_5(Parser yyq):base(yyq,
	((Typename)(yyq.StackAt(5).m_value))
	.yytext, new IncrementDecrementExpression(((LSLSyntax
)yyq), new IdentDotExpression(((LSLSyntax
)yyq), 
	((IDENT)(yyq.StackAt(3).m_value))
	.yytext, 
	((IDENT)(yyq.StackAt(1).m_value))
	.yytext), 
	((INCREMENT)(yyq.StackAt(0).m_value))
	.yytext, true)){}}

public class TypecastExpression_6 : TypecastExpression {
  public TypecastExpression_6(Parser yyq):base(yyq,
	((Typename)(yyq.StackAt(3).m_value))
	.yytext, new IncrementDecrementExpression(((LSLSyntax
)yyq), 
	((IDENT)(yyq.StackAt(1).m_value))
	.yytext, 
	((DECREMENT)(yyq.StackAt(0).m_value))
	.yytext, true)){}}

public class TypecastExpression_7 : TypecastExpression {
  public TypecastExpression_7(Parser yyq):base(yyq,
	((Typename)(yyq.StackAt(5).m_value))
	.yytext, new IncrementDecrementExpression(((LSLSyntax
)yyq), new IdentDotExpression(((LSLSyntax
)yyq), 
	((IDENT)(yyq.StackAt(3).m_value))
	.yytext, 
	((IDENT)(yyq.StackAt(1).m_value))
	.yytext), 
	((DECREMENT)(yyq.StackAt(0).m_value))
	.yytext, true)){}}

public class TypecastExpression_8 : TypecastExpression {
  public TypecastExpression_8(Parser yyq):base(yyq,
	((Typename)(yyq.StackAt(2).m_value))
	.yytext, 
	((FunctionCall)(yyq.StackAt(0).m_value))
	){}}

public class TypecastExpression_9 : TypecastExpression {
  public TypecastExpression_9(Parser yyq):base(yyq,
	((Typename)(yyq.StackAt(4).m_value))
	.yytext, 
	((Expression)(yyq.StackAt(1).m_value))
	){}}

public class FunctionCall_1 : FunctionCall {
  public FunctionCall_1(Parser yyq):base(yyq,
	((IDENT)(yyq.StackAt(3).m_value))
	.yytext, 
	((ArgumentList)(yyq.StackAt(1).m_value))
	){}}

public class ArgumentList_1 : ArgumentList {
  public ArgumentList_1(Parser yyq):base(yyq,
	((Argument)(yyq.StackAt(0).m_value))
	){}}

public class ArgumentList_2 : ArgumentList {
  public ArgumentList_2(Parser yyq):base(yyq,
	((ArgumentList)(yyq.StackAt(2).m_value))
	, 
	((Argument)(yyq.StackAt(0).m_value))
	){}}

public class ExpressionArgument_1 : ExpressionArgument {
  public ExpressionArgument_1(Parser yyq):base(yyq,
	((Expression)(yyq.StackAt(0).m_value))
	){}}

public class Typename_1 : Typename {
  public Typename_1(Parser yyq):base(yyq,
	((INTEGER_TYPE)(yyq.StackAt(0).m_value))
	.yytext){}}

public class Typename_2 : Typename {
  public Typename_2(Parser yyq):base(yyq,
	((FLOAT_TYPE)(yyq.StackAt(0).m_value))
	.yytext){}}

public class Typename_3 : Typename {
  public Typename_3(Parser yyq):base(yyq,
	((STRING_TYPE)(yyq.StackAt(0).m_value))
	.yytext){}}

public class Typename_4 : Typename {
  public Typename_4(Parser yyq):base(yyq,
	((KEY_TYPE)(yyq.StackAt(0).m_value))
	.yytext){}}

public class Typename_5 : Typename {
  public Typename_5(Parser yyq):base(yyq,
	((VECTOR_TYPE)(yyq.StackAt(0).m_value))
	.yytext){}}

public class Typename_6 : Typename {
  public Typename_6(Parser yyq):base(yyq,
	((ROTATION_TYPE)(yyq.StackAt(0).m_value))
	.yytext){}}

public class Typename_7 : Typename {
  public Typename_7(Parser yyq):base(yyq,
	((LIST_TYPE)(yyq.StackAt(0).m_value))
	.yytext){}}

public class Event_1 : Event {
  public Event_1(Parser yyq):base(yyq,
	((DATASERVER_EVENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class Event_2 : Event {
  public Event_2(Parser yyq):base(yyq,
	((EMAIL_EVENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class Event_3 : Event {
  public Event_3(Parser yyq):base(yyq,
	((HTTP_RESPONSE_EVENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class Event_4 : Event {
  public Event_4(Parser yyq):base(yyq,
	((LINK_MESSAGE_EVENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class Event_5 : Event {
  public Event_5(Parser yyq):base(yyq,
	((LISTEN_EVENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class Event_6 : Event {
  public Event_6(Parser yyq):base(yyq,
	((MONEY_EVENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class Event_7 : Event {
  public Event_7(Parser yyq):base(yyq,
	((REMOTE_DATA_EVENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class Event_8 : Event {
  public Event_8(Parser yyq):base(yyq,
	((HTTP_REQUEST_EVENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class Event_9 : Event {
  public Event_9(Parser yyq):base(yyq,
	((TRANSACTION_RESULT_EVENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class VoidArgEvent_1 : VoidArgEvent {
  public VoidArgEvent_1(Parser yyq):base(yyq,
	((STATE_ENTRY_EVENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class VoidArgEvent_2 : VoidArgEvent {
  public VoidArgEvent_2(Parser yyq):base(yyq,
	((STATE_EXIT_EVENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class VoidArgEvent_3 : VoidArgEvent {
  public VoidArgEvent_3(Parser yyq):base(yyq,
	((MOVING_END_EVENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class VoidArgEvent_4 : VoidArgEvent {
  public VoidArgEvent_4(Parser yyq):base(yyq,
	((MOVING_START_EVENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class VoidArgEvent_5 : VoidArgEvent {
  public VoidArgEvent_5(Parser yyq):base(yyq,
	((NO_SENSOR_EVENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class VoidArgEvent_6 : VoidArgEvent {
  public VoidArgEvent_6(Parser yyq):base(yyq,
	((NOT_AT_ROT_TARGET_EVENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class VoidArgEvent_7 : VoidArgEvent {
  public VoidArgEvent_7(Parser yyq):base(yyq,
	((NOT_AT_TARGET_EVENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class VoidArgEvent_8 : VoidArgEvent {
  public VoidArgEvent_8(Parser yyq):base(yyq,
	((TIMER_EVENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class KeyArgEvent_1 : KeyArgEvent {
  public KeyArgEvent_1(Parser yyq):base(yyq,
	((ATTACH_EVENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class KeyArgEvent_2 : KeyArgEvent {
  public KeyArgEvent_2(Parser yyq):base(yyq,
	((OBJECT_REZ_EVENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class IntArgEvent_1 : IntArgEvent {
  public IntArgEvent_1(Parser yyq):base(yyq,
	((CHANGED_EVENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class IntArgEvent_2 : IntArgEvent {
  public IntArgEvent_2(Parser yyq):base(yyq,
	((COLLISION_EVENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class IntArgEvent_3 : IntArgEvent {
  public IntArgEvent_3(Parser yyq):base(yyq,
	((COLLISION_END_EVENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class IntArgEvent_4 : IntArgEvent {
  public IntArgEvent_4(Parser yyq):base(yyq,
	((COLLISION_START_EVENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class IntArgEvent_5 : IntArgEvent {
  public IntArgEvent_5(Parser yyq):base(yyq,
	((ON_REZ_EVENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class IntArgEvent_6 : IntArgEvent {
  public IntArgEvent_6(Parser yyq):base(yyq,
	((RUN_TIME_PERMISSIONS_EVENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class IntArgEvent_7 : IntArgEvent {
  public IntArgEvent_7(Parser yyq):base(yyq,
	((SENSOR_EVENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class IntArgEvent_8 : IntArgEvent {
  public IntArgEvent_8(Parser yyq):base(yyq,
	((TOUCH_EVENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class IntArgEvent_9 : IntArgEvent {
  public IntArgEvent_9(Parser yyq):base(yyq,
	((TOUCH_END_EVENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class IntArgEvent_10 : IntArgEvent {
  public IntArgEvent_10(Parser yyq):base(yyq,
	((TOUCH_START_EVENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class VectorArgEvent_1 : VectorArgEvent {
  public VectorArgEvent_1(Parser yyq):base(yyq,
	((LAND_COLLISION_EVENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class VectorArgEvent_2 : VectorArgEvent {
  public VectorArgEvent_2(Parser yyq):base(yyq,
	((LAND_COLLISION_END_EVENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class VectorArgEvent_3 : VectorArgEvent {
  public VectorArgEvent_3(Parser yyq):base(yyq,
	((LAND_COLLISION_START_EVENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class IntRotRotArgEvent_1 : IntRotRotArgEvent {
  public IntRotRotArgEvent_1(Parser yyq):base(yyq,
	((AT_ROT_TARGET_EVENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class IntVecVecArgEvent_1 : IntVecVecArgEvent {
  public IntVecVecArgEvent_1(Parser yyq):base(yyq,
	((AT_TARGET_EVENT)(yyq.StackAt(0).m_value))
	.yytext){}}

public class KeyIntIntArgEvent_1 : KeyIntIntArgEvent {
  public KeyIntIntArgEvent_1(Parser yyq):base(yyq,
	((CONTROL_EVENT)(yyq.StackAt(0).m_value))
	.yytext){}}
public class yyLSLSyntax
: YyParser {
  public override object Action(Parser yyq,SYMBOL yysym, int yyact) {
    switch(yyact) {
	 case -1: break; //// keep compiler happy
}  return null; }

public class ArgumentDeclarationList_3 : ArgumentDeclarationList {
  public ArgumentDeclarationList_3(Parser yyq):base(yyq){}}

public class ArgumentList_3 : ArgumentList {
  public ArgumentList_3(Parser yyq):base(yyq){}}

public class ArgumentList_4 : ArgumentList {
  public ArgumentList_4(Parser yyq):base(yyq){}}

public class ArgumentDeclarationList_4 : ArgumentDeclarationList {
  public ArgumentDeclarationList_4(Parser yyq):base(yyq){}}

public class ArgumentDeclarationList_5 : ArgumentDeclarationList {
  public ArgumentDeclarationList_5(Parser yyq):base(yyq){}}
public yyLSLSyntax
():base() { arr = new int[] { 
101,4,6,52,0,
46,0,53,0,102,
20,103,4,28,76,
0,83,0,76,0,
80,0,114,0,111,
0,103,0,114,0,
97,0,109,0,82,
0,111,0,111,0,
116,0,1,97,1,
2,104,18,1,2845,
102,2,0,105,5,
395,1,0,106,18,
1,0,0,2,0,
1,1,107,18,1,
1,108,20,109,4,
18,76,0,73,0,
83,0,84,0,95,
0,84,0,89,0,
80,0,69,0,1,
57,1,1,2,0,
1,2,110,18,1,
2,111,20,112,4,
26,82,0,79,0,
84,0,65,0,84,
0,73,0,79,0,
78,0,95,0,84,
0,89,0,80,0,
69,0,1,56,1,
1,2,0,1,3,
113,18,1,3,114,
20,115,4,22,86,
0,69,0,67,0,
84,0,79,0,82,
0,95,0,84,0,
89,0,80,0,69,
0,1,55,1,1,
2,0,1,4,116,
18,1,4,117,20,
118,4,16,75,0,
69,0,89,0,95,
0,84,0,89,0,
80,0,69,0,1,
54,1,1,2,0,
1,5,119,18,1,
5,120,20,121,4,
22,83,0,84,0,
82,0,73,0,78,
0,71,0,95,0,
84,0,89,0,80,
0,69,0,1,53,
1,1,2,0,1,
6,122,18,1,6,
123,20,124,4,20,
70,0,76,0,79,
0,65,0,84,0,
95,0,84,0,89,
0,80,0,69,0,
1,52,1,1,2,
0,1,7,125,18,
1,7,126,20,127,
4,24,73,0,78,
0,84,0,69,0,
71,0,69,0,82,
0,95,0,84,0,
89,0,80,0,69,
0,1,51,1,1,
2,0,1,8,128,
18,1,8,129,20,
130,4,16,84,0,
121,0,112,0,101,
0,110,0,97,0,
109,0,101,0,1,
124,1,2,2,0,
1,9,131,18,1,
9,132,20,133,4,
10,73,0,68,0,
69,0,78,0,84,
0,1,93,1,1,
2,0,1,10,134,
18,1,10,135,20,
136,4,20,76,0,
69,0,70,0,84,
0,95,0,80,0,
65,0,82,0,69,
0,78,0,1,16,
1,1,2,0,1,
18,137,18,1,18,
129,2,0,1,19,
138,18,1,19,132,
2,0,1,20,139,
18,1,20,140,20,
141,4,46,65,0,
114,0,103,0,117,
0,109,0,101,0,
110,0,116,0,68,
0,101,0,99,0,
108,0,97,0,114,
0,97,0,116,0,
105,0,111,0,110,
0,76,0,105,0,
115,0,116,0,1,
112,1,2,2,0,
1,21,142,18,1,
21,143,20,144,4,
10,67,0,79,0,
77,0,77,0,65,
0,1,14,1,1,
2,0,1,1694,145,
18,1,1694,146,20,
147,4,32,70,0,
111,0,114,0,76,
0,111,0,111,0,
112,0,83,0,116,
0,97,0,116,0,
101,0,109,0,101,
0,110,0,116,0,
1,147,1,2,2,
0,1,1695,148,18,
1,1695,143,2,0,
1,2811,149,18,1,
2811,150,20,151,4,
18,83,0,69,0,
77,0,73,0,67,
0,79,0,76,0,
79,0,78,0,1,
11,1,1,2,0,
1,2645,152,18,1,
2645,153,20,154,4,
32,73,0,110,0,
116,0,65,0,114,
0,103,0,83,0,
116,0,97,0,116,
0,101,0,69,0,
118,0,101,0,110,
0,116,0,1,107,
1,2,2,0,1,
2646,155,18,1,2646,
156,20,157,4,32,
75,0,101,0,121,
0,65,0,114,0,
103,0,83,0,116,
0,97,0,116,0,
101,0,69,0,118,
0,101,0,110,0,
116,0,1,106,1,
2,2,0,1,30,
158,18,1,30,159,
20,160,4,22,68,
0,101,0,99,0,
108,0,97,0,114,
0,97,0,116,0,
105,0,111,0,110,
0,1,119,1,2,
2,0,1,31,161,
18,1,31,162,20,
163,4,22,82,0,
73,0,71,0,72,
0,84,0,95,0,
80,0,65,0,82,
0,69,0,78,0,
1,17,1,1,2,
0,1,32,164,18,
1,32,165,20,166,
4,20,76,0,69,
0,70,0,84,0,
95,0,66,0,82,
0,65,0,67,0,
69,0,1,12,1,
1,2,0,1,2650,
167,18,1,2650,168,
20,169,4,44,75,
0,101,0,121,0,
73,0,110,0,116,
0,73,0,110,0,
116,0,65,0,114,
0,103,0,83,0,
116,0,97,0,116,
0,101,0,69,0,
118,0,101,0,110,
0,116,0,1,111,
1,2,2,0,1,
2651,170,18,1,2651,
171,20,172,4,44,
73,0,110,0,116,
0,86,0,101,0,
99,0,86,0,101,
0,99,0,65,0,
114,0,103,0,83,
0,116,0,97,0,
116,0,101,0,69,
0,118,0,101,0,
110,0,116,0,1,
110,1,2,2,0,
1,1114,173,18,1,
1114,132,2,0,1,
2654,174,18,1,2654,
153,2,0,1,1152,
175,18,1,1152,176,
20,177,4,32,83,
0,105,0,109,0,
112,0,108,0,101,
0,65,0,115,0,
115,0,105,0,103,
0,110,0,109,0,
101,0,110,0,116,
0,1,138,1,2,
2,0,1,1117,178,
18,1,1117,179,20,
180,4,28,80,0,
69,0,82,0,67,
0,69,0,78,0,
84,0,95,0,69,
0,81,0,85,0,
65,0,76,0,83,
0,1,10,1,1,
2,0,1,40,181,
18,1,40,132,2,
0,1,41,182,18,
1,41,135,2,0,
1,42,183,18,1,
42,184,20,185,4,
20,69,0,120,0,
112,0,114,0,101,
0,115,0,115,0,
105,0,111,0,110,
0,1,156,1,2,
2,0,1,43,186,
18,1,43,187,20,
188,4,22,82,0,
73,0,71,0,72,
0,84,0,95,0,
83,0,72,0,73,
0,70,0,84,0,
1,41,1,1,2,
0,1,44,189,18,
1,44,132,2,0,
1,1159,190,18,1,
1159,184,2,0,1,
46,191,18,1,46,
192,20,193,4,12,
80,0,69,0,82,
0,73,0,79,0,
68,0,1,24,1,
1,2,0,1,47,
194,18,1,47,132,
2,0,1,48,195,
18,1,48,196,20,
197,4,18,68,0,
69,0,67,0,82,
0,69,0,77,0,
69,0,78,0,84,
0,1,5,1,1,
2,0,1,49,198,
18,1,49,199,20,
200,4,18,73,0,
78,0,67,0,82,
0,69,0,77,0,
69,0,78,0,84,
0,1,4,1,1,
2,0,1,50,201,
18,1,50,196,2,
0,1,51,202,18,
1,51,199,2,0,
1,52,203,18,1,
52,135,2,0,1,
2281,204,18,1,2281,
176,2,0,1,2841,
205,18,1,2841,206,
20,207,4,48,71,
0,108,0,111,0,
98,0,97,0,108,
0,70,0,117,0,
110,0,99,0,116,
0,105,0,111,0,
110,0,68,0,101,
0,102,0,105,0,
110,0,105,0,116,
0,105,0,111,0,
110,0,1,100,1,
2,2,0,1,2842,
208,18,1,2842,209,
20,210,4,50,71,
0,108,0,111,0,
98,0,97,0,108,
0,86,0,97,0,
114,0,105,0,97,
0,98,0,108,0,
101,0,68,0,101,
0,99,0,108,0,
97,0,114,0,97,
0,116,0,105,0,
111,0,110,0,1,
99,1,2,2,0,
1,2755,211,18,1,
2755,212,20,213,4,
22,82,0,73,0,
71,0,72,0,84,
0,95,0,66,0,
82,0,65,0,67,
0,69,0,1,13,
1,1,2,0,1,
1730,214,18,1,1730,
176,2,0,1,1731,
215,18,1,1731,150,
2,0,1,61,216,
18,1,61,129,2,
0,1,62,217,18,
1,62,162,2,0,
1,63,218,18,1,
63,132,2,0,1,
65,219,18,1,65,
192,2,0,1,66,
220,18,1,66,132,
2,0,1,67,221,
18,1,67,196,2,
0,1,68,222,18,
1,68,199,2,0,
1,69,223,18,1,
69,196,2,0,1,
70,224,18,1,70,
199,2,0,1,71,
225,18,1,71,135,
2,0,1,73,226,
18,1,73,184,2,
0,1,74,227,18,
1,74,162,2,0,
1,1189,228,18,1,
1189,229,20,230,4,
22,83,0,84,0,
65,0,82,0,95,
0,69,0,81,0,
85,0,65,0,76,
0,83,0,1,8,
1,1,2,0,1,
76,231,18,1,76,
232,20,233,4,20,
76,0,69,0,70,
0,84,0,95,0,
83,0,72,0,73,
0,70,0,84,0,
1,40,1,1,2,
0,1,1153,234,18,
1,1153,235,20,236,
4,24,83,0,76,
0,65,0,83,0,
72,0,95,0,69,
0,81,0,85,0,
65,0,76,0,83,
0,1,9,1,1,
2,0,1,79,237,
18,1,79,238,20,
239,4,10,84,0,
73,0,76,0,68,
0,69,0,1,36,
1,1,2,0,1,
1195,240,18,1,1195,
184,2,0,1,82,
241,18,1,82,184,
2,0,1,1123,242,
18,1,1123,184,2,
0,1,85,243,18,
1,85,244,20,245,
4,26,83,0,84,
0,82,0,79,0,
75,0,69,0,95,
0,83,0,84,0,
82,0,79,0,75,
0,69,0,1,39,
1,1,2,0,1,
2547,246,18,1,2547,
247,20,248,4,28,
82,0,111,0,116,
0,68,0,101,0,
99,0,108,0,97,
0,114,0,97,0,
116,0,105,0,111,
0,110,0,1,123,
1,2,2,0,1,
89,249,18,1,89,
250,20,251,4,10,
77,0,73,0,78,
0,85,0,83,0,
1,19,1,1,2,
0,1,2318,252,18,
1,2318,150,2,0,
1,93,253,18,1,
93,184,2,0,1,
2792,254,18,1,2792,
184,2,0,1,97,
255,18,1,97,256,
20,257,4,14,65,
0,77,0,80,0,
95,0,65,0,77,
0,80,0,1,38,
1,1,2,0,1,
102,258,18,1,102,
259,20,260,4,22,
69,0,88,0,67,
0,76,0,65,0,
77,0,65,0,84,
0,73,0,79,0,
78,0,1,37,1,
1,2,0,1,1775,
261,18,1,1775,162,
2,0,1,107,262,
18,1,107,184,2,
0,1,2337,263,18,
1,2337,162,2,0,
1,1224,264,18,1,
1224,176,2,0,1,
1225,265,18,1,1225,
266,20,267,4,24,
77,0,73,0,78,
0,85,0,83,0,
95,0,69,0,81,
0,85,0,65,0,
76,0,83,0,1,
7,1,1,2,0,
1,112,268,18,1,
112,269,20,270,4,
28,71,0,82,0,
69,0,65,0,84,
0,69,0,82,0,
95,0,69,0,81,
0,85,0,65,0,
76,0,83,0,1,
32,1,1,2,0,
1,1188,271,18,1,
1188,176,2,0,1,
1231,272,18,1,1231,
184,2,0,1,118,
273,18,1,118,184,
2,0,1,1737,274,
18,1,1737,184,2,
0,1,124,275,18,
1,124,276,20,277,
4,22,76,0,69,
0,83,0,83,0,
95,0,69,0,81,
0,85,0,65,0,
76,0,83,0,1,
31,1,1,2,0,
1,2657,278,18,1,
2657,279,20,280,4,
20,83,0,116,0,
97,0,116,0,101,
0,69,0,118,0,
101,0,110,0,116,
0,1,104,1,2,
2,0,1,2658,281,
18,1,2658,282,20,
283,4,26,68,0,
69,0,70,0,65,
0,85,0,76,0,
84,0,95,0,83,
0,84,0,65,0,
84,0,69,0,1,
47,1,1,2,0,
1,2659,284,18,1,
2659,165,2,0,1,
130,285,18,1,130,
184,2,0,1,2843,
286,18,1,2843,206,
2,0,1,1803,287,
18,1,1803,288,20,
289,4,18,83,0,
116,0,97,0,116,
0,101,0,109,0,
101,0,110,0,116,
0,1,135,1,2,
2,0,1,1804,290,
18,1,1804,291,20,
292,4,4,68,0,
79,0,1,44,1,
1,2,0,1,2591,
293,18,1,2591,140,
2,0,1,2364,294,
18,1,2364,288,2,
0,1,137,295,18,
1,137,296,20,297,
4,36,69,0,88,
0,67,0,76,0,
65,0,77,0,65,
0,84,0,73,0,
79,0,78,0,95,
0,69,0,81,0,
85,0,65,0,76,
0,83,0,1,30,
1,1,2,0,1,
2293,298,18,1,2293,
150,2,0,1,2834,
299,18,1,2834,300,
20,301,4,12,83,
0,116,0,97,0,
116,0,101,0,115,
0,1,101,1,2,
2,0,1,1701,302,
18,1,1701,184,2,
0,1,1756,303,18,
1,1756,150,2,0,
1,2527,304,18,1,
2527,114,2,0,1,
143,305,18,1,143,
184,2,0,1,2299,
306,18,1,2299,184,
2,0,1,1260,307,
18,1,1260,176,2,
0,1,1261,308,18,
1,1261,309,20,310,
4,22,80,0,76,
0,85,0,83,0,
95,0,69,0,81,
0,85,0,65,0,
76,0,83,0,1,
6,1,1,2,0,
1,2528,311,18,1,
2528,132,2,0,1,
2844,312,18,1,2844,
209,2,0,1,2845,
104,1,151,313,18,
1,151,314,20,315,
4,26,69,0,81,
0,85,0,65,0,
76,0,83,0,95,
0,69,0,81,0,
85,0,65,0,76,
0,83,0,1,29,
1,1,2,0,1,
1267,316,18,1,1267,
184,2,0,1,157,
317,18,1,157,184,
2,0,1,2767,318,
18,1,2767,319,20,
320,4,10,83,0,
116,0,97,0,116,
0,101,0,1,102,
1,2,2,0,1,
1773,321,18,1,1773,
146,2,0,1,1832,
322,18,1,1832,288,
2,0,1,1833,323,
18,1,1833,324,20,
325,4,10,87,0,
72,0,73,0,76,
0,69,0,1,45,
1,1,2,0,1,
1834,326,18,1,1834,
135,2,0,1,166,
327,18,1,166,328,
20,329,4,20,76,
0,69,0,70,0,
84,0,95,0,65,
0,78,0,71,0,
76,0,69,0,1,
25,1,1,2,0,
1,1840,330,18,1,
1840,184,2,0,1,
2779,331,18,1,2779,
140,2,0,1,172,
332,18,1,172,184,
2,0,1,2785,333,
18,1,2785,159,2,
0,1,2786,334,18,
1,2786,335,20,336,
4,12,69,0,81,
0,85,0,65,0,
76,0,83,0,1,
15,1,1,2,0,
1,2335,337,18,1,
2335,146,2,0,1,
1296,338,18,1,1296,
176,2,0,1,1297,
339,18,1,1297,335,
2,0,1,2413,340,
18,1,2413,341,20,
342,4,26,83,0,
116,0,97,0,116,
0,101,0,109,0,
101,0,110,0,116,
0,76,0,105,0,
115,0,116,0,1,
134,1,2,2,0,
1,1859,343,18,1,
1859,162,2,0,1,
1860,344,18,1,1860,
150,2,0,1,188,
345,18,1,188,184,
2,0,1,182,346,
18,1,182,347,20,
348,4,22,82,0,
73,0,71,0,72,
0,84,0,95,0,
65,0,78,0,71,
0,76,0,69,0,
1,26,1,1,2,
0,1,199,349,18,
1,199,350,20,351,
4,10,67,0,65,
0,82,0,69,0,
84,0,1,35,1,
1,2,0,1,1871,
352,18,1,1871,176,
2,0,1,1872,353,
18,1,1872,162,2,
0,1,1873,354,18,
1,1873,150,2,0,
1,1875,355,18,1,
1875,324,2,0,1,
205,356,18,1,205,
184,2,0,1,2581,
357,18,1,2581,358,
20,359,4,10,69,
0,118,0,101,0,
110,0,116,0,1,
125,1,2,2,0,
1,2515,360,18,1,
2515,143,2,0,1,
1882,361,18,1,1882,
184,2,0,1,2227,
362,18,1,2227,288,
2,0,1,217,363,
18,1,217,364,20,
365,4,12,83,0,
84,0,82,0,79,
0,75,0,69,0,
1,34,1,1,2,
0,1,1332,366,18,
1,1332,176,2,0,
1,1335,367,18,1,
1335,179,2,0,1,
223,368,18,1,223,
184,2,0,1,2846,
369,18,1,2846,370,
23,371,4,6,69,
0,79,0,70,0,
1,2,1,6,2,
0,1,1341,372,18,
1,1341,184,2,0,
1,1901,373,18,1,
1901,162,2,0,1,
1303,374,18,1,1303,
184,2,0,1,2462,
375,18,1,2462,288,
2,0,1,236,376,
18,1,236,377,20,
378,4,6,65,0,
77,0,80,0,1,
33,1,1,2,0,
1,2466,379,18,1,
2466,380,20,381,4,
34,67,0,111,0,
109,0,112,0,111,
0,117,0,110,0,
100,0,83,0,116,
0,97,0,116,0,
101,0,109,0,101,
0,110,0,116,0,
1,133,1,2,2,
0,1,2467,382,18,
1,2467,159,2,0,
1,2468,383,18,1,
2468,384,20,385,4,
10,83,0,84,0,
65,0,84,0,69,
0,1,48,1,1,
2,0,1,2469,386,
18,1,2469,132,2,
0,1,242,387,18,
1,242,184,2,0,
1,2471,388,18,1,
2471,389,20,390,4,
26,67,0,79,0,
78,0,84,0,82,
0,79,0,76,0,
95,0,69,0,86,
0,69,0,78,0,
84,0,1,65,1,
1,2,0,1,2472,
391,18,1,2472,392,
20,393,4,30,65,
0,84,0,95,0,
84,0,65,0,82,
0,71,0,69,0,
84,0,95,0,69,
0,86,0,69,0,
78,0,84,0,1,
59,1,1,2,0,
1,2473,394,18,1,
2473,395,20,396,4,
38,65,0,84,0,
95,0,82,0,79,
0,84,0,95,0,
84,0,65,0,82,
0,71,0,69,0,
84,0,95,0,69,
0,86,0,69,0,
78,0,84,0,1,
58,1,1,2,0,
1,2474,397,18,1,
2474,398,20,399,4,
52,76,0,65,0,
78,0,68,0,95,
0,67,0,79,0,
76,0,76,0,73,
0,83,0,73,0,
79,0,78,0,95,
0,83,0,84,0,
65,0,82,0,84,
0,95,0,69,0,
86,0,69,0,78,
0,84,0,1,71,
1,1,2,0,1,
2475,400,18,1,2475,
401,20,402,4,48,
76,0,65,0,78,
0,68,0,95,0,
67,0,79,0,76,
0,76,0,73,0,
83,0,73,0,79,
0,78,0,95,0,
69,0,78,0,68,
0,95,0,69,0,
86,0,69,0,78,
0,84,0,1,70,
1,1,2,0,1,
2476,403,18,1,2476,
404,20,405,4,40,
76,0,65,0,78,
0,68,0,95,0,
67,0,79,0,76,
0,76,0,73,0,
83,0,73,0,79,
0,78,0,95,0,
69,0,86,0,69,
0,78,0,84,0,
1,69,1,1,2,
0,1,2477,406,18,
1,2477,407,20,408,
4,34,84,0,79,
0,85,0,67,0,
72,0,95,0,83,
0,84,0,65,0,
82,0,84,0,95,
0,69,0,86,0,
69,0,78,0,84,
0,1,89,1,1,
2,0,1,2478,409,
18,1,2478,410,20,
411,4,30,84,0,
79,0,85,0,67,
0,72,0,95,0,
69,0,78,0,68,
0,95,0,69,0,
86,0,69,0,78,
0,84,0,1,90,
1,1,2,0,1,
2479,412,18,1,2479,
413,20,414,4,22,
84,0,79,0,85,
0,67,0,72,0,
95,0,69,0,86,
0,69,0,78,0,
84,0,1,88,1,
1,2,0,1,2480,
415,18,1,2480,416,
20,417,4,24,83,
0,69,0,78,0,
83,0,79,0,82,
0,95,0,69,0,
86,0,69,0,78,
0,84,0,1,84,
1,1,2,0,1,
2481,418,18,1,2481,
419,20,420,4,52,
82,0,85,0,78,
0,95,0,84,0,
73,0,77,0,69,
0,95,0,80,0,
69,0,82,0,77,
0,73,0,83,0,
83,0,73,0,79,
0,78,0,83,0,
95,0,69,0,86,
0,69,0,78,0,
84,0,1,83,1,
1,2,0,1,2482,
421,18,1,2482,422,
20,423,4,24,79,
0,78,0,95,0,
82,0,69,0,90,
0,95,0,69,0,
86,0,69,0,78,
0,84,0,1,81,
1,1,2,0,1,
2483,424,18,1,2483,
425,20,426,4,42,
67,0,79,0,76,
0,76,0,73,0,
83,0,73,0,79,
0,78,0,95,0,
83,0,84,0,65,
0,82,0,84,0,
95,0,69,0,86,
0,69,0,78,0,
84,0,1,64,1,
1,2,0,1,256,
427,18,1,256,428,
20,429,4,14,80,
0,69,0,82,0,
67,0,69,0,78,
0,84,0,1,22,
1,1,2,0,1,
1371,430,18,1,1371,
235,2,0,1,2486,
431,18,1,2486,432,
20,433,4,26,67,
0,72,0,65,0,
78,0,71,0,69,
0,68,0,95,0,
69,0,86,0,69,
0,78,0,84,0,
1,61,1,1,2,
0,1,2487,434,18,
1,2487,435,20,436,
4,32,79,0,66,
0,74,0,69,0,
67,0,84,0,95,
0,82,0,69,0,
90,0,95,0,69,
0,86,0,69,0,
78,0,84,0,1,
80,1,1,2,0,
1,1931,437,18,1,
1931,288,2,0,1,
1932,438,18,1,1932,
439,20,440,4,4,
73,0,70,0,1,
42,1,1,2,0,
1,262,441,18,1,
262,184,2,0,1,
1377,442,18,1,1377,
184,2,0,1,2492,
443,18,1,2492,444,
20,445,4,30,78,
0,79,0,95,0,
83,0,69,0,78,
0,83,0,79,0,
82,0,95,0,69,
0,86,0,69,0,
78,0,84,0,1,
77,1,1,2,0,
1,1876,446,18,1,
1876,135,2,0,1,
2494,447,18,1,2494,
448,20,449,4,32,
77,0,79,0,86,
0,73,0,78,0,
71,0,95,0,69,
0,78,0,68,0,
95,0,69,0,86,
0,69,0,78,0,
84,0,1,75,1,
1,2,0,1,2495,
450,18,1,2495,451,
20,452,4,32,83,
0,84,0,65,0,
84,0,69,0,95,
0,69,0,88,0,
73,0,84,0,95,
0,69,0,86,0,
69,0,78,0,84,
0,1,86,1,1,
2,0,1,1939,453,
18,1,1939,184,2,
0,1,2497,454,18,
1,2497,455,20,456,
4,48,84,0,82,
0,65,0,78,0,
83,0,65,0,67,
0,84,0,73,0,
79,0,78,0,95,
0,82,0,69,0,
83,0,85,0,76,
0,84,0,95,0,
69,0,86,0,69,
0,78,0,84,0,
1,92,1,1,2,
0,1,827,457,18,
1,827,184,2,0,
1,2499,458,18,1,
2499,459,20,460,4,
34,82,0,69,0,
77,0,79,0,84,
0,69,0,95,0,
68,0,65,0,84,
0,65,0,95,0,
69,0,86,0,69,
0,78,0,84,0,
1,82,1,1,2,
0,1,2500,461,18,
1,2500,462,20,463,
4,22,77,0,79,
0,78,0,69,0,
89,0,95,0,69,
0,86,0,69,0,
78,0,84,0,1,
74,1,1,2,0,
1,2501,464,18,1,
2501,465,20,466,4,
24,76,0,73,0,
83,0,84,0,69,
0,78,0,95,0,
69,0,86,0,69,
0,78,0,84,0,
1,73,1,1,2,
0,1,2502,467,18,
1,2502,468,20,469,
4,36,76,0,73,
0,78,0,75,0,
95,0,77,0,69,
0,83,0,83,0,
65,0,71,0,69,
0,95,0,69,0,
86,0,69,0,78,
0,84,0,1,72,
1,1,2,0,1,
2503,470,18,1,2503,
471,20,472,4,38,
72,0,84,0,84,
0,80,0,95,0,
82,0,69,0,83,
0,80,0,79,0,
78,0,83,0,69,
0,95,0,69,0,
86,0,69,0,78,
0,84,0,1,68,
1,1,2,0,1,
2504,473,18,1,2504,
474,20,475,4,22,
69,0,77,0,65,
0,73,0,76,0,
95,0,69,0,86,
0,69,0,78,0,
84,0,1,67,1,
1,2,0,1,277,
476,18,1,277,477,
20,478,4,10,83,
0,76,0,65,0,
83,0,72,0,1,
21,1,1,2,0,
1,2506,479,18,1,
2506,480,20,481,4,
34,75,0,101,0,
121,0,73,0,110,
0,116,0,73,0,
110,0,116,0,65,
0,114,0,103,0,
69,0,118,0,101,
0,110,0,116,0,
1,132,1,2,2,
0,1,2507,482,18,
1,2507,135,2,0,
1,2508,483,18,1,
2508,117,2,0,1,
2509,484,18,1,2509,
132,2,0,1,2510,
485,18,1,2510,486,
20,487,4,28,75,
0,101,0,121,0,
68,0,101,0,99,
0,108,0,97,0,
114,0,97,0,116,
0,105,0,111,0,
110,0,1,120,1,
2,2,0,1,283,
488,18,1,283,184,
2,0,1,2512,489,
18,1,2512,126,2,
0,1,2513,490,18,
1,2513,132,2,0,
1,2514,491,18,1,
2514,492,20,493,4,
28,73,0,110,0,
116,0,68,0,101,
0,99,0,108,0,
97,0,114,0,97,
0,116,0,105,0,
111,0,110,0,1,
121,1,2,2,0,
1,1958,494,18,1,
1958,162,2,0,1,
2517,495,18,1,2517,
492,2,0,1,2518,
496,18,1,2518,497,
20,498,4,64,75,
0,101,0,121,0,
73,0,110,0,116,
0,73,0,110,0,
116,0,65,0,114,
0,103,0,117,0,
109,0,101,0,110,
0,116,0,68,0,
101,0,99,0,108,
0,97,0,114,0,
97,0,116,0,105,
0,111,0,110,0,
76,0,105,0,115,
0,116,0,1,118,
1,2,2,0,1,
2519,499,18,1,2519,
162,2,0,1,1406,
500,18,1,1406,176,
2,0,1,1407,501,
18,1,1407,229,2,
0,1,2522,502,18,
1,2522,503,20,504,
4,34,73,0,110,
0,116,0,86,0,
101,0,99,0,86,
0,101,0,99,0,
65,0,114,0,103,
0,69,0,118,0,
101,0,110,0,116,
0,1,131,1,2,
2,0,1,2523,505,
18,1,2523,135,2,
0,1,2525,506,18,
1,2525,492,2,0,
1,2526,507,18,1,
2526,143,2,0,1,
299,508,18,1,299,
509,20,510,4,8,
83,0,84,0,65,
0,82,0,1,20,
1,1,2,0,1,
1370,511,18,1,1370,
176,2,0,1,2529,
512,18,1,2529,513,
20,514,4,28,86,
0,101,0,99,0,
68,0,101,0,99,
0,108,0,97,0,
114,0,97,0,116,
0,105,0,111,0,
110,0,1,122,1,
2,2,0,1,2530,
515,18,1,2530,143,
2,0,1,2532,516,
18,1,2532,513,2,
0,1,305,517,18,
1,305,184,2,0,
1,2534,518,18,1,
2534,162,2,0,1,
2822,519,18,1,2822,
150,2,0,1,2458,
520,18,1,2458,288,
2,0,1,2459,521,
18,1,2459,212,2,
0,1,2538,522,18,
1,2538,135,2,0,
1,2540,523,18,1,
2540,492,2,0,1,
2541,524,18,1,2541,
143,2,0,1,2542,
525,18,1,2542,111,
2,0,1,2464,526,
18,1,2464,212,2,
0,1,2544,527,18,
1,2544,247,2,0,
1,2545,528,18,1,
2545,143,2,0,1,
1989,529,18,1,1989,
288,2,0,1,1990,
530,18,1,1990,531,
20,532,4,8,69,
0,76,0,83,0,
69,0,1,43,1,
1,2,0,1,2548,
533,18,1,2548,534,
20,535,4,64,73,
0,110,0,116,0,
82,0,111,0,116,
0,82,0,111,0,
116,0,65,0,114,
0,103,0,117,0,
109,0,101,0,110,
0,116,0,68,0,
101,0,99,0,108,
0,97,0,114,0,
97,0,116,0,105,
0,111,0,110,0,
76,0,105,0,115,
0,116,0,1,116,
1,2,2,0,1,
2470,536,18,1,2470,
165,2,0,1,322,
537,18,1,322,250,
2,0,1,2551,538,
18,1,2551,380,2,
0,1,1933,539,18,
1,1933,135,2,0,
1,2553,540,18,1,
2553,135,2,0,1,
883,541,18,1,883,
184,2,0,1,2555,
542,18,1,2555,513,
2,0,1,328,543,
18,1,328,184,2,
0,1,1443,544,18,
1,1443,266,2,0,
1,2559,545,18,1,
2559,380,2,0,1,
2560,546,18,1,2560,
547,20,548,4,22,
73,0,110,0,116,
0,65,0,114,0,
103,0,69,0,118,
0,101,0,110,0,
116,0,1,128,1,
2,2,0,1,2561,
549,18,1,2561,135,
2,0,1,1449,550,
18,1,1449,184,2,
0,1,2485,551,18,
1,2485,552,20,553,
4,30,67,0,79,
0,76,0,76,0,
73,0,83,0,73,
0,79,0,78,0,
95,0,69,0,86,
0,69,0,78,0,
84,0,1,62,1,
1,2,0,1,2565,
554,18,1,2565,162,
2,0,1,2488,555,
18,1,2488,556,20,
557,4,24,65,0,
84,0,84,0,65,
0,67,0,72,0,
95,0,69,0,86,
0,69,0,78,0,
84,0,1,60,1,
1,2,0,1,2489,
558,18,1,2489,559,
20,560,4,22,84,
0,73,0,77,0,
69,0,82,0,95,
0,69,0,86,0,
69,0,78,0,84,
0,1,87,1,1,
2,0,1,2490,561,
18,1,2490,562,20,
563,4,38,78,0,
79,0,84,0,95,
0,65,0,84,0,
95,0,84,0,65,
0,82,0,71,0,
69,0,84,0,95,
0,69,0,86,0,
69,0,78,0,84,
0,1,79,1,1,
2,0,1,2491,564,
18,1,2491,565,20,
566,4,46,78,0,
79,0,84,0,95,
0,65,0,84,0,
95,0,82,0,79,
0,84,0,95,0,
84,0,65,0,82,
0,71,0,69,0,
84,0,95,0,69,
0,86,0,69,0,
78,0,84,0,1,
78,1,1,2,0,
1,2571,567,18,1,
2571,486,2,0,1,
2493,568,18,1,2493,
569,20,570,4,36,
77,0,79,0,86,
0,73,0,78,0,
71,0,95,0,83,
0,84,0,65,0,
82,0,84,0,95,
0,69,0,86,0,
69,0,78,0,84,
0,1,76,1,1,
2,0,1,1413,571,
18,1,1413,184,2,
0,1,346,572,18,
1,346,573,20,574,
4,8,80,0,76,
0,85,0,83,0,
1,18,1,1,2,
0,1,2575,575,18,
1,2575,380,2,0,
1,2496,576,18,1,
2496,577,20,578,4,
34,83,0,84,0,
65,0,84,0,69,
0,95,0,69,0,
78,0,84,0,82,
0,89,0,95,0,
69,0,86,0,69,
0,78,0,84,0,
1,85,1,1,2,
0,1,2577,579,18,
1,2577,135,2,0,
1,2021,580,18,1,
2021,288,2,0,1,
2022,581,18,1,2022,
384,2,0,1,352,
582,18,1,352,184,
2,0,1,2024,583,
18,1,2024,132,2,
0,1,2025,584,18,
1,2025,585,20,586,
4,8,74,0,85,
0,77,0,80,0,
1,49,1,1,2,
0,1,2026,587,18,
1,2026,132,2,0,
1,2027,588,18,1,
2027,589,20,590,4,
4,65,0,84,0,
1,23,1,1,2,
0,1,2028,591,18,
1,2028,132,2,0,
1,2029,592,18,1,
2029,380,2,0,1,
2030,593,18,1,2030,
594,20,595,4,14,
70,0,111,0,114,
0,76,0,111,0,
111,0,112,0,1,
146,1,2,2,0,
1,2031,596,18,1,
2031,597,20,598,4,
32,68,0,111,0,
87,0,104,0,105,
0,108,0,101,0,
83,0,116,0,97,
0,116,0,101,0,
109,0,101,0,110,
0,116,0,1,145,
1,2,2,0,1,
2032,599,18,1,2032,
600,20,601,4,28,
87,0,104,0,105,
0,108,0,101,0,
83,0,116,0,97,
0,116,0,101,0,
109,0,101,0,110,
0,116,0,1,144,
1,2,2,0,1,
2033,602,18,1,2033,
603,20,604,4,22,
73,0,102,0,83,
0,116,0,97,0,
116,0,101,0,109,
0,101,0,110,0,
116,0,1,143,1,
2,2,0,1,2034,
605,18,1,2034,606,
20,607,4,22,83,
0,116,0,97,0,
116,0,101,0,67,
0,104,0,97,0,
110,0,103,0,101,
0,1,142,1,2,
2,0,1,1478,608,
18,1,1478,176,2,
0,1,1479,609,18,
1,1479,309,2,0,
1,2037,610,18,1,
2037,150,2,0,1,
2038,611,18,1,2038,
612,20,613,4,18,
74,0,117,0,109,
0,112,0,76,0,
97,0,98,0,101,
0,108,0,1,140,
1,2,2,0,1,
2039,614,18,1,2039,
150,2,0,1,2040,
615,18,1,2040,616,
20,617,4,30,82,
0,101,0,116,0,
117,0,114,0,110,
0,83,0,116,0,
97,0,116,0,101,
0,109,0,101,0,
110,0,116,0,1,
139,1,2,2,0,
1,2041,618,18,1,
2041,150,2,0,1,
1485,619,18,1,1485,
184,2,0,1,372,
620,18,1,372,196,
2,0,1,373,621,
18,1,373,132,2,
0,1,374,622,18,
1,374,192,2,0,
1,375,623,18,1,
375,132,2,0,1,
376,624,18,1,376,
199,2,0,1,377,
625,18,1,377,132,
2,0,1,378,626,
18,1,378,192,2,
0,1,379,627,18,
1,379,132,2,0,
1,380,628,18,1,
380,629,20,630,4,
16,67,0,111,0,
110,0,115,0,116,
0,97,0,110,0,
116,0,1,152,1,
2,2,0,1,381,
631,18,1,381,328,
2,0,1,371,632,
18,1,371,633,20,
634,4,24,70,0,
117,0,110,0,99,
0,116,0,105,0,
111,0,110,0,67,
0,97,0,108,0,
108,0,1,148,1,
2,2,0,1,942,
635,18,1,942,184,
2,0,1,2533,636,
18,1,2533,637,20,
638,4,64,73,0,
110,0,116,0,86,
0,101,0,99,0,
86,0,101,0,99,
0,65,0,114,0,
103,0,117,0,109,
0,101,0,110,0,
116,0,68,0,101,
0,99,0,108,0,
97,0,114,0,97,
0,116,0,105,0,
111,0,110,0,76,
0,105,0,115,0,
116,0,1,117,1,
2,2,0,1,387,
639,18,1,387,184,
2,0,1,2536,640,
18,1,2536,380,2,
0,1,2537,641,18,
1,2537,642,20,643,
4,34,73,0,110,
0,116,0,82,0,
111,0,116,0,82,
0,111,0,116,0,
65,0,114,0,103,
0,69,0,118,0,
101,0,110,0,116,
0,1,130,1,2,
2,0,1,2543,644,
18,1,2543,132,2,
0,1,2823,645,18,
1,2823,646,20,647,
4,34,71,0,108,
0,111,0,98,0,
97,0,108,0,68,
0,101,0,102,0,
105,0,110,0,105,
0,116,0,105,0,
111,0,110,0,115,
0,1,98,1,2,
2,0,1,1514,648,
18,1,1514,176,2,
0,1,1515,649,18,
1,1515,335,2,0,
1,2549,650,18,1,
2549,162,2,0,1,
2074,651,18,1,2074,
176,2,0,1,2075,
652,18,1,2075,162,
2,0,1,2552,653,
18,1,2552,654,20,
655,4,28,86,0,
101,0,99,0,116,
0,111,0,114,0,
65,0,114,0,103,
0,69,0,118,0,
101,0,110,0,116,
0,1,129,1,2,
2,0,1,406,656,
18,1,406,143,2,
0,1,1521,657,18,
1,1521,184,2,0,
1,2556,658,18,1,
2556,659,20,660,4,
58,86,0,101,0,
99,0,116,0,111,
0,114,0,65,0,
114,0,103,0,117,
0,109,0,101,0,
110,0,116,0,68,
0,101,0,99,0,
108,0,97,0,114,
0,97,0,116,0,
105,0,111,0,110,
0,76,0,105,0,
115,0,116,0,1,
115,1,2,2,0,
1,2557,661,18,1,
2557,162,2,0,1,
412,662,18,1,412,
184,2,0,1,2641,
663,18,1,2641,168,
2,0,1,2484,664,
18,1,2484,665,20,
666,4,38,67,0,
79,0,76,0,76,
0,73,0,83,0,
73,0,79,0,78,
0,95,0,69,0,
78,0,68,0,95,
0,69,0,86,0,
69,0,78,0,84,
0,1,63,1,1,
2,0,1,2643,667,
18,1,2643,668,20,
669,4,44,73,0,
110,0,116,0,82,
0,111,0,116,0,
82,0,111,0,116,
0,65,0,114,0,
103,0,83,0,116,
0,97,0,116,0,
101,0,69,0,118,
0,101,0,110,0,
116,0,1,109,1,
2,2,0,1,2644,
670,18,1,2644,671,
20,672,4,38,86,
0,101,0,99,0,
116,0,111,0,114,
0,65,0,114,0,
103,0,83,0,116,
0,97,0,116,0,
101,0,69,0,118,
0,101,0,110,0,
116,0,1,108,1,
2,2,0,1,2023,
673,18,1,2023,282,
2,0,1,2564,674,
18,1,2564,675,20,
676,4,52,73,0,
110,0,116,0,65,
0,114,0,103,0,
117,0,109,0,101,
0,110,0,116,0,
68,0,101,0,99,
0,108,0,97,0,
114,0,97,0,116,
0,105,0,111,0,
110,0,76,0,105,
0,115,0,116,0,
1,114,1,2,2,
0,1,2647,677,18,
1,2647,678,20,679,
4,34,86,0,111,
0,105,0,100,0,
65,0,114,0,103,
0,83,0,116,0,
97,0,116,0,101,
0,69,0,118,0,
101,0,110,0,116,
0,1,105,1,2,
2,0,1,2648,680,
18,1,2648,279,2,
0,1,2567,681,18,
1,2567,380,2,0,
1,1442,682,18,1,
1442,176,2,0,1,
2569,683,18,1,2569,
135,2,0,1,2652,
684,18,1,2652,668,
2,0,1,2653,685,
18,1,2653,671,2,
0,1,2572,686,18,
1,2572,687,20,688,
4,52,75,0,101,
0,121,0,65,0,
114,0,103,0,117,
0,109,0,101,0,
110,0,116,0,68,
0,101,0,99,0,
108,0,97,0,114,
0,97,0,116,0,
105,0,111,0,110,
0,76,0,105,0,
115,0,116,0,1,
113,1,2,2,0,
1,2573,689,18,1,
2573,162,2,0,1,
2656,690,18,1,2656,
678,2,0,1,2035,
691,18,1,2035,150,
2,0,1,2036,692,
18,1,2036,693,20,
694,4,26,74,0,
117,0,109,0,112,
0,83,0,116,0,
97,0,116,0,101,
0,109,0,101,0,
110,0,116,0,1,
141,1,2,2,0,
1,431,695,18,1,
431,143,2,0,1,
2578,696,18,1,2578,
162,2,0,1,2105,
697,18,1,2105,288,
2,0,1,2106,698,
18,1,2106,531,2,
0,1,1550,699,18,
1,1550,176,2,0,
1,437,700,18,1,
437,184,2,0,1,
2044,701,18,1,2044,
702,20,703,4,28,
69,0,109,0,112,
0,116,0,121,0,
83,0,116,0,97,
0,116,0,101,0,
109,0,101,0,110,
0,116,0,1,136,
1,2,2,0,1,
2045,704,18,1,2045,
150,2,0,1,1555,
705,18,1,1555,184,
2,0,1,2511,706,
18,1,2511,143,2,
0,1,1001,707,18,
1,1001,633,2,0,
1,1002,708,18,1,
1002,629,2,0,1,
447,709,18,1,447,
347,2,0,1,2593,
710,18,1,2593,162,
2,0,1,2595,711,
18,1,2595,380,2,
0,1,2597,712,18,
1,2597,713,20,714,
4,18,83,0,116,
0,97,0,116,0,
101,0,66,0,111,
0,100,0,121,0,
1,103,1,2,2,
0,1,1010,715,18,
1,1010,176,2,0,
1,1011,716,18,1,
1011,162,2,0,1,
1012,717,18,1,1012,
184,2,0,1,1013,
718,18,1,1013,162,
2,0,1,459,719,
18,1,459,720,20,
721,4,24,76,0,
69,0,70,0,84,
0,95,0,66,0,
82,0,65,0,67,
0,75,0,69,0,
84,0,1,27,1,
1,2,0,1,1574,
722,18,1,1574,150,
2,0,1,461,723,
18,1,461,724,20,
725,4,24,65,0,
114,0,103,0,117,
0,109,0,101,0,
110,0,116,0,76,
0,105,0,115,0,
116,0,1,149,1,
2,2,0,1,462,
726,18,1,462,143,
2,0,1,464,727,
18,1,464,728,20,
729,4,16,65,0,
114,0,103,0,117,
0,109,0,101,0,
110,0,116,0,1,
150,1,2,2,0,
1,2136,730,18,1,
2136,288,2,0,1,
1585,731,18,1,1585,
732,20,733,4,12,
82,0,69,0,84,
0,85,0,82,0,
78,0,1,50,1,
1,2,0,1,2703,
734,18,1,2703,713,
2,0,1,476,735,
18,1,476,736,20,
737,4,30,83,0,
84,0,82,0,73,
0,78,0,71,0,
95,0,67,0,79,
0,78,0,83,0,
84,0,65,0,78,
0,84,0,1,3,
1,1,2,0,1,
477,738,18,1,477,
739,20,740,4,28,
70,0,76,0,79,
0,65,0,84,0,
95,0,67,0,79,
0,78,0,83,0,
84,0,65,0,78,
0,84,0,1,96,
1,1,2,0,1,
478,741,18,1,478,
742,20,743,4,40,
72,0,69,0,88,
0,95,0,73,0,
78,0,84,0,69,
0,71,0,69,0,
82,0,95,0,67,
0,79,0,78,0,
83,0,84,0,65,
0,78,0,84,0,
1,95,1,1,2,
0,1,479,744,18,
1,479,745,20,746,
4,32,73,0,78,
0,84,0,69,0,
71,0,69,0,82,
0,95,0,67,0,
79,0,78,0,83,
0,84,0,65,0,
78,0,84,0,1,
94,1,1,2,0,
1,480,747,18,1,
480,748,20,749,4,
26,82,0,73,0,
71,0,72,0,84,
0,95,0,66,0,
82,0,65,0,67,
0,75,0,69,0,
84,0,1,28,1,
1,2,0,1,481,
750,18,1,481,728,
2,0,1,1048,751,
18,1,1048,184,2,
0,1,2642,752,18,
1,2642,171,2,0,
1,2563,753,18,1,
2563,492,2,0,1,
2042,754,18,1,2042,
755,20,756,4,20,
65,0,115,0,115,
0,105,0,103,0,
110,0,109,0,101,
0,110,0,116,0,
1,137,1,2,2,
0,1,2043,757,18,
1,2043,150,2,0,
1,2568,758,18,1,
2568,759,20,760,4,
22,75,0,101,0,
121,0,65,0,114,
0,103,0,69,0,
118,0,101,0,110,
0,116,0,1,127,
1,2,2,0,1,
2649,761,18,1,2649,
212,2,0,1,1620,
762,18,1,1620,176,
2,0,1,1621,763,
18,1,1621,159,2,
0,1,1622,764,18,
1,1622,335,2,0,
1,509,765,18,1,
509,143,2,0,1,
2498,766,18,1,2498,
767,20,768,4,36,
72,0,84,0,84,
0,80,0,95,0,
82,0,69,0,81,
0,85,0,69,0,
83,0,84,0,95,
0,69,0,86,0,
69,0,78,0,84,
0,1,91,1,1,
2,0,1,2655,769,
18,1,2655,156,2,
0,1,2576,770,18,
1,2576,771,20,772,
4,24,86,0,111,
0,105,0,100,0,
65,0,114,0,103,
0,69,0,118,0,
101,0,110,0,116,
0,1,126,1,2,
2,0,1,1628,773,
18,1,1628,184,2,
0,1,515,774,18,
1,515,184,2,0,
1,2580,775,18,1,
2580,380,2,0,1,
2505,776,18,1,2505,
777,20,778,4,32,
68,0,65,0,84,
0,65,0,83,0,
69,0,82,0,86,
0,69,0,82,0,
95,0,69,0,86,
0,69,0,78,0,
84,0,1,66,1,
1,2,0,1,2582,
779,18,1,2582,135,
2,0,1,525,780,
18,1,525,347,2,
0,1,2197,781,18,
1,2197,176,2,0,
1,2198,782,18,1,
2198,162,2,0,1,
1591,783,18,1,1591,
184,2,0,1,2521,
784,18,1,2521,380,
2,0,1,2764,785,
18,1,2764,300,2,
0,1,1094,786,18,
1,1094,724,2,0,
1,1096,787,18,1,
1096,162,2,0,1,
2768,788,18,1,2768,
319,2,0,1,2769,
789,18,1,2769,132,
2,0,1,2770,790,
18,1,2770,135,2,
0,1,1657,791,18,
1,1657,150,2,0,
1,1658,792,18,1,
1658,793,20,794,4,
6,70,0,79,0,
82,0,1,46,1,
1,2,0,1,1659,
795,18,1,1659,135,
2,0,1,1665,796,
18,1,1665,184,2,
0,1,2781,797,18,
1,2781,162,2,0,
1,2783,798,18,1,
2783,380,2,0,1,
1113,799,18,1,1113,
192,2,0,800,5,
0,801,5,381,1,
2,802,19,371,1,
2,803,5,6,1,
2764,804,17,805,15,
806,4,30,37,0,
76,0,83,0,76,
0,80,0,114,0,
111,0,103,0,114,
0,97,0,109,0,
82,0,111,0,111,
0,116,0,1,-1,
1,5,807,20,808,
4,32,76,0,83,
0,76,0,80,0,
114,0,111,0,103,
0,114,0,97,0,
109,0,82,0,111,
0,111,0,116,0,
95,0,50,0,1,
168,1,3,1,2,
1,1,809,22,1,
2,1,2768,810,17,
811,15,812,4,14,
37,0,83,0,116,
0,97,0,116,0,
101,0,115,0,1,
-1,1,5,813,20,
814,4,16,83,0,
116,0,97,0,116,
0,101,0,115,0,
95,0,49,0,1,
177,1,3,1,2,
1,1,815,22,1,
11,1,2755,816,17,
817,15,818,4,12,
37,0,83,0,116,
0,97,0,116,0,
101,0,1,-1,1,
5,819,20,820,4,
14,83,0,116,0,
97,0,116,0,101,
0,95,0,49,0,
1,179,1,3,1,
5,1,4,821,22,
1,13,1,2767,822,
17,823,15,812,1,
-1,1,5,824,20,
825,4,16,83,0,
116,0,97,0,116,
0,101,0,115,0,
95,0,50,0,1,
178,1,3,1,3,
1,2,826,22,1,
12,1,2834,827,17,
828,15,806,1,-1,
1,5,829,20,830,
4,32,76,0,83,
0,76,0,80,0,
114,0,111,0,103,
0,114,0,97,0,
109,0,82,0,111,
0,111,0,116,0,
95,0,49,0,1,
167,1,3,1,3,
1,2,831,22,1,
1,1,2649,832,17,
833,15,818,1,-1,
1,5,834,20,835,
4,14,83,0,116,
0,97,0,116,0,
101,0,95,0,50,
0,1,180,1,3,
1,6,1,5,836,
22,1,14,1,3,
837,19,737,1,3,
838,5,95,1,256,
839,16,0,735,1,
1261,840,16,0,735,
1,509,841,16,0,
735,1,1515,842,16,
0,735,1,2021,843,
17,844,15,845,4,
24,37,0,73,0,
102,0,83,0,116,
0,97,0,116,0,
101,0,109,0,101,
0,110,0,116,0,
1,-1,1,5,846,
20,847,4,26,73,
0,102,0,83,0,
116,0,97,0,116,
0,101,0,109,0,
101,0,110,0,116,
0,95,0,50,0,
1,241,1,3,1,
8,1,7,848,22,
1,76,1,1775,849,
16,0,735,1,2029,
850,17,851,15,852,
4,20,37,0,83,
0,116,0,97,0,
116,0,101,0,109,
0,101,0,110,0,
116,0,1,-1,1,
5,853,20,854,4,
24,83,0,116,0,
97,0,116,0,101,
0,109,0,101,0,
110,0,116,0,95,
0,49,0,51,0,
1,235,1,3,1,
2,1,1,855,22,
1,70,1,2030,856,
17,857,15,852,1,
-1,1,5,858,20,
859,4,24,83,0,
116,0,97,0,116,
0,101,0,109,0,
101,0,110,0,116,
0,95,0,49,0,
50,0,1,234,1,
3,1,2,1,1,
860,22,1,69,1,
2031,861,17,862,15,
852,1,-1,1,5,
863,20,864,4,24,
83,0,116,0,97,
0,116,0,101,0,
109,0,101,0,110,
0,116,0,95,0,
49,0,49,0,1,
233,1,3,1,2,
1,1,865,22,1,
68,1,2032,866,17,
867,15,852,1,-1,
1,5,868,20,869,
4,24,83,0,116,
0,97,0,116,0,
101,0,109,0,101,
0,110,0,116,0,
95,0,49,0,48,
0,1,232,1,3,
1,2,1,1,870,
22,1,67,1,2033,
871,17,872,15,852,
1,-1,1,5,873,
20,874,4,22,83,
0,116,0,97,0,
116,0,101,0,109,
0,101,0,110,0,
116,0,95,0,57,
0,1,231,1,3,
1,2,1,1,875,
22,1,66,1,277,
876,16,0,735,1,
2035,877,17,878,15,
852,1,-1,1,5,
879,20,880,4,22,
83,0,116,0,97,
0,116,0,101,0,
109,0,101,0,110,
0,116,0,95,0,
56,0,1,230,1,
3,1,3,1,2,
881,22,1,65,1,
2037,882,17,883,15,
852,1,-1,1,5,
884,20,885,4,22,
83,0,116,0,97,
0,116,0,101,0,
109,0,101,0,110,
0,116,0,95,0,
55,0,1,229,1,
3,1,3,1,2,
886,22,1,64,1,
2039,887,17,888,15,
852,1,-1,1,5,
889,20,890,4,22,
83,0,116,0,97,
0,116,0,101,0,
109,0,101,0,110,
0,116,0,95,0,
54,0,1,228,1,
3,1,3,1,2,
891,22,1,63,1,
32,892,16,0,735,
1,2041,893,17,894,
15,852,1,-1,1,
5,895,20,896,4,
22,83,0,116,0,
97,0,116,0,101,
0,109,0,101,0,
110,0,116,0,95,
0,53,0,1,227,
1,3,1,3,1,
2,897,22,1,62,
1,2293,898,16,0,
735,1,2043,899,17,
900,15,852,1,-1,
1,5,901,20,902,
4,22,83,0,116,
0,97,0,116,0,
101,0,109,0,101,
0,110,0,116,0,
95,0,51,0,1,
225,1,3,1,3,
1,2,903,22,1,
60,1,2045,904,17,
905,15,852,1,-1,
1,5,906,20,907,
4,22,83,0,116,
0,97,0,116,0,
101,0,109,0,101,
0,110,0,116,0,
95,0,49,0,1,
223,1,3,1,3,
1,2,908,22,1,
58,1,41,909,16,
0,735,1,1297,910,
16,0,735,1,43,
911,16,0,735,1,
1803,912,17,913,15,
914,4,16,37,0,
70,0,111,0,114,
0,76,0,111,0,
111,0,112,0,1,
-1,1,5,915,20,
916,4,18,70,0,
111,0,114,0,76,
0,111,0,111,0,
112,0,95,0,49,
0,1,248,1,3,
1,10,1,9,917,
22,1,83,1,1804,
918,16,0,735,1,
299,919,16,0,735,
1,52,920,16,0,
735,1,2318,921,16,
0,735,1,62,922,
16,0,735,1,2075,
923,16,0,735,1,
1574,924,17,925,15,
852,1,-1,1,5,
926,20,927,4,22,
83,0,116,0,97,
0,116,0,101,0,
109,0,101,0,110,
0,116,0,95,0,
52,0,1,226,1,
3,1,3,1,2,
928,22,1,61,1,
71,929,16,0,735,
1,76,930,16,0,
735,1,1834,931,16,
0,735,1,2337,932,
16,0,735,1,79,
933,16,0,735,1,
1335,934,16,0,735,
1,322,935,16,0,
735,1,85,936,16,
0,735,1,89,937,
16,0,735,1,346,
938,16,0,735,1,
2105,939,17,940,15,
845,1,-1,1,5,
941,20,942,4,26,
73,0,102,0,83,
0,116,0,97,0,
116,0,101,0,109,
0,101,0,110,0,
116,0,95,0,51,
0,1,242,1,3,
1,6,1,5,943,
22,1,77,1,2106,
944,16,0,735,1,
97,945,16,0,735,
1,1860,946,17,947,
15,948,4,34,37,
0,68,0,111,0,
87,0,104,0,105,
0,108,0,101,0,
83,0,116,0,97,
0,116,0,101,0,
109,0,101,0,110,
0,116,0,1,-1,
1,5,949,20,950,
4,36,68,0,111,
0,87,0,104,0,
105,0,108,0,101,
0,83,0,116,0,
97,0,116,0,101,
0,109,0,101,0,
110,0,116,0,95,
0,49,0,1,246,
1,3,1,8,1,
7,951,22,1,81,
1,2364,952,17,953,
15,914,1,-1,1,
5,954,20,955,4,
18,70,0,111,0,
114,0,76,0,111,
0,111,0,112,0,
95,0,50,0,1,
249,1,3,1,9,
1,8,956,22,1,
84,1,102,957,16,
0,735,1,112,958,
16,0,735,1,1117,
959,16,0,735,1,
2786,960,16,0,735,
1,1873,961,17,962,
15,948,1,-1,1,
5,963,20,964,4,
36,68,0,111,0,
87,0,104,0,105,
0,108,0,101,0,
83,0,116,0,97,
0,116,0,101,0,
109,0,101,0,110,
0,116,0,95,0,
50,0,1,247,1,
3,1,8,1,7,
965,22,1,82,1,
1876,966,16,0,735,
1,124,967,16,0,
735,1,2136,968,17,
969,15,845,1,-1,
1,5,970,20,971,
4,26,73,0,102,
0,83,0,116,0,
97,0,116,0,101,
0,109,0,101,0,
110,0,116,0,95,
0,52,0,1,243,
1,3,1,8,1,
7,972,22,1,78,
1,381,973,16,0,
735,1,525,974,16,
0,735,1,137,975,
16,0,735,1,1901,
976,16,0,735,1,
1153,977,16,0,735,
1,151,978,16,0,
735,1,1407,979,16,
0,735,1,1659,980,
16,0,735,1,2413,
981,16,0,735,1,
406,982,16,0,735,
1,1371,983,16,0,
735,1,166,984,16,
0,735,1,1622,985,
16,0,735,1,1931,
986,17,987,15,988,
4,30,37,0,87,
0,104,0,105,0,
108,0,101,0,83,
0,116,0,97,0,
116,0,101,0,109,
0,101,0,110,0,
116,0,1,-1,1,
5,989,20,990,4,
32,87,0,104,0,
105,0,108,0,101,
0,83,0,116,0,
97,0,116,0,101,
0,109,0,101,0,
110,0,116,0,95,
0,49,0,1,244,
1,3,1,6,1,
5,991,22,1,79,
1,1933,992,16,0,
735,1,431,993,16,
0,735,1,1585,994,
16,0,735,1,182,
995,16,0,735,1,
1189,996,16,0,735,
1,1443,997,16,0,
735,1,1695,998,16,
0,735,1,2198,999,
16,0,735,1,447,
1000,16,0,735,1,
2458,1001,17,1002,15,
1003,4,28,37,0,
83,0,116,0,97,
0,116,0,101,0,
109,0,101,0,110,
0,116,0,76,0,
105,0,115,0,116,
0,1,-1,1,5,
1004,20,1005,4,30,
83,0,116,0,97,
0,116,0,101,0,
109,0,101,0,110,
0,116,0,76,0,
105,0,115,0,116,
0,95,0,50,0,
1,221,1,3,1,
3,1,2,1006,22,
1,56,1,2459,1007,
17,1008,15,1009,4,
36,37,0,67,0,
111,0,109,0,112,
0,111,0,117,0,
110,0,100,0,83,
0,116,0,97,0,
116,0,101,0,109,
0,101,0,110,0,
116,0,1,-1,1,
5,1010,20,1011,4,
38,67,0,111,0,
109,0,112,0,111,
0,117,0,110,0,
100,0,83,0,116,
0,97,0,116,0,
101,0,109,0,101,
0,110,0,116,0,
95,0,50,0,1,
219,1,3,1,4,
1,3,1012,22,1,
54,1,1958,1013,16,
0,735,1,2462,1014,
17,1015,15,1003,1,
-1,1,5,1016,20,
1017,4,30,83,0,
116,0,97,0,116,
0,101,0,109,0,
101,0,110,0,116,
0,76,0,105,0,
115,0,116,0,95,
0,49,0,1,220,
1,3,1,2,1,
1,1018,22,1,55,
1,1657,1019,17,1020,
15,852,1,-1,1,
5,1021,20,1022,4,
22,83,0,116,0,
97,0,116,0,101,
0,109,0,101,0,
110,0,116,0,95,
0,50,0,1,224,
1,3,1,3,1,
2,1023,22,1,59,
1,2464,1024,17,1025,
15,1009,1,-1,1,
5,1026,20,1027,4,
38,67,0,111,0,
109,0,112,0,111,
0,117,0,110,0,
100,0,83,0,116,
0,97,0,116,0,
101,0,109,0,101,
0,110,0,116,0,
95,0,49,0,1,
218,1,3,1,3,
1,2,1028,22,1,
53,1,199,1029,16,
0,735,1,459,1030,
16,0,735,1,462,
1031,16,0,735,1,
217,1032,16,0,735,
1,2227,1033,17,1034,
15,988,1,-1,1,
5,1035,20,1036,4,
32,87,0,104,0,
105,0,108,0,101,
0,83,0,116,0,
97,0,116,0,101,
0,109,0,101,0,
110,0,116,0,95,
0,50,0,1,245,
1,3,1,6,1,
5,1037,22,1,80,
1,1225,1038,16,0,
735,1,1479,1039,16,
0,735,1,1731,1040,
16,0,735,1,1989,
1041,17,1042,15,845,
1,-1,1,5,1043,
20,1044,4,26,73,
0,102,0,83,0,
116,0,97,0,116,
0,101,0,109,0,
101,0,110,0,116,
0,95,0,49,0,
1,240,1,3,1,
6,1,5,1045,22,
1,75,1,1990,1046,
16,0,735,1,236,
1047,16,0,735,1,
1756,1048,16,0,735,
1,4,1049,19,200,
1,4,1050,5,100,
1,256,1051,16,0,
624,1,1261,1052,16,
0,624,1,509,1053,
16,0,624,1,1515,
1054,16,0,624,1,
2021,843,1,1775,1055,
16,0,624,1,2029,
850,1,2030,856,1,
2031,861,1,2032,866,
1,2033,871,1,277,
1056,16,0,624,1,
2035,877,1,2037,882,
1,2039,887,1,32,
1057,16,0,624,1,
2041,893,1,2293,1058,
16,0,624,1,2043,
899,1,2045,904,1,
40,1059,16,0,202,
1,41,1060,16,0,
624,1,1297,1061,16,
0,624,1,43,1062,
16,0,624,1,44,
1063,16,0,202,1,
1803,912,1,1804,1064,
16,0,624,1,299,
1065,16,0,624,1,
47,1066,16,0,198,
1,52,1067,16,0,
624,1,2318,1068,16,
0,624,1,63,1069,
16,0,224,1,66,
1070,16,0,222,1,
2075,1071,16,0,624,
1,1574,924,1,71,
1072,16,0,624,1,
76,1073,16,0,624,
1,1834,1074,16,0,
624,1,2337,1075,16,
0,624,1,79,1076,
16,0,624,1,1335,
1077,16,0,624,1,
322,1078,16,0,624,
1,85,1079,16,0,
624,1,89,1080,16,
0,624,1,346,1081,
16,0,624,1,97,
1082,16,0,624,1,
2106,1083,16,0,624,
1,102,1084,16,0,
624,1,1860,946,1,
2364,952,1,1114,1085,
16,0,198,1,112,
1086,16,0,624,1,
1117,1087,16,0,624,
1,2786,1088,16,0,
624,1,1873,961,1,
1876,1089,16,0,624,
1,124,1090,16,0,
624,1,2136,968,1,
381,1091,16,0,624,
1,525,1092,16,0,
624,1,137,1093,16,
0,624,1,1901,1094,
16,0,624,1,1153,
1095,16,0,624,1,
151,1096,16,0,624,
1,1407,1097,16,0,
624,1,1659,1098,16,
0,624,1,2413,1099,
16,0,624,1,406,
1100,16,0,624,1,
1371,1101,16,0,624,
1,2105,939,1,166,
1102,16,0,624,1,
1622,1103,16,0,624,
1,1931,986,1,1933,
1104,16,0,624,1,
431,1105,16,0,624,
1,1585,1106,16,0,
624,1,182,1107,16,
0,624,1,1189,1108,
16,0,624,1,1443,
1109,16,0,624,1,
1695,1110,16,0,624,
1,2198,1111,16,0,
624,1,447,1112,16,
0,624,1,2458,1001,
1,2459,1007,1,1958,
1113,16,0,624,1,
2462,1014,1,1657,1019,
1,2464,1024,1,199,
1114,16,0,624,1,
459,1115,16,0,624,
1,462,1116,16,0,
624,1,217,1117,16,
0,624,1,2227,1033,
1,1225,1118,16,0,
624,1,1479,1119,16,
0,624,1,1731,1120,
16,0,624,1,1989,
1041,1,1990,1121,16,
0,624,1,236,1122,
16,0,624,1,1756,
1123,16,0,624,1,
5,1124,19,197,1,
5,1125,5,100,1,
256,1126,16,0,620,
1,1261,1127,16,0,
620,1,509,1128,16,
0,620,1,1515,1129,
16,0,620,1,2021,
843,1,1775,1130,16,
0,620,1,2029,850,
1,2030,856,1,2031,
861,1,2032,866,1,
2033,871,1,277,1131,
16,0,620,1,2035,
877,1,2037,882,1,
2039,887,1,32,1132,
16,0,620,1,2041,
893,1,2293,1133,16,
0,620,1,2043,899,
1,2045,904,1,40,
1134,16,0,201,1,
41,1135,16,0,620,
1,1297,1136,16,0,
620,1,43,1137,16,
0,620,1,44,1138,
16,0,201,1,1803,
912,1,1804,1139,16,
0,620,1,299,1140,
16,0,620,1,47,
1141,16,0,195,1,
52,1142,16,0,620,
1,2318,1143,16,0,
620,1,63,1144,16,
0,223,1,66,1145,
16,0,221,1,2075,
1146,16,0,620,1,
1574,924,1,71,1147,
16,0,620,1,76,
1148,16,0,620,1,
1834,1149,16,0,620,
1,2337,1150,16,0,
620,1,79,1151,16,
0,620,1,1335,1152,
16,0,620,1,322,
1153,16,0,620,1,
85,1154,16,0,620,
1,89,1155,16,0,
620,1,346,1156,16,
0,620,1,97,1157,
16,0,620,1,2106,
1158,16,0,620,1,
102,1159,16,0,620,
1,1860,946,1,2364,
952,1,1114,1160,16,
0,195,1,112,1161,
16,0,620,1,1117,
1162,16,0,620,1,
2786,1163,16,0,620,
1,1873,961,1,1876,
1164,16,0,620,1,
124,1165,16,0,620,
1,2136,968,1,381,
1166,16,0,620,1,
525,1167,16,0,620,
1,137,1168,16,0,
620,1,1901,1169,16,
0,620,1,1153,1170,
16,0,620,1,151,
1171,16,0,620,1,
1407,1172,16,0,620,
1,1659,1173,16,0,
620,1,2413,1174,16,
0,620,1,406,1175,
16,0,620,1,1371,
1176,16,0,620,1,
2105,939,1,166,1177,
16,0,620,1,1622,
1178,16,0,620,1,
1931,986,1,1933,1179,
16,0,620,1,431,
1180,16,0,620,1,
1585,1181,16,0,620,
1,182,1182,16,0,
620,1,1189,1183,16,
0,620,1,1443,1184,
16,0,620,1,1695,
1185,16,0,620,1,
2198,1186,16,0,620,
1,447,1187,16,0,
620,1,2458,1001,1,
2459,1007,1,1958,1188,
16,0,620,1,2462,
1014,1,1657,1019,1,
2464,1024,1,199,1189,
16,0,620,1,459,
1190,16,0,620,1,
462,1191,16,0,620,
1,217,1192,16,0,
620,1,2227,1033,1,
1225,1193,16,0,620,
1,1479,1194,16,0,
620,1,1731,1195,16,
0,620,1,1989,1041,
1,1990,1196,16,0,
620,1,236,1197,16,
0,620,1,1756,1198,
16,0,620,1,6,
1199,19,310,1,6,
1200,5,2,1,1114,
1201,16,0,308,1,
40,1202,16,0,609,
1,7,1203,19,267,
1,7,1204,5,2,
1,1114,1205,16,0,
265,1,40,1206,16,
0,544,1,8,1207,
19,230,1,8,1208,
5,2,1,1114,1209,
16,0,228,1,40,
1210,16,0,501,1,
9,1211,19,236,1,
9,1212,5,2,1,
1114,1213,16,0,234,
1,40,1214,16,0,
430,1,10,1215,19,
180,1,10,1216,5,
2,1,1114,1217,16,
0,178,1,40,1218,
16,0,367,1,11,
1219,19,151,1,11,
1220,5,146,1,1260,
1221,17,1222,15,1223,
4,34,37,0,83,
0,105,0,109,0,
112,0,108,0,101,
0,65,0,115,0,
115,0,105,0,103,
0,110,0,109,0,
101,0,110,0,116,
0,1,-1,1,5,
1224,20,1225,4,38,
83,0,105,0,109,
0,112,0,108,0,
101,0,65,0,115,
0,115,0,105,0,
103,0,110,0,109,
0,101,0,110,0,
116,0,95,0,50,
0,49,0,1,276,
1,3,1,6,1,
5,1226,22,1,111,
1,1011,1227,17,1228,
15,1229,4,44,37,
0,80,0,97,0,
114,0,101,0,110,
0,116,0,104,0,
101,0,115,0,105,
0,115,0,69,0,
120,0,112,0,114,
0,101,0,115,0,
115,0,105,0,111,
0,110,0,1,-1,
1,5,1230,20,1231,
4,46,80,0,97,
0,114,0,101,0,
110,0,116,0,104,
0,101,0,115,0,
105,0,115,0,69,
0,120,0,112,0,
114,0,101,0,115,
0,115,0,105,0,
111,0,110,0,95,
0,50,0,1,323,
1,3,1,4,1,
3,1232,22,1,158,
1,1514,1233,17,1234,
15,1223,1,-1,1,
5,1235,20,1236,4,
38,83,0,105,0,
109,0,112,0,108,
0,101,0,65,0,
115,0,115,0,105,
0,103,0,110,0,
109,0,101,0,110,
0,116,0,95,0,
49,0,52,0,1,
269,1,3,1,4,
1,3,1237,22,1,
104,1,9,1238,17,
1239,15,1240,4,24,
37,0,68,0,101,
0,99,0,108,0,
97,0,114,0,97,
0,116,0,105,0,
111,0,110,0,1,
-1,1,5,1241,20,
1242,4,26,68,0,
101,0,99,0,108,
0,97,0,114,0,
97,0,116,0,105,
0,111,0,110,0,
95,0,49,0,1,
213,1,3,1,3,
1,2,1243,22,1,
48,1,262,1244,17,
1245,15,1246,4,34,
37,0,66,0,105,
0,110,0,97,0,
114,0,121,0,69,
0,120,0,112,0,
114,0,101,0,115,
0,115,0,105,0,
111,0,110,0,1,
-1,1,5,1247,20,
1248,4,36,66,0,
105,0,110,0,97,
0,114,0,121,0,
69,0,120,0,112,
0,114,0,101,0,
115,0,115,0,105,
0,111,0,110,0,
95,0,53,0,1,
305,1,3,1,4,
1,3,1249,22,1,
140,1,1267,1250,17,
1251,15,1223,1,-1,
1,5,1252,20,1253,
4,36,83,0,105,
0,109,0,112,0,
108,0,101,0,65,
0,115,0,115,0,
105,0,103,0,110,
0,109,0,101,0,
110,0,116,0,95,
0,56,0,1,263,
1,3,1,6,1,
5,1254,22,1,98,
1,2021,843,1,1521,
1255,17,1256,15,1223,
1,-1,1,5,1257,
20,1258,4,36,83,
0,105,0,109,0,
112,0,108,0,101,
0,65,0,115,0,
115,0,105,0,103,
0,110,0,109,0,
101,0,110,0,116,
0,95,0,49,0,
1,256,1,3,1,
4,1,3,1259,22,
1,91,1,2024,1260,
17,1261,15,1262,4,
24,37,0,83,0,
116,0,97,0,116,
0,101,0,67,0,
104,0,97,0,110,
0,103,0,101,0,
1,-1,1,5,1263,
20,1264,4,26,83,
0,116,0,97,0,
116,0,101,0,67,
0,104,0,97,0,
110,0,103,0,101,
0,95,0,49,0,
1,238,1,3,1,
3,1,2,1265,22,
1,73,1,1775,1266,
17,1267,15,1268,4,
30,37,0,69,0,
109,0,112,0,116,
0,121,0,83,0,
116,0,97,0,116,
0,101,0,109,0,
101,0,110,0,116,
0,1,-1,1,5,
1269,20,1270,4,32,
69,0,109,0,112,
0,116,0,121,0,
83,0,116,0,97,
0,116,0,101,0,
109,0,101,0,110,
0,116,0,95,0,
49,0,1,222,1,
3,1,1,1,0,
1271,22,1,57,1,
19,1272,17,1239,1,
2,1243,1,2028,1273,
17,1274,15,1275,4,
20,37,0,74,0,
117,0,109,0,112,
0,76,0,97,0,
98,0,101,0,108,
0,1,-1,1,5,
1276,20,1277,4,22,
74,0,117,0,109,
0,112,0,76,0,
97,0,98,0,101,
0,108,0,95,0,
49,0,1,236,1,
3,1,3,1,2,
1278,22,1,71,1,
2029,850,1,2281,1279,
17,1280,15,1281,4,
34,37,0,70,0,
111,0,114,0,76,
0,111,0,111,0,
112,0,83,0,116,
0,97,0,116,0,
101,0,109,0,101,
0,110,0,116,0,
1,-1,1,5,1282,
20,1283,4,36,70,
0,111,0,114,0,
76,0,111,0,111,
0,112,0,83,0,
116,0,97,0,116,
0,101,0,109,0,
101,0,110,0,116,
0,95,0,50,0,
1,251,1,3,1,
2,1,1,1284,22,
1,86,1,2031,861,
1,2785,1285,16,0,
519,1,2033,871,1,
2034,1286,16,0,691,
1,2035,877,1,2036,
1287,16,0,610,1,
2037,882,1,2038,1288,
16,0,614,1,2792,
1289,16,0,149,1,
32,1290,17,1267,1,
0,1271,1,2032,866,
1,2042,1291,16,0,
757,1,2043,899,1,
2044,1292,16,0,704,
1,2045,904,1,2299,
1293,16,0,252,1,
1296,1294,17,1295,15,
1223,1,-1,1,5,
1296,20,1297,4,38,
83,0,105,0,109,
0,112,0,108,0,
101,0,65,0,115,
0,115,0,105,0,
103,0,110,0,109,
0,101,0,110,0,
116,0,95,0,50,
0,48,0,1,275,
1,3,1,6,1,
5,1298,22,1,110,
1,283,1299,17,1300,
15,1246,1,-1,1,
5,1301,20,1302,4,
36,66,0,105,0,
110,0,97,0,114,
0,121,0,69,0,
120,0,112,0,114,
0,101,0,115,0,
115,0,105,0,111,
0,110,0,95,0,
52,0,1,304,1,
3,1,4,1,3,
1303,22,1,139,1,
40,1304,17,1305,15,
1306,4,32,37,0,
73,0,100,0,101,
0,110,0,116,0,
69,0,120,0,112,
0,114,0,101,0,
115,0,115,0,105,
0,111,0,110,0,
1,-1,1,5,1307,
20,1308,4,34,73,
0,100,0,101,0,
110,0,116,0,69,
0,120,0,112,0,
114,0,101,0,115,
0,115,0,105,0,
111,0,110,0,95,
0,49,0,1,290,
1,3,1,2,1,
1,1309,22,1,125,
1,44,1310,17,1305,
1,1,1309,1,1803,
912,1,47,1311,17,
1312,15,1313,4,38,
37,0,73,0,100,
0,101,0,110,0,
116,0,68,0,111,
0,116,0,69,0,
120,0,112,0,114,
0,101,0,115,0,
115,0,105,0,111,
0,110,0,1,-1,
1,5,1314,20,1315,
4,40,73,0,100,
0,101,0,110,0,
116,0,68,0,111,
0,116,0,69,0,
120,0,112,0,114,
0,101,0,115,0,
115,0,105,0,111,
0,110,0,95,0,
49,0,1,291,1,
3,1,4,1,3,
1316,22,1,126,1,
48,1317,17,1318,15,
1319,4,58,37,0,
73,0,110,0,99,
0,114,0,101,0,
109,0,101,0,110,
0,116,0,68,0,
101,0,99,0,114,
0,101,0,109,0,
101,0,110,0,116,
0,69,0,120,0,
112,0,114,0,101,
0,115,0,115,0,
105,0,111,0,110,
0,1,-1,1,5,
1320,20,1321,4,60,
73,0,110,0,99,
0,114,0,101,0,
109,0,101,0,110,
0,116,0,68,0,
101,0,99,0,114,
0,101,0,109,0,
101,0,110,0,116,
0,69,0,120,0,
112,0,114,0,101,
0,115,0,115,0,
105,0,111,0,110,
0,95,0,52,0,
1,295,1,3,1,
5,1,4,1322,22,
1,130,1,49,1323,
17,1324,15,1319,1,
-1,1,5,1325,20,
1326,4,60,73,0,
110,0,99,0,114,
0,101,0,109,0,
101,0,110,0,116,
0,68,0,101,0,
99,0,114,0,101,
0,109,0,101,0,
110,0,116,0,69,
0,120,0,112,0,
114,0,101,0,115,
0,115,0,105,0,
111,0,110,0,95,
0,51,0,1,294,
1,3,1,5,1,
4,1327,22,1,129,
1,50,1328,17,1329,
15,1319,1,-1,1,
5,1330,20,1331,4,
60,73,0,110,0,
99,0,114,0,101,
0,109,0,101,0,
110,0,116,0,68,
0,101,0,99,0,
114,0,101,0,109,
0,101,0,110,0,
116,0,69,0,120,
0,112,0,114,0,
101,0,115,0,115,
0,105,0,111,0,
110,0,95,0,50,
0,1,293,1,3,
1,3,1,2,1332,
22,1,128,1,51,
1333,17,1334,15,1319,
1,-1,1,5,1335,
20,1336,4,60,73,
0,110,0,99,0,
114,0,101,0,109,
0,101,0,110,0,
116,0,68,0,101,
0,99,0,114,0,
101,0,109,0,101,
0,110,0,116,0,
69,0,120,0,112,
0,114,0,101,0,
115,0,115,0,105,
0,111,0,110,0,
95,0,49,0,1,
292,1,3,1,3,
1,2,1337,22,1,
127,1,305,1338,17,
1339,15,1246,1,-1,
1,5,1340,20,1341,
4,36,66,0,105,
0,110,0,97,0,
114,0,121,0,69,
0,120,0,112,0,
114,0,101,0,115,
0,115,0,105,0,
111,0,110,0,95,
0,51,0,1,303,
1,3,1,4,1,
3,1342,22,1,138,
1,525,1343,17,1344,
15,1345,4,34,37,
0,82,0,111,0,
116,0,97,0,116,
0,105,0,111,0,
110,0,67,0,111,
0,110,0,115,0,
116,0,97,0,110,
0,116,0,1,-1,
1,5,1346,20,1347,
4,36,82,0,111,
0,116,0,97,0,
116,0,105,0,111,
0,110,0,67,0,
111,0,110,0,115,
0,116,0,97,0,
110,0,116,0,95,
0,49,0,1,288,
1,3,1,10,1,
9,1348,22,1,123,
1,63,1349,17,1350,
15,1351,4,38,37,
0,84,0,121,0,
112,0,101,0,99,
0,97,0,115,0,
116,0,69,0,120,
0,112,0,114,0,
101,0,115,0,115,
0,105,0,111,0,
110,0,1,-1,1,
5,1352,20,1353,4,
40,84,0,121,0,
112,0,101,0,99,
0,97,0,115,0,
116,0,69,0,120,
0,112,0,114,0,
101,0,115,0,115,
0,105,0,111,0,
110,0,95,0,50,
0,1,325,1,3,
1,5,1,4,1354,
22,1,160,1,66,
1355,17,1356,15,1351,
1,-1,1,5,1357,
20,1358,4,40,84,
0,121,0,112,0,
101,0,99,0,97,
0,115,0,116,0,
69,0,120,0,112,
0,114,0,101,0,
115,0,115,0,105,
0,111,0,110,0,
95,0,51,0,1,
326,1,3,1,7,
1,6,1359,22,1,
161,1,67,1360,17,
1361,15,1351,1,-1,
1,5,1362,20,1363,
4,40,84,0,121,
0,112,0,101,0,
99,0,97,0,115,
0,116,0,69,0,
120,0,112,0,114,
0,101,0,115,0,
115,0,105,0,111,
0,110,0,95,0,
55,0,1,330,1,
3,1,8,1,7,
1364,22,1,165,1,
68,1365,17,1366,15,
1351,1,-1,1,5,
1367,20,1368,4,40,
84,0,121,0,112,
0,101,0,99,0,
97,0,115,0,116,
0,69,0,120,0,
112,0,114,0,101,
0,115,0,115,0,
105,0,111,0,110,
0,95,0,53,0,
1,328,1,3,1,
8,1,7,1369,22,
1,163,1,69,1370,
17,1371,15,1351,1,
-1,1,5,1372,20,
1373,4,40,84,0,
121,0,112,0,101,
0,99,0,97,0,
115,0,116,0,69,
0,120,0,112,0,
114,0,101,0,115,
0,115,0,105,0,
111,0,110,0,95,
0,54,0,1,329,
1,3,1,6,1,
5,1374,22,1,164,
1,70,1375,17,1376,
15,1351,1,-1,1,
5,1377,20,1378,4,
40,84,0,121,0,
112,0,101,0,99,
0,97,0,115,0,
116,0,69,0,120,
0,112,0,114,0,
101,0,115,0,115,
0,105,0,111,0,
110,0,95,0,52,
0,1,327,1,3,
1,6,1,5,1379,
22,1,162,1,74,
1380,17,1381,15,1351,
1,-1,1,5,1382,
20,1383,4,40,84,
0,121,0,112,0,
101,0,99,0,97,
0,115,0,116,0,
69,0,120,0,112,
0,114,0,101,0,
115,0,115,0,105,
0,111,0,110,0,
95,0,57,0,1,
332,1,3,1,7,
1,6,1384,22,1,
167,1,1013,1385,17,
1386,15,1229,1,-1,
1,5,1387,20,1388,
4,46,80,0,97,
0,114,0,101,0,
110,0,116,0,104,
0,101,0,115,0,
105,0,115,0,69,
0,120,0,112,0,
114,0,101,0,115,
0,115,0,105,0,
111,0,110,0,95,
0,49,0,1,322,
1,3,1,4,1,
3,1389,22,1,157,
1,1332,1390,17,1391,
15,1223,1,-1,1,
5,1392,20,1393,4,
38,83,0,105,0,
109,0,112,0,108,
0,101,0,65,0,
115,0,115,0,105,
0,103,0,110,0,
109,0,101,0,110,
0,116,0,95,0,
49,0,57,0,1,
274,1,3,1,6,
1,5,1394,22,1,
109,1,2337,1395,17,
1267,1,0,1271,1,
1585,1396,17,1397,15,
1398,4,32,37,0,
82,0,101,0,116,
0,117,0,114,0,
110,0,83,0,116,
0,97,0,116,0,
101,0,109,0,101,
0,110,0,116,0,
1,-1,1,5,1399,
20,1400,4,34,82,
0,101,0,116,0,
117,0,114,0,110,
0,83,0,116,0,
97,0,116,0,101,
0,109,0,101,0,
110,0,116,0,95,
0,50,0,1,281,
1,3,1,2,1,
1,1401,22,1,116,
1,2023,1402,17,1403,
15,1262,1,-1,1,
5,1404,20,1405,4,
26,83,0,116,0,
97,0,116,0,101,
0,67,0,104,0,
97,0,110,0,103,
0,101,0,95,0,
50,0,1,239,1,
3,1,3,1,2,
1406,22,1,74,1,
2136,968,1,82,1407,
17,1408,15,1409,4,
32,37,0,85,0,
110,0,97,0,114,
0,121,0,69,0,
120,0,112,0,114,
0,101,0,115,0,
115,0,105,0,111,
0,110,0,1,-1,
1,5,1410,20,1411,
4,34,85,0,110,
0,97,0,114,0,
121,0,69,0,120,
0,112,0,114,0,
101,0,115,0,115,
0,105,0,111,0,
110,0,95,0,51,
0,1,321,1,3,
1,3,1,2,1412,
22,1,156,1,2026,
1413,17,1414,15,1415,
4,28,37,0,74,
0,117,0,109,0,
112,0,83,0,116,
0,97,0,116,0,
101,0,109,0,101,
0,110,0,116,0,
1,-1,1,5,1416,
20,1417,4,30,74,
0,117,0,109,0,
112,0,83,0,116,
0,97,0,116,0,
101,0,109,0,101,
0,110,0,116,0,
95,0,49,0,1,
237,1,3,1,3,
1,2,1418,22,1,
72,1,1591,1419,17,
1420,15,1398,1,-1,
1,5,1421,20,1422,
4,34,82,0,101,
0,116,0,117,0,
114,0,110,0,83,
0,116,0,97,0,
116,0,101,0,109,
0,101,0,110,0,
116,0,95,0,49,
0,1,280,1,3,
1,3,1,2,1423,
22,1,115,1,1341,
1424,17,1425,15,1223,
1,-1,1,5,1426,
20,1427,4,36,83,
0,105,0,109,0,
112,0,108,0,101,
0,65,0,115,0,
115,0,105,0,103,
0,110,0,109,0,
101,0,110,0,116,
0,95,0,54,0,
1,261,1,3,1,
4,1,3,1428,22,
1,96,1,2030,856,
1,328,1429,17,1430,
15,1246,1,-1,1,
5,1431,20,1432,4,
36,66,0,105,0,
110,0,97,0,114,
0,121,0,69,0,
120,0,112,0,114,
0,101,0,115,0,
115,0,105,0,111,
0,110,0,95,0,
50,0,1,302,1,
3,1,4,1,3,
1433,22,1,137,1,
1303,1434,17,1435,15,
1223,1,-1,1,5,
1436,20,1437,4,36,
83,0,105,0,109,
0,112,0,108,0,
101,0,65,0,115,
0,115,0,105,0,
103,0,110,0,109,
0,101,0,110,0,
116,0,95,0,55,
0,1,262,1,3,
1,6,1,5,1438,
22,1,97,1,1096,
1439,17,1440,15,1441,
4,26,37,0,70,
0,117,0,110,0,
99,0,116,0,105,
0,111,0,110,0,
67,0,97,0,108,
0,108,0,1,-1,
1,5,1442,20,1443,
4,28,70,0,117,
0,110,0,99,0,
116,0,105,0,111,
0,110,0,67,0,
97,0,108,0,108,
0,95,0,49,0,
1,333,1,3,1,
5,1,4,1444,22,
1,168,1,93,1445,
17,1446,15,1409,1,
-1,1,5,1447,20,
1448,4,34,85,0,
110,0,97,0,114,
0,121,0,69,0,
120,0,112,0,114,
0,101,0,115,0,
115,0,105,0,111,
0,110,0,95,0,
50,0,1,320,1,
3,1,3,1,2,
1449,22,1,155,1,
1550,1450,17,1451,15,
1223,1,-1,1,5,
1452,20,1453,4,38,
83,0,105,0,109,
0,112,0,108,0,
101,0,65,0,115,
0,115,0,105,0,
103,0,110,0,109,
0,101,0,110,0,
116,0,95,0,49,
0,51,0,1,268,
1,3,1,4,1,
3,1454,22,1,103,
1,2039,887,1,2040,
1455,16,0,618,1,
2041,893,1,1555,1456,
16,0,722,1,827,
1457,17,1458,15,1246,
1,-1,1,5,1459,
20,1460,4,38,66,
0,105,0,110,0,
97,0,114,0,121,
0,69,0,120,0,
112,0,114,0,101,
0,115,0,115,0,
105,0,111,0,110,
0,95,0,49,0,
53,0,1,315,1,
3,1,4,1,3,
1461,22,1,150,1,
1859,1462,16,0,344,
1,1860,946,1,1804,
1463,17,1267,1,0,
1271,1,107,1464,17,
1465,15,1409,1,-1,
1,5,1466,20,1467,
4,34,85,0,110,
0,97,0,114,0,
121,0,69,0,120,
0,112,0,114,0,
101,0,115,0,115,
0,105,0,111,0,
110,0,95,0,49,
0,1,319,1,3,
1,3,1,2,1468,
22,1,154,1,1114,
1469,17,1312,1,3,
1316,1,1048,1470,17,
1471,15,1246,1,-1,
1,5,1472,20,1473,
4,38,66,0,105,
0,110,0,97,0,
114,0,121,0,69,
0,120,0,112,0,
114,0,101,0,115,
0,115,0,105,0,
111,0,110,0,95,
0,49,0,56,0,
1,318,1,3,1,
4,1,3,1474,22,
1,153,1,352,1475,
17,1476,15,1246,1,
-1,1,5,1477,20,
1478,4,36,66,0,
105,0,110,0,97,
0,114,0,121,0,
69,0,120,0,112,
0,114,0,101,0,
115,0,115,0,105,
0,111,0,110,0,
95,0,49,0,1,
301,1,3,1,4,
1,3,1479,22,1,
136,1,1872,1480,16,
0,354,1,1873,961,
1,118,1481,17,1482,
15,1246,1,-1,1,
5,1483,20,1484,4,
38,66,0,105,0,
110,0,97,0,114,
0,121,0,69,0,
120,0,112,0,114,
0,101,0,115,0,
115,0,105,0,111,
0,110,0,95,0,
49,0,52,0,1,
314,1,3,1,4,
1,3,1485,22,1,
149,1,1123,1486,17,
1487,15,1223,1,-1,
1,5,1488,20,1489,
4,38,83,0,105,
0,109,0,112,0,
108,0,101,0,65,
0,115,0,115,0,
105,0,103,0,110,
0,109,0,101,0,
110,0,116,0,95,
0,49,0,50,0,
1,267,1,3,1,
6,1,5,1490,22,
1,102,1,371,1491,
17,1492,15,1493,4,
46,37,0,70,0,
117,0,110,0,99,
0,116,0,105,0,
111,0,110,0,67,
0,97,0,108,0,
108,0,69,0,120,
0,112,0,114,0,
101,0,115,0,115,
0,105,0,111,0,
110,0,1,-1,1,
5,1494,20,1495,4,
48,70,0,117,0,
110,0,99,0,116,
0,105,0,111,0,
110,0,67,0,97,
0,108,0,108,0,
69,0,120,0,112,
0,114,0,101,0,
115,0,115,0,105,
0,111,0,110,0,
95,0,49,0,1,
300,1,3,1,2,
1,1,1496,22,1,
135,1,1377,1497,17,
1498,15,1223,1,-1,
1,5,1499,20,1500,
4,36,83,0,105,
0,109,0,112,0,
108,0,101,0,65,
0,115,0,115,0,
105,0,103,0,110,
0,109,0,101,0,
110,0,116,0,95,
0,53,0,1,260,
1,3,1,4,1,
3,1501,22,1,95,
1,375,1502,17,1503,
15,1319,1,-1,1,
5,1504,20,1505,4,
60,73,0,110,0,
99,0,114,0,101,
0,109,0,101,0,
110,0,116,0,68,
0,101,0,99,0,
114,0,101,0,109,
0,101,0,110,0,
116,0,69,0,120,
0,112,0,114,0,
101,0,115,0,115,
0,105,0,111,0,
110,0,95,0,56,
0,1,299,1,3,
1,5,1,4,1506,
22,1,134,1,377,
1507,17,1508,15,1319,
1,-1,1,5,1509,
20,1510,4,60,73,
0,110,0,99,0,
114,0,101,0,109,
0,101,0,110,0,
116,0,68,0,101,
0,99,0,114,0,
101,0,109,0,101,
0,110,0,116,0,
69,0,120,0,112,
0,114,0,101,0,
115,0,115,0,105,
0,111,0,110,0,
95,0,53,0,1,
296,1,3,1,3,
1,2,1511,22,1,
131,1,379,1512,17,
1513,15,1319,1,-1,
1,5,1514,20,1515,
4,60,73,0,110,
0,99,0,114,0,
101,0,109,0,101,
0,110,0,116,0,
68,0,101,0,99,
0,114,0,101,0,
109,0,101,0,110,
0,116,0,69,0,
120,0,112,0,114,
0,101,0,115,0,
115,0,105,0,111,
0,110,0,95,0,
55,0,1,298,1,
3,1,5,1,4,
1516,22,1,133,1,
380,1517,17,1518,15,
1519,4,38,37,0,
67,0,111,0,110,
0,115,0,116,0,
97,0,110,0,116,
0,69,0,120,0,
112,0,114,0,101,
0,115,0,115,0,
105,0,111,0,110,
0,1,-1,1,5,
1520,20,1521,4,40,
67,0,111,0,110,
0,115,0,116,0,
97,0,110,0,116,
0,69,0,120,0,
112,0,114,0,101,
0,115,0,115,0,
105,0,111,0,110,
0,95,0,49,0,
1,289,1,3,1,
2,1,1,1522,22,
1,124,1,883,1523,
17,1524,15,1246,1,
-1,1,5,1525,20,
1526,4,38,66,0,
105,0,110,0,97,
0,114,0,121,0,
69,0,120,0,112,
0,114,0,101,0,
115,0,115,0,105,
0,111,0,110,0,
95,0,49,0,54,
0,1,316,1,3,
1,4,1,3,1527,
22,1,151,1,1628,
1528,17,1529,15,1530,
4,22,37,0,65,
0,115,0,115,0,
105,0,103,0,110,
0,109,0,101,0,
110,0,116,0,1,
-1,1,5,1531,20,
1532,4,24,65,0,
115,0,115,0,105,
0,103,0,110,0,
109,0,101,0,110,
0,116,0,95,0,
49,0,1,254,1,
3,1,4,1,3,
1533,22,1,89,1,
2075,1534,17,1267,1,
0,1271,1,373,1535,
17,1536,15,1319,1,
-1,1,5,1537,20,
1538,4,60,73,0,
110,0,99,0,114,
0,101,0,109,0,
101,0,110,0,116,
0,68,0,101,0,
99,0,114,0,101,
0,109,0,101,0,
110,0,116,0,69,
0,120,0,112,0,
114,0,101,0,115,
0,115,0,105,0,
111,0,110,0,95,
0,54,0,1,297,
1,3,1,3,1,
2,1539,22,1,132,
1,130,1540,17,1541,
15,1246,1,-1,1,
5,1542,20,1543,4,
38,66,0,105,0,
110,0,97,0,114,
0,121,0,69,0,
120,0,112,0,114,
0,101,0,115,0,
115,0,105,0,111,
0,110,0,95,0,
49,0,51,0,1,
313,1,3,1,4,
1,3,1544,22,1,
148,1,143,1545,17,
1546,15,1246,1,-1,
1,5,1547,20,1548,
4,38,66,0,105,
0,110,0,97,0,
114,0,121,0,69,
0,120,0,112,0,
114,0,101,0,115,
0,115,0,105,0,
111,0,110,0,95,
0,49,0,50,0,
1,312,1,3,1,
4,1,3,1549,22,
1,147,1,1901,1550,
17,1267,1,0,1271,
1,1152,1551,17,1552,
15,1223,1,-1,1,
5,1553,20,1554,4,
38,83,0,105,0,
109,0,112,0,108,
0,101,0,65,0,
115,0,115,0,105,
0,103,0,110,0,
109,0,101,0,110,
0,116,0,95,0,
50,0,52,0,1,
279,1,3,1,6,
1,5,1555,22,1,
114,1,1406,1556,17,
1557,15,1223,1,-1,
1,5,1558,20,1559,
4,38,83,0,105,
0,109,0,112,0,
108,0,101,0,65,
0,115,0,115,0,
105,0,103,0,110,
0,109,0,101,0,
110,0,116,0,95,
0,49,0,55,0,
1,272,1,3,1,
4,1,3,1560,22,
1,107,1,1659,1561,
16,0,298,1,2413,
1562,17,1267,1,0,
1271,1,1159,1563,17,
1564,15,1223,1,-1,
1,5,1565,20,1566,
4,38,83,0,105,
0,109,0,112,0,
108,0,101,0,65,
0,115,0,115,0,
105,0,103,0,110,
0,109,0,101,0,
110,0,116,0,95,
0,49,0,49,0,
1,266,1,3,1,
6,1,5,1567,22,
1,101,1,157,1568,
17,1569,15,1246,1,
-1,1,5,1570,20,
1571,4,38,66,0,
105,0,110,0,97,
0,114,0,121,0,
69,0,120,0,112,
0,114,0,101,0,
115,0,115,0,105,
0,111,0,110,0,
95,0,49,0,49,
0,1,311,1,3,
1,4,1,3,1572,
22,1,146,1,1413,
1573,17,1574,15,1223,
1,-1,1,5,1575,
20,1576,4,36,83,
0,105,0,109,0,
112,0,108,0,101,
0,65,0,115,0,
115,0,105,0,103,
0,110,0,109,0,
101,0,110,0,116,
0,95,0,52,0,
1,259,1,3,1,
4,1,3,1577,22,
1,94,1,1370,1578,
17,1579,15,1223,1,
-1,1,5,1580,20,
1581,4,38,83,0,
105,0,109,0,112,
0,108,0,101,0,
65,0,115,0,115,
0,105,0,103,0,
110,0,109,0,101,
0,110,0,116,0,
95,0,49,0,56,
0,1,273,1,3,
1,4,1,3,1582,
22,1,108,1,1478,
1583,17,1584,15,1223,
1,-1,1,5,1585,
20,1586,4,38,83,
0,105,0,109,0,
112,0,108,0,101,
0,65,0,115,0,
115,0,105,0,103,
0,110,0,109,0,
101,0,110,0,116,
0,95,0,49,0,
53,0,1,270,1,
3,1,4,1,3,
1587,22,1,105,1,
2106,1588,17,1267,1,
0,1271,1,1620,1589,
17,1590,15,1530,1,
-1,1,5,1591,20,
1592,4,24,65,0,
115,0,115,0,105,
0,103,0,110,0,
109,0,101,0,110,
0,116,0,95,0,
50,0,1,255,1,
3,1,2,1,1,
1593,22,1,90,1,
1621,1594,16,0,791,
1,1574,924,1,172,
1595,17,1596,15,1246,
1,-1,1,5,1597,
20,1598,4,38,66,
0,105,0,110,0,
97,0,114,0,121,
0,69,0,120,0,
112,0,114,0,101,
0,115,0,115,0,
105,0,111,0,110,
0,95,0,49,0,
48,0,1,310,1,
3,1,4,1,3,
1599,22,1,145,1,
1931,986,1,1665,1600,
17,1601,15,1281,1,
-1,1,5,1602,20,
1603,4,36,70,0,
111,0,114,0,76,
0,111,0,111,0,
112,0,83,0,116,
0,97,0,116,0,
101,0,109,0,101,
0,110,0,116,0,
95,0,49,0,1,
250,1,3,1,2,
1,1,1604,22,1,
85,1,2364,952,1,
2105,939,1,1188,1605,
17,1606,15,1223,1,
-1,1,5,1607,20,
1608,4,38,83,0,
105,0,109,0,112,
0,108,0,101,0,
65,0,115,0,115,
0,105,0,103,0,
110,0,109,0,101,
0,110,0,116,0,
95,0,50,0,51,
0,1,278,1,3,
1,6,1,5,1609,
22,1,113,1,1442,
1610,17,1611,15,1223,
1,-1,1,5,1612,
20,1613,4,38,83,
0,105,0,109,0,
112,0,108,0,101,
0,65,0,115,0,
115,0,105,0,103,
0,110,0,109,0,
101,0,110,0,116,
0,95,0,49,0,
54,0,1,271,1,
3,1,4,1,3,
1614,22,1,106,1,
1694,1615,16,0,215,
1,942,1616,17,1617,
15,1246,1,-1,1,
5,1618,20,1619,4,
38,66,0,105,0,
110,0,97,0,114,
0,121,0,69,0,
120,0,112,0,114,
0,101,0,115,0,
115,0,105,0,111,
0,110,0,95,0,
49,0,55,0,1,
317,1,3,1,4,
1,3,1620,22,1,
152,1,2198,1621,17,
1267,1,0,1271,1,
1195,1622,17,1623,15,
1223,1,-1,1,5,
1624,20,1625,4,38,
83,0,105,0,109,
0,112,0,108,0,
101,0,65,0,115,
0,115,0,105,0,
103,0,110,0,109,
0,101,0,110,0,
116,0,95,0,49,
0,48,0,1,265,
1,3,1,6,1,
5,1626,22,1,100,
1,1449,1627,17,1628,
15,1223,1,-1,1,
5,1629,20,1630,4,
36,83,0,105,0,
109,0,112,0,108,
0,101,0,65,0,
115,0,115,0,105,
0,103,0,110,0,
109,0,101,0,110,
0,116,0,95,0,
51,0,1,258,1,
3,1,4,1,3,
1631,22,1,93,1,
1701,1632,17,1633,15,
1281,1,-1,1,5,
1634,20,1635,4,36,
70,0,111,0,114,
0,76,0,111,0,
111,0,112,0,83,
0,116,0,97,0,
116,0,101,0,109,
0,101,0,110,0,
116,0,95,0,51,
0,1,252,1,3,
1,4,1,3,1636,
22,1,87,1,447,
1637,17,1638,15,1639,
4,30,37,0,86,
0,101,0,99,0,
116,0,111,0,114,
0,67,0,111,0,
110,0,115,0,116,
0,97,0,110,0,
116,0,1,-1,1,
5,1640,20,1641,4,
32,86,0,101,0,
99,0,116,0,111,
0,114,0,67,0,
111,0,110,0,115,
0,116,0,97,0,
110,0,116,0,95,
0,49,0,1,287,
1,3,1,8,1,
7,1642,22,1,122,
1,2458,1001,1,2459,
1007,1,1958,1643,17,
1267,1,0,1271,1,
188,1644,17,1645,15,
1246,1,-1,1,5,
1646,20,1647,4,36,
66,0,105,0,110,
0,97,0,114,0,
121,0,69,0,120,
0,112,0,114,0,
101,0,115,0,115,
0,105,0,111,0,
110,0,95,0,57,
0,1,309,1,3,
1,4,1,3,1648,
22,1,144,1,2462,
1014,1,1657,1019,1,
2464,1024,1,205,1649,
17,1650,15,1246,1,
-1,1,5,1651,20,
1652,4,36,66,0,
105,0,110,0,97,
0,114,0,121,0,
69,0,120,0,112,
0,114,0,101,0,
115,0,115,0,105,
0,111,0,110,0,
95,0,56,0,1,
308,1,3,1,4,
1,3,1653,22,1,
143,1,2227,1033,1,
1224,1654,17,1655,15,
1223,1,-1,1,5,
1656,20,1657,4,38,
83,0,105,0,109,
0,112,0,108,0,
101,0,65,0,115,
0,115,0,105,0,
103,0,110,0,109,
0,101,0,110,0,
116,0,95,0,50,
0,50,0,1,277,
1,3,1,6,1,
5,1658,22,1,112,
1,223,1659,17,1660,
15,1246,1,-1,1,
5,1661,20,1662,4,
36,66,0,105,0,
110,0,97,0,114,
0,121,0,69,0,
120,0,112,0,114,
0,101,0,115,0,
115,0,105,0,111,
0,110,0,95,0,
55,0,1,307,1,
3,1,4,1,3,
1663,22,1,142,1,
1730,1664,17,1665,15,
1281,1,-1,1,5,
1666,20,1667,4,36,
70,0,111,0,114,
0,76,0,111,0,
111,0,112,0,83,
0,116,0,97,0,
116,0,101,0,109,
0,101,0,110,0,
116,0,95,0,52,
0,1,253,1,3,
1,4,1,3,1668,
22,1,88,1,476,
1669,17,1670,15,1671,
4,18,37,0,67,
0,111,0,110,0,
115,0,116,0,97,
0,110,0,116,0,
1,-1,1,5,1672,
20,1673,4,20,67,
0,111,0,110,0,
115,0,116,0,97,
0,110,0,116,0,
95,0,52,0,1,
285,1,3,1,2,
1,1,1674,22,1,
120,1,477,1675,17,
1676,15,1671,1,-1,
1,5,1677,20,1678,
4,20,67,0,111,
0,110,0,115,0,
116,0,97,0,110,
0,116,0,95,0,
51,0,1,284,1,
3,1,2,1,1,
1679,22,1,119,1,
1231,1680,17,1681,15,
1223,1,-1,1,5,
1682,20,1683,4,36,
83,0,105,0,109,
0,112,0,108,0,
101,0,65,0,115,
0,115,0,105,0,
103,0,110,0,109,
0,101,0,110,0,
116,0,95,0,57,
0,1,264,1,3,
1,6,1,5,1684,
22,1,99,1,479,
1685,17,1686,15,1671,
1,-1,1,5,1687,
20,1688,4,20,67,
0,111,0,110,0,
115,0,116,0,97,
0,110,0,116,0,
95,0,49,0,1,
282,1,3,1,2,
1,1,1689,22,1,
117,1,480,1690,17,
1691,15,1692,4,26,
37,0,76,0,105,
0,115,0,116,0,
67,0,111,0,110,
0,115,0,116,0,
97,0,110,0,116,
0,1,-1,1,5,
1693,20,1694,4,28,
76,0,105,0,115,
0,116,0,67,0,
111,0,110,0,115,
0,116,0,97,0,
110,0,116,0,95,
0,49,0,1,286,
1,3,1,4,1,
3,1695,22,1,121,
1,1485,1696,17,1697,
15,1223,1,-1,1,
5,1698,20,1699,4,
36,83,0,105,0,
109,0,112,0,108,
0,101,0,65,0,
115,0,115,0,105,
0,103,0,110,0,
109,0,101,0,110,
0,116,0,95,0,
50,0,1,257,1,
3,1,4,1,3,
1700,22,1,92,1,
1737,1701,16,0,303,
1,1989,1041,1,1990,
1702,17,1267,1,0,
1271,1,242,1703,17,
1704,15,1246,1,-1,
1,5,1705,20,1706,
4,36,66,0,105,
0,110,0,97,0,
114,0,121,0,69,
0,120,0,112,0,
114,0,101,0,115,
0,115,0,105,0,
111,0,110,0,95,
0,54,0,1,306,
1,3,1,4,1,
3,1707,22,1,141,
1,478,1708,17,1709,
15,1671,1,-1,1,
5,1710,20,1711,4,
20,67,0,111,0,
110,0,115,0,116,
0,97,0,110,0,
116,0,95,0,50,
0,1,283,1,3,
1,2,1,1,1712,
22,1,118,1,1001,
1713,17,1714,15,1351,
1,-1,1,5,1715,
20,1716,4,40,84,
0,121,0,112,0,
101,0,99,0,97,
0,115,0,116,0,
69,0,120,0,112,
0,114,0,101,0,
115,0,115,0,105,
0,111,0,110,0,
95,0,56,0,1,
331,1,3,1,5,
1,4,1717,22,1,
166,1,1002,1718,17,
1719,15,1351,1,-1,
1,5,1720,20,1721,
4,40,84,0,121,
0,112,0,101,0,
99,0,97,0,115,
0,116,0,69,0,
120,0,112,0,114,
0,101,0,115,0,
115,0,105,0,111,
0,110,0,95,0,
49,0,1,324,1,
3,1,5,1,4,
1722,22,1,159,1,
12,1723,19,166,1,
12,1724,5,50,1,
1901,1725,16,0,164,
1,2075,1726,16,0,
164,1,1860,946,1,
1803,912,1,1804,1727,
16,0,164,1,2519,
1728,16,0,164,1,
2549,1729,16,0,164,
1,2413,1730,16,0,
164,1,2198,1731,16,
0,164,1,1873,961,
1,1657,1019,1,2534,
1732,16,0,164,1,
1990,1733,16,0,164,
1,31,1734,16,0,
164,1,32,1735,16,
0,164,1,2105,939,
1,2106,1736,16,0,
164,1,2573,1737,16,
0,164,1,2658,1738,
16,0,284,1,2578,
1739,16,0,164,1,
2227,1033,1,2337,1740,
16,0,164,1,2557,
1741,16,0,164,1,
2781,1742,16,0,164,
1,2565,1743,16,0,
164,1,2021,843,1,
2458,1001,1,2459,1007,
1,2462,1014,1,2136,
968,1,2464,1024,1,
2029,850,1,2030,856,
1,2031,861,1,2032,
866,1,2469,1744,16,
0,536,1,2035,877,
1,2364,952,1,2039,
887,1,1931,986,1,
2041,893,1,2043,899,
1,2045,904,1,2593,
1745,16,0,164,1,
1775,1746,16,0,164,
1,1989,1041,1,2033,
871,1,2037,882,1,
1574,924,1,1958,1747,
16,0,164,1,13,
1748,19,213,1,13,
1749,5,55,1,2536,
1750,17,1751,15,1752,
4,46,37,0,73,
0,110,0,116,0,
86,0,101,0,99,
0,86,0,101,0,
99,0,65,0,114,
0,103,0,83,0,
116,0,97,0,116,
0,101,0,69,0,
118,0,101,0,110,
0,116,0,1,-1,
1,5,1753,20,1754,
4,48,73,0,110,
0,116,0,86,0,
101,0,99,0,86,
0,101,0,99,0,
65,0,114,0,103,
0,83,0,116,0,
97,0,116,0,101,
0,69,0,118,0,
101,0,110,0,116,
0,95,0,49,0,
1,203,1,3,1,
6,1,5,1755,22,
1,37,1,2643,1756,
17,1757,15,1758,4,
20,37,0,83,0,
116,0,97,0,116,
0,101,0,66,0,
111,0,100,0,121,
0,1,-1,1,5,
1759,20,1760,4,24,
83,0,116,0,97,
0,116,0,101,0,
66,0,111,0,100,
0,121,0,95,0,
49,0,50,0,1,
192,1,3,1,3,
1,2,1761,22,1,
26,1,2647,1762,17,
1763,15,1758,1,-1,
1,5,1764,20,1765,
4,22,83,0,116,
0,97,0,116,0,
101,0,66,0,111,
0,100,0,121,0,
95,0,52,0,1,
184,1,3,1,3,
1,2,1766,22,1,
18,1,1860,946,1,
1803,912,1,2521,1767,
17,1768,15,1769,4,
46,37,0,75,0,
101,0,121,0,73,
0,110,0,116,0,
73,0,110,0,116,
0,65,0,114,0,
103,0,83,0,116,
0,97,0,116,0,
101,0,69,0,118,
0,101,0,110,0,
116,0,1,-1,1,
5,1770,20,1771,4,
48,75,0,101,0,
121,0,73,0,110,
0,116,0,73,0,
110,0,116,0,65,
0,114,0,103,0,
83,0,116,0,97,
0,116,0,101,0,
69,0,118,0,101,
0,110,0,116,0,
95,0,49,0,1,
204,1,3,1,6,
1,5,1772,22,1,
38,1,2413,1773,16,
0,521,1,2657,1774,
17,1775,15,1758,1,
-1,1,5,1776,20,
1777,4,22,83,0,
116,0,97,0,116,
0,101,0,66,0,
111,0,100,0,121,
0,95,0,49,0,
1,181,1,3,1,
2,1,1,1778,22,
1,15,1,1873,961,
1,1657,1019,1,2641,
1779,17,1780,15,1758,
1,-1,1,5,1781,
20,1782,4,24,83,
0,116,0,97,0,
116,0,101,0,66,
0,111,0,100,0,
121,0,95,0,49,
0,54,0,1,196,
1,3,1,3,1,
2,1783,22,1,30,
1,2642,1784,17,1785,
15,1758,1,-1,1,
5,1786,20,1787,4,
24,83,0,116,0,
97,0,116,0,101,
0,66,0,111,0,
100,0,121,0,95,
0,49,0,52,0,
1,194,1,3,1,
3,1,2,1788,22,
1,28,1,1989,1041,
1,2644,1789,17,1790,
15,1758,1,-1,1,
5,1791,20,1792,4,
24,83,0,116,0,
97,0,116,0,101,
0,66,0,111,0,
100,0,121,0,95,
0,49,0,48,0,
1,190,1,3,1,
3,1,2,1793,22,
1,24,1,2645,1794,
17,1795,15,1758,1,
-1,1,5,1796,20,
1797,4,22,83,0,
116,0,97,0,116,
0,101,0,66,0,
111,0,100,0,121,
0,95,0,56,0,
1,188,1,3,1,
3,1,2,1798,22,
1,22,1,2646,1799,
17,1800,15,1758,1,
-1,1,5,1801,20,
1802,4,22,83,0,
116,0,97,0,116,
0,101,0,66,0,
111,0,100,0,121,
0,95,0,54,0,
1,186,1,3,1,
3,1,2,1803,22,
1,20,1,2037,882,
1,32,1804,16,0,
526,1,2567,1805,17,
1806,15,1807,4,34,
37,0,73,0,110,
0,116,0,65,0,
114,0,103,0,83,
0,116,0,97,0,
116,0,101,0,69,
0,118,0,101,0,
110,0,116,0,1,
-1,1,5,1808,20,
1809,4,36,73,0,
110,0,116,0,65,
0,114,0,103,0,
83,0,116,0,97,
0,116,0,101,0,
69,0,118,0,101,
0,110,0,116,0,
95,0,49,0,1,
200,1,3,1,6,
1,5,1810,22,1,
34,1,2650,1811,17,
1812,15,1758,1,-1,
1,5,1813,20,1814,
4,24,83,0,116,
0,97,0,116,0,
101,0,66,0,111,
0,100,0,121,0,
95,0,49,0,53,
0,1,195,1,3,
1,2,1,1,1815,
22,1,29,1,2651,
1816,17,1817,15,1758,
1,-1,1,5,1818,
20,1819,4,24,83,
0,116,0,97,0,
116,0,101,0,66,
0,111,0,100,0,
121,0,95,0,49,
0,51,0,1,193,
1,3,1,2,1,
1,1820,22,1,27,
1,2652,1821,17,1822,
15,1758,1,-1,1,
5,1823,20,1824,4,
24,83,0,116,0,
97,0,116,0,101,
0,66,0,111,0,
100,0,121,0,95,
0,49,0,49,0,
1,191,1,3,1,
2,1,1,1825,22,
1,25,1,2653,1826,
17,1827,15,1758,1,
-1,1,5,1828,20,
1829,4,22,83,0,
116,0,97,0,116,
0,101,0,66,0,
111,0,100,0,121,
0,95,0,57,0,
1,189,1,3,1,
2,1,1,1830,22,
1,23,1,2654,1831,
17,1832,15,1758,1,
-1,1,5,1833,20,
1834,4,22,83,0,
116,0,97,0,116,
0,101,0,66,0,
111,0,100,0,121,
0,95,0,55,0,
1,187,1,3,1,
2,1,1,1835,22,
1,21,1,2655,1836,
17,1837,15,1758,1,
-1,1,5,1838,20,
1839,4,22,83,0,
116,0,97,0,116,
0,101,0,66,0,
111,0,100,0,121,
0,95,0,53,0,
1,185,1,3,1,
2,1,1,1840,22,
1,19,1,2656,1841,
17,1842,15,1758,1,
-1,1,5,1843,20,
1844,4,22,83,0,
116,0,97,0,116,
0,101,0,66,0,
111,0,100,0,121,
0,95,0,51,0,
1,183,1,3,1,
2,1,1,1845,22,
1,17,1,2575,1846,
17,1847,15,1848,4,
34,37,0,75,0,
101,0,121,0,65,
0,114,0,103,0,
83,0,116,0,97,
0,116,0,101,0,
69,0,118,0,101,
0,110,0,116,0,
1,-1,1,5,1849,
20,1850,4,36,75,
0,101,0,121,0,
65,0,114,0,103,
0,83,0,116,0,
97,0,116,0,101,
0,69,0,118,0,
101,0,110,0,116,
0,95,0,49,0,
1,199,1,3,1,
6,1,5,1851,22,
1,33,1,2551,1852,
17,1853,15,1854,4,
46,37,0,73,0,
110,0,116,0,82,
0,111,0,116,0,
82,0,111,0,116,
0,65,0,114,0,
103,0,83,0,116,
0,97,0,116,0,
101,0,69,0,118,
0,101,0,110,0,
116,0,1,-1,1,
5,1855,20,1856,4,
48,73,0,110,0,
116,0,82,0,111,
0,116,0,82,0,
111,0,116,0,65,
0,114,0,103,0,
83,0,116,0,97,
0,116,0,101,0,
69,0,118,0,101,
0,110,0,116,0,
95,0,49,0,1,
202,1,3,1,6,
1,5,1857,22,1,
36,1,2580,1858,17,
1859,15,1860,4,36,
37,0,86,0,111,
0,105,0,100,0,
65,0,114,0,103,
0,83,0,116,0,
97,0,116,0,101,
0,69,0,118,0,
101,0,110,0,116,
0,1,-1,1,5,
1861,20,1862,4,38,
86,0,111,0,105,
0,100,0,65,0,
114,0,103,0,83,
0,116,0,97,0,
116,0,101,0,69,
0,118,0,101,0,
110,0,116,0,95,
0,49,0,1,198,
1,3,1,5,1,
4,1863,22,1,32,
1,2227,1033,1,1574,
924,1,2559,1864,17,
1865,15,1866,4,40,
37,0,86,0,101,
0,99,0,116,0,
111,0,114,0,65,
0,114,0,103,0,
83,0,116,0,97,
0,116,0,101,0,
69,0,118,0,101,
0,110,0,116,0,
1,-1,1,5,1867,
20,1868,4,42,86,
0,101,0,99,0,
116,0,111,0,114,
0,65,0,114,0,
103,0,83,0,116,
0,97,0,116,0,
101,0,69,0,118,
0,101,0,110,0,
116,0,95,0,49,
0,1,201,1,3,
1,6,1,5,1869,
22,1,35,1,2021,
843,1,2458,1001,1,
2459,1007,1,2462,1014,
1,2136,968,1,2464,
1024,1,2029,850,1,
2030,856,1,2031,861,
1,2032,866,1,2033,
871,1,2035,877,1,
2364,952,1,2039,887,
1,1931,986,1,2041,
893,1,2043,899,1,
2045,904,1,2703,1870,
16,0,211,1,2595,
1871,17,1872,15,1873,
4,22,37,0,83,
0,116,0,97,0,
116,0,101,0,69,
0,118,0,101,0,
110,0,116,0,1,
-1,1,5,1874,20,
1875,4,24,83,0,
116,0,97,0,116,
0,101,0,69,0,
118,0,101,0,110,
0,116,0,95,0,
49,0,1,197,1,
3,1,6,1,5,
1876,22,1,31,1,
2597,1877,16,0,761,
1,2648,1878,17,1879,
15,1758,1,-1,1,
5,1880,20,1881,4,
22,83,0,116,0,
97,0,116,0,101,
0,66,0,111,0,
100,0,121,0,95,
0,50,0,1,182,
1,3,1,3,1,
2,1882,22,1,16,
1,2105,939,1,14,
1883,19,144,1,14,
1884,5,115,1,2510,
1885,16,0,706,1,
2513,1886,17,1887,15,
1888,4,30,37,0,
73,0,110,0,116,
0,68,0,101,0,
99,0,108,0,97,
0,114,0,97,0,
116,0,105,0,111,
0,110,0,1,-1,
1,5,1889,20,1890,
4,32,73,0,110,
0,116,0,68,0,
101,0,99,0,108,
0,97,0,114,0,
97,0,116,0,105,
0,111,0,110,0,
95,0,49,0,1,
215,1,3,1,3,
1,2,1891,22,1,
50,1,2514,1892,16,
0,360,1,1260,1221,
1,1011,1227,1,1514,
1233,1,9,1238,1,
10,1893,17,1894,15,
1895,4,48,37,0,
65,0,114,0,103,
0,117,0,109,0,
101,0,110,0,116,
0,68,0,101,0,
99,0,108,0,97,
0,114,0,97,0,
116,0,105,0,111,
0,110,0,76,0,
105,0,115,0,116,
0,1,-1,1,5,
140,1,0,1,0,
1896,22,1,39,1,
262,1244,1,1267,1250,
1,2525,1897,16,0,
507,1,1773,1898,16,
0,148,1,2779,1899,
16,0,142,1,19,
1272,1,20,1900,16,
0,142,1,2281,1279,
1,525,1343,1,30,
1901,17,1902,15,1895,
1,-1,1,5,1903,
20,1904,4,50,65,
0,114,0,103,0,
117,0,109,0,101,
0,110,0,116,0,
68,0,101,0,99,
0,108,0,97,0,
114,0,97,0,116,
0,105,0,111,0,
110,0,76,0,105,
0,115,0,116,0,
95,0,50,0,1,
206,1,3,1,4,
1,3,1905,22,1,
41,1,283,1299,1,
2543,1906,17,1907,15,
1908,4,30,37,0,
82,0,111,0,116,
0,68,0,101,0,
99,0,108,0,97,
0,114,0,97,0,
116,0,105,0,111,
0,110,0,1,-1,
1,5,1909,20,1910,
4,32,82,0,111,
0,116,0,68,0,
101,0,99,0,108,
0,97,0,114,0,
97,0,116,0,105,
0,111,0,110,0,
95,0,49,0,1,
217,1,3,1,3,
1,2,1911,22,1,
52,1,2544,1912,16,
0,528,1,40,1304,
1,41,1913,17,1914,
15,1915,4,26,37,
0,65,0,114,0,
103,0,117,0,109,
0,101,0,110,0,
116,0,76,0,105,
0,115,0,116,0,
1,-1,1,5,724,
1,0,1,0,1916,
22,1,169,1,42,
1917,17,1918,15,1919,
4,38,37,0,69,
0,120,0,112,0,
114,0,101,0,115,
0,115,0,105,0,
111,0,110,0,65,
0,114,0,103,0,
117,0,109,0,101,
0,110,0,116,0,
1,-1,1,5,1920,
20,1921,4,40,69,
0,120,0,112,0,
114,0,101,0,115,
0,115,0,105,0,
111,0,110,0,65,
0,114,0,103,0,
117,0,109,0,101,
0,110,0,116,0,
95,0,49,0,1,
336,1,3,1,2,
1,1,1922,22,1,
172,1,44,1310,1,
47,1311,1,48,1317,
1,49,1323,1,50,
1328,1,51,1333,1,
305,1338,1,63,1349,
1,1521,1255,1,66,
1355,1,67,1360,1,
1478,1583,1,69,1370,
1,70,1375,1,68,
1365,1,74,1380,1,
1013,1385,1,2335,1923,
16,0,148,1,1332,
1390,1,1048,1470,1,
2591,1924,16,0,142,
1,82,1407,1,1296,
1294,1,1341,1424,1,
328,1429,1,1303,1434,
1,1096,1439,1,93,
1445,1,1550,1450,1,
2770,1925,17,1926,15,
1895,1,-1,1,5,
140,1,0,1,0,
1896,1,2528,1927,17,
1928,15,1929,4,30,
37,0,86,0,101,
0,99,0,68,0,
101,0,99,0,108,
0,97,0,114,0,
97,0,116,0,105,
0,111,0,110,0,
1,-1,1,5,1930,
20,1931,4,32,86,
0,101,0,99,0,
68,0,101,0,99,
0,108,0,97,0,
114,0,97,0,116,
0,105,0,111,0,
110,0,95,0,49,
0,1,216,1,3,
1,3,1,2,1932,
22,1,51,1,2529,
1933,16,0,515,1,
352,1475,1,107,1464,
1,1114,1469,1,2540,
1934,16,0,524,1,
1370,1578,1,118,1481,
1,1123,1486,1,371,
1491,1,1377,1497,1,
375,1502,1,377,1507,
1,827,1457,1,380,
1517,1,883,1523,1,
373,1535,1,130,1540,
1,379,1512,1,143,
1545,1,1152,1551,1,
387,1935,16,0,656,
1,1406,1556,1,2582,
1936,17,1937,15,1895,
1,-1,1,5,140,
1,0,1,0,1896,
1,1159,1563,1,157,
1568,1,1413,1573,1,
1665,1600,1,412,1938,
16,0,695,1,1094,
1939,16,0,726,1,
172,1595,1,1188,1605,
1,437,1940,16,0,
765,1,1442,1610,1,
1694,1941,16,0,148,
1,942,1616,1,1195,
1622,1,1449,1627,1,
1701,1632,1,447,1637,
1,188,1644,1,205,
1649,1,2467,1942,17,
1943,15,1895,1,-1,
1,5,1944,20,1945,
4,50,65,0,114,
0,103,0,117,0,
109,0,101,0,110,
0,116,0,68,0,
101,0,99,0,108,
0,97,0,114,0,
97,0,116,0,105,
0,111,0,110,0,
76,0,105,0,115,
0,116,0,95,0,
49,0,1,205,1,
3,1,2,1,1,
1946,22,1,40,1,
461,1947,16,0,726,
1,464,1948,17,1949,
15,1915,1,-1,1,
5,1950,20,1951,4,
28,65,0,114,0,
103,0,117,0,109,
0,101,0,110,0,
116,0,76,0,105,
0,115,0,116,0,
95,0,50,0,1,
335,1,3,1,4,
1,3,1952,22,1,
171,1,1224,1654,1,
223,1659,1,1730,1664,
1,476,1669,1,477,
1675,1,1231,1680,1,
479,1685,1,480,1690,
1,1485,1696,1,459,
1953,17,1954,15,1915,
1,-1,1,5,724,
1,0,1,0,1916,
1,242,1703,1,478,
1708,1,481,1955,17,
1956,15,1915,1,-1,
1,5,1957,20,1958,
4,28,65,0,114,
0,103,0,117,0,
109,0,101,0,110,
0,116,0,76,0,
105,0,115,0,116,
0,95,0,49,0,
1,334,1,3,1,
2,1,1,1959,22,
1,170,1,1001,1713,
1,1002,1718,1,2509,
1960,17,1961,15,1962,
4,30,37,0,75,
0,101,0,121,0,
68,0,101,0,99,
0,108,0,97,0,
114,0,97,0,116,
0,105,0,111,0,
110,0,1,-1,1,
5,1963,20,1964,4,
32,75,0,101,0,
121,0,68,0,101,
0,99,0,108,0,
97,0,114,0,97,
0,116,0,105,0,
111,0,110,0,95,
0,49,0,1,214,
1,3,1,3,1,
2,1965,22,1,49,
1,15,1966,19,336,
1,15,1967,5,6,
1,2785,1968,16,0,
334,1,1114,1969,16,
0,339,1,1621,1970,
16,0,764,1,40,
1971,16,0,649,1,
19,1272,1,9,1238,
1,16,1972,19,136,
1,16,1973,5,147,
1,256,1974,16,0,
203,1,1261,1975,16,
0,203,1,509,1976,
16,0,203,1,2769,
1977,16,0,790,1,
9,1978,16,0,134,
1,2522,1979,16,0,
505,1,2021,843,1,
1775,1980,16,0,203,
1,2029,850,1,2030,
856,1,2031,861,1,
2032,866,1,2786,1981,
16,0,203,1,277,
1982,16,0,203,1,
2537,1983,16,0,522,
1,2037,882,1,2039,
887,1,32,1984,16,
0,203,1,2041,893,
1,2293,1985,16,0,
203,1,2043,899,1,
2045,904,1,40,1986,
16,0,182,1,41,
1987,16,0,203,1,
1297,1988,16,0,203,
1,43,1989,16,0,
203,1,44,1990,16,
0,182,1,1803,912,
1,1804,1991,16,0,
203,1,299,1992,16,
0,203,1,2480,1993,
17,1994,15,1995,4,
24,37,0,73,0,
110,0,116,0,65,
0,114,0,103,0,
69,0,118,0,101,
0,110,0,116,0,
1,-1,1,5,1996,
20,1997,4,26,73,
0,110,0,116,0,
65,0,114,0,103,
0,69,0,118,0,
101,0,110,0,116,
0,95,0,55,0,
1,369,1,3,1,
2,1,1,1998,22,
1,205,1,2560,1999,
16,0,549,1,52,
2000,16,0,203,1,
2484,2001,17,2002,15,
1995,1,-1,1,5,
2003,20,2004,4,26,
73,0,110,0,116,
0,65,0,114,0,
103,0,69,0,118,
0,101,0,110,0,
116,0,95,0,51,
0,1,365,1,3,
1,2,1,1,2005,
22,1,201,1,1515,
2006,16,0,203,1,
2318,2007,16,0,203,
1,2491,2008,17,2009,
15,2010,4,26,37,
0,86,0,111,0,
105,0,100,0,65,
0,114,0,103,0,
69,0,118,0,101,
0,110,0,116,0,
1,-1,1,5,2011,
20,2012,4,28,86,
0,111,0,105,0,
100,0,65,0,114,
0,103,0,69,0,
118,0,101,0,110,
0,116,0,95,0,
54,0,1,358,1,
3,1,2,1,1,
2013,22,1,194,1,
62,2014,16,0,225,
1,63,2015,16,0,
182,1,2495,2016,17,
2017,15,2010,1,-1,
1,5,2018,20,2019,
4,28,86,0,111,
0,105,0,100,0,
65,0,114,0,103,
0,69,0,118,0,
101,0,110,0,116,
0,95,0,50,0,
1,354,1,3,1,
2,1,1,2020,22,
1,190,1,2576,2021,
16,0,579,1,2075,
2022,16,0,203,1,
1574,924,1,1479,2023,
16,0,203,1,71,
2024,16,0,203,1,
1658,2025,16,0,795,
1,1833,2026,16,0,
326,1,1834,2027,16,
0,203,1,2337,2028,
16,0,203,1,79,
2029,16,0,203,1,
1335,2030,16,0,203,
1,322,2031,16,0,
203,1,76,2032,16,
0,203,1,85,2033,
16,0,203,1,89,
2034,16,0,203,1,
2033,871,1,2035,877,
1,346,2035,16,0,
203,1,97,2036,16,
0,203,1,2106,2037,
16,0,203,1,102,
2038,16,0,203,1,
1860,946,1,2458,1001,
1,2364,952,1,1990,
2039,16,0,203,1,
112,2040,16,0,203,
1,1117,2041,16,0,
203,1,1873,961,1,
1875,2042,16,0,446,
1,1876,2043,16,0,
203,1,2552,2044,16,
0,540,1,124,2045,
16,0,203,1,2478,
2046,17,2047,15,1995,
1,-1,1,5,2048,
20,2049,4,26,73,
0,110,0,116,0,
65,0,114,0,103,
0,69,0,118,0,
101,0,110,0,116,
0,95,0,57,0,
1,371,1,3,1,
2,1,1,2050,22,
1,207,1,2136,968,
1,381,2051,16,0,
203,1,525,2052,16,
0,203,1,137,2053,
16,0,203,1,2568,
2054,16,0,683,1,
1901,2055,16,0,203,
1,1153,2056,16,0,
203,1,151,2057,16,
0,203,1,1407,2058,
16,0,203,1,2581,
2059,16,0,779,1,
2413,2060,16,0,203,
1,406,2061,16,0,
203,1,1371,2062,16,
0,203,1,2105,939,
1,166,2063,16,0,
203,1,1622,2064,16,
0,203,1,1931,986,
1,1932,2065,16,0,
539,1,1933,2066,16,
0,203,1,431,2067,
16,0,203,1,1585,
2068,16,0,203,1,
182,2069,16,0,203,
1,1189,2070,16,0,
203,1,1443,2071,16,
0,203,1,1695,2072,
16,0,203,1,2198,
2073,16,0,203,1,
447,2074,16,0,203,
1,199,2075,16,0,
203,1,2459,1007,1,
1958,2076,16,0,203,
1,2462,1014,1,1657,
1019,1,2464,1024,1,
1659,2077,16,0,203,
1,459,2078,16,0,
203,1,462,2079,16,
0,203,1,2471,2080,
17,2081,15,2082,4,
36,37,0,75,0,
101,0,121,0,73,
0,110,0,116,0,
73,0,110,0,116,
0,65,0,114,0,
103,0,69,0,118,
0,101,0,110,0,
116,0,1,-1,1,
5,2083,20,2084,4,
38,75,0,101,0,
121,0,73,0,110,
0,116,0,73,0,
110,0,116,0,65,
0,114,0,103,0,
69,0,118,0,101,
0,110,0,116,0,
95,0,49,0,1,
378,1,3,1,2,
1,1,2085,22,1,
214,1,2472,2086,17,
2087,15,2088,4,36,
37,0,73,0,110,
0,116,0,86,0,
101,0,99,0,86,
0,101,0,99,0,
65,0,114,0,103,
0,69,0,118,0,
101,0,110,0,116,
0,1,-1,1,5,
2089,20,2090,4,38,
73,0,110,0,116,
0,86,0,101,0,
99,0,86,0,101,
0,99,0,65,0,
114,0,103,0,69,
0,118,0,101,0,
110,0,116,0,95,
0,49,0,1,377,
1,3,1,2,1,
1,2091,22,1,213,
1,2473,2092,17,2093,
15,2094,4,36,37,
0,73,0,110,0,
116,0,82,0,111,
0,116,0,82,0,
111,0,116,0,65,
0,114,0,103,0,
69,0,118,0,101,
0,110,0,116,0,
1,-1,1,5,2095,
20,2096,4,38,73,
0,110,0,116,0,
82,0,111,0,116,
0,82,0,111,0,
116,0,65,0,114,
0,103,0,69,0,
118,0,101,0,110,
0,116,0,95,0,
49,0,1,376,1,
3,1,2,1,1,
2097,22,1,212,1,
2474,2098,17,2099,15,
2100,4,30,37,0,
86,0,101,0,99,
0,116,0,111,0,
114,0,65,0,114,
0,103,0,69,0,
118,0,101,0,110,
0,116,0,1,-1,
1,5,2101,20,2102,
4,32,86,0,101,
0,99,0,116,0,
111,0,114,0,65,
0,114,0,103,0,
69,0,118,0,101,
0,110,0,116,0,
95,0,51,0,1,
375,1,3,1,2,
1,1,2103,22,1,
211,1,2475,2104,17,
2105,15,2100,1,-1,
1,5,2106,20,2107,
4,32,86,0,101,
0,99,0,116,0,
111,0,114,0,65,
0,114,0,103,0,
69,0,118,0,101,
0,110,0,116,0,
95,0,50,0,1,
374,1,3,1,2,
1,1,2108,22,1,
210,1,2476,2109,17,
2110,15,2100,1,-1,
1,5,2111,20,2112,
4,32,86,0,101,
0,99,0,116,0,
111,0,114,0,65,
0,114,0,103,0,
69,0,118,0,101,
0,110,0,116,0,
95,0,49,0,1,
373,1,3,1,2,
1,1,2113,22,1,
209,1,2477,2114,17,
2115,15,1995,1,-1,
1,5,2116,20,2117,
4,28,73,0,110,
0,116,0,65,0,
114,0,103,0,69,
0,118,0,101,0,
110,0,116,0,95,
0,49,0,48,0,
1,372,1,3,1,
2,1,1,2118,22,
1,208,1,2227,1033,
1,2479,2119,17,2120,
15,1995,1,-1,1,
5,2121,20,2122,4,
26,73,0,110,0,
116,0,65,0,114,
0,103,0,69,0,
118,0,101,0,110,
0,116,0,95,0,
56,0,1,370,1,
3,1,2,1,1,
2123,22,1,206,1,
1225,2124,16,0,203,
1,2481,2125,17,2126,
15,1995,1,-1,1,
5,2127,20,2128,4,
26,73,0,110,0,
116,0,65,0,114,
0,103,0,69,0,
118,0,101,0,110,
0,116,0,95,0,
54,0,1,368,1,
3,1,2,1,1,
2129,22,1,204,1,
2482,2130,17,2131,15,
1995,1,-1,1,5,
2132,20,2133,4,26,
73,0,110,0,116,
0,65,0,114,0,
103,0,69,0,118,
0,101,0,110,0,
116,0,95,0,53,
0,1,367,1,3,
1,2,1,1,2134,
22,1,203,1,2483,
2135,17,2136,15,1995,
1,-1,1,5,2137,
20,2138,4,26,73,
0,110,0,116,0,
65,0,114,0,103,
0,69,0,118,0,
101,0,110,0,116,
0,95,0,52,0,
1,366,1,3,1,
2,1,1,2139,22,
1,202,1,1731,2140,
16,0,203,1,2485,
2141,17,2142,15,1995,
1,-1,1,5,2143,
20,2144,4,26,73,
0,110,0,116,0,
65,0,114,0,103,
0,69,0,118,0,
101,0,110,0,116,
0,95,0,50,0,
1,364,1,3,1,
2,1,1,2145,22,
1,200,1,2486,2146,
17,2147,15,1995,1,
-1,1,5,2148,20,
2149,4,26,73,0,
110,0,116,0,65,
0,114,0,103,0,
69,0,118,0,101,
0,110,0,116,0,
95,0,49,0,1,
363,1,3,1,2,
1,1,2150,22,1,
199,1,2487,2151,17,
2152,15,2153,4,24,
37,0,75,0,101,
0,121,0,65,0,
114,0,103,0,69,
0,118,0,101,0,
110,0,116,0,1,
-1,1,5,2154,20,
2155,4,26,75,0,
101,0,121,0,65,
0,114,0,103,0,
69,0,118,0,101,
0,110,0,116,0,
95,0,50,0,1,
362,1,3,1,2,
1,1,2156,22,1,
198,1,2488,2157,17,
2158,15,2153,1,-1,
1,5,2159,20,2160,
4,26,75,0,101,
0,121,0,65,0,
114,0,103,0,69,
0,118,0,101,0,
110,0,116,0,95,
0,49,0,1,361,
1,3,1,2,1,
1,2161,22,1,197,
1,2489,2162,17,2163,
15,2010,1,-1,1,
5,2164,20,2165,4,
28,86,0,111,0,
105,0,100,0,65,
0,114,0,103,0,
69,0,118,0,101,
0,110,0,116,0,
95,0,56,0,1,
360,1,3,1,2,
1,1,2166,22,1,
196,1,2490,2167,17,
2168,15,2010,1,-1,
1,5,2169,20,2170,
4,28,86,0,111,
0,105,0,100,0,
65,0,114,0,103,
0,69,0,118,0,
101,0,110,0,116,
0,95,0,55,0,
1,359,1,3,1,
2,1,1,2171,22,
1,195,1,1989,1041,
1,2492,2172,17,2173,
15,2010,1,-1,1,
5,2174,20,2175,4,
28,86,0,111,0,
105,0,100,0,65,
0,114,0,103,0,
69,0,118,0,101,
0,110,0,116,0,
95,0,53,0,1,
357,1,3,1,2,
1,1,2176,22,1,
193,1,2493,2177,17,
2178,15,2010,1,-1,
1,5,2179,20,2180,
4,28,86,0,111,
0,105,0,100,0,
65,0,114,0,103,
0,69,0,118,0,
101,0,110,0,116,
0,95,0,52,0,
1,356,1,3,1,
2,1,1,2181,22,
1,192,1,2494,2182,
17,2183,15,2010,1,
-1,1,5,2184,20,
2185,4,28,86,0,
111,0,105,0,100,
0,65,0,114,0,
103,0,69,0,118,
0,101,0,110,0,
116,0,95,0,51,
0,1,355,1,3,
1,2,1,1,2186,
22,1,191,1,236,
2187,16,0,203,1,
2496,2188,17,2189,15,
2010,1,-1,1,5,
2190,20,2191,4,28,
86,0,111,0,105,
0,100,0,65,0,
114,0,103,0,69,
0,118,0,101,0,
110,0,116,0,95,
0,49,0,1,353,
1,3,1,2,1,
1,2192,22,1,189,
1,2497,2193,17,2194,
15,2195,4,12,37,
0,69,0,118,0,
101,0,110,0,116,
0,1,-1,1,5,
2196,20,2197,4,14,
69,0,118,0,101,
0,110,0,116,0,
95,0,57,0,1,
352,1,3,1,2,
1,1,2198,22,1,
188,1,2498,2199,17,
2200,15,2195,1,-1,
1,5,2201,20,2202,
4,14,69,0,118,
0,101,0,110,0,
116,0,95,0,56,
0,1,351,1,3,
1,2,1,1,2203,
22,1,187,1,2499,
2204,17,2205,15,2195,
1,-1,1,5,2206,
20,2207,4,14,69,
0,118,0,101,0,
110,0,116,0,95,
0,55,0,1,350,
1,3,1,2,1,
1,2208,22,1,186,
1,2500,2209,17,2210,
15,2195,1,-1,1,
5,2211,20,2212,4,
14,69,0,118,0,
101,0,110,0,116,
0,95,0,54,0,
1,349,1,3,1,
2,1,1,2213,22,
1,185,1,2501,2214,
17,2215,15,2195,1,
-1,1,5,2216,20,
2217,4,14,69,0,
118,0,101,0,110,
0,116,0,95,0,
53,0,1,348,1,
3,1,2,1,1,
2218,22,1,184,1,
2502,2219,17,2220,15,
2195,1,-1,1,5,
2221,20,2222,4,14,
69,0,118,0,101,
0,110,0,116,0,
95,0,52,0,1,
347,1,3,1,2,
1,1,2223,22,1,
183,1,2503,2224,17,
2225,15,2195,1,-1,
1,5,2226,20,2227,
4,14,69,0,118,
0,101,0,110,0,
116,0,95,0,51,
0,1,346,1,3,
1,2,1,1,2228,
22,1,182,1,2504,
2229,17,2230,15,2195,
1,-1,1,5,2231,
20,2232,4,14,69,
0,118,0,101,0,
110,0,116,0,95,
0,50,0,1,345,
1,3,1,2,1,
1,2233,22,1,181,
1,2505,2234,17,2235,
15,2195,1,-1,1,
5,2236,20,2237,4,
14,69,0,118,0,
101,0,110,0,116,
0,95,0,49,0,
1,344,1,3,1,
2,1,1,2238,22,
1,180,1,2506,2239,
16,0,482,1,217,
2240,16,0,203,1,
1756,2241,16,0,203,
1,17,2242,19,163,
1,17,2243,5,134,
1,1,2244,17,2245,
15,2246,4,18,37,
0,84,0,121,0,
112,0,101,0,110,
0,97,0,109,0,
101,0,1,-1,1,
5,2247,20,2248,4,
20,84,0,121,0,
112,0,101,0,110,
0,97,0,109,0,
101,0,95,0,55,
0,1,343,1,3,
1,2,1,1,2249,
22,1,179,1,2,
2250,17,2251,15,2246,
1,-1,1,5,2252,
20,2253,4,20,84,
0,121,0,112,0,
101,0,110,0,97,
0,109,0,101,0,
95,0,54,0,1,
342,1,3,1,2,
1,1,2254,22,1,
178,1,3,2255,17,
2256,15,2246,1,-1,
1,5,2257,20,2258,
4,20,84,0,121,
0,112,0,101,0,
110,0,97,0,109,
0,101,0,95,0,
53,0,1,341,1,
3,1,2,1,1,
2259,22,1,177,1,
4,2260,17,2261,15,
2246,1,-1,1,5,
2262,20,2263,4,20,
84,0,121,0,112,
0,101,0,110,0,
97,0,109,0,101,
0,95,0,52,0,
1,340,1,3,1,
2,1,1,2264,22,
1,176,1,5,2265,
17,2266,15,2246,1,
-1,1,5,2267,20,
2268,4,20,84,0,
121,0,112,0,101,
0,110,0,97,0,
109,0,101,0,95,
0,51,0,1,339,
1,3,1,2,1,
1,2269,22,1,175,
1,6,2270,17,2271,
15,2246,1,-1,1,
5,2272,20,2273,4,
20,84,0,121,0,
112,0,101,0,110,
0,97,0,109,0,
101,0,95,0,50,
0,1,338,1,3,
1,2,1,1,2274,
22,1,174,1,7,
2275,17,2276,15,2246,
1,-1,1,5,2277,
20,2278,4,20,84,
0,121,0,112,0,
101,0,110,0,97,
0,109,0,101,0,
95,0,49,0,1,
337,1,3,1,2,
1,1,2279,22,1,
173,1,2518,2280,16,
0,499,1,9,1238,
1,10,1893,1,262,
1244,1,1267,1250,1,
1521,1255,1,1773,2281,
16,0,261,1,2528,
1927,1,19,1272,1,
20,2282,16,0,161,
1,2532,2283,17,2284,
15,2285,4,66,37,
0,73,0,110,0,
116,0,86,0,101,
0,99,0,86,0,
101,0,99,0,65,
0,114,0,103,0,
117,0,109,0,101,
0,110,0,116,0,
68,0,101,0,99,
0,108,0,97,0,
114,0,97,0,116,
0,105,0,111,0,
110,0,76,0,105,
0,115,0,116,0,
1,-1,1,5,2286,
20,2287,4,68,73,
0,110,0,116,0,
86,0,101,0,99,
0,86,0,101,0,
99,0,65,0,114,
0,103,0,117,0,
109,0,101,0,110,
0,116,0,68,0,
101,0,99,0,108,
0,97,0,114,0,
97,0,116,0,105,
0,111,0,110,0,
76,0,105,0,115,
0,116,0,95,0,
49,0,1,211,1,
3,1,6,1,5,
2288,22,1,46,1,
2533,2289,16,0,518,
1,30,1901,1,283,
1299,1,2543,1906,1,
2547,2290,17,2291,15,
2292,4,66,37,0,
73,0,110,0,116,
0,82,0,111,0,
116,0,82,0,111,
0,116,0,65,0,
114,0,103,0,117,
0,109,0,101,0,
110,0,116,0,68,
0,101,0,99,0,
108,0,97,0,114,
0,97,0,116,0,
105,0,111,0,110,
0,76,0,105,0,
115,0,116,0,1,
-1,1,5,2293,20,
2294,4,68,73,0,
110,0,116,0,82,
0,111,0,116,0,
82,0,111,0,116,
0,65,0,114,0,
103,0,117,0,109,
0,101,0,110,0,
116,0,68,0,101,
0,99,0,108,0,
97,0,114,0,97,
0,116,0,105,0,
111,0,110,0,76,
0,105,0,115,0,
116,0,95,0,49,
0,1,210,1,3,
1,6,1,5,2295,
22,1,45,1,2548,
2296,16,0,650,1,
1010,2297,16,0,716,
1,40,1304,1,41,
1913,1,42,1917,1,
44,1310,1,2555,2298,
17,2299,15,2300,4,
60,37,0,86,0,
101,0,99,0,116,
0,111,0,114,0,
65,0,114,0,103,
0,117,0,109,0,
101,0,110,0,116,
0,68,0,101,0,
99,0,108,0,97,
0,114,0,97,0,
116,0,105,0,111,
0,110,0,76,0,
105,0,115,0,116,
0,1,-1,1,5,
2301,20,2302,4,62,
86,0,101,0,99,
0,116,0,111,0,
114,0,65,0,114,
0,103,0,117,0,
109,0,101,0,110,
0,116,0,68,0,
101,0,99,0,108,
0,97,0,114,0,
97,0,116,0,105,
0,111,0,110,0,
76,0,105,0,115,
0,116,0,95,0,
49,0,1,209,1,
3,1,2,1,1,
2303,22,1,44,1,
1260,1221,1,47,1311,
1,48,1317,1,49,
1323,1,50,1328,1,
51,1333,1,2563,2304,
17,2305,15,2306,4,
54,37,0,73,0,
110,0,116,0,65,
0,114,0,103,0,
117,0,109,0,101,
0,110,0,116,0,
68,0,101,0,99,
0,108,0,97,0,
114,0,97,0,116,
0,105,0,111,0,
110,0,76,0,105,
0,115,0,116,0,
1,-1,1,5,2307,
20,2308,4,56,73,
0,110,0,116,0,
65,0,114,0,103,
0,117,0,109,0,
101,0,110,0,116,
0,68,0,101,0,
99,0,108,0,97,
0,114,0,97,0,
116,0,105,0,111,
0,110,0,76,0,
105,0,115,0,116,
0,95,0,49,0,
1,208,1,3,1,
2,1,1,2309,22,
1,43,1,305,1338,
1,1514,1233,1,525,
1343,1,61,2310,16,
0,217,1,2572,2311,
16,0,689,1,63,
1349,1,66,1355,1,
67,1360,1,68,1365,
1,69,1370,1,70,
1375,1,2582,1936,1,
73,2312,16,0,227,
1,827,1457,1,1013,
1385,1,2335,2313,16,
0,263,1,1332,1390,
1,74,1380,1,2591,
2314,16,0,710,1,
82,1407,1,2513,1886,
1,1341,1424,1,2517,
2315,17,2316,15,2317,
4,66,37,0,75,
0,101,0,121,0,
73,0,110,0,116,
0,73,0,110,0,
116,0,65,0,114,
0,103,0,117,0,
109,0,101,0,110,
0,116,0,68,0,
101,0,99,0,108,
0,97,0,114,0,
97,0,116,0,105,
0,111,0,110,0,
76,0,105,0,115,
0,116,0,1,-1,
1,5,2318,20,2319,
4,68,75,0,101,
0,121,0,73,0,
110,0,116,0,73,
0,110,0,116,0,
65,0,114,0,103,
0,117,0,109,0,
101,0,110,0,116,
0,68,0,101,0,
99,0,108,0,97,
0,114,0,97,0,
116,0,105,0,111,
0,110,0,76,0,
105,0,115,0,116,
0,95,0,49,0,
1,212,1,3,1,
6,1,5,2320,22,
1,47,1,328,1429,
1,1303,1434,1,1096,
1439,1,93,1445,1,
1550,1450,1,2281,1279,
1,2770,1925,1,352,
1475,1,2779,2321,16,
0,797,1,107,1464,
1,1114,1469,1,1048,
1470,1,1871,2322,16,
0,353,1,1370,1578,
1,1478,1583,1,118,
1481,1,1123,1486,1,
371,1491,1,1377,1497,
1,375,1502,1,1882,
2323,16,0,373,1,
377,1507,1,2556,2324,
16,0,661,1,379,
1512,1,380,1517,1,
130,1540,1,2074,2325,
16,0,652,1,373,
1535,1,2564,2326,16,
0,554,1,1011,1227,
1,1012,2327,16,0,
718,1,1840,2328,16,
0,343,1,143,1545,
1,1152,1551,1,2577,
2329,16,0,696,1,
1406,1556,1,1159,1563,
1,157,1568,1,1413,
1573,1,883,1523,1,
1094,2330,16,0,787,
1,1296,1294,1,172,
1595,1,1665,1600,1,
1939,2331,16,0,494,
1,1188,1605,1,1442,
1610,1,188,1644,1,
942,1616,1,1195,1622,
1,1449,1627,1,1701,
1632,1,447,1637,1,
205,1649,1,2467,1942,
1,464,1948,1,2197,
2332,16,0,782,1,
1224,1654,1,223,1659,
1,1730,1664,1,2571,
2333,17,2334,15,2335,
4,54,37,0,75,
0,101,0,121,0,
65,0,114,0,103,
0,117,0,109,0,
101,0,110,0,116,
0,68,0,101,0,
99,0,108,0,97,
0,114,0,97,0,
116,0,105,0,111,
0,110,0,76,0,
105,0,115,0,116,
0,1,-1,1,5,
2336,20,2337,4,56,
75,0,101,0,121,
0,65,0,114,0,
103,0,117,0,109,
0,101,0,110,0,
116,0,68,0,101,
0,99,0,108,0,
97,0,114,0,97,
0,116,0,105,0,
111,0,110,0,76,
0,105,0,115,0,
116,0,95,0,49,
0,1,207,1,3,
1,2,1,1,2338,
22,1,42,1,477,
1675,1,1231,1680,1,
479,1685,1,480,1690,
1,1485,1696,1,459,
1953,1,476,1669,1,
242,1703,1,478,1708,
1,481,1955,1,1001,
1713,1,1002,1718,1,
2509,1960,1,18,2339,
19,574,1,18,2340,
5,84,1,1011,1227,
1,1012,2341,16,0,
572,1,1013,1385,1,
262,1244,1,1267,2342,
16,0,572,1,515,
2343,16,0,572,1,
1521,2344,16,0,572,
1,525,1343,1,2792,
2345,16,0,572,1,
283,1299,1,2299,2346,
16,0,572,1,42,
2347,16,0,572,1,
40,1304,1,44,1310,
1,47,1311,1,1303,
2348,16,0,572,1,
1555,2349,16,0,572,
1,50,1328,1,48,
1317,1,49,1323,1,
51,1333,1,63,1349,
1,305,1338,1,66,
1355,1,67,1360,1,
68,1365,1,69,1370,
1,70,1375,1,73,
2350,16,0,572,1,
74,1380,1,328,1429,
1,1048,2351,16,0,
572,1,82,2352,16,
0,572,1,1840,2353,
16,0,572,1,1591,
2354,16,0,572,1,
1341,2355,16,0,572,
1,1096,1439,1,93,
1445,1,352,1475,1,
107,2356,16,0,572,
1,1114,1469,1,118,
2357,16,0,572,1,
1123,2358,16,0,572,
1,371,1491,1,1628,
2359,16,0,572,1,
375,1502,1,1882,2360,
16,0,572,1,377,
1507,1,379,1512,1,
380,1517,1,883,2361,
16,0,572,1,373,
1535,1,130,2362,16,
0,572,1,143,2363,
16,0,572,1,387,
2364,16,0,572,1,
1159,2365,16,0,572,
1,157,2366,16,0,
572,1,1413,2367,16,
0,572,1,1665,2368,
16,0,572,1,412,
2369,16,0,572,1,
1377,2370,16,0,572,
1,172,2371,16,0,
572,1,1939,2372,16,
0,572,1,437,2373,
16,0,572,1,188,
2374,16,0,572,1,
942,2375,16,0,572,
1,1195,2376,16,0,
572,1,1449,2377,16,
0,572,1,1701,2378,
16,0,572,1,447,
1637,1,205,2379,16,
0,572,1,827,2380,
16,0,572,1,223,
2381,16,0,572,1,
476,1669,1,477,1675,
1,1231,2382,16,0,
572,1,479,1685,1,
480,1690,1,1485,2383,
16,0,572,1,1737,
2384,16,0,572,1,
242,2385,16,0,572,
1,478,1708,1,1001,
1713,1,1002,1718,1,
19,2386,19,251,1,
19,2387,5,176,1,
942,2388,16,0,537,
1,256,2389,16,0,
249,1,1261,2390,16,
0,249,1,1011,1227,
1,1012,2391,16,0,
537,1,2458,1001,1,
262,1244,1,1267,2392,
16,0,537,1,2021,
843,1,1521,2393,16,
0,537,1,1775,2394,
16,0,249,1,2029,
850,1,2030,856,1,
2031,861,1,2032,866,
1,2786,2395,16,0,
249,1,277,2396,16,
0,249,1,2035,877,
1,2037,882,1,2792,
2397,16,0,537,1,
32,2398,16,0,249,
1,2464,1024,1,2293,
2399,16,0,249,1,
2043,899,1,2045,904,
1,2299,2400,16,0,
537,1,41,2401,16,
0,249,1,42,2402,
16,0,537,1,40,
1304,1,44,1310,1,
43,2403,16,0,249,
1,1804,2404,16,0,
249,1,48,1317,1,
49,1323,1,47,1311,
1,51,1333,1,52,
2405,16,0,249,1,
50,1328,1,305,1338,
1,1096,1439,1,1515,
2406,16,0,249,1,
2318,2407,16,0,249,
1,283,1299,1,63,
1349,1,66,1355,1,
67,1360,1,68,1365,
1,69,1370,1,70,
1375,1,71,2408,16,
0,249,1,73,2409,
16,0,537,1,74,
1380,1,1013,1385,1,
76,2410,16,0,249,
1,1834,2411,16,0,
249,1,2337,2412,16,
0,249,1,79,2413,
16,0,249,1,1335,
2414,16,0,249,1,
299,2415,16,0,249,
1,82,2416,16,0,
537,1,1840,2417,16,
0,537,1,1297,2418,
16,0,249,1,85,
2419,16,0,249,1,
1341,2420,16,0,537,
1,89,2421,16,0,
249,1,1303,2422,16,
0,537,1,509,2423,
16,0,249,1,93,
1445,1,322,2424,16,
0,249,1,2039,887,
1,97,2425,16,0,
249,1,2041,893,1,
1555,2426,16,0,537,
1,827,2427,16,0,
537,1,102,2428,16,
0,249,1,1860,946,
1,1803,912,1,2364,
952,1,107,2429,16,
0,537,1,1114,1469,
1,112,2430,16,0,
249,1,1117,2431,16,
0,249,1,352,1475,
1,1873,961,1,118,
2432,16,0,537,1,
1123,2433,16,0,537,
1,371,1491,1,515,
2434,16,0,537,1,
1377,2435,16,0,537,
1,124,2436,16,0,
249,1,1882,2437,16,
0,537,1,377,1507,
1,379,1512,1,380,
1517,1,130,2438,16,
0,537,1,346,2439,
16,0,249,1,2075,
2440,16,0,249,1,
373,1535,1,387,2441,
16,0,537,1,137,
2442,16,0,249,1,
143,2443,16,0,537,
1,1901,2444,16,0,
249,1,1048,2445,16,
0,537,1,1153,2446,
16,0,249,1,375,
1502,1,151,2447,16,
0,249,1,1407,2448,
16,0,249,1,1659,
2449,16,0,249,1,
2413,2450,16,0,249,
1,1159,2451,16,0,
537,1,381,2452,16,
0,249,1,157,2453,
16,0,537,1,1413,
2454,16,0,537,1,
883,2455,16,0,537,
1,1371,2456,16,0,
249,1,328,1429,1,
2105,939,1,2106,2457,
16,0,249,1,166,
2458,16,0,249,1,
525,2459,16,0,249,
1,1622,2460,16,0,
249,1,406,2461,16,
0,249,1,1574,924,
1,172,2462,16,0,
537,1,1931,986,1,
412,2463,16,0,537,
1,1933,2464,16,0,
249,1,1876,2465,16,
0,249,1,431,2466,
16,0,249,1,1585,
2467,16,0,249,1,
182,2468,16,0,249,
1,1628,2469,16,0,
537,1,1189,2470,16,
0,249,1,437,2471,
16,0,537,1,1591,
2472,16,0,537,1,
188,2473,16,0,537,
1,1695,2474,16,0,
249,1,2198,2475,16,
0,249,1,1195,2476,
16,0,537,1,1449,
2477,16,0,537,1,
1701,2478,16,0,537,
1,447,2479,16,0,
249,1,199,2480,16,
0,249,1,2459,1007,
1,1958,2481,16,0,
249,1,2462,1014,1,
1657,1019,1,205,2482,
16,0,537,1,459,
2483,16,0,249,1,
462,2484,16,0,249,
1,1665,2485,16,0,
537,1,217,2486,16,
0,249,1,2227,1033,
1,2033,871,1,1225,
2487,16,0,249,1,
223,2488,16,0,537,
1,1479,2489,16,0,
249,1,1731,2490,16,
0,249,1,477,1675,
1,1231,2491,16,0,
537,1,479,1685,1,
480,1690,1,1485,2492,
16,0,537,1,1737,
2493,16,0,537,1,
1989,1041,1,1990,2494,
16,0,249,1,1443,
2495,16,0,249,1,
236,2496,16,0,249,
1,2136,968,1,476,
1669,1,242,2497,16,
0,537,1,478,1708,
1,1939,2498,16,0,
537,1,1001,1713,1,
1002,1718,1,1756,2499,
16,0,249,1,20,
2500,19,510,1,20,
2501,5,84,1,1011,
1227,1,1012,2502,16,
0,508,1,1013,1385,
1,262,1244,1,1267,
2503,16,0,508,1,
515,2504,16,0,508,
1,1521,2505,16,0,
508,1,525,1343,1,
2792,2506,16,0,508,
1,283,1299,1,2299,
2507,16,0,508,1,
42,2508,16,0,508,
1,40,1304,1,44,
1310,1,47,1311,1,
1303,2509,16,0,508,
1,1555,2510,16,0,
508,1,50,1328,1,
48,1317,1,49,1323,
1,51,1333,1,63,
1349,1,305,1338,1,
66,1355,1,67,1360,
1,68,1365,1,69,
1370,1,70,1375,1,
73,2511,16,0,508,
1,74,1380,1,328,
2512,16,0,508,1,
1048,2513,16,0,508,
1,82,2514,16,0,
508,1,1840,2515,16,
0,508,1,1591,2516,
16,0,508,1,1341,
2517,16,0,508,1,
1096,1439,1,93,1445,
1,352,2518,16,0,
508,1,107,2519,16,
0,508,1,1114,1469,
1,118,2520,16,0,
508,1,1123,2521,16,
0,508,1,371,1491,
1,1628,2522,16,0,
508,1,375,1502,1,
1882,2523,16,0,508,
1,377,1507,1,379,
1512,1,380,1517,1,
883,2524,16,0,508,
1,373,1535,1,130,
2525,16,0,508,1,
143,2526,16,0,508,
1,387,2527,16,0,
508,1,1159,2528,16,
0,508,1,157,2529,
16,0,508,1,1413,
2530,16,0,508,1,
1665,2531,16,0,508,
1,412,2532,16,0,
508,1,1377,2533,16,
0,508,1,172,2534,
16,0,508,1,1939,
2535,16,0,508,1,
437,2536,16,0,508,
1,188,2537,16,0,
508,1,942,2538,16,
0,508,1,1195,2539,
16,0,508,1,1449,
2540,16,0,508,1,
1701,2541,16,0,508,
1,447,1637,1,205,
2542,16,0,508,1,
827,2543,16,0,508,
1,223,2544,16,0,
508,1,476,1669,1,
477,1675,1,1231,2545,
16,0,508,1,479,
1685,1,480,1690,1,
1485,2546,16,0,508,
1,1737,2547,16,0,
508,1,242,2548,16,
0,508,1,478,1708,
1,1001,1713,1,1002,
1718,1,21,2549,19,
478,1,21,2550,5,
84,1,1011,1227,1,
1012,2551,16,0,476,
1,1013,1385,1,262,
1244,1,1267,2552,16,
0,476,1,515,2553,
16,0,476,1,1521,
2554,16,0,476,1,
525,1343,1,2792,2555,
16,0,476,1,283,
1299,1,2299,2556,16,
0,476,1,42,2557,
16,0,476,1,40,
1304,1,44,1310,1,
47,1311,1,1303,2558,
16,0,476,1,1555,
2559,16,0,476,1,
50,1328,1,48,1317,
1,49,1323,1,51,
1333,1,63,1349,1,
305,1338,1,66,1355,
1,67,1360,1,68,
1365,1,69,1370,1,
70,1375,1,73,2560,
16,0,476,1,74,
1380,1,328,2561,16,
0,476,1,1048,2562,
16,0,476,1,82,
2563,16,0,476,1,
1840,2564,16,0,476,
1,1591,2565,16,0,
476,1,1341,2566,16,
0,476,1,1096,1439,
1,93,1445,1,352,
2567,16,0,476,1,
107,2568,16,0,476,
1,1114,1469,1,118,
2569,16,0,476,1,
1123,2570,16,0,476,
1,371,1491,1,1628,
2571,16,0,476,1,
375,1502,1,1882,2572,
16,0,476,1,377,
1507,1,379,1512,1,
380,1517,1,883,2573,
16,0,476,1,373,
1535,1,130,2574,16,
0,476,1,143,2575,
16,0,476,1,387,
2576,16,0,476,1,
1159,2577,16,0,476,
1,157,2578,16,0,
476,1,1413,2579,16,
0,476,1,1665,2580,
16,0,476,1,412,
2581,16,0,476,1,
1377,2582,16,0,476,
1,172,2583,16,0,
476,1,1939,2584,16,
0,476,1,437,2585,
16,0,476,1,188,
2586,16,0,476,1,
942,2587,16,0,476,
1,1195,2588,16,0,
476,1,1449,2589,16,
0,476,1,1701,2590,
16,0,476,1,447,
1637,1,205,2591,16,
0,476,1,827,2592,
16,0,476,1,223,
2593,16,0,476,1,
476,1669,1,477,1675,
1,1231,2594,16,0,
476,1,479,1685,1,
480,1690,1,1485,2595,
16,0,476,1,1737,
2596,16,0,476,1,
242,2597,16,0,476,
1,478,1708,1,1001,
1713,1,1002,1718,1,
22,2598,19,429,1,
22,2599,5,84,1,
1011,1227,1,1012,2600,
16,0,427,1,1013,
1385,1,262,1244,1,
1267,2601,16,0,427,
1,515,2602,16,0,
427,1,1521,2603,16,
0,427,1,525,1343,
1,2792,2604,16,0,
427,1,283,1299,1,
2299,2605,16,0,427,
1,42,2606,16,0,
427,1,40,1304,1,
44,1310,1,47,1311,
1,1303,2607,16,0,
427,1,1555,2608,16,
0,427,1,50,1328,
1,48,1317,1,49,
1323,1,51,1333,1,
63,1349,1,305,1338,
1,66,1355,1,67,
1360,1,68,1365,1,
69,1370,1,70,1375,
1,73,2609,16,0,
427,1,74,1380,1,
328,2610,16,0,427,
1,1048,2611,16,0,
427,1,82,2612,16,
0,427,1,1840,2613,
16,0,427,1,1591,
2614,16,0,427,1,
1341,2615,16,0,427,
1,1096,1439,1,93,
1445,1,352,2616,16,
0,427,1,107,2617,
16,0,427,1,1114,
1469,1,118,2618,16,
0,427,1,1123,2619,
16,0,427,1,371,
1491,1,1628,2620,16,
0,427,1,375,1502,
1,1882,2621,16,0,
427,1,377,1507,1,
379,1512,1,380,1517,
1,883,2622,16,0,
427,1,373,1535,1,
130,2623,16,0,427,
1,143,2624,16,0,
427,1,387,2625,16,
0,427,1,1159,2626,
16,0,427,1,157,
2627,16,0,427,1,
1413,2628,16,0,427,
1,1665,2629,16,0,
427,1,412,2630,16,
0,427,1,1377,2631,
16,0,427,1,172,
2632,16,0,427,1,
1939,2633,16,0,427,
1,437,2634,16,0,
427,1,188,2635,16,
0,427,1,942,2636,
16,0,427,1,1195,
2637,16,0,427,1,
1449,2638,16,0,427,
1,1701,2639,16,0,
427,1,447,1637,1,
205,2640,16,0,427,
1,827,2641,16,0,
427,1,223,2642,16,
0,427,1,476,1669,
1,477,1675,1,1231,
2643,16,0,427,1,
479,1685,1,480,1690,
1,1485,2644,16,0,
427,1,1737,2645,16,
0,427,1,242,2646,
16,0,427,1,478,
1708,1,1001,1713,1,
1002,1718,1,23,2647,
19,590,1,23,2648,
5,38,1,1901,2649,
16,0,588,1,2075,
2650,16,0,588,1,
1860,946,1,1803,912,
1,1804,2651,16,0,
588,1,2413,2652,16,
0,588,1,2198,2653,
16,0,588,1,1873,
961,1,1657,1019,1,
1989,1041,1,1990,2654,
16,0,588,1,1775,
2655,16,0,588,1,
32,2656,16,0,588,
1,2105,939,1,2106,
2657,16,0,588,1,
2364,952,1,2227,1033,
1,2337,2658,16,0,
588,1,2021,843,1,
2458,1001,1,2459,1007,
1,2462,1014,1,2136,
968,1,2464,1024,1,
2029,850,1,2030,856,
1,2031,861,1,2032,
866,1,2033,871,1,
2035,877,1,2037,882,
1,2039,887,1,1931,
986,1,2041,893,1,
2043,899,1,2045,904,
1,1574,924,1,1958,
2659,16,0,588,1,
24,2660,19,193,1,
24,2661,5,5,1,
44,2662,16,0,191,
1,377,2663,16,0,
626,1,40,2664,16,
0,799,1,63,2665,
16,0,219,1,373,
2666,16,0,622,1,
25,2667,19,329,1,
25,2668,5,177,1,
942,1616,1,256,2669,
16,0,631,1,1261,
2670,16,0,631,1,
1011,1227,1,1012,2671,
16,0,327,1,2458,
1001,1,262,1244,1,
1267,2672,16,0,327,
1,2021,843,1,1521,
2673,16,0,327,1,
1775,2674,16,0,631,
1,2029,850,1,2030,
856,1,2031,861,1,
2032,866,1,2786,2675,
16,0,631,1,277,
2676,16,0,631,1,
2035,877,1,2037,882,
1,2792,2677,16,0,
327,1,32,2678,16,
0,631,1,2464,1024,
1,2293,2679,16,0,
631,1,2043,899,1,
2045,904,1,2299,2680,
16,0,327,1,41,
2681,16,0,631,1,
42,2682,16,0,327,
1,40,1304,1,44,
1310,1,43,2683,16,
0,631,1,1804,2684,
16,0,631,1,48,
1317,1,49,1323,1,
47,1311,1,51,1333,
1,52,2685,16,0,
631,1,50,1328,1,
305,1338,1,1096,1439,
1,1515,2686,16,0,
631,1,2318,2687,16,
0,631,1,62,2688,
16,0,631,1,63,
1349,1,66,1355,1,
67,1360,1,68,1365,
1,69,1370,1,70,
1375,1,71,2689,16,
0,631,1,283,1299,
1,73,2690,16,0,
327,1,74,1380,1,
1013,1385,1,76,2691,
16,0,631,1,1834,
2692,16,0,631,1,
2337,2693,16,0,631,
1,79,2694,16,0,
631,1,1335,2695,16,
0,631,1,299,2696,
16,0,631,1,82,
2697,16,0,327,1,
1840,2698,16,0,327,
1,1297,2699,16,0,
631,1,85,2700,16,
0,631,1,1341,2701,
16,0,327,1,89,
2702,16,0,631,1,
1303,2703,16,0,327,
1,509,2704,16,0,
631,1,93,1445,1,
322,2705,16,0,631,
1,2039,887,1,97,
2706,16,0,631,1,
2041,893,1,1555,2707,
16,0,327,1,827,
2708,16,0,327,1,
102,2709,16,0,631,
1,1860,946,1,1803,
912,1,2364,952,1,
107,2710,16,0,327,
1,1114,1469,1,112,
2711,16,0,631,1,
1117,2712,16,0,631,
1,352,1475,1,1873,
961,1,118,1481,1,
1123,2713,16,0,327,
1,371,1491,1,515,
2714,16,0,327,1,
1377,2715,16,0,327,
1,124,2716,16,0,
631,1,1882,2717,16,
0,327,1,377,1507,
1,379,1512,1,380,
1517,1,130,1540,1,
346,2718,16,0,631,
1,2075,2719,16,0,
631,1,373,1535,1,
387,2720,16,0,327,
1,137,2721,16,0,
631,1,143,2722,16,
0,327,1,1901,2723,
16,0,631,1,1048,
1470,1,1153,2724,16,
0,631,1,375,1502,
1,151,2725,16,0,
631,1,1407,2726,16,
0,631,1,1659,2727,
16,0,631,1,2413,
2728,16,0,631,1,
1159,2729,16,0,327,
1,381,2730,16,0,
631,1,157,2731,16,
0,327,1,1413,2732,
16,0,327,1,883,
2733,16,0,327,1,
1371,2734,16,0,631,
1,328,1429,1,2105,
939,1,2106,2735,16,
0,631,1,166,2736,
16,0,631,1,525,
2737,16,0,631,1,
1622,2738,16,0,631,
1,406,2739,16,0,
631,1,1574,924,1,
172,1595,1,1931,986,
1,412,2740,16,0,
327,1,1933,2741,16,
0,631,1,1876,2742,
16,0,631,1,431,
2743,16,0,631,1,
1585,2744,16,0,631,
1,182,2745,16,0,
631,1,1628,2746,16,
0,327,1,1189,2747,
16,0,631,1,437,
2748,16,0,327,1,
1591,2749,16,0,327,
1,188,1644,1,1695,
2750,16,0,631,1,
2198,2751,16,0,631,
1,1195,2752,16,0,
327,1,1449,2753,16,
0,327,1,1701,2754,
16,0,327,1,447,
2755,16,0,631,1,
199,2756,16,0,631,
1,2459,1007,1,1958,
2757,16,0,631,1,
2462,1014,1,1657,1019,
1,205,2758,16,0,
327,1,459,2759,16,
0,631,1,462,2760,
16,0,631,1,1665,
2761,16,0,327,1,
217,2762,16,0,631,
1,2227,1033,1,2033,
871,1,1225,2763,16,
0,631,1,223,2764,
16,0,327,1,1479,
2765,16,0,631,1,
1731,2766,16,0,631,
1,477,1675,1,1231,
2767,16,0,327,1,
479,1685,1,480,1690,
1,1485,2768,16,0,
327,1,1737,2769,16,
0,327,1,1989,1041,
1,1990,2770,16,0,
631,1,1443,2771,16,
0,631,1,236,2772,
16,0,631,1,2136,
968,1,476,1669,1,
242,2773,16,0,327,
1,478,1708,1,1939,
2774,16,0,327,1,
1001,1713,1,1002,1718,
1,1756,2775,16,0,
631,1,26,2776,19,
348,1,26,2777,5,
84,1,1011,1227,1,
1012,2778,16,0,346,
1,1013,1385,1,262,
1244,1,1267,2779,16,
0,346,1,515,2780,
16,0,780,1,1521,
2781,16,0,346,1,
525,1343,1,2792,2782,
16,0,346,1,283,
1299,1,2299,2783,16,
0,346,1,42,2784,
16,0,346,1,40,
1304,1,44,1310,1,
47,1311,1,1303,2785,
16,0,346,1,1555,
2786,16,0,346,1,
50,1328,1,48,1317,
1,49,1323,1,51,
1333,1,63,1349,1,
305,1338,1,66,1355,
1,67,1360,1,68,
1365,1,69,1370,1,
70,1375,1,73,2787,
16,0,346,1,74,
1380,1,328,1429,1,
1048,1470,1,82,2788,
16,0,346,1,1840,
2789,16,0,346,1,
1591,2790,16,0,346,
1,1341,2791,16,0,
346,1,1096,1439,1,
93,1445,1,352,1475,
1,107,2792,16,0,
346,1,1114,1469,1,
118,1481,1,1123,2793,
16,0,346,1,371,
1491,1,1628,2794,16,
0,346,1,375,1502,
1,1882,2795,16,0,
346,1,377,1507,1,
379,1512,1,380,1517,
1,883,2796,16,0,
346,1,373,1535,1,
130,1540,1,143,2797,
16,0,346,1,387,
2798,16,0,346,1,
1159,2799,16,0,346,
1,157,2800,16,0,
346,1,1413,2801,16,
0,346,1,1665,2802,
16,0,346,1,412,
2803,16,0,346,1,
1377,2804,16,0,346,
1,172,1595,1,1939,
2805,16,0,346,1,
437,2806,16,0,709,
1,188,1644,1,942,
1616,1,1195,2807,16,
0,346,1,1449,2808,
16,0,346,1,1701,
2809,16,0,346,1,
447,1637,1,205,2810,
16,0,346,1,827,
2811,16,0,346,1,
223,2812,16,0,346,
1,476,1669,1,477,
1675,1,1231,2813,16,
0,346,1,479,1685,
1,480,1690,1,1485,
2814,16,0,346,1,
1737,2815,16,0,346,
1,242,2816,16,0,
346,1,478,1708,1,
1001,1713,1,1002,1718,
1,27,2817,19,721,
1,27,2818,5,95,
1,256,2819,16,0,
719,1,1261,2820,16,
0,719,1,509,2821,
16,0,719,1,1515,
2822,16,0,719,1,
2021,843,1,1775,2823,
16,0,719,1,2029,
850,1,2030,856,1,
2031,861,1,2032,866,
1,2033,871,1,277,
2824,16,0,719,1,
2035,877,1,2037,882,
1,2039,887,1,32,
2825,16,0,719,1,
2041,893,1,2293,2826,
16,0,719,1,2043,
899,1,2045,904,1,
41,2827,16,0,719,
1,1297,2828,16,0,
719,1,43,2829,16,
0,719,1,1803,912,
1,1804,2830,16,0,
719,1,299,2831,16,
0,719,1,52,2832,
16,0,719,1,2318,
2833,16,0,719,1,
62,2834,16,0,719,
1,2075,2835,16,0,
719,1,1574,924,1,
71,2836,16,0,719,
1,76,2837,16,0,
719,1,1834,2838,16,
0,719,1,2337,2839,
16,0,719,1,79,
2840,16,0,719,1,
1335,2841,16,0,719,
1,322,2842,16,0,
719,1,85,2843,16,
0,719,1,89,2844,
16,0,719,1,346,
2845,16,0,719,1,
2105,939,1,2106,2846,
16,0,719,1,97,
2847,16,0,719,1,
1860,946,1,2364,952,
1,102,2848,16,0,
719,1,112,2849,16,
0,719,1,1117,2850,
16,0,719,1,2786,
2851,16,0,719,1,
1873,961,1,1876,2852,
16,0,719,1,124,
2853,16,0,719,1,
2136,968,1,381,2854,
16,0,719,1,525,
2855,16,0,719,1,
137,2856,16,0,719,
1,1901,2857,16,0,
719,1,1153,2858,16,
0,719,1,151,2859,
16,0,719,1,1407,
2860,16,0,719,1,
1659,2861,16,0,719,
1,2413,2862,16,0,
719,1,406,2863,16,
0,719,1,1371,2864,
16,0,719,1,166,
2865,16,0,719,1,
1622,2866,16,0,719,
1,1931,986,1,1933,
2867,16,0,719,1,
431,2868,16,0,719,
1,1585,2869,16,0,
719,1,182,2870,16,
0,719,1,1189,2871,
16,0,719,1,1443,
2872,16,0,719,1,
1695,2873,16,0,719,
1,2198,2874,16,0,
719,1,447,2875,16,
0,719,1,2458,1001,
1,2459,1007,1,1958,
2876,16,0,719,1,
2462,1014,1,1657,1019,
1,2464,1024,1,199,
2877,16,0,719,1,
459,2878,16,0,719,
1,462,2879,16,0,
719,1,217,2880,16,
0,719,1,2227,1033,
1,1225,2881,16,0,
719,1,1479,2882,16,
0,719,1,1731,2883,
16,0,719,1,1989,
1041,1,1990,2884,16,
0,719,1,236,2885,
16,0,719,1,1756,
2886,16,0,719,1,
28,2887,19,749,1,
28,2888,5,60,1,
328,1429,1,223,1659,
1,1096,1439,1,118,
1481,1,883,1523,1,
525,1343,1,1001,1713,
1,130,1540,1,459,
1953,1,1114,1469,1,
352,1475,1,447,1637,
1,464,1948,1,1011,
1227,1,1013,1385,1,
242,1703,1,143,1545,
1,40,1304,1,41,
1913,1,42,1917,1,
479,1685,1,44,1310,
1,481,1955,1,373,
1535,1,47,1311,1,
157,1568,1,49,1323,
1,50,1328,1,48,
1317,1,379,1512,1,
380,1517,1,51,1333,
1,476,1669,1,371,
1491,1,478,1708,1,
1048,1470,1,375,1502,
1,172,1595,1,262,
1244,1,283,1299,1,
63,1349,1,67,1360,
1,68,1365,1,69,
1370,1,66,1355,1,
461,2889,16,0,747,
1,74,1380,1,377,
1507,1,1002,1718,1,
70,1375,1,188,1644,
1,82,1407,1,305,
1338,1,477,1675,1,
827,1457,1,93,1445,
1,480,1690,1,205,
1649,1,942,1616,1,
107,1464,1,29,2890,
19,315,1,29,2891,
5,84,1,1011,1227,
1,1012,2892,16,0,
313,1,1013,1385,1,
262,1244,1,1267,2893,
16,0,313,1,515,
2894,16,0,313,1,
1521,2895,16,0,313,
1,525,1343,1,2792,
2896,16,0,313,1,
283,1299,1,2299,2897,
16,0,313,1,42,
2898,16,0,313,1,
40,1304,1,44,1310,
1,47,1311,1,1303,
2899,16,0,313,1,
1555,2900,16,0,313,
1,50,1328,1,48,
1317,1,49,1323,1,
51,1333,1,63,1349,
1,305,1338,1,66,
1355,1,67,1360,1,
68,1365,1,69,1370,
1,70,1375,1,73,
2901,16,0,313,1,
74,1380,1,328,1429,
1,1048,1470,1,82,
2902,16,0,313,1,
1840,2903,16,0,313,
1,1591,2904,16,0,
313,1,1341,2905,16,
0,313,1,1096,1439,
1,93,1445,1,352,
1475,1,107,2906,16,
0,313,1,1114,1469,
1,118,1481,1,1123,
2907,16,0,313,1,
371,1491,1,1628,2908,
16,0,313,1,375,
1502,1,1882,2909,16,
0,313,1,377,1507,
1,379,1512,1,380,
1517,1,883,2910,16,
0,313,1,373,1535,
1,130,1540,1,143,
1545,1,387,2911,16,
0,313,1,1159,2912,
16,0,313,1,157,
1568,1,1413,2913,16,
0,313,1,1665,2914,
16,0,313,1,412,
2915,16,0,313,1,
1377,2916,16,0,313,
1,172,1595,1,1939,
2917,16,0,313,1,
437,2918,16,0,313,
1,188,1644,1,942,
1616,1,1195,2919,16,
0,313,1,1449,2920,
16,0,313,1,1701,
2921,16,0,313,1,
447,1637,1,205,2922,
16,0,313,1,827,
2923,16,0,313,1,
223,2924,16,0,313,
1,476,1669,1,477,
1675,1,1231,2925,16,
0,313,1,479,1685,
1,480,1690,1,1485,
2926,16,0,313,1,
1737,2927,16,0,313,
1,242,2928,16,0,
313,1,478,1708,1,
1001,1713,1,1002,1718,
1,30,2929,19,297,
1,30,2930,5,84,
1,1011,1227,1,1012,
2931,16,0,295,1,
1013,1385,1,262,1244,
1,1267,2932,16,0,
295,1,515,2933,16,
0,295,1,1521,2934,
16,0,295,1,525,
1343,1,2792,2935,16,
0,295,1,283,1299,
1,2299,2936,16,0,
295,1,42,2937,16,
0,295,1,40,1304,
1,44,1310,1,47,
1311,1,1303,2938,16,
0,295,1,1555,2939,
16,0,295,1,50,
1328,1,48,1317,1,
49,1323,1,51,1333,
1,63,1349,1,305,
1338,1,66,1355,1,
67,1360,1,68,1365,
1,69,1370,1,70,
1375,1,73,2940,16,
0,295,1,74,1380,
1,328,1429,1,1048,
1470,1,82,2941,16,
0,295,1,1840,2942,
16,0,295,1,1591,
2943,16,0,295,1,
1341,2944,16,0,295,
1,1096,1439,1,93,
1445,1,352,1475,1,
107,2945,16,0,295,
1,1114,1469,1,118,
1481,1,1123,2946,16,
0,295,1,371,1491,
1,1628,2947,16,0,
295,1,375,1502,1,
1882,2948,16,0,295,
1,377,1507,1,379,
1512,1,380,1517,1,
883,2949,16,0,295,
1,373,1535,1,130,
1540,1,143,1545,1,
387,2950,16,0,295,
1,1159,2951,16,0,
295,1,157,1568,1,
1413,2952,16,0,295,
1,1665,2953,16,0,
295,1,412,2954,16,
0,295,1,1377,2955,
16,0,295,1,172,
1595,1,1939,2956,16,
0,295,1,437,2957,
16,0,295,1,188,
1644,1,942,1616,1,
1195,2958,16,0,295,
1,1449,2959,16,0,
295,1,1701,2960,16,
0,295,1,447,1637,
1,205,2961,16,0,
295,1,827,2962,16,
0,295,1,223,2963,
16,0,295,1,476,
1669,1,477,1675,1,
1231,2964,16,0,295,
1,479,1685,1,480,
1690,1,1485,2965,16,
0,295,1,1737,2966,
16,0,295,1,242,
2967,16,0,295,1,
478,1708,1,1001,1713,
1,1002,1718,1,31,
2968,19,277,1,31,
2969,5,84,1,1011,
1227,1,1012,2970,16,
0,275,1,1013,1385,
1,262,1244,1,1267,
2971,16,0,275,1,
515,2972,16,0,275,
1,1521,2973,16,0,
275,1,525,1343,1,
2792,2974,16,0,275,
1,283,1299,1,2299,
2975,16,0,275,1,
42,2976,16,0,275,
1,40,1304,1,44,
1310,1,47,1311,1,
1303,2977,16,0,275,
1,1555,2978,16,0,
275,1,50,1328,1,
48,1317,1,49,1323,
1,51,1333,1,63,
1349,1,305,1338,1,
66,1355,1,67,1360,
1,68,1365,1,69,
1370,1,70,1375,1,
73,2979,16,0,275,
1,74,1380,1,328,
1429,1,1048,1470,1,
82,2980,16,0,275,
1,1840,2981,16,0,
275,1,1591,2982,16,
0,275,1,1341,2983,
16,0,275,1,1096,
1439,1,93,1445,1,
352,1475,1,107,2984,
16,0,275,1,1114,
1469,1,118,1481,1,
1123,2985,16,0,275,
1,371,1491,1,1628,
2986,16,0,275,1,
375,1502,1,1882,2987,
16,0,275,1,377,
1507,1,379,1512,1,
380,1517,1,883,2988,
16,0,275,1,373,
1535,1,130,1540,1,
143,2989,16,0,275,
1,387,2990,16,0,
275,1,1159,2991,16,
0,275,1,157,2992,
16,0,275,1,1413,
2993,16,0,275,1,
1665,2994,16,0,275,
1,412,2995,16,0,
275,1,1377,2996,16,
0,275,1,172,1595,
1,1939,2997,16,0,
275,1,437,2998,16,
0,275,1,188,1644,
1,942,1616,1,1195,
2999,16,0,275,1,
1449,3000,16,0,275,
1,1701,3001,16,0,
275,1,447,1637,1,
205,3002,16,0,275,
1,827,3003,16,0,
275,1,223,3004,16,
0,275,1,476,1669,
1,477,1675,1,1231,
3005,16,0,275,1,
479,1685,1,480,1690,
1,1485,3006,16,0,
275,1,1737,3007,16,
0,275,1,242,3008,
16,0,275,1,478,
1708,1,1001,1713,1,
1002,1718,1,32,3009,
19,270,1,32,3010,
5,84,1,1011,1227,
1,1012,3011,16,0,
268,1,1013,1385,1,
262,1244,1,1267,3012,
16,0,268,1,515,
3013,16,0,268,1,
1521,3014,16,0,268,
1,525,1343,1,2792,
3015,16,0,268,1,
283,1299,1,2299,3016,
16,0,268,1,42,
3017,16,0,268,1,
40,1304,1,44,1310,
1,47,1311,1,1303,
3018,16,0,268,1,
1555,3019,16,0,268,
1,50,1328,1,48,
1317,1,49,1323,1,
51,1333,1,63,1349,
1,305,1338,1,66,
1355,1,67,1360,1,
68,1365,1,69,1370,
1,70,1375,1,73,
3020,16,0,268,1,
74,1380,1,328,1429,
1,1048,1470,1,82,
3021,16,0,268,1,
1840,3022,16,0,268,
1,1591,3023,16,0,
268,1,1341,3024,16,
0,268,1,1096,1439,
1,93,1445,1,352,
1475,1,107,3025,16,
0,268,1,1114,1469,
1,118,1481,1,1123,
3026,16,0,268,1,
371,1491,1,1628,3027,
16,0,268,1,375,
1502,1,1882,3028,16,
0,268,1,377,1507,
1,379,1512,1,380,
1517,1,883,3029,16,
0,268,1,373,1535,
1,130,1540,1,143,
3030,16,0,268,1,
387,3031,16,0,268,
1,1159,3032,16,0,
268,1,157,3033,16,
0,268,1,1413,3034,
16,0,268,1,1665,
3035,16,0,268,1,
412,3036,16,0,268,
1,1377,3037,16,0,
268,1,172,1595,1,
1939,3038,16,0,268,
1,437,3039,16,0,
268,1,188,1644,1,
942,1616,1,1195,3040,
16,0,268,1,1449,
3041,16,0,268,1,
1701,3042,16,0,268,
1,447,1637,1,205,
3043,16,0,268,1,
827,3044,16,0,268,
1,223,3045,16,0,
268,1,476,1669,1,
477,1675,1,1231,3046,
16,0,268,1,479,
1685,1,480,1690,1,
1485,3047,16,0,268,
1,1737,3048,16,0,
268,1,242,3049,16,
0,268,1,478,1708,
1,1001,1713,1,1002,
1718,1,33,3050,19,
378,1,33,3051,5,
84,1,1011,1227,1,
1012,3052,16,0,376,
1,1013,1385,1,262,
1244,1,1267,3053,16,
0,376,1,515,3054,
16,0,376,1,1521,
3055,16,0,376,1,
525,1343,1,2792,3056,
16,0,376,1,283,
1299,1,2299,3057,16,
0,376,1,42,3058,
16,0,376,1,40,
1304,1,44,1310,1,
47,1311,1,1303,3059,
16,0,376,1,1555,
3060,16,0,376,1,
50,1328,1,48,1317,
1,49,1323,1,51,
1333,1,63,1349,1,
305,1338,1,66,1355,
1,67,1360,1,68,
1365,1,69,1370,1,
70,1375,1,73,3061,
16,0,376,1,74,
1380,1,328,1429,1,
1048,1470,1,82,3062,
16,0,376,1,1840,
3063,16,0,376,1,
1591,3064,16,0,376,
1,1341,3065,16,0,
376,1,1096,1439,1,
93,1445,1,352,1475,
1,107,3066,16,0,
376,1,1114,1469,1,
118,1481,1,1123,3067,
16,0,376,1,371,
1491,1,1628,3068,16,
0,376,1,375,1502,
1,1882,3069,16,0,
376,1,377,1507,1,
379,1512,1,380,1517,
1,883,3070,16,0,
376,1,373,1535,1,
130,1540,1,143,1545,
1,387,3071,16,0,
376,1,1159,3072,16,
0,376,1,157,1568,
1,1413,3073,16,0,
376,1,1665,3074,16,
0,376,1,412,3075,
16,0,376,1,1377,
3076,16,0,376,1,
172,1595,1,1939,3077,
16,0,376,1,437,
3078,16,0,376,1,
188,1644,1,942,1616,
1,1195,3079,16,0,
376,1,1449,3080,16,
0,376,1,1701,3081,
16,0,376,1,447,
1637,1,205,3082,16,
0,376,1,827,3083,
16,0,376,1,223,
3084,16,0,376,1,
476,1669,1,477,1675,
1,1231,3085,16,0,
376,1,479,1685,1,
480,1690,1,1485,3086,
16,0,376,1,1737,
3087,16,0,376,1,
242,1703,1,478,1708,
1,1001,1713,1,1002,
1718,1,34,3088,19,
365,1,34,3089,5,
84,1,1011,1227,1,
1012,3090,16,0,363,
1,1013,1385,1,262,
1244,1,1267,3091,16,
0,363,1,515,3092,
16,0,363,1,1521,
3093,16,0,363,1,
525,1343,1,2792,3094,
16,0,363,1,283,
1299,1,2299,3095,16,
0,363,1,42,3096,
16,0,363,1,40,
1304,1,44,1310,1,
47,1311,1,1303,3097,
16,0,363,1,1555,
3098,16,0,363,1,
50,1328,1,48,1317,
1,49,1323,1,51,
1333,1,63,1349,1,
305,1338,1,66,1355,
1,67,1360,1,68,
1365,1,69,1370,1,
70,1375,1,73,3099,
16,0,363,1,74,
1380,1,328,1429,1,
1048,1470,1,82,3100,
16,0,363,1,1840,
3101,16,0,363,1,
1591,3102,16,0,363,
1,1341,3103,16,0,
363,1,1096,1439,1,
93,1445,1,352,1475,
1,107,3104,16,0,
363,1,1114,1469,1,
118,1481,1,1123,3105,
16,0,363,1,371,
1491,1,1628,3106,16,
0,363,1,375,1502,
1,1882,3107,16,0,
363,1,377,1507,1,
379,1512,1,380,1517,
1,883,3108,16,0,
363,1,373,1535,1,
130,1540,1,143,1545,
1,387,3109,16,0,
363,1,1159,3110,16,
0,363,1,157,1568,
1,1413,3111,16,0,
363,1,1665,3112,16,
0,363,1,412,3113,
16,0,363,1,1377,
3114,16,0,363,1,
172,1595,1,1939,3115,
16,0,363,1,437,
3116,16,0,363,1,
188,1644,1,942,1616,
1,1195,3117,16,0,
363,1,1449,3118,16,
0,363,1,1701,3119,
16,0,363,1,447,
1637,1,205,1649,1,
827,3120,16,0,363,
1,223,1659,1,476,
1669,1,477,1675,1,
1231,3121,16,0,363,
1,479,1685,1,480,
1690,1,1485,3122,16,
0,363,1,1737,3123,
16,0,363,1,242,
1703,1,478,1708,1,
1001,1713,1,1002,1718,
1,35,3124,19,351,
1,35,3125,5,84,
1,1011,1227,1,1012,
3126,16,0,349,1,
1013,1385,1,262,1244,
1,1267,3127,16,0,
349,1,515,3128,16,
0,349,1,1521,3129,
16,0,349,1,525,
1343,1,2792,3130,16,
0,349,1,283,1299,
1,2299,3131,16,0,
349,1,42,3132,16,
0,349,1,40,1304,
1,44,1310,1,47,
1311,1,1303,3133,16,
0,349,1,1555,3134,
16,0,349,1,50,
1328,1,48,1317,1,
49,1323,1,51,1333,
1,63,1349,1,305,
1338,1,66,1355,1,
67,1360,1,68,1365,
1,69,1370,1,70,
1375,1,73,3135,16,
0,349,1,74,1380,
1,328,1429,1,1048,
1470,1,82,3136,16,
0,349,1,1840,3137,
16,0,349,1,1591,
3138,16,0,349,1,
1341,3139,16,0,349,
1,1096,1439,1,93,
1445,1,352,1475,1,
107,3140,16,0,349,
1,1114,1469,1,118,
1481,1,1123,3141,16,
0,349,1,371,1491,
1,1628,3142,16,0,
349,1,375,1502,1,
1882,3143,16,0,349,
1,377,1507,1,379,
1512,1,380,1517,1,
883,3144,16,0,349,
1,373,1535,1,130,
1540,1,143,1545,1,
387,3145,16,0,349,
1,1159,3146,16,0,
349,1,157,1568,1,
1413,3147,16,0,349,
1,1665,3148,16,0,
349,1,412,3149,16,
0,349,1,1377,3150,
16,0,349,1,172,
1595,1,1939,3151,16,
0,349,1,437,3152,
16,0,349,1,188,
1644,1,942,1616,1,
1195,3153,16,0,349,
1,1449,3154,16,0,
349,1,1701,3155,16,
0,349,1,447,1637,
1,205,1649,1,827,
3156,16,0,349,1,
223,3157,16,0,349,
1,476,1669,1,477,
1675,1,1231,3158,16,
0,349,1,479,1685,
1,480,1690,1,1485,
3159,16,0,349,1,
1737,3160,16,0,349,
1,242,1703,1,478,
1708,1,1001,1713,1,
1002,1718,1,36,3161,
19,239,1,36,3162,
5,94,1,256,3163,
16,0,237,1,1261,
3164,16,0,237,1,
509,3165,16,0,237,
1,1515,3166,16,0,
237,1,2021,843,1,
1775,3167,16,0,237,
1,2029,850,1,2030,
856,1,2031,861,1,
2032,866,1,2033,871,
1,277,3168,16,0,
237,1,2035,877,1,
2037,882,1,2039,887,
1,32,3169,16,0,
237,1,2041,893,1,
2293,3170,16,0,237,
1,2043,899,1,2045,
904,1,41,3171,16,
0,237,1,1297,3172,
16,0,237,1,43,
3173,16,0,237,1,
1803,912,1,1804,3174,
16,0,237,1,299,
3175,16,0,237,1,
52,3176,16,0,237,
1,2318,3177,16,0,
237,1,2075,3178,16,
0,237,1,1574,924,
1,71,3179,16,0,
237,1,76,3180,16,
0,237,1,1834,3181,
16,0,237,1,2337,
3182,16,0,237,1,
79,3183,16,0,237,
1,1335,3184,16,0,
237,1,322,3185,16,
0,237,1,85,3186,
16,0,237,1,89,
3187,16,0,237,1,
346,3188,16,0,237,
1,2105,939,1,2106,
3189,16,0,237,1,
97,3190,16,0,237,
1,1860,946,1,2364,
952,1,102,3191,16,
0,237,1,112,3192,
16,0,237,1,1117,
3193,16,0,237,1,
2786,3194,16,0,237,
1,1873,961,1,1876,
3195,16,0,237,1,
124,3196,16,0,237,
1,2136,968,1,381,
3197,16,0,237,1,
525,3198,16,0,237,
1,137,3199,16,0,
237,1,1901,3200,16,
0,237,1,1153,3201,
16,0,237,1,151,
3202,16,0,237,1,
1407,3203,16,0,237,
1,1659,3204,16,0,
237,1,2413,3205,16,
0,237,1,406,3206,
16,0,237,1,1371,
3207,16,0,237,1,
166,3208,16,0,237,
1,1622,3209,16,0,
237,1,1931,986,1,
1933,3210,16,0,237,
1,431,3211,16,0,
237,1,1585,3212,16,
0,237,1,182,3213,
16,0,237,1,1189,
3214,16,0,237,1,
1443,3215,16,0,237,
1,1695,3216,16,0,
237,1,2198,3217,16,
0,237,1,447,3218,
16,0,237,1,2458,
1001,1,2459,1007,1,
1958,3219,16,0,237,
1,2462,1014,1,1657,
1019,1,2464,1024,1,
199,3220,16,0,237,
1,459,3221,16,0,
237,1,462,3222,16,
0,237,1,217,3223,
16,0,237,1,2227,
1033,1,1225,3224,16,
0,237,1,1479,3225,
16,0,237,1,1731,
3226,16,0,237,1,
1989,1041,1,1990,3227,
16,0,237,1,236,
3228,16,0,237,1,
1756,3229,16,0,237,
1,37,3230,19,260,
1,37,3231,5,94,
1,256,3232,16,0,
258,1,1261,3233,16,
0,258,1,509,3234,
16,0,258,1,1515,
3235,16,0,258,1,
2021,843,1,1775,3236,
16,0,258,1,2029,
850,1,2030,856,1,
2031,861,1,2032,866,
1,2033,871,1,277,
3237,16,0,258,1,
2035,877,1,2037,882,
1,2039,887,1,32,
3238,16,0,258,1,
2041,893,1,2293,3239,
16,0,258,1,2043,
899,1,2045,904,1,
41,3240,16,0,258,
1,1297,3241,16,0,
258,1,43,3242,16,
0,258,1,1803,912,
1,1804,3243,16,0,
258,1,299,3244,16,
0,258,1,52,3245,
16,0,258,1,2318,
3246,16,0,258,1,
2075,3247,16,0,258,
1,1574,924,1,71,
3248,16,0,258,1,
76,3249,16,0,258,
1,1834,3250,16,0,
258,1,2337,3251,16,
0,258,1,79,3252,
16,0,258,1,1335,
3253,16,0,258,1,
322,3254,16,0,258,
1,85,3255,16,0,
258,1,89,3256,16,
0,258,1,346,3257,
16,0,258,1,2105,
939,1,2106,3258,16,
0,258,1,97,3259,
16,0,258,1,1860,
946,1,2364,952,1,
102,3260,16,0,258,
1,112,3261,16,0,
258,1,1117,3262,16,
0,258,1,2786,3263,
16,0,258,1,1873,
961,1,1876,3264,16,
0,258,1,124,3265,
16,0,258,1,2136,
968,1,381,3266,16,
0,258,1,525,3267,
16,0,258,1,137,
3268,16,0,258,1,
1901,3269,16,0,258,
1,1153,3270,16,0,
258,1,151,3271,16,
0,258,1,1407,3272,
16,0,258,1,1659,
3273,16,0,258,1,
2413,3274,16,0,258,
1,406,3275,16,0,
258,1,1371,3276,16,
0,258,1,166,3277,
16,0,258,1,1622,
3278,16,0,258,1,
1931,986,1,1933,3279,
16,0,258,1,431,
3280,16,0,258,1,
1585,3281,16,0,258,
1,182,3282,16,0,
258,1,1189,3283,16,
0,258,1,1443,3284,
16,0,258,1,1695,
3285,16,0,258,1,
2198,3286,16,0,258,
1,447,3287,16,0,
258,1,2458,1001,1,
2459,1007,1,1958,3288,
16,0,258,1,2462,
1014,1,1657,1019,1,
2464,1024,1,199,3289,
16,0,258,1,459,
3290,16,0,258,1,
462,3291,16,0,258,
1,217,3292,16,0,
258,1,2227,1033,1,
1225,3293,16,0,258,
1,1479,3294,16,0,
258,1,1731,3295,16,
0,258,1,1989,1041,
1,1990,3296,16,0,
258,1,236,3297,16,
0,258,1,1756,3298,
16,0,258,1,38,
3299,19,257,1,38,
3300,5,84,1,1011,
1227,1,1012,3301,16,
0,255,1,1013,1385,
1,262,1244,1,1267,
3302,16,0,255,1,
515,3303,16,0,255,
1,1521,3304,16,0,
255,1,525,1343,1,
2792,3305,16,0,255,
1,283,1299,1,2299,
3306,16,0,255,1,
42,3307,16,0,255,
1,40,1304,1,44,
1310,1,47,1311,1,
1303,3308,16,0,255,
1,1555,3309,16,0,
255,1,50,1328,1,
48,1317,1,49,1323,
1,51,1333,1,63,
1349,1,305,1338,1,
66,1355,1,67,1360,
1,68,1365,1,69,
1370,1,70,1375,1,
73,3310,16,0,255,
1,74,1380,1,328,
1429,1,1048,1470,1,
82,3311,16,0,255,
1,1840,3312,16,0,
255,1,1591,3313,16,
0,255,1,1341,3314,
16,0,255,1,1096,
1439,1,93,1445,1,
352,1475,1,107,3315,
16,0,255,1,1114,
1469,1,118,1481,1,
1123,3316,16,0,255,
1,371,1491,1,1628,
3317,16,0,255,1,
375,1502,1,1882,3318,
16,0,255,1,377,
1507,1,379,1512,1,
380,1517,1,883,1523,
1,373,1535,1,130,
1540,1,143,1545,1,
387,3319,16,0,255,
1,1159,3320,16,0,
255,1,157,1568,1,
1413,3321,16,0,255,
1,1665,3322,16,0,
255,1,412,3323,16,
0,255,1,1377,3324,
16,0,255,1,172,
1595,1,1939,3325,16,
0,255,1,437,3326,
16,0,255,1,188,
1644,1,942,1616,1,
1195,3327,16,0,255,
1,1449,3328,16,0,
255,1,1701,3329,16,
0,255,1,447,1637,
1,205,1649,1,827,
1457,1,223,1659,1,
476,1669,1,477,1675,
1,1231,3330,16,0,
255,1,479,1685,1,
480,1690,1,1485,3331,
16,0,255,1,1737,
3332,16,0,255,1,
242,1703,1,478,1708,
1,1001,1713,1,1002,
1718,1,39,3333,19,
245,1,39,3334,5,
84,1,1011,1227,1,
1012,3335,16,0,243,
1,1013,1385,1,262,
1244,1,1267,3336,16,
0,243,1,515,3337,
16,0,243,1,1521,
3338,16,0,243,1,
525,1343,1,2792,3339,
16,0,243,1,283,
1299,1,2299,3340,16,
0,243,1,42,3341,
16,0,243,1,40,
1304,1,44,1310,1,
47,1311,1,1303,3342,
16,0,243,1,1555,
3343,16,0,243,1,
50,1328,1,48,1317,
1,49,1323,1,51,
1333,1,63,1349,1,
305,1338,1,66,1355,
1,67,1360,1,68,
1365,1,69,1370,1,
70,1375,1,73,3344,
16,0,243,1,74,
1380,1,328,1429,1,
1048,1470,1,82,3345,
16,0,243,1,1840,
3346,16,0,243,1,
1591,3347,16,0,243,
1,1341,3348,16,0,
243,1,1096,1439,1,
93,1445,1,352,1475,
1,107,3349,16,0,
243,1,1114,1469,1,
118,1481,1,1123,3350,
16,0,243,1,371,
1491,1,1628,3351,16,
0,243,1,375,1502,
1,1882,3352,16,0,
243,1,377,1507,1,
379,1512,1,380,1517,
1,883,1523,1,373,
1535,1,130,1540,1,
143,1545,1,387,3353,
16,0,243,1,1159,
3354,16,0,243,1,
157,1568,1,1413,3355,
16,0,243,1,1665,
3356,16,0,243,1,
412,3357,16,0,243,
1,1377,3358,16,0,
243,1,172,1595,1,
1939,3359,16,0,243,
1,437,3360,16,0,
243,1,188,1644,1,
942,1616,1,1195,3361,
16,0,243,1,1449,
3362,16,0,243,1,
1701,3363,16,0,243,
1,447,1637,1,205,
1649,1,827,1457,1,
223,1659,1,476,1669,
1,477,1675,1,1231,
3364,16,0,243,1,
479,1685,1,480,1690,
1,1485,3365,16,0,
243,1,1737,3366,16,
0,243,1,242,1703,
1,478,1708,1,1001,
1713,1,1002,1718,1,
40,3367,19,233,1,
40,3368,5,84,1,
1011,1227,1,1012,3369,
16,0,231,1,1013,
1385,1,262,1244,1,
1267,3370,16,0,231,
1,515,3371,16,0,
231,1,1521,3372,16,
0,231,1,525,1343,
1,2792,3373,16,0,
231,1,283,1299,1,
2299,3374,16,0,231,
1,42,3375,16,0,
231,1,40,1304,1,
44,1310,1,47,1311,
1,1303,3376,16,0,
231,1,1555,3377,16,
0,231,1,50,1328,
1,48,1317,1,49,
1323,1,51,1333,1,
63,1349,1,305,1338,
1,66,1355,1,67,
1360,1,68,1365,1,
69,1370,1,70,1375,
1,73,3378,16,0,
231,1,74,1380,1,
328,1429,1,1048,1470,
1,82,3379,16,0,
231,1,1840,3380,16,
0,231,1,1591,3381,
16,0,231,1,1341,
3382,16,0,231,1,
1096,1439,1,93,1445,
1,352,1475,1,107,
3383,16,0,231,1,
1114,1469,1,118,3384,
16,0,231,1,1123,
3385,16,0,231,1,
371,1491,1,1628,3386,
16,0,231,1,375,
1502,1,1882,3387,16,
0,231,1,377,1507,
1,379,1512,1,380,
1517,1,883,3388,16,
0,231,1,373,1535,
1,130,3389,16,0,
231,1,143,3390,16,
0,231,1,387,3391,
16,0,231,1,1159,
3392,16,0,231,1,
157,3393,16,0,231,
1,1413,3394,16,0,
231,1,1665,3395,16,
0,231,1,412,3396,
16,0,231,1,1377,
3397,16,0,231,1,
172,3398,16,0,231,
1,1939,3399,16,0,
231,1,437,3400,16,
0,231,1,188,3401,
16,0,231,1,942,
1616,1,1195,3402,16,
0,231,1,1449,3403,
16,0,231,1,1701,
3404,16,0,231,1,
447,1637,1,205,3405,
16,0,231,1,827,
3406,16,0,231,1,
223,3407,16,0,231,
1,476,1669,1,477,
1675,1,1231,3408,16,
0,231,1,479,1685,
1,480,1690,1,1485,
3409,16,0,231,1,
1737,3410,16,0,231,
1,242,3411,16,0,
231,1,478,1708,1,
1001,1713,1,1002,1718,
1,41,3412,19,188,
1,41,3413,5,84,
1,1011,1227,1,1012,
3414,16,0,186,1,
1013,1385,1,262,1244,
1,1267,3415,16,0,
186,1,515,3416,16,
0,186,1,1521,3417,
16,0,186,1,525,
1343,1,2792,3418,16,
0,186,1,283,1299,
1,2299,3419,16,0,
186,1,42,3420,16,
0,186,1,40,1304,
1,44,1310,1,47,
1311,1,1303,3421,16,
0,186,1,1555,3422,
16,0,186,1,50,
1328,1,48,1317,1,
49,1323,1,51,1333,
1,63,1349,1,305,
1338,1,66,1355,1,
67,1360,1,68,1365,
1,69,1370,1,70,
1375,1,73,3423,16,
0,186,1,74,1380,
1,328,1429,1,1048,
1470,1,82,3424,16,
0,186,1,1840,3425,
16,0,186,1,1591,
3426,16,0,186,1,
1341,3427,16,0,186,
1,1096,1439,1,93,
1445,1,352,1475,1,
107,3428,16,0,186,
1,1114,1469,1,118,
3429,16,0,186,1,
1123,3430,16,0,186,
1,371,1491,1,1628,
3431,16,0,186,1,
375,1502,1,1882,3432,
16,0,186,1,377,
1507,1,379,1512,1,
380,1517,1,883,3433,
16,0,186,1,373,
1535,1,130,3434,16,
0,186,1,143,3435,
16,0,186,1,387,
3436,16,0,186,1,
1159,3437,16,0,186,
1,157,3438,16,0,
186,1,1413,3439,16,
0,186,1,1665,3440,
16,0,186,1,412,
3441,16,0,186,1,
1377,3442,16,0,186,
1,172,3443,16,0,
186,1,1939,3444,16,
0,186,1,437,3445,
16,0,186,1,188,
3446,16,0,186,1,
942,1616,1,1195,3447,
16,0,186,1,1449,
3448,16,0,186,1,
1701,3449,16,0,186,
1,447,1637,1,205,
3450,16,0,186,1,
827,3451,16,0,186,
1,223,3452,16,0,
186,1,476,1669,1,
477,1675,1,1231,3453,
16,0,186,1,479,
1685,1,480,1690,1,
1485,3454,16,0,186,
1,1737,3455,16,0,
186,1,242,3456,16,
0,186,1,478,1708,
1,1001,1713,1,1002,
1718,1,42,3457,19,
440,1,42,3458,5,
38,1,1901,3459,16,
0,438,1,2075,3460,
16,0,438,1,1860,
946,1,1803,912,1,
1804,3461,16,0,438,
1,2413,3462,16,0,
438,1,2198,3463,16,
0,438,1,1873,961,
1,1657,1019,1,1989,
1041,1,1990,3464,16,
0,438,1,1775,3465,
16,0,438,1,32,
3466,16,0,438,1,
2105,939,1,2106,3467,
16,0,438,1,2364,
952,1,2227,1033,1,
2337,3468,16,0,438,
1,2021,843,1,2458,
1001,1,2459,1007,1,
2462,1014,1,2136,968,
1,2464,1024,1,2029,
850,1,2030,856,1,
2031,861,1,2032,866,
1,2033,871,1,2035,
877,1,2037,882,1,
2039,887,1,1931,986,
1,2041,893,1,2043,
899,1,2045,904,1,
1574,924,1,1958,3469,
16,0,438,1,43,
3470,19,532,1,43,
3471,5,25,1,2035,
877,1,2037,882,1,
2039,887,1,2041,893,
1,2227,1033,1,2043,
899,1,1657,1019,1,
1860,946,1,2136,968,
1,2021,843,1,2459,
1007,1,1574,924,1,
2105,3472,16,0,698,
1,1931,986,1,1873,
961,1,2031,861,1,
1803,912,1,1989,3473,
16,0,530,1,2464,
1024,1,2029,850,1,
2030,856,1,2364,952,
1,2032,866,1,2033,
871,1,2045,904,1,
44,3474,19,292,1,
44,3475,5,38,1,
1901,3476,16,0,290,
1,2075,3477,16,0,
290,1,1860,946,1,
1803,912,1,1804,3478,
16,0,290,1,2413,
3479,16,0,290,1,
2198,3480,16,0,290,
1,1873,961,1,1657,
1019,1,1989,1041,1,
1990,3481,16,0,290,
1,1775,3482,16,0,
290,1,32,3483,16,
0,290,1,2105,939,
1,2106,3484,16,0,
290,1,2364,952,1,
2227,1033,1,2337,3485,
16,0,290,1,2021,
843,1,2458,1001,1,
2459,1007,1,2462,1014,
1,2136,968,1,2464,
1024,1,2029,850,1,
2030,856,1,2031,861,
1,2032,866,1,2033,
871,1,2035,877,1,
2037,882,1,2039,887,
1,1931,986,1,2041,
893,1,2043,899,1,
2045,904,1,1574,924,
1,1958,3486,16,0,
290,1,45,3487,19,
325,1,45,3488,5,
39,1,1901,3489,16,
0,355,1,2075,3490,
16,0,355,1,1860,
946,1,1803,912,1,
1804,3491,16,0,355,
1,2413,3492,16,0,
355,1,2198,3493,16,
0,355,1,1873,961,
1,1657,1019,1,1989,
1041,1,1990,3494,16,
0,355,1,1775,3495,
16,0,355,1,32,
3496,16,0,355,1,
2105,939,1,2106,3497,
16,0,355,1,2364,
952,1,2227,1033,1,
2337,3498,16,0,355,
1,2021,843,1,2458,
1001,1,2459,1007,1,
2462,1014,1,2136,968,
1,2464,1024,1,2029,
850,1,2030,856,1,
2031,861,1,2032,866,
1,2033,871,1,2035,
877,1,2037,882,1,
2039,887,1,1931,986,
1,2041,893,1,2043,
899,1,2045,904,1,
1832,3499,16,0,323,
1,1574,924,1,1958,
3500,16,0,355,1,
46,3501,19,794,1,
46,3502,5,38,1,
1901,3503,16,0,792,
1,2075,3504,16,0,
792,1,1860,946,1,
1803,912,1,1804,3505,
16,0,792,1,2413,
3506,16,0,792,1,
2198,3507,16,0,792,
1,1873,961,1,1657,
1019,1,1989,1041,1,
1990,3508,16,0,792,
1,1775,3509,16,0,
792,1,32,3510,16,
0,792,1,2105,939,
1,2106,3511,16,0,
792,1,2364,952,1,
2227,1033,1,2337,3512,
16,0,792,1,2021,
843,1,2458,1001,1,
2459,1007,1,2462,1014,
1,2136,968,1,2464,
1024,1,2029,850,1,
2030,856,1,2031,861,
1,2032,866,1,2033,
871,1,2035,877,1,
2037,882,1,2039,887,
1,1931,986,1,2041,
893,1,2043,899,1,
2045,904,1,1574,924,
1,1958,3513,16,0,
792,1,47,3514,19,
283,1,47,3515,5,
19,1,0,3516,16,
0,281,1,2783,3517,
17,3518,15,3519,4,
50,37,0,71,0,
108,0,111,0,98,
0,97,0,108,0,
70,0,117,0,110,
0,99,0,116,0,
105,0,111,0,110,
0,68,0,101,0,
102,0,105,0,110,
0,105,0,116,0,
105,0,111,0,110,
0,1,-1,1,5,
3520,20,3521,4,52,
71,0,108,0,111,
0,98,0,97,0,
108,0,70,0,117,
0,110,0,99,0,
116,0,105,0,111,
0,110,0,68,0,
101,0,102,0,105,
0,110,0,105,0,
116,0,105,0,111,
0,110,0,95,0,
49,0,1,175,1,
3,1,6,1,5,
3522,22,1,9,1,
2464,1024,1,2767,822,
1,2768,810,1,2822,
3523,17,3524,15,3525,
4,52,37,0,71,
0,108,0,111,0,
98,0,97,0,108,
0,86,0,97,0,
114,0,105,0,97,
0,98,0,108,0,
101,0,68,0,101,
0,99,0,108,0,
97,0,114,0,97,
0,116,0,105,0,
111,0,110,0,1,
-1,1,5,3526,20,
3527,4,54,71,0,
108,0,111,0,98,
0,97,0,108,0,
86,0,97,0,114,
0,105,0,97,0,
98,0,108,0,101,
0,68,0,101,0,
99,0,108,0,97,
0,114,0,97,0,
116,0,105,0,111,
0,110,0,95,0,
49,0,1,173,1,
3,1,3,1,2,
3528,22,1,7,1,
2823,3529,16,0,281,
1,2022,3530,16,0,
673,1,2755,816,1,
2834,3531,16,0,281,
1,2459,1007,1,2466,
3532,17,3533,15,3519,
1,-1,1,5,3534,
20,3535,4,52,71,
0,108,0,111,0,
98,0,97,0,108,
0,70,0,117,0,
110,0,99,0,116,
0,105,0,111,0,
110,0,68,0,101,
0,102,0,105,0,
110,0,105,0,116,
0,105,0,111,0,
110,0,95,0,50,
0,1,176,1,3,
1,7,1,6,3536,
22,1,10,1,2764,
3537,16,0,281,1,
2841,3538,17,3539,15,
3540,4,36,37,0,
71,0,108,0,111,
0,98,0,97,0,
108,0,68,0,101,
0,102,0,105,0,
110,0,105,0,116,
0,105,0,111,0,
110,0,115,0,1,
-1,1,5,3541,20,
3542,4,38,71,0,
108,0,111,0,98,
0,97,0,108,0,
68,0,101,0,102,
0,105,0,110,0,
105,0,116,0,105,
0,111,0,110,0,
115,0,95,0,52,
0,1,172,1,3,
1,3,1,2,3543,
22,1,6,1,2842,
3544,17,3545,15,3540,
1,-1,1,5,3546,
20,3547,4,38,71,
0,108,0,111,0,
98,0,97,0,108,
0,68,0,101,0,
102,0,105,0,110,
0,105,0,116,0,
105,0,111,0,110,
0,115,0,95,0,
50,0,1,170,1,
3,1,3,1,2,
3548,22,1,4,1,
2843,3549,17,3550,15,
3540,1,-1,1,5,
3551,20,3552,4,38,
71,0,108,0,111,
0,98,0,97,0,
108,0,68,0,101,
0,102,0,105,0,
110,0,105,0,116,
0,105,0,111,0,
110,0,115,0,95,
0,51,0,1,171,
1,3,1,2,1,
1,3553,22,1,5,
1,2844,3554,17,3555,
15,3540,1,-1,1,
5,3556,20,3557,4,
38,71,0,108,0,
111,0,98,0,97,
0,108,0,68,0,
101,0,102,0,105,
0,110,0,105,0,
116,0,105,0,111,
0,110,0,115,0,
95,0,49,0,1,
169,1,3,1,2,
1,1,3558,22,1,
3,1,2649,832,1,
2811,3559,17,3560,15,
3525,1,-1,1,5,
3561,20,3562,4,54,
71,0,108,0,111,
0,98,0,97,0,
108,0,86,0,97,
0,114,0,105,0,
97,0,98,0,108,
0,101,0,68,0,
101,0,99,0,108,
0,97,0,114,0,
97,0,116,0,105,
0,111,0,110,0,
95,0,50,0,1,
174,1,3,1,5,
1,4,3563,22,1,
8,1,48,3564,19,
385,1,48,3565,5,
54,1,0,3566,16,
0,383,1,2075,3567,
16,0,581,1,1860,
946,1,2842,3544,1,
1804,3568,16,0,581,
1,2844,3554,1,2413,
3569,16,0,581,1,
2198,3570,16,0,581,
1,1873,961,1,1657,
1019,1,2030,856,1,
1989,1041,1,1990,3571,
16,0,581,1,2755,
816,1,1775,3572,16,
0,581,1,32,3573,
16,0,581,1,2649,
832,1,2105,939,1,
2106,3574,16,0,581,
1,2764,3575,16,0,
383,1,2841,3538,1,
1574,924,1,2767,822,
1,2768,810,1,2227,
1033,1,2337,3576,16,
0,581,1,2783,3517,
1,1803,912,1,2458,
1001,1,1901,3577,16,
0,581,1,2462,1014,
1,2136,968,1,2464,
1024,1,2029,850,1,
2466,3532,1,2031,861,
1,2032,866,1,2033,
871,1,2035,877,1,
2364,952,1,2039,887,
1,1931,986,1,2041,
893,1,2021,843,1,
2043,899,1,2045,904,
1,2811,3559,1,2834,
3578,16,0,383,1,
2037,882,1,2822,3523,
1,2823,3579,16,0,
383,1,2843,3549,1,
1958,3580,16,0,581,
1,2459,1007,1,49,
3581,19,586,1,49,
3582,5,38,1,1901,
3583,16,0,584,1,
2075,3584,16,0,584,
1,1860,946,1,1803,
912,1,1804,3585,16,
0,584,1,2413,3586,
16,0,584,1,2198,
3587,16,0,584,1,
1873,961,1,1657,1019,
1,1989,1041,1,1990,
3588,16,0,584,1,
1775,3589,16,0,584,
1,32,3590,16,0,
584,1,2105,939,1,
2106,3591,16,0,584,
1,2364,952,1,2227,
1033,1,2337,3592,16,
0,584,1,2021,843,
1,2458,1001,1,2459,
1007,1,2462,1014,1,
2136,968,1,2464,1024,
1,2029,850,1,2030,
856,1,2031,861,1,
2032,866,1,2033,871,
1,2035,877,1,2037,
882,1,2039,887,1,
1931,986,1,2041,893,
1,2043,899,1,2045,
904,1,1574,924,1,
1958,3593,16,0,584,
1,50,3594,19,733,
1,50,3595,5,38,
1,1901,3596,16,0,
731,1,2075,3597,16,
0,731,1,1860,946,
1,1803,912,1,1804,
3598,16,0,731,1,
2413,3599,16,0,731,
1,2198,3600,16,0,
731,1,1873,961,1,
1657,1019,1,1989,1041,
1,1990,3601,16,0,
731,1,1775,3602,16,
0,731,1,32,3603,
16,0,731,1,2105,
939,1,2106,3604,16,
0,731,1,2364,952,
1,2227,1033,1,2337,
3605,16,0,731,1,
2021,843,1,2458,1001,
1,2459,1007,1,2462,
1014,1,2136,968,1,
2464,1024,1,2029,850,
1,2030,856,1,2031,
861,1,2032,866,1,
2033,871,1,2035,877,
1,2037,882,1,2039,
887,1,1931,986,1,
2041,893,1,2043,899,
1,2045,904,1,1574,
924,1,1958,3606,16,
0,731,1,51,3607,
19,127,1,51,3608,
5,58,1,0,3609,
16,0,125,1,2538,
3610,16,0,489,1,
2075,3611,16,0,125,
1,2841,3538,1,2515,
3612,16,0,489,1,
2843,3549,1,10,3613,
16,0,125,1,2413,
3614,16,0,125,1,
2523,3615,16,0,489,
1,2198,3616,16,0,
125,1,1873,961,1,
21,3617,16,0,125,
1,1657,1019,1,2029,
850,1,2030,856,1,
1989,1041,1,1990,3618,
16,0,125,1,2458,
1001,1,2459,1007,1,
1775,3619,16,0,125,
1,32,3620,16,0,
125,1,2105,939,1,
2106,3621,16,0,125,
1,2823,3622,16,0,
125,1,2770,3623,16,
0,125,1,2227,1033,
1,2337,3624,16,0,
125,1,52,3625,16,
0,125,1,2561,3626,
16,0,489,1,2783,
3517,1,1803,912,1,
1804,3627,16,0,125,
1,1901,3628,16,0,
125,1,2462,1014,1,
2136,968,1,2464,1024,
1,1860,946,1,2466,
3532,1,2031,861,1,
2032,866,1,2033,871,
1,2035,877,1,2364,
952,1,2039,887,1,
1931,986,1,2041,893,
1,2021,843,1,2043,
899,1,2045,904,1,
2511,3629,16,0,489,
1,2811,3559,1,2037,
882,1,2822,3523,1,
2842,3544,1,1574,924,
1,2844,3554,1,2582,
3630,16,0,125,1,
1958,3631,16,0,125,
1,52,3632,19,124,
1,52,3633,5,53,
1,0,3634,16,0,
122,1,2075,3635,16,
0,122,1,2841,3538,
1,2842,3544,1,1804,
3636,16,0,122,1,
10,3637,16,0,122,
1,2413,3638,16,0,
122,1,2198,3639,16,
0,122,1,1873,961,
1,21,3640,16,0,
122,1,1657,1019,1,
2029,850,1,2030,856,
1,1989,1041,1,1990,
3641,16,0,122,1,
2459,1007,1,1775,3642,
16,0,122,1,32,
3643,16,0,122,1,
2105,939,1,2106,3644,
16,0,122,1,1574,
924,1,2770,3645,16,
0,122,1,2227,1033,
1,2337,3646,16,0,
122,1,52,3647,16,
0,122,1,2783,3517,
1,1803,912,1,2458,
1001,1,1901,3648,16,
0,122,1,2462,1014,
1,2136,968,1,2464,
1024,1,1860,946,1,
2466,3532,1,2031,861,
1,2032,866,1,2033,
871,1,2035,877,1,
2364,952,1,2039,887,
1,1931,986,1,2041,
893,1,2021,843,1,
2043,899,1,2045,904,
1,2811,3559,1,2037,
882,1,2822,3523,1,
2823,3649,16,0,122,
1,2843,3549,1,2844,
3554,1,2582,3650,16,
0,122,1,1958,3651,
16,0,122,1,53,
3652,19,121,1,53,
3653,5,53,1,0,
3654,16,0,119,1,
2075,3655,16,0,119,
1,2841,3538,1,2842,
3544,1,1804,3656,16,
0,119,1,10,3657,
16,0,119,1,2413,
3658,16,0,119,1,
2198,3659,16,0,119,
1,1873,961,1,21,
3660,16,0,119,1,
1657,1019,1,2029,850,
1,2030,856,1,1989,
1041,1,1990,3661,16,
0,119,1,2459,1007,
1,1775,3662,16,0,
119,1,32,3663,16,
0,119,1,2105,939,
1,2106,3664,16,0,
119,1,1574,924,1,
2770,3665,16,0,119,
1,2227,1033,1,2337,
3666,16,0,119,1,
52,3667,16,0,119,
1,2783,3517,1,1803,
912,1,2458,1001,1,
1901,3668,16,0,119,
1,2462,1014,1,2136,
968,1,2464,1024,1,
1860,946,1,2466,3532,
1,2031,861,1,2032,
866,1,2033,871,1,
2035,877,1,2364,952,
1,2039,887,1,1931,
986,1,2041,893,1,
2021,843,1,2043,899,
1,2045,904,1,2811,
3559,1,2037,882,1,
2822,3523,1,2823,3669,
16,0,119,1,2843,
3549,1,2844,3554,1,
2582,3670,16,0,119,
1,1958,3671,16,0,
119,1,54,3672,19,
118,1,54,3673,5,
55,1,0,3674,16,
0,116,1,2075,3675,
16,0,116,1,2841,
3538,1,2842,3544,1,
1804,3676,16,0,116,
1,10,3677,16,0,
116,1,2413,3678,16,
0,116,1,2198,3679,
16,0,116,1,1873,
961,1,21,3680,16,
0,116,1,1657,1019,
1,2029,850,1,2030,
856,1,1989,1041,1,
1990,3681,16,0,116,
1,2459,1007,1,1775,
3682,16,0,116,1,
32,3683,16,0,116,
1,2105,939,1,2106,
3684,16,0,116,1,
2021,843,1,1574,924,
1,2770,3685,16,0,
116,1,2227,1033,1,
2337,3686,16,0,116,
1,52,3687,16,0,
116,1,2783,3517,1,
1803,912,1,2458,1001,
1,1901,3688,16,0,
116,1,2569,3689,16,
0,483,1,2462,1014,
1,2136,968,1,2464,
1024,1,1860,946,1,
2466,3532,1,2031,861,
1,2032,866,1,2033,
871,1,2035,877,1,
2364,952,1,2039,887,
1,1931,986,1,2041,
893,1,2507,3690,16,
0,483,1,2043,899,
1,2045,904,1,2811,
3559,1,2037,882,1,
2822,3523,1,2823,3691,
16,0,116,1,2843,
3549,1,2844,3554,1,
2582,3692,16,0,116,
1,1958,3693,16,0,
116,1,55,3694,19,
115,1,55,3695,5,
56,1,0,3696,16,
0,113,1,2075,3697,
16,0,113,1,2841,
3538,1,2842,3544,1,
2843,3549,1,10,3698,
16,0,113,1,2413,
3699,16,0,113,1,
2198,3700,16,0,113,
1,2526,3701,16,0,
304,1,1873,961,1,
21,3702,16,0,113,
1,1657,1019,1,2530,
3703,16,0,304,1,
2030,856,1,1989,1041,
1,1990,3704,16,0,
113,1,2458,1001,1,
2459,1007,1,1775,3705,
16,0,113,1,32,
3706,16,0,113,1,
2105,939,1,2106,3707,
16,0,113,1,2770,
3708,16,0,113,1,
2553,3709,16,0,304,
1,2227,1033,1,2337,
3710,16,0,113,1,
52,3711,16,0,113,
1,2783,3517,1,1803,
912,1,1804,3712,16,
0,113,1,1901,3713,
16,0,113,1,2462,
1014,1,2136,968,1,
2464,1024,1,1860,946,
1,2466,3532,1,2031,
861,1,2032,866,1,
2033,871,1,2035,877,
1,2364,952,1,2039,
887,1,1931,986,1,
2041,893,1,2021,843,
1,2043,899,1,2045,
904,1,2811,3559,1,
2029,850,1,2037,882,
1,2822,3523,1,2823,
3714,16,0,113,1,
1574,924,1,2844,3554,
1,2582,3715,16,0,
113,1,1958,3716,16,
0,113,1,56,3717,
19,112,1,56,3718,
5,55,1,0,3719,
16,0,110,1,2075,
3720,16,0,110,1,
2841,3538,1,2842,3544,
1,1804,3721,16,0,
110,1,10,3722,16,
0,110,1,2413,3723,
16,0,110,1,2198,
3724,16,0,110,1,
1873,961,1,21,3725,
16,0,110,1,1657,
1019,1,2029,850,1,
2030,856,1,1989,1041,
1,1990,3726,16,0,
110,1,2459,1007,1,
1775,3727,16,0,110,
1,32,3728,16,0,
110,1,2541,3729,16,
0,525,1,2106,3730,
16,0,110,1,2545,
3731,16,0,525,1,
1574,924,1,2770,3732,
16,0,110,1,2227,
1033,1,2337,3733,16,
0,110,1,52,3734,
16,0,110,1,2783,
3517,1,1803,912,1,
2458,1001,1,1901,3735,
16,0,110,1,2462,
1014,1,2136,968,1,
2464,1024,1,1860,946,
1,2466,3532,1,2031,
861,1,2032,866,1,
2033,871,1,2035,877,
1,2364,952,1,2039,
887,1,1931,986,1,
2041,893,1,2021,843,
1,2043,899,1,2045,
904,1,2811,3559,1,
2037,882,1,2822,3523,
1,2823,3736,16,0,
110,1,2843,3549,1,
2844,3554,1,2105,939,
1,2582,3737,16,0,
110,1,1958,3738,16,
0,110,1,57,3739,
19,109,1,57,3740,
5,53,1,0,3741,
16,0,107,1,2075,
3742,16,0,107,1,
2841,3538,1,2842,3544,
1,1804,3743,16,0,
107,1,10,3744,16,
0,107,1,2413,3745,
16,0,107,1,2198,
3746,16,0,107,1,
1873,961,1,21,3747,
16,0,107,1,1657,
1019,1,2029,850,1,
2030,856,1,1989,1041,
1,1990,3748,16,0,
107,1,2459,1007,1,
1775,3749,16,0,107,
1,32,3750,16,0,
107,1,2105,939,1,
2106,3751,16,0,107,
1,1574,924,1,2770,
3752,16,0,107,1,
2227,1033,1,2337,3753,
16,0,107,1,52,
3754,16,0,107,1,
2783,3517,1,1803,912,
1,2458,1001,1,1901,
3755,16,0,107,1,
2462,1014,1,2136,968,
1,2464,1024,1,1860,
946,1,2466,3532,1,
2031,861,1,2032,866,
1,2033,871,1,2035,
877,1,2364,952,1,
2039,887,1,1931,986,
1,2041,893,1,2021,
843,1,2043,899,1,
2045,904,1,2811,3559,
1,2037,882,1,2822,
3523,1,2823,3756,16,
0,107,1,2843,3549,
1,2844,3554,1,2582,
3757,16,0,107,1,
1958,3758,16,0,107,
1,58,3759,19,396,
1,58,3760,5,30,
1,2536,1750,1,2521,
1767,1,2641,1779,1,
2642,1784,1,2643,1756,
1,2644,1789,1,2645,
1794,1,2646,1799,1,
2647,1762,1,2648,1878,
1,2650,1811,1,2651,
1816,1,2652,1821,1,
2653,1826,1,2654,1831,
1,2655,1836,1,2656,
1841,1,2657,1774,1,
2659,3761,16,0,394,
1,2551,1852,1,2559,
1864,1,2567,1805,1,
2459,1007,1,2464,1024,
1,2575,1846,1,2470,
3762,16,0,394,1,
2580,1858,1,2703,3763,
16,0,394,1,2595,
1871,1,2597,3764,16,
0,394,1,59,3765,
19,393,1,59,3766,
5,30,1,2536,1750,
1,2521,1767,1,2641,
1779,1,2642,1784,1,
2643,1756,1,2644,1789,
1,2645,1794,1,2646,
1799,1,2647,1762,1,
2648,1878,1,2650,1811,
1,2651,1816,1,2652,
1821,1,2653,1826,1,
2654,1831,1,2655,1836,
1,2656,1841,1,2657,
1774,1,2659,3767,16,
0,391,1,2551,1852,
1,2559,1864,1,2567,
1805,1,2459,1007,1,
2464,1024,1,2575,1846,
1,2470,3768,16,0,
391,1,2580,1858,1,
2703,3769,16,0,391,
1,2595,1871,1,2597,
3770,16,0,391,1,
60,3771,19,557,1,
60,3772,5,30,1,
2536,1750,1,2521,1767,
1,2641,1779,1,2642,
1784,1,2643,1756,1,
2644,1789,1,2645,1794,
1,2646,1799,1,2647,
1762,1,2648,1878,1,
2650,1811,1,2651,1816,
1,2652,1821,1,2653,
1826,1,2654,1831,1,
2655,1836,1,2656,1841,
1,2657,1774,1,2659,
3773,16,0,555,1,
2551,1852,1,2559,1864,
1,2567,1805,1,2459,
1007,1,2464,1024,1,
2575,1846,1,2470,3774,
16,0,555,1,2580,
1858,1,2703,3775,16,
0,555,1,2595,1871,
1,2597,3776,16,0,
555,1,61,3777,19,
433,1,61,3778,5,
30,1,2536,1750,1,
2521,1767,1,2641,1779,
1,2642,1784,1,2643,
1756,1,2644,1789,1,
2645,1794,1,2646,1799,
1,2647,1762,1,2648,
1878,1,2650,1811,1,
2651,1816,1,2652,1821,
1,2653,1826,1,2654,
1831,1,2655,1836,1,
2656,1841,1,2657,1774,
1,2659,3779,16,0,
431,1,2551,1852,1,
2559,1864,1,2567,1805,
1,2459,1007,1,2464,
1024,1,2575,1846,1,
2470,3780,16,0,431,
1,2580,1858,1,2703,
3781,16,0,431,1,
2595,1871,1,2597,3782,
16,0,431,1,62,
3783,19,553,1,62,
3784,5,30,1,2536,
1750,1,2521,1767,1,
2641,1779,1,2642,1784,
1,2643,1756,1,2644,
1789,1,2645,1794,1,
2646,1799,1,2647,1762,
1,2648,1878,1,2650,
1811,1,2651,1816,1,
2652,1821,1,2653,1826,
1,2654,1831,1,2655,
1836,1,2656,1841,1,
2657,1774,1,2659,3785,
16,0,551,1,2551,
1852,1,2559,1864,1,
2567,1805,1,2459,1007,
1,2464,1024,1,2575,
1846,1,2470,3786,16,
0,551,1,2580,1858,
1,2703,3787,16,0,
551,1,2595,1871,1,
2597,3788,16,0,551,
1,63,3789,19,666,
1,63,3790,5,30,
1,2536,1750,1,2521,
1767,1,2641,1779,1,
2642,1784,1,2643,1756,
1,2644,1789,1,2645,
1794,1,2646,1799,1,
2647,1762,1,2648,1878,
1,2650,1811,1,2651,
1816,1,2652,1821,1,
2653,1826,1,2654,1831,
1,2655,1836,1,2656,
1841,1,2657,1774,1,
2659,3791,16,0,664,
1,2551,1852,1,2559,
1864,1,2567,1805,1,
2459,1007,1,2464,1024,
1,2575,1846,1,2470,
3792,16,0,664,1,
2580,1858,1,2703,3793,
16,0,664,1,2595,
1871,1,2597,3794,16,
0,664,1,64,3795,
19,426,1,64,3796,
5,30,1,2536,1750,
1,2521,1767,1,2641,
1779,1,2642,1784,1,
2643,1756,1,2644,1789,
1,2645,1794,1,2646,
1799,1,2647,1762,1,
2648,1878,1,2650,1811,
1,2651,1816,1,2652,
1821,1,2653,1826,1,
2654,1831,1,2655,1836,
1,2656,1841,1,2657,
1774,1,2659,3797,16,
0,424,1,2551,1852,
1,2559,1864,1,2567,
1805,1,2459,1007,1,
2464,1024,1,2575,1846,
1,2470,3798,16,0,
424,1,2580,1858,1,
2703,3799,16,0,424,
1,2595,1871,1,2597,
3800,16,0,424,1,
65,3801,19,390,1,
65,3802,5,30,1,
2536,1750,1,2521,1767,
1,2641,1779,1,2642,
1784,1,2643,1756,1,
2644,1789,1,2645,1794,
1,2646,1799,1,2647,
1762,1,2648,1878,1,
2650,1811,1,2651,1816,
1,2652,1821,1,2653,
1826,1,2654,1831,1,
2655,1836,1,2656,1841,
1,2657,1774,1,2659,
3803,16,0,388,1,
2551,1852,1,2559,1864,
1,2567,1805,1,2459,
1007,1,2464,1024,1,
2575,1846,1,2470,3804,
16,0,388,1,2580,
1858,1,2703,3805,16,
0,388,1,2595,1871,
1,2597,3806,16,0,
388,1,66,3807,19,
778,1,66,3808,5,
30,1,2536,1750,1,
2521,1767,1,2641,1779,
1,2642,1784,1,2643,
1756,1,2644,1789,1,
2645,1794,1,2646,1799,
1,2647,1762,1,2648,
1878,1,2650,1811,1,
2651,1816,1,2652,1821,
1,2653,1826,1,2654,
1831,1,2655,1836,1,
2656,1841,1,2657,1774,
1,2659,3809,16,0,
776,1,2551,1852,1,
2559,1864,1,2567,1805,
1,2459,1007,1,2464,
1024,1,2575,1846,1,
2470,3810,16,0,776,
1,2580,1858,1,2703,
3811,16,0,776,1,
2595,1871,1,2597,3812,
16,0,776,1,67,
3813,19,475,1,67,
3814,5,30,1,2536,
1750,1,2521,1767,1,
2641,1779,1,2642,1784,
1,2643,1756,1,2644,
1789,1,2645,1794,1,
2646,1799,1,2647,1762,
1,2648,1878,1,2650,
1811,1,2651,1816,1,
2652,1821,1,2653,1826,
1,2654,1831,1,2655,
1836,1,2656,1841,1,
2657,1774,1,2659,3815,
16,0,473,1,2551,
1852,1,2559,1864,1,
2567,1805,1,2459,1007,
1,2464,1024,1,2575,
1846,1,2470,3816,16,
0,473,1,2580,1858,
1,2703,3817,16,0,
473,1,2595,1871,1,
2597,3818,16,0,473,
1,68,3819,19,472,
1,68,3820,5,30,
1,2536,1750,1,2521,
1767,1,2641,1779,1,
2642,1784,1,2643,1756,
1,2644,1789,1,2645,
1794,1,2646,1799,1,
2647,1762,1,2648,1878,
1,2650,1811,1,2651,
1816,1,2652,1821,1,
2653,1826,1,2654,1831,
1,2655,1836,1,2656,
1841,1,2657,1774,1,
2659,3821,16,0,470,
1,2551,1852,1,2559,
1864,1,2567,1805,1,
2459,1007,1,2464,1024,
1,2575,1846,1,2470,
3822,16,0,470,1,
2580,1858,1,2703,3823,
16,0,470,1,2595,
1871,1,2597,3824,16,
0,470,1,69,3825,
19,405,1,69,3826,
5,30,1,2536,1750,
1,2521,1767,1,2641,
1779,1,2642,1784,1,
2643,1756,1,2644,1789,
1,2645,1794,1,2646,
1799,1,2647,1762,1,
2648,1878,1,2650,1811,
1,2651,1816,1,2652,
1821,1,2653,1826,1,
2654,1831,1,2655,1836,
1,2656,1841,1,2657,
1774,1,2659,3827,16,
0,403,1,2551,1852,
1,2559,1864,1,2567,
1805,1,2459,1007,1,
2464,1024,1,2575,1846,
1,2470,3828,16,0,
403,1,2580,1858,1,
2703,3829,16,0,403,
1,2595,1871,1,2597,
3830,16,0,403,1,
70,3831,19,402,1,
70,3832,5,30,1,
2536,1750,1,2521,1767,
1,2641,1779,1,2642,
1784,1,2643,1756,1,
2644,1789,1,2645,1794,
1,2646,1799,1,2647,
1762,1,2648,1878,1,
2650,1811,1,2651,1816,
1,2652,1821,1,2653,
1826,1,2654,1831,1,
2655,1836,1,2656,1841,
1,2657,1774,1,2659,
3833,16,0,400,1,
2551,1852,1,2559,1864,
1,2567,1805,1,2459,
1007,1,2464,1024,1,
2575,1846,1,2470,3834,
16,0,400,1,2580,
1858,1,2703,3835,16,
0,400,1,2595,1871,
1,2597,3836,16,0,
400,1,71,3837,19,
399,1,71,3838,5,
30,1,2536,1750,1,
2521,1767,1,2641,1779,
1,2642,1784,1,2643,
1756,1,2644,1789,1,
2645,1794,1,2646,1799,
1,2647,1762,1,2648,
1878,1,2650,1811,1,
2651,1816,1,2652,1821,
1,2653,1826,1,2654,
1831,1,2655,1836,1,
2656,1841,1,2657,1774,
1,2659,3839,16,0,
397,1,2551,1852,1,
2559,1864,1,2567,1805,
1,2459,1007,1,2464,
1024,1,2575,1846,1,
2470,3840,16,0,397,
1,2580,1858,1,2703,
3841,16,0,397,1,
2595,1871,1,2597,3842,
16,0,397,1,72,
3843,19,469,1,72,
3844,5,30,1,2536,
1750,1,2521,1767,1,
2641,1779,1,2642,1784,
1,2643,1756,1,2644,
1789,1,2645,1794,1,
2646,1799,1,2647,1762,
1,2648,1878,1,2650,
1811,1,2651,1816,1,
2652,1821,1,2653,1826,
1,2654,1831,1,2655,
1836,1,2656,1841,1,
2657,1774,1,2659,3845,
16,0,467,1,2551,
1852,1,2559,1864,1,
2567,1805,1,2459,1007,
1,2464,1024,1,2575,
1846,1,2470,3846,16,
0,467,1,2580,1858,
1,2703,3847,16,0,
467,1,2595,1871,1,
2597,3848,16,0,467,
1,73,3849,19,466,
1,73,3850,5,30,
1,2536,1750,1,2521,
1767,1,2641,1779,1,
2642,1784,1,2643,1756,
1,2644,1789,1,2645,
1794,1,2646,1799,1,
2647,1762,1,2648,1878,
1,2650,1811,1,2651,
1816,1,2652,1821,1,
2653,1826,1,2654,1831,
1,2655,1836,1,2656,
1841,1,2657,1774,1,
2659,3851,16,0,464,
1,2551,1852,1,2559,
1864,1,2567,1805,1,
2459,1007,1,2464,1024,
1,2575,1846,1,2470,
3852,16,0,464,1,
2580,1858,1,2703,3853,
16,0,464,1,2595,
1871,1,2597,3854,16,
0,464,1,74,3855,
19,463,1,74,3856,
5,30,1,2536,1750,
1,2521,1767,1,2641,
1779,1,2642,1784,1,
2643,1756,1,2644,1789,
1,2645,1794,1,2646,
1799,1,2647,1762,1,
2648,1878,1,2650,1811,
1,2651,1816,1,2652,
1821,1,2653,1826,1,
2654,1831,1,2655,1836,
1,2656,1841,1,2657,
1774,1,2659,3857,16,
0,461,1,2551,1852,
1,2559,1864,1,2567,
1805,1,2459,1007,1,
2464,1024,1,2575,1846,
1,2470,3858,16,0,
461,1,2580,1858,1,
2703,3859,16,0,461,
1,2595,1871,1,2597,
3860,16,0,461,1,
75,3861,19,449,1,
75,3862,5,30,1,
2536,1750,1,2521,1767,
1,2641,1779,1,2642,
1784,1,2643,1756,1,
2644,1789,1,2645,1794,
1,2646,1799,1,2647,
1762,1,2648,1878,1,
2650,1811,1,2651,1816,
1,2652,1821,1,2653,
1826,1,2654,1831,1,
2655,1836,1,2656,1841,
1,2657,1774,1,2659,
3863,16,0,447,1,
2551,1852,1,2559,1864,
1,2567,1805,1,2459,
1007,1,2464,1024,1,
2575,1846,1,2470,3864,
16,0,447,1,2580,
1858,1,2703,3865,16,
0,447,1,2595,1871,
1,2597,3866,16,0,
447,1,76,3867,19,
570,1,76,3868,5,
30,1,2536,1750,1,
2521,1767,1,2641,1779,
1,2642,1784,1,2643,
1756,1,2644,1789,1,
2645,1794,1,2646,1799,
1,2647,1762,1,2648,
1878,1,2650,1811,1,
2651,1816,1,2652,1821,
1,2653,1826,1,2654,
1831,1,2655,1836,1,
2656,1841,1,2657,1774,
1,2659,3869,16,0,
568,1,2551,1852,1,
2559,1864,1,2567,1805,
1,2459,1007,1,2464,
1024,1,2575,1846,1,
2470,3870,16,0,568,
1,2580,1858,1,2703,
3871,16,0,568,1,
2595,1871,1,2597,3872,
16,0,568,1,77,
3873,19,445,1,77,
3874,5,30,1,2536,
1750,1,2521,1767,1,
2641,1779,1,2642,1784,
1,2643,1756,1,2644,
1789,1,2645,1794,1,
2646,1799,1,2647,1762,
1,2648,1878,1,2650,
1811,1,2651,1816,1,
2652,1821,1,2653,1826,
1,2654,1831,1,2655,
1836,1,2656,1841,1,
2657,1774,1,2659,3875,
16,0,443,1,2551,
1852,1,2559,1864,1,
2567,1805,1,2459,1007,
1,2464,1024,1,2575,
1846,1,2470,3876,16,
0,443,1,2580,1858,
1,2703,3877,16,0,
443,1,2595,1871,1,
2597,3878,16,0,443,
1,78,3879,19,566,
1,78,3880,5,30,
1,2536,1750,1,2521,
1767,1,2641,1779,1,
2642,1784,1,2643,1756,
1,2644,1789,1,2645,
1794,1,2646,1799,1,
2647,1762,1,2648,1878,
1,2650,1811,1,2651,
1816,1,2652,1821,1,
2653,1826,1,2654,1831,
1,2655,1836,1,2656,
1841,1,2657,1774,1,
2659,3881,16,0,564,
1,2551,1852,1,2559,
1864,1,2567,1805,1,
2459,1007,1,2464,1024,
1,2575,1846,1,2470,
3882,16,0,564,1,
2580,1858,1,2703,3883,
16,0,564,1,2595,
1871,1,2597,3884,16,
0,564,1,79,3885,
19,563,1,79,3886,
5,30,1,2536,1750,
1,2521,1767,1,2641,
1779,1,2642,1784,1,
2643,1756,1,2644,1789,
1,2645,1794,1,2646,
1799,1,2647,1762,1,
2648,1878,1,2650,1811,
1,2651,1816,1,2652,
1821,1,2653,1826,1,
2654,1831,1,2655,1836,
1,2656,1841,1,2657,
1774,1,2659,3887,16,
0,561,1,2551,1852,
1,2559,1864,1,2567,
1805,1,2459,1007,1,
2464,1024,1,2575,1846,
1,2470,3888,16,0,
561,1,2580,1858,1,
2703,3889,16,0,561,
1,2595,1871,1,2597,
3890,16,0,561,1,
80,3891,19,436,1,
80,3892,5,30,1,
2536,1750,1,2521,1767,
1,2641,1779,1,2642,
1784,1,2643,1756,1,
2644,1789,1,2645,1794,
1,2646,1799,1,2647,
1762,1,2648,1878,1,
2650,1811,1,2651,1816,
1,2652,1821,1,2653,
1826,1,2654,1831,1,
2655,1836,1,2656,1841,
1,2657,1774,1,2659,
3893,16,0,434,1,
2551,1852,1,2559,1864,
1,2567,1805,1,2459,
1007,1,2464,1024,1,
2575,1846,1,2470,3894,
16,0,434,1,2580,
1858,1,2703,3895,16,
0,434,1,2595,1871,
1,2597,3896,16,0,
434,1,81,3897,19,
423,1,81,3898,5,
30,1,2536,1750,1,
2521,1767,1,2641,1779,
1,2642,1784,1,2643,
1756,1,2644,1789,1,
2645,1794,1,2646,1799,
1,2647,1762,1,2648,
1878,1,2650,1811,1,
2651,1816,1,2652,1821,
1,2653,1826,1,2654,
1831,1,2655,1836,1,
2656,1841,1,2657,1774,
1,2659,3899,16,0,
421,1,2551,1852,1,
2559,1864,1,2567,1805,
1,2459,1007,1,2464,
1024,1,2575,1846,1,
2470,3900,16,0,421,
1,2580,1858,1,2703,
3901,16,0,421,1,
2595,1871,1,2597,3902,
16,0,421,1,82,
3903,19,460,1,82,
3904,5,30,1,2536,
1750,1,2521,1767,1,
2641,1779,1,2642,1784,
1,2643,1756,1,2644,
1789,1,2645,1794,1,
2646,1799,1,2647,1762,
1,2648,1878,1,2650,
1811,1,2651,1816,1,
2652,1821,1,2653,1826,
1,2654,1831,1,2655,
1836,1,2656,1841,1,
2657,1774,1,2659,3905,
16,0,458,1,2551,
1852,1,2559,1864,1,
2567,1805,1,2459,1007,
1,2464,1024,1,2575,
1846,1,2470,3906,16,
0,458,1,2580,1858,
1,2703,3907,16,0,
458,1,2595,1871,1,
2597,3908,16,0,458,
1,83,3909,19,420,
1,83,3910,5,30,
1,2536,1750,1,2521,
1767,1,2641,1779,1,
2642,1784,1,2643,1756,
1,2644,1789,1,2645,
1794,1,2646,1799,1,
2647,1762,1,2648,1878,
1,2650,1811,1,2651,
1816,1,2652,1821,1,
2653,1826,1,2654,1831,
1,2655,1836,1,2656,
1841,1,2657,1774,1,
2659,3911,16,0,418,
1,2551,1852,1,2559,
1864,1,2567,1805,1,
2459,1007,1,2464,1024,
1,2575,1846,1,2470,
3912,16,0,418,1,
2580,1858,1,2703,3913,
16,0,418,1,2595,
1871,1,2597,3914,16,
0,418,1,84,3915,
19,417,1,84,3916,
5,30,1,2536,1750,
1,2521,1767,1,2641,
1779,1,2642,1784,1,
2643,1756,1,2644,1789,
1,2645,1794,1,2646,
1799,1,2647,1762,1,
2648,1878,1,2650,1811,
1,2651,1816,1,2652,
1821,1,2653,1826,1,
2654,1831,1,2655,1836,
1,2656,1841,1,2657,
1774,1,2659,3917,16,
0,415,1,2551,1852,
1,2559,1864,1,2567,
1805,1,2459,1007,1,
2464,1024,1,2575,1846,
1,2470,3918,16,0,
415,1,2580,1858,1,
2703,3919,16,0,415,
1,2595,1871,1,2597,
3920,16,0,415,1,
85,3921,19,578,1,
85,3922,5,30,1,
2536,1750,1,2521,1767,
1,2641,1779,1,2642,
1784,1,2643,1756,1,
2644,1789,1,2645,1794,
1,2646,1799,1,2647,
1762,1,2648,1878,1,
2650,1811,1,2651,1816,
1,2652,1821,1,2653,
1826,1,2654,1831,1,
2655,1836,1,2656,1841,
1,2657,1774,1,2659,
3923,16,0,576,1,
2551,1852,1,2559,1864,
1,2567,1805,1,2459,
1007,1,2464,1024,1,
2575,1846,1,2470,3924,
16,0,576,1,2580,
1858,1,2703,3925,16,
0,576,1,2595,1871,
1,2597,3926,16,0,
576,1,86,3927,19,
452,1,86,3928,5,
30,1,2536,1750,1,
2521,1767,1,2641,1779,
1,2642,1784,1,2643,
1756,1,2644,1789,1,
2645,1794,1,2646,1799,
1,2647,1762,1,2648,
1878,1,2650,1811,1,
2651,1816,1,2652,1821,
1,2653,1826,1,2654,
1831,1,2655,1836,1,
2656,1841,1,2657,1774,
1,2659,3929,16,0,
450,1,2551,1852,1,
2559,1864,1,2567,1805,
1,2459,1007,1,2464,
1024,1,2575,1846,1,
2470,3930,16,0,450,
1,2580,1858,1,2703,
3931,16,0,450,1,
2595,1871,1,2597,3932,
16,0,450,1,87,
3933,19,560,1,87,
3934,5,30,1,2536,
1750,1,2521,1767,1,
2641,1779,1,2642,1784,
1,2643,1756,1,2644,
1789,1,2645,1794,1,
2646,1799,1,2647,1762,
1,2648,1878,1,2650,
1811,1,2651,1816,1,
2652,1821,1,2653,1826,
1,2654,1831,1,2655,
1836,1,2656,1841,1,
2657,1774,1,2659,3935,
16,0,558,1,2551,
1852,1,2559,1864,1,
2567,1805,1,2459,1007,
1,2464,1024,1,2575,
1846,1,2470,3936,16,
0,558,1,2580,1858,
1,2703,3937,16,0,
558,1,2595,1871,1,
2597,3938,16,0,558,
1,88,3939,19,414,
1,88,3940,5,30,
1,2536,1750,1,2521,
1767,1,2641,1779,1,
2642,1784,1,2643,1756,
1,2644,1789,1,2645,
1794,1,2646,1799,1,
2647,1762,1,2648,1878,
1,2650,1811,1,2651,
1816,1,2652,1821,1,
2653,1826,1,2654,1831,
1,2655,1836,1,2656,
1841,1,2657,1774,1,
2659,3941,16,0,412,
1,2551,1852,1,2559,
1864,1,2567,1805,1,
2459,1007,1,2464,1024,
1,2575,1846,1,2470,
3942,16,0,412,1,
2580,1858,1,2703,3943,
16,0,412,1,2595,
1871,1,2597,3944,16,
0,412,1,89,3945,
19,408,1,89,3946,
5,30,1,2536,1750,
1,2521,1767,1,2641,
1779,1,2642,1784,1,
2643,1756,1,2644,1789,
1,2645,1794,1,2646,
1799,1,2647,1762,1,
2648,1878,1,2650,1811,
1,2651,1816,1,2652,
1821,1,2653,1826,1,
2654,1831,1,2655,1836,
1,2656,1841,1,2657,
1774,1,2659,3947,16,
0,406,1,2551,1852,
1,2559,1864,1,2567,
1805,1,2459,1007,1,
2464,1024,1,2575,1846,
1,2470,3948,16,0,
406,1,2580,1858,1,
2703,3949,16,0,406,
1,2595,1871,1,2597,
3950,16,0,406,1,
90,3951,19,411,1,
90,3952,5,30,1,
2536,1750,1,2521,1767,
1,2641,1779,1,2642,
1784,1,2643,1756,1,
2644,1789,1,2645,1794,
1,2646,1799,1,2647,
1762,1,2648,1878,1,
2650,1811,1,2651,1816,
1,2652,1821,1,2653,
1826,1,2654,1831,1,
2655,1836,1,2656,1841,
1,2657,1774,1,2659,
3953,16,0,409,1,
2551,1852,1,2559,1864,
1,2567,1805,1,2459,
1007,1,2464,1024,1,
2575,1846,1,2470,3954,
16,0,409,1,2580,
1858,1,2703,3955,16,
0,409,1,2595,1871,
1,2597,3956,16,0,
409,1,91,3957,19,
768,1,91,3958,5,
30,1,2536,1750,1,
2521,1767,1,2641,1779,
1,2642,1784,1,2643,
1756,1,2644,1789,1,
2645,1794,1,2646,1799,
1,2647,1762,1,2648,
1878,1,2650,1811,1,
2651,1816,1,2652,1821,
1,2653,1826,1,2654,
1831,1,2655,1836,1,
2656,1841,1,2657,1774,
1,2659,3959,16,0,
766,1,2551,1852,1,
2559,1864,1,2567,1805,
1,2459,1007,1,2464,
1024,1,2575,1846,1,
2470,3960,16,0,766,
1,2580,1858,1,2703,
3961,16,0,766,1,
2595,1871,1,2597,3962,
16,0,766,1,92,
3963,19,456,1,92,
3964,5,30,1,2536,
1750,1,2521,1767,1,
2641,1779,1,2642,1784,
1,2643,1756,1,2644,
1789,1,2645,1794,1,
2646,1799,1,2647,1762,
1,2648,1878,1,2650,
1811,1,2651,1816,1,
2652,1821,1,2653,1826,
1,2654,1831,1,2655,
1836,1,2656,1841,1,
2657,1774,1,2659,3965,
16,0,454,1,2551,
1852,1,2559,1864,1,
2567,1805,1,2459,1007,
1,2464,1024,1,2575,
1846,1,2470,3966,16,
0,454,1,2580,1858,
1,2703,3967,16,0,
454,1,2595,1871,1,
2597,3968,16,0,454,
1,93,3969,19,133,
1,93,3970,5,129,
1,0,3971,16,0,
789,1,1,2244,1,
2,2250,1,3,2255,
1,4,2260,1,5,
2265,1,6,2270,1,
7,2275,1,8,3972,
16,0,131,1,1515,
3973,16,0,181,1,
2021,843,1,2022,3974,
16,0,583,1,256,
3975,16,0,189,1,
2527,3976,16,0,311,
1,18,3977,16,0,
138,1,2027,3978,16,
0,591,1,2029,850,
1,2030,856,1,2031,
861,1,2032,866,1,
2786,3979,16,0,189,
1,277,3980,16,0,
189,1,2035,877,1,
2037,882,1,2039,887,
1,32,3981,16,0,
181,1,2041,893,1,
2293,3982,16,0,189,
1,2043,899,1,2045,
904,1,41,3983,16,
0,189,1,1297,3984,
16,0,181,1,43,
3985,16,0,189,1,
46,3986,16,0,194,
1,1804,3987,16,0,
181,1,299,3988,16,
0,189,1,2811,3559,
1,52,3989,16,0,
181,1,509,3990,16,
0,189,1,2318,3991,
16,0,181,1,2822,
3523,1,62,3992,16,
0,218,1,65,3993,
16,0,220,1,2075,
3994,16,0,181,1,
1574,924,1,71,3995,
16,0,189,1,1775,
3996,16,0,181,1,
76,3997,16,0,189,
1,1834,3998,16,0,
181,1,2337,3999,16,
0,181,1,79,4000,
16,0,189,1,1335,
4001,16,0,181,1,
2842,3544,1,2843,3549,
1,2844,3554,1,85,
4002,16,0,189,1,
1261,4003,16,0,181,
1,89,4004,16,0,
189,1,2033,871,1,
322,4005,16,0,189,
1,97,4006,16,0,
189,1,2106,4007,16,
0,181,1,102,4008,
16,0,189,1,1860,
946,1,1803,912,1,
2364,952,1,346,4009,
16,0,189,1,1113,
4010,16,0,173,1,
2783,3517,1,112,4011,
16,0,189,1,1117,
4012,16,0,181,1,
1371,4013,16,0,181,
1,1876,4014,16,0,
181,1,372,4015,16,
0,621,1,374,4016,
16,0,623,1,124,
4017,16,0,189,1,
376,4018,16,0,625,
1,378,4019,16,0,
627,1,2136,968,1,
381,4020,16,0,189,
1,525,4021,16,0,
189,1,137,4022,16,
0,189,1,1901,4023,
16,0,181,1,2025,
4024,16,0,587,1,
1153,4025,16,0,181,
1,151,4026,16,0,
189,1,1407,4027,16,
0,181,1,1659,4028,
16,0,181,1,2413,
4029,16,0,181,1,
406,4030,16,0,189,
1,2512,4031,16,0,
490,1,2105,939,1,
166,4032,16,0,189,
1,1622,4033,16,0,
189,1,2841,3538,1,
1931,986,1,1873,961,
1,431,4034,16,0,
189,1,1585,4035,16,
0,189,1,182,4036,
16,0,189,1,1189,
4037,16,0,181,1,
1443,4038,16,0,181,
1,1695,4039,16,0,
181,1,2198,4040,16,
0,181,1,2542,4041,
16,0,644,1,447,
4042,16,0,189,1,
2458,1001,1,2459,1007,
1,1958,4043,16,0,
181,1,2462,1014,1,
1657,1019,1,2464,1024,
1,2466,3532,1,459,
4044,16,0,189,1,
2468,4045,16,0,386,
1,462,4046,16,0,
189,1,199,4047,16,
0,189,1,217,4048,
16,0,189,1,2227,
1033,1,1225,4049,16,
0,181,1,1479,4050,
16,0,181,1,1731,
4051,16,0,189,1,
1989,1041,1,1990,4052,
16,0,181,1,236,
4053,16,0,189,1,
1933,4054,16,0,181,
1,2823,4055,16,0,
789,1,2508,4056,16,
0,484,1,1756,4057,
16,0,181,1,94,
4058,19,746,1,94,
4059,5,95,1,256,
4060,16,0,744,1,
1261,4061,16,0,744,
1,509,4062,16,0,
744,1,1515,4063,16,
0,744,1,2021,843,
1,1775,4064,16,0,
744,1,2029,850,1,
2030,856,1,2031,861,
1,2032,866,1,2033,
871,1,277,4065,16,
0,744,1,2035,877,
1,2037,882,1,2039,
887,1,32,4066,16,
0,744,1,2041,893,
1,2293,4067,16,0,
744,1,2043,899,1,
2045,904,1,41,4068,
16,0,744,1,1297,
4069,16,0,744,1,
43,4070,16,0,744,
1,1803,912,1,1804,
4071,16,0,744,1,
299,4072,16,0,744,
1,52,4073,16,0,
744,1,2318,4074,16,
0,744,1,62,4075,
16,0,744,1,2075,
4076,16,0,744,1,
1574,924,1,71,4077,
16,0,744,1,76,
4078,16,0,744,1,
1834,4079,16,0,744,
1,2337,4080,16,0,
744,1,79,4081,16,
0,744,1,1335,4082,
16,0,744,1,322,
4083,16,0,744,1,
85,4084,16,0,744,
1,89,4085,16,0,
744,1,346,4086,16,
0,744,1,2105,939,
1,2106,4087,16,0,
744,1,97,4088,16,
0,744,1,1860,946,
1,2364,952,1,102,
4089,16,0,744,1,
112,4090,16,0,744,
1,1117,4091,16,0,
744,1,2786,4092,16,
0,744,1,1873,961,
1,1876,4093,16,0,
744,1,124,4094,16,
0,744,1,2136,968,
1,381,4095,16,0,
744,1,525,4096,16,
0,744,1,137,4097,
16,0,744,1,1901,
4098,16,0,744,1,
1153,4099,16,0,744,
1,151,4100,16,0,
744,1,1407,4101,16,
0,744,1,1659,4102,
16,0,744,1,2413,
4103,16,0,744,1,
406,4104,16,0,744,
1,1371,4105,16,0,
744,1,166,4106,16,
0,744,1,1622,4107,
16,0,744,1,1931,
986,1,1933,4108,16,
0,744,1,431,4109,
16,0,744,1,1585,
4110,16,0,744,1,
182,4111,16,0,744,
1,1189,4112,16,0,
744,1,1443,4113,16,
0,744,1,1695,4114,
16,0,744,1,2198,
4115,16,0,744,1,
447,4116,16,0,744,
1,2458,1001,1,2459,
1007,1,1958,4117,16,
0,744,1,2462,1014,
1,1657,1019,1,2464,
1024,1,199,4118,16,
0,744,1,459,4119,
16,0,744,1,462,
4120,16,0,744,1,
217,4121,16,0,744,
1,2227,1033,1,1225,
4122,16,0,744,1,
1479,4123,16,0,744,
1,1731,4124,16,0,
744,1,1989,1041,1,
1990,4125,16,0,744,
1,236,4126,16,0,
744,1,1756,4127,16,
0,744,1,95,4128,
19,743,1,95,4129,
5,95,1,256,4130,
16,0,741,1,1261,
4131,16,0,741,1,
509,4132,16,0,741,
1,1515,4133,16,0,
741,1,2021,843,1,
1775,4134,16,0,741,
1,2029,850,1,2030,
856,1,2031,861,1,
2032,866,1,2033,871,
1,277,4135,16,0,
741,1,2035,877,1,
2037,882,1,2039,887,
1,32,4136,16,0,
741,1,2041,893,1,
2293,4137,16,0,741,
1,2043,899,1,2045,
904,1,41,4138,16,
0,741,1,1297,4139,
16,0,741,1,43,
4140,16,0,741,1,
1803,912,1,1804,4141,
16,0,741,1,299,
4142,16,0,741,1,
52,4143,16,0,741,
1,2318,4144,16,0,
741,1,62,4145,16,
0,741,1,2075,4146,
16,0,741,1,1574,
924,1,71,4147,16,
0,741,1,76,4148,
16,0,741,1,1834,
4149,16,0,741,1,
2337,4150,16,0,741,
1,79,4151,16,0,
741,1,1335,4152,16,
0,741,1,322,4153,
16,0,741,1,85,
4154,16,0,741,1,
89,4155,16,0,741,
1,346,4156,16,0,
741,1,2105,939,1,
2106,4157,16,0,741,
1,97,4158,16,0,
741,1,1860,946,1,
2364,952,1,102,4159,
16,0,741,1,112,
4160,16,0,741,1,
1117,4161,16,0,741,
1,2786,4162,16,0,
741,1,1873,961,1,
1876,4163,16,0,741,
1,124,4164,16,0,
741,1,2136,968,1,
381,4165,16,0,741,
1,525,4166,16,0,
741,1,137,4167,16,
0,741,1,1901,4168,
16,0,741,1,1153,
4169,16,0,741,1,
151,4170,16,0,741,
1,1407,4171,16,0,
741,1,1659,4172,16,
0,741,1,2413,4173,
16,0,741,1,406,
4174,16,0,741,1,
1371,4175,16,0,741,
1,166,4176,16,0,
741,1,1622,4177,16,
0,741,1,1931,986,
1,1933,4178,16,0,
741,1,431,4179,16,
0,741,1,1585,4180,
16,0,741,1,182,
4181,16,0,741,1,
1189,4182,16,0,741,
1,1443,4183,16,0,
741,1,1695,4184,16,
0,741,1,2198,4185,
16,0,741,1,447,
4186,16,0,741,1,
2458,1001,1,2459,1007,
1,1958,4187,16,0,
741,1,2462,1014,1,
1657,1019,1,2464,1024,
1,199,4188,16,0,
741,1,459,4189,16,
0,741,1,462,4190,
16,0,741,1,217,
4191,16,0,741,1,
2227,1033,1,1225,4192,
16,0,741,1,1479,
4193,16,0,741,1,
1731,4194,16,0,741,
1,1989,1041,1,1990,
4195,16,0,741,1,
236,4196,16,0,741,
1,1756,4197,16,0,
741,1,96,4198,19,
740,1,96,4199,5,
95,1,256,4200,16,
0,738,1,1261,4201,
16,0,738,1,509,
4202,16,0,738,1,
1515,4203,16,0,738,
1,2021,843,1,1775,
4204,16,0,738,1,
2029,850,1,2030,856,
1,2031,861,1,2032,
866,1,2033,871,1,
277,4205,16,0,738,
1,2035,877,1,2037,
882,1,2039,887,1,
32,4206,16,0,738,
1,2041,893,1,2293,
4207,16,0,738,1,
2043,899,1,2045,904,
1,41,4208,16,0,
738,1,1297,4209,16,
0,738,1,43,4210,
16,0,738,1,1803,
912,1,1804,4211,16,
0,738,1,299,4212,
16,0,738,1,52,
4213,16,0,738,1,
2318,4214,16,0,738,
1,62,4215,16,0,
738,1,2075,4216,16,
0,738,1,1574,924,
1,71,4217,16,0,
738,1,76,4218,16,
0,738,1,1834,4219,
16,0,738,1,2337,
4220,16,0,738,1,
79,4221,16,0,738,
1,1335,4222,16,0,
738,1,322,4223,16,
0,738,1,85,4224,
16,0,738,1,89,
4225,16,0,738,1,
346,4226,16,0,738,
1,2105,939,1,2106,
4227,16,0,738,1,
97,4228,16,0,738,
1,1860,946,1,2364,
952,1,102,4229,16,
0,738,1,112,4230,
16,0,738,1,1117,
4231,16,0,738,1,
2786,4232,16,0,738,
1,1873,961,1,1876,
4233,16,0,738,1,
124,4234,16,0,738,
1,2136,968,1,381,
4235,16,0,738,1,
525,4236,16,0,738,
1,137,4237,16,0,
738,1,1901,4238,16,
0,738,1,1153,4239,
16,0,738,1,151,
4240,16,0,738,1,
1407,4241,16,0,738,
1,1659,4242,16,0,
738,1,2413,4243,16,
0,738,1,406,4244,
16,0,738,1,1371,
4245,16,0,738,1,
166,4246,16,0,738,
1,1622,4247,16,0,
738,1,1931,986,1,
1933,4248,16,0,738,
1,431,4249,16,0,
738,1,1585,4250,16,
0,738,1,182,4251,
16,0,738,1,1189,
4252,16,0,738,1,
1443,4253,16,0,738,
1,1695,4254,16,0,
738,1,2198,4255,16,
0,738,1,447,4256,
16,0,738,1,2458,
1001,1,2459,1007,1,
1958,4257,16,0,738,
1,2462,1014,1,1657,
1019,1,2464,1024,1,
199,4258,16,0,738,
1,459,4259,16,0,
738,1,462,4260,16,
0,738,1,217,4261,
16,0,738,1,2227,
1033,1,1225,4262,16,
0,738,1,1479,4263,
16,0,738,1,1731,
4264,16,0,738,1,
1989,1041,1,1990,4265,
16,0,738,1,236,
4266,16,0,738,1,
1756,4267,16,0,738,
1,97,4268,19,103,
1,97,4269,5,1,
1,0,4270,16,0,
104,1,98,4271,19,
647,1,98,4272,5,
1,1,0,4273,16,
0,645,1,99,4274,
19,210,1,99,4275,
5,2,1,0,4276,
16,0,312,1,2823,
4277,16,0,208,1,
100,4278,19,207,1,
100,4279,5,2,1,
0,4280,16,0,286,
1,2823,4281,16,0,
205,1,101,4282,19,
301,1,101,4283,5,
2,1,0,4284,16,
0,785,1,2823,4285,
16,0,299,1,102,
4286,19,320,1,102,
4287,5,4,1,0,
4288,16,0,788,1,
2764,4289,16,0,318,
1,2823,4290,16,0,
788,1,2834,4291,16,
0,318,1,103,4292,
19,714,1,103,4293,
5,2,1,2470,4294,
16,0,712,1,2659,
4295,16,0,734,1,
104,4296,19,280,1,
104,4297,5,4,1,
2597,4298,16,0,680,
1,2703,4299,16,0,
680,1,2470,4300,16,
0,278,1,2659,4301,
16,0,278,1,105,
4302,19,679,1,105,
4303,5,4,1,2597,
4304,16,0,677,1,
2703,4305,16,0,677,
1,2470,4306,16,0,
690,1,2659,4307,16,
0,690,1,106,4308,
19,157,1,106,4309,
5,4,1,2597,4310,
16,0,155,1,2703,
4311,16,0,155,1,
2470,4312,16,0,769,
1,2659,4313,16,0,
769,1,107,4314,19,
154,1,107,4315,5,
4,1,2597,4316,16,
0,152,1,2703,4317,
16,0,152,1,2470,
4318,16,0,174,1,
2659,4319,16,0,174,
1,108,4320,19,672,
1,108,4321,5,4,
1,2597,4322,16,0,
670,1,2703,4323,16,
0,670,1,2470,4324,
16,0,685,1,2659,
4325,16,0,685,1,
109,4326,19,669,1,
109,4327,5,4,1,
2597,4328,16,0,667,
1,2703,4329,16,0,
667,1,2470,4330,16,
0,684,1,2659,4331,
16,0,684,1,110,
4332,19,172,1,110,
4333,5,4,1,2597,
4334,16,0,752,1,
2703,4335,16,0,752,
1,2470,4336,16,0,
170,1,2659,4337,16,
0,170,1,111,4338,
19,169,1,111,4339,
5,4,1,2597,4340,
16,0,663,1,2703,
4341,16,0,663,1,
2470,4342,16,0,167,
1,2659,4343,16,0,
167,1,112,4344,19,
141,1,112,4345,5,
3,1,2582,4346,16,
0,293,1,2770,4347,
16,0,331,1,10,
4348,16,0,139,1,
113,4349,19,688,1,
113,4350,5,1,1,
2569,4351,16,0,686,
1,114,4352,19,676,
1,114,4353,5,1,
1,2561,4354,16,0,
674,1,115,4355,19,
660,1,115,4356,5,
1,1,2553,4357,16,
0,658,1,116,4358,
19,535,1,116,4359,
5,1,1,2538,4360,
16,0,533,1,117,
4361,19,638,1,117,
4362,5,1,1,2523,
4363,16,0,636,1,
118,4364,19,498,1,
118,4365,5,1,1,
2507,4366,16,0,496,
1,119,4367,19,160,
1,119,4368,5,17,
1,0,4369,16,0,
333,1,2582,4370,16,
0,382,1,2075,4371,
16,0,763,1,2337,
4372,16,0,763,1,
2413,4373,16,0,763,
1,10,4374,16,0,
382,1,2823,4375,16,
0,333,1,1901,4376,
16,0,763,1,2198,
4377,16,0,763,1,
21,4378,16,0,158,
1,2106,4379,16,0,
763,1,2770,4380,16,
0,382,1,1804,4381,
16,0,763,1,1990,
4382,16,0,763,1,
32,4383,16,0,763,
1,1958,4384,16,0,
763,1,1775,4385,16,
0,763,1,120,4386,
19,487,1,120,4387,
5,2,1,2569,4388,
16,0,567,1,2507,
4389,16,0,485,1,
121,4390,19,493,1,
121,4391,5,5,1,
2511,4392,16,0,491,
1,2523,4393,16,0,
506,1,2515,4394,16,
0,495,1,2538,4395,
16,0,523,1,2561,
4396,16,0,753,1,
122,4397,19,514,1,
122,4398,5,3,1,
2530,4399,16,0,516,
1,2553,4400,16,0,
542,1,2526,4401,16,
0,512,1,123,4402,
19,248,1,123,4403,
5,2,1,2541,4404,
16,0,527,1,2545,
4405,16,0,246,1,
124,4406,19,130,1,
124,4407,5,18,1,
0,4408,16,0,128,
1,2582,4409,16,0,
137,1,2075,4410,16,
0,137,1,2337,4411,
16,0,137,1,2413,
4412,16,0,137,1,
10,4413,16,0,137,
1,2823,4414,16,0,
128,1,2198,4415,16,
0,137,1,1901,4416,
16,0,137,1,52,
4417,16,0,216,1,
21,4418,16,0,137,
1,2106,4419,16,0,
137,1,2770,4420,16,
0,137,1,1804,4421,
16,0,137,1,1990,
4422,16,0,137,1,
32,4423,16,0,137,
1,1958,4424,16,0,
137,1,1775,4425,16,
0,137,1,125,4426,
19,359,1,125,4427,
5,4,1,2597,4428,
16,0,357,1,2703,
4429,16,0,357,1,
2470,4430,16,0,357,
1,2659,4431,16,0,
357,1,126,4432,19,
772,1,126,4433,5,
4,1,2597,4434,16,
0,770,1,2703,4435,
16,0,770,1,2470,
4436,16,0,770,1,
2659,4437,16,0,770,
1,127,4438,19,760,
1,127,4439,5,4,
1,2597,4440,16,0,
758,1,2703,4441,16,
0,758,1,2470,4442,
16,0,758,1,2659,
4443,16,0,758,1,
128,4444,19,548,1,
128,4445,5,4,1,
2597,4446,16,0,546,
1,2703,4447,16,0,
546,1,2470,4448,16,
0,546,1,2659,4449,
16,0,546,1,129,
4450,19,655,1,129,
4451,5,4,1,2597,
4452,16,0,653,1,
2703,4453,16,0,653,
1,2470,4454,16,0,
653,1,2659,4455,16,
0,653,1,130,4456,
19,643,1,130,4457,
5,4,1,2597,4458,
16,0,641,1,2703,
4459,16,0,641,1,
2470,4460,16,0,641,
1,2659,4461,16,0,
641,1,131,4462,19,
504,1,131,4463,5,
4,1,2597,4464,16,
0,502,1,2703,4465,
16,0,502,1,2470,
4466,16,0,502,1,
2659,4467,16,0,502,
1,132,4468,19,481,
1,132,4469,5,4,
1,2597,4470,16,0,
479,1,2703,4471,16,
0,479,1,2470,4472,
16,0,479,1,2659,
4473,16,0,479,1,
133,4474,19,381,1,
133,4475,5,21,1,
2781,4476,16,0,798,
1,2519,4477,16,0,
784,1,2557,4478,16,
0,545,1,2337,4479,
16,0,592,1,2413,
4480,16,0,592,1,
2593,4481,16,0,711,
1,2565,4482,16,0,
681,1,1901,4483,16,
0,592,1,2198,4484,
16,0,592,1,2534,
4485,16,0,640,1,
2573,4486,16,0,575,
1,2106,4487,16,0,
592,1,2578,4488,16,
0,775,1,2075,4489,
16,0,592,1,1804,
4490,16,0,592,1,
1990,4491,16,0,592,
1,31,4492,16,0,
379,1,32,4493,16,
0,592,1,2549,4494,
16,0,538,1,1958,
4495,16,0,592,1,
1775,4496,16,0,592,
1,134,4497,19,342,
1,134,4498,5,1,
1,32,4499,16,0,
340,1,135,4500,19,
289,1,135,4501,5,
11,1,2075,4502,16,
0,697,1,2337,4503,
16,0,294,1,2413,
4504,16,0,520,1,
1901,4505,16,0,437,
1,2198,4506,16,0,
362,1,2106,4507,16,
0,730,1,1804,4508,
16,0,322,1,1990,
4509,16,0,580,1,
32,4510,16,0,375,
1,1958,4511,16,0,
529,1,1775,4512,16,
0,287,1,136,4513,
19,703,1,136,4514,
5,11,1,2075,4515,
16,0,701,1,2337,
4516,16,0,701,1,
2413,4517,16,0,701,
1,1901,4518,16,0,
701,1,2198,4519,16,
0,701,1,2106,4520,
16,0,701,1,1804,
4521,16,0,701,1,
1990,4522,16,0,701,
1,32,4523,16,0,
701,1,1958,4524,16,
0,701,1,1775,4525,
16,0,701,1,137,
4526,19,756,1,137,
4527,5,11,1,2075,
4528,16,0,754,1,
2337,4529,16,0,754,
1,2413,4530,16,0,
754,1,1901,4531,16,
0,754,1,2198,4532,
16,0,754,1,2106,
4533,16,0,754,1,
1804,4534,16,0,754,
1,1990,4535,16,0,
754,1,32,4536,16,
0,754,1,1958,4537,
16,0,754,1,1775,
4538,16,0,754,1,
138,4539,19,177,1,
138,4540,5,31,1,
1901,4541,16,0,762,
1,1479,4542,16,0,
648,1,2075,4543,16,
0,762,1,1695,4544,
16,0,214,1,1756,
4545,16,0,204,1,
2413,4546,16,0,762,
1,2198,4547,16,0,
762,1,1876,4548,16,
0,781,1,1659,4549,
16,0,204,1,1443,
4550,16,0,608,1,
1117,4551,16,0,175,
1,1990,4552,16,0,
762,1,1189,4553,16,
0,264,1,1775,4554,
16,0,762,1,32,
4555,16,0,762,1,
2106,4556,16,0,762,
1,1515,4557,16,0,
699,1,2337,4558,16,
0,762,1,52,4559,
16,0,715,1,1804,
4560,16,0,762,1,
1261,4561,16,0,338,
1,1153,4562,16,0,
271,1,1225,4563,16,
0,307,1,1335,4564,
16,0,511,1,1933,
4565,16,0,651,1,
1834,4566,16,0,352,
1,1297,4567,16,0,
366,1,1407,4568,16,
0,682,1,2318,4569,
16,0,204,1,1958,
4570,16,0,762,1,
1371,4571,16,0,500,
1,139,4572,19,617,
1,139,4573,5,11,
1,2075,4574,16,0,
615,1,2337,4575,16,
0,615,1,2413,4576,
16,0,615,1,1901,
4577,16,0,615,1,
2198,4578,16,0,615,
1,2106,4579,16,0,
615,1,1804,4580,16,
0,615,1,1990,4581,
16,0,615,1,32,
4582,16,0,615,1,
1958,4583,16,0,615,
1,1775,4584,16,0,
615,1,140,4585,19,
613,1,140,4586,5,
11,1,2075,4587,16,
0,611,1,2337,4588,
16,0,611,1,2413,
4589,16,0,611,1,
1901,4590,16,0,611,
1,2198,4591,16,0,
611,1,2106,4592,16,
0,611,1,1804,4593,
16,0,611,1,1990,
4594,16,0,611,1,
32,4595,16,0,611,
1,1958,4596,16,0,
611,1,1775,4597,16,
0,611,1,141,4598,
19,694,1,141,4599,
5,11,1,2075,4600,
16,0,692,1,2337,
4601,16,0,692,1,
2413,4602,16,0,692,
1,1901,4603,16,0,
692,1,2198,4604,16,
0,692,1,2106,4605,
16,0,692,1,1804,
4606,16,0,692,1,
1990,4607,16,0,692,
1,32,4608,16,0,
692,1,1958,4609,16,
0,692,1,1775,4610,
16,0,692,1,142,
4611,19,607,1,142,
4612,5,11,1,2075,
4613,16,0,605,1,
2337,4614,16,0,605,
1,2413,4615,16,0,
605,1,1901,4616,16,
0,605,1,2198,4617,
16,0,605,1,2106,
4618,16,0,605,1,
1804,4619,16,0,605,
1,1990,4620,16,0,
605,1,32,4621,16,
0,605,1,1958,4622,
16,0,605,1,1775,
4623,16,0,605,1,
143,4624,19,604,1,
143,4625,5,11,1,
2075,4626,16,0,602,
1,2337,4627,16,0,
602,1,2413,4628,16,
0,602,1,1901,4629,
16,0,602,1,2198,
4630,16,0,602,1,
2106,4631,16,0,602,
1,1804,4632,16,0,
602,1,1990,4633,16,
0,602,1,32,4634,
16,0,602,1,1958,
4635,16,0,602,1,
1775,4636,16,0,602,
1,144,4637,19,601,
1,144,4638,5,11,
1,2075,4639,16,0,
599,1,2337,4640,16,
0,599,1,2413,4641,
16,0,599,1,1901,
4642,16,0,599,1,
2198,4643,16,0,599,
1,2106,4644,16,0,
599,1,1804,4645,16,
0,599,1,1990,4646,
16,0,599,1,32,
4647,16,0,599,1,
1958,4648,16,0,599,
1,1775,4649,16,0,
599,1,145,4650,19,
598,1,145,4651,5,
11,1,2075,4652,16,
0,596,1,2337,4653,
16,0,596,1,2413,
4654,16,0,596,1,
1901,4655,16,0,596,
1,2198,4656,16,0,
596,1,2106,4657,16,
0,596,1,1804,4658,
16,0,596,1,1990,
4659,16,0,596,1,
32,4660,16,0,596,
1,1958,4661,16,0,
596,1,1775,4662,16,
0,596,1,146,4663,
19,595,1,146,4664,
5,11,1,2075,4665,
16,0,593,1,2337,
4666,16,0,593,1,
2413,4667,16,0,593,
1,1901,4668,16,0,
593,1,2198,4669,16,
0,593,1,2106,4670,
16,0,593,1,1804,
4671,16,0,593,1,
1990,4672,16,0,593,
1,32,4673,16,0,
593,1,1958,4674,16,
0,593,1,1775,4675,
16,0,593,1,147,
4676,19,147,1,147,
4677,5,3,1,1756,
4678,16,0,321,1,
2318,4679,16,0,337,
1,1659,4680,16,0,
145,1,148,4681,19,
634,1,148,4682,5,
68,1,1901,4683,16,
0,632,1,1479,4684,
16,0,632,1,112,
4685,16,0,632,1,
2293,4686,16,0,632,
1,1804,4687,16,0,
632,1,431,4688,16,
0,632,1,1443,4689,
16,0,632,1,1756,
4690,16,0,632,1,
124,4691,16,0,632,
1,525,4692,16,0,
632,1,236,4693,16,
0,632,1,346,4694,
16,0,632,1,1876,
4695,16,0,632,1,
1659,4696,16,0,632,
1,1225,4697,16,0,
632,1,1117,4698,16,
0,632,1,137,4699,
16,0,632,1,2318,
4700,16,0,632,1,
1775,4701,16,0,632,
1,32,4702,16,0,
632,1,1407,4703,16,
0,632,1,256,4704,
16,0,632,1,459,
4705,16,0,632,1,
406,4706,16,0,632,
1,41,4707,16,0,
632,1,151,4708,16,
0,632,1,43,4709,
16,0,632,1,1585,
4710,16,0,632,1,
1990,4711,16,0,632,
1,2337,4712,16,0,
632,1,509,4713,16,
0,632,1,52,4714,
16,0,632,1,381,
4715,16,0,632,1,
447,4716,16,0,632,
1,166,4717,16,0,
632,1,462,4718,16,
0,632,1,277,4719,
16,0,632,1,1695,
4720,16,0,632,1,
2786,4721,16,0,632,
1,62,4722,16,0,
707,1,1153,4723,16,
0,632,1,2106,4724,
16,0,632,1,1335,
4725,16,0,632,1,
71,4726,16,0,632,
1,182,4727,16,0,
632,1,76,4728,16,
0,632,1,79,4729,
16,0,632,1,1933,
4730,16,0,632,1,
299,4731,16,0,632,
1,85,4732,16,0,
632,1,1515,4733,16,
0,632,1,2198,4734,
16,0,632,1,89,
4735,16,0,632,1,
1834,4736,16,0,632,
1,1622,4737,16,0,
632,1,2413,4738,16,
0,632,1,2075,4739,
16,0,632,1,1731,
4740,16,0,632,1,
97,4741,16,0,632,
1,1297,4742,16,0,
632,1,1189,4743,16,
0,632,1,102,4744,
16,0,632,1,1261,
4745,16,0,632,1,
322,4746,16,0,632,
1,1958,4747,16,0,
632,1,199,4748,16,
0,632,1,1371,4749,
16,0,632,1,217,
4750,16,0,632,1,
149,4751,19,725,1,
149,4752,5,2,1,
459,4753,16,0,723,
1,41,4754,16,0,
786,1,150,4755,19,
729,1,150,4756,5,
3,1,462,4757,16,
0,727,1,459,4758,
16,0,750,1,41,
4759,16,0,750,1,
151,4760,19,4761,4,
36,69,0,120,0,
112,0,114,0,101,
0,115,0,115,0,
105,0,111,0,110,
0,65,0,114,0,
103,0,117,0,109,
0,101,0,110,0,
116,0,1,151,4756,
1,152,4762,19,630,
1,152,4763,5,68,
1,1901,4764,16,0,
628,1,1479,4765,16,
0,628,1,112,4766,
16,0,628,1,2293,
4767,16,0,628,1,
1804,4768,16,0,628,
1,431,4769,16,0,
628,1,1443,4770,16,
0,628,1,1756,4771,
16,0,628,1,124,
4772,16,0,628,1,
525,4773,16,0,628,
1,236,4774,16,0,
628,1,346,4775,16,
0,628,1,1876,4776,
16,0,628,1,1659,
4777,16,0,628,1,
1225,4778,16,0,628,
1,1117,4779,16,0,
628,1,137,4780,16,
0,628,1,2318,4781,
16,0,628,1,1775,
4782,16,0,628,1,
32,4783,16,0,628,
1,1407,4784,16,0,
628,1,256,4785,16,
0,628,1,459,4786,
16,0,628,1,406,
4787,16,0,628,1,
41,4788,16,0,628,
1,151,4789,16,0,
628,1,43,4790,16,
0,628,1,1585,4791,
16,0,628,1,1990,
4792,16,0,628,1,
2337,4793,16,0,628,
1,509,4794,16,0,
628,1,52,4795,16,
0,628,1,381,4796,
16,0,628,1,447,
4797,16,0,628,1,
166,4798,16,0,628,
1,462,4799,16,0,
628,1,277,4800,16,
0,628,1,1695,4801,
16,0,628,1,2786,
4802,16,0,628,1,
62,4803,16,0,708,
1,1153,4804,16,0,
628,1,2106,4805,16,
0,628,1,1335,4806,
16,0,628,1,71,
4807,16,0,628,1,
182,4808,16,0,628,
1,76,4809,16,0,
628,1,79,4810,16,
0,628,1,1933,4811,
16,0,628,1,299,
4812,16,0,628,1,
85,4813,16,0,628,
1,1515,4814,16,0,
628,1,2198,4815,16,
0,628,1,89,4816,
16,0,628,1,1834,
4817,16,0,628,1,
1622,4818,16,0,628,
1,2413,4819,16,0,
628,1,2075,4820,16,
0,628,1,1731,4821,
16,0,628,1,97,
4822,16,0,628,1,
1297,4823,16,0,628,
1,1189,4824,16,0,
628,1,102,4825,16,
0,628,1,1261,4826,
16,0,628,1,322,
4827,16,0,628,1,
1958,4828,16,0,628,
1,199,4829,16,0,
628,1,1371,4830,16,
0,628,1,217,4831,
16,0,628,1,153,
4832,19,4833,4,28,
86,0,101,0,99,
0,116,0,111,0,
114,0,67,0,111,
0,110,0,115,0,
116,0,97,0,110,
0,116,0,1,153,
4763,1,154,4834,19,
4835,4,32,82,0,
111,0,116,0,97,
0,116,0,105,0,
111,0,110,0,67,
0,111,0,110,0,
115,0,116,0,97,
0,110,0,116,0,
1,154,4763,1,155,
4836,19,4837,4,24,
76,0,105,0,115,
0,116,0,67,0,
111,0,110,0,115,
0,116,0,97,0,
110,0,116,0,1,
155,4763,1,156,4838,
19,185,1,156,4839,
5,67,1,1901,4840,
16,0,705,1,1479,
4841,16,0,619,1,
112,4842,16,0,273,
1,2293,4843,16,0,
306,1,1804,4844,16,
0,705,1,431,4845,
16,0,700,1,1443,
4846,16,0,550,1,
1756,4847,16,0,796,
1,124,4848,16,0,
285,1,525,4849,16,
0,345,1,236,4850,
16,0,387,1,346,
4851,16,0,582,1,
1876,4852,16,0,361,
1,1659,4853,16,0,
796,1,1225,4854,16,
0,272,1,1117,4855,
16,0,242,1,137,
4856,16,0,305,1,
2318,4857,16,0,796,
1,1775,4858,16,0,
705,1,32,4859,16,
0,705,1,1407,4860,
16,0,571,1,256,
4861,16,0,441,1,
459,4862,16,0,183,
1,406,4863,16,0,
662,1,41,4864,16,
0,183,1,151,4865,
16,0,317,1,43,
4866,16,0,751,1,
1990,4867,16,0,705,
1,2337,4868,16,0,
705,1,509,4869,16,
0,774,1,52,4870,
16,0,717,1,381,
4871,16,0,639,1,
447,4872,16,0,345,
1,166,4873,16,0,
332,1,462,4874,16,
0,183,1,277,4875,
16,0,488,1,1695,
4876,16,0,302,1,
2786,4877,16,0,254,
1,1261,4878,16,0,
316,1,1153,4879,16,
0,190,1,2106,4880,
16,0,705,1,1335,
4881,16,0,372,1,
71,4882,16,0,226,
1,182,4883,16,0,
345,1,76,4884,16,
0,635,1,79,4885,
16,0,241,1,1933,
4886,16,0,453,1,
299,4887,16,0,517,
1,85,4888,16,0,
541,1,1515,4889,16,
0,657,1,2198,4890,
16,0,705,1,89,
4891,16,0,253,1,
1834,4892,16,0,330,
1,1622,4893,16,0,
773,1,2413,4894,16,
0,705,1,2075,4895,
16,0,705,1,1731,
4896,16,0,274,1,
97,4897,16,0,457,
1,1297,4898,16,0,
374,1,1189,4899,16,
0,240,1,102,4900,
16,0,262,1,1585,
4901,16,0,783,1,
322,4902,16,0,543,
1,1958,4903,16,0,
705,1,199,4904,16,
0,356,1,1371,4905,
16,0,442,1,217,
4906,16,0,368,1,
157,4907,19,4908,4,
36,67,0,111,0,
110,0,115,0,116,
0,97,0,110,0,
116,0,69,0,120,
0,112,0,114,0,
101,0,115,0,115,
0,105,0,111,0,
110,0,1,157,4839,
1,158,4909,19,4910,
4,30,73,0,100,
0,101,0,110,0,
116,0,69,0,120,
0,112,0,114,0,
101,0,115,0,115,
0,105,0,111,0,
110,0,1,158,4839,
1,159,4911,19,4912,
4,36,73,0,100,
0,101,0,110,0,
116,0,68,0,111,
0,116,0,69,0,
120,0,112,0,114,
0,101,0,115,0,
115,0,105,0,111,
0,110,0,1,159,
4839,1,160,4913,19,
4914,4,44,70,0,
117,0,110,0,99,
0,116,0,105,0,
111,0,110,0,67,
0,97,0,108,0,
108,0,69,0,120,
0,112,0,114,0,
101,0,115,0,115,
0,105,0,111,0,
110,0,1,160,4839,
1,161,4915,19,4916,
4,32,66,0,105,
0,110,0,97,0,
114,0,121,0,69,
0,120,0,112,0,
114,0,101,0,115,
0,115,0,105,0,
111,0,110,0,1,
161,4839,1,162,4917,
19,4918,4,30,85,
0,110,0,97,0,
114,0,121,0,69,
0,120,0,112,0,
114,0,101,0,115,
0,115,0,105,0,
111,0,110,0,1,
162,4839,1,163,4919,
19,4920,4,36,84,
0,121,0,112,0,
101,0,99,0,97,
0,115,0,116,0,
69,0,120,0,112,
0,114,0,101,0,
115,0,115,0,105,
0,111,0,110,0,
1,163,4839,1,164,
4921,19,4922,4,42,
80,0,97,0,114,
0,101,0,110,0,
116,0,104,0,101,
0,115,0,105,0,
115,0,69,0,120,
0,112,0,114,0,
101,0,115,0,115,
0,105,0,111,0,
110,0,1,164,4839,
1,165,4923,19,4924,
4,56,73,0,110,
0,99,0,114,0,
101,0,109,0,101,
0,110,0,116,0,
68,0,101,0,99,
0,114,0,101,0,
109,0,101,0,110,
0,116,0,69,0,
120,0,112,0,114,
0,101,0,115,0,
115,0,105,0,111,
0,110,0,1,165,
4839,1,167,4925,19,
830,1,167,4269,1,
168,4926,19,808,1,
168,4269,1,169,4927,
19,3557,1,169,4272,
1,170,4928,19,3547,
1,170,4272,1,171,
4929,19,3552,1,171,
4272,1,172,4930,19,
3542,1,172,4272,1,
173,4931,19,3527,1,
173,4275,1,174,4932,
19,3562,1,174,4275,
1,175,4933,19,3521,
1,175,4279,1,176,
4934,19,3535,1,176,
4279,1,177,4935,19,
814,1,177,4283,1,
178,4936,19,825,1,
178,4283,1,179,4937,
19,820,1,179,4287,
1,180,4938,19,835,
1,180,4287,1,181,
4939,19,1777,1,181,
4293,1,182,4940,19,
1881,1,182,4293,1,
183,4941,19,1844,1,
183,4293,1,184,4942,
19,1765,1,184,4293,
1,185,4943,19,1839,
1,185,4293,1,186,
4944,19,1802,1,186,
4293,1,187,4945,19,
1834,1,187,4293,1,
188,4946,19,1797,1,
188,4293,1,189,4947,
19,1829,1,189,4293,
1,190,4948,19,1792,
1,190,4293,1,191,
4949,19,1824,1,191,
4293,1,192,4950,19,
1760,1,192,4293,1,
193,4951,19,1819,1,
193,4293,1,194,4952,
19,1787,1,194,4293,
1,195,4953,19,1814,
1,195,4293,1,196,
4954,19,1782,1,196,
4293,1,197,4955,19,
1875,1,197,4297,1,
198,4956,19,1862,1,
198,4303,1,199,4957,
19,1850,1,199,4309,
1,200,4958,19,1809,
1,200,4315,1,201,
4959,19,1868,1,201,
4321,1,202,4960,19,
1856,1,202,4327,1,
203,4961,19,1754,1,
203,4333,1,204,4962,
19,1771,1,204,4339,
1,205,4963,19,1945,
1,205,4345,1,206,
4964,19,1904,1,206,
4345,1,207,4965,19,
2337,1,207,4350,1,
208,4966,19,2308,1,
208,4353,1,209,4967,
19,2302,1,209,4356,
1,210,4968,19,2294,
1,210,4359,1,211,
4969,19,2287,1,211,
4362,1,212,4970,19,
2319,1,212,4365,1,
213,4971,19,1242,1,
213,4368,1,214,4972,
19,1964,1,214,4387,
1,215,4973,19,1890,
1,215,4391,1,216,
4974,19,1931,1,216,
4398,1,217,4975,19,
1910,1,217,4403,1,
218,4976,19,1027,1,
218,4475,1,219,4977,
19,1011,1,219,4475,
1,220,4978,19,1017,
1,220,4498,1,221,
4979,19,1005,1,221,
4498,1,222,4980,19,
1270,1,222,4514,1,
223,4981,19,907,1,
223,4501,1,224,4982,
19,1022,1,224,4501,
1,225,4983,19,902,
1,225,4501,1,226,
4984,19,927,1,226,
4501,1,227,4985,19,
896,1,227,4501,1,
228,4986,19,890,1,
228,4501,1,229,4987,
19,885,1,229,4501,
1,230,4988,19,880,
1,230,4501,1,231,
4989,19,874,1,231,
4501,1,232,4990,19,
869,1,232,4501,1,
233,4991,19,864,1,
233,4501,1,234,4992,
19,859,1,234,4501,
1,235,4993,19,854,
1,235,4501,1,236,
4994,19,1277,1,236,
4586,1,237,4995,19,
1417,1,237,4599,1,
238,4996,19,1264,1,
238,4612,1,239,4997,
19,1405,1,239,4612,
1,240,4998,19,1044,
1,240,4625,1,241,
4999,19,847,1,241,
4625,1,242,5000,19,
942,1,242,4625,1,
243,5001,19,971,1,
243,4625,1,244,5002,
19,990,1,244,4638,
1,245,5003,19,1036,
1,245,4638,1,246,
5004,19,950,1,246,
4651,1,247,5005,19,
964,1,247,4651,1,
248,5006,19,916,1,
248,4664,1,249,5007,
19,955,1,249,4664,
1,250,5008,19,1603,
1,250,4677,1,251,
5009,19,1283,1,251,
4677,1,252,5010,19,
1635,1,252,4677,1,
253,5011,19,1667,1,
253,4677,1,254,5012,
19,1532,1,254,4527,
1,255,5013,19,1592,
1,255,4527,1,256,
5014,19,1258,1,256,
4540,1,257,5015,19,
1699,1,257,4540,1,
258,5016,19,1630,1,
258,4540,1,259,5017,
19,1576,1,259,4540,
1,260,5018,19,1500,
1,260,4540,1,261,
5019,19,1427,1,261,
4540,1,262,5020,19,
1437,1,262,4540,1,
263,5021,19,1253,1,
263,4540,1,264,5022,
19,1683,1,264,4540,
1,265,5023,19,1625,
1,265,4540,1,266,
5024,19,1566,1,266,
4540,1,267,5025,19,
1489,1,267,4540,1,
268,5026,19,1453,1,
268,4540,1,269,5027,
19,1236,1,269,4540,
1,270,5028,19,1586,
1,270,4540,1,271,
5029,19,1613,1,271,
4540,1,272,5030,19,
1559,1,272,4540,1,
273,5031,19,1581,1,
273,4540,1,274,5032,
19,1393,1,274,4540,
1,275,5033,19,1297,
1,275,4540,1,276,
5034,19,1225,1,276,
4540,1,277,5035,19,
1657,1,277,4540,1,
278,5036,19,1608,1,
278,4540,1,279,5037,
19,1554,1,279,4540,
1,280,5038,19,1422,
1,280,4573,1,281,
5039,19,1400,1,281,
4573,1,282,5040,19,
1688,1,282,4763,1,
283,5041,19,1711,1,
283,4763,1,284,5042,
19,1678,1,284,4763,
1,285,5043,19,1673,
1,285,4763,1,286,
5044,19,1694,1,286,
4763,1,287,5045,19,
1641,1,287,4763,1,
288,5046,19,1347,1,
288,4763,1,289,5047,
19,1521,1,289,4839,
1,290,5048,19,1308,
1,290,4839,1,291,
5049,19,1315,1,291,
4839,1,292,5050,19,
1336,1,292,4839,1,
293,5051,19,1331,1,
293,4839,1,294,5052,
19,1326,1,294,4839,
1,295,5053,19,1321,
1,295,4839,1,296,
5054,19,1510,1,296,
4839,1,297,5055,19,
1538,1,297,4839,1,
298,5056,19,1515,1,
298,4839,1,299,5057,
19,1505,1,299,4839,
1,300,5058,19,1495,
1,300,4839,1,301,
5059,19,1478,1,301,
4839,1,302,5060,19,
1432,1,302,4839,1,
303,5061,19,1341,1,
303,4839,1,304,5062,
19,1302,1,304,4839,
1,305,5063,19,1248,
1,305,4839,1,306,
5064,19,1706,1,306,
4839,1,307,5065,19,
1662,1,307,4839,1,
308,5066,19,1652,1,
308,4839,1,309,5067,
19,1647,1,309,4839,
1,310,5068,19,1598,
1,310,4839,1,311,
5069,19,1571,1,311,
4839,1,312,5070,19,
1548,1,312,4839,1,
313,5071,19,1543,1,
313,4839,1,314,5072,
19,1484,1,314,4839,
1,315,5073,19,1460,
1,315,4839,1,316,
5074,19,1526,1,316,
4839,1,317,5075,19,
1619,1,317,4839,1,
318,5076,19,1473,1,
318,4839,1,319,5077,
19,1467,1,319,4839,
1,320,5078,19,1448,
1,320,4839,1,321,
5079,19,1411,1,321,
4839,1,322,5080,19,
1388,1,322,4839,1,
323,5081,19,1231,1,
323,4839,1,324,5082,
19,1721,1,324,4839,
1,325,5083,19,1353,
1,325,4839,1,326,
5084,19,1358,1,326,
4839,1,327,5085,19,
1378,1,327,4839,1,
328,5086,19,1368,1,
328,4839,1,329,5087,
19,1373,1,329,4839,
1,330,5088,19,1363,
1,330,4839,1,331,
5089,19,1716,1,331,
4839,1,332,5090,19,
1383,1,332,4839,1,
333,5091,19,1443,1,
333,4682,1,334,5092,
19,1958,1,334,4752,
1,335,5093,19,1951,
1,335,4752,1,336,
5094,19,1921,1,336,
4756,1,337,5095,19,
2278,1,337,4407,1,
338,5096,19,2273,1,
338,4407,1,339,5097,
19,2268,1,339,4407,
1,340,5098,19,2263,
1,340,4407,1,341,
5099,19,2258,1,341,
4407,1,342,5100,19,
2253,1,342,4407,1,
343,5101,19,2248,1,
343,4407,1,344,5102,
19,2237,1,344,4427,
1,345,5103,19,2232,
1,345,4427,1,346,
5104,19,2227,1,346,
4427,1,347,5105,19,
2222,1,347,4427,1,
348,5106,19,2217,1,
348,4427,1,349,5107,
19,2212,1,349,4427,
1,350,5108,19,2207,
1,350,4427,1,351,
5109,19,2202,1,351,
4427,1,352,5110,19,
2197,1,352,4427,1,
353,5111,19,2191,1,
353,4433,1,354,5112,
19,2019,1,354,4433,
1,355,5113,19,2185,
1,355,4433,1,356,
5114,19,2180,1,356,
4433,1,357,5115,19,
2175,1,357,4433,1,
358,5116,19,2012,1,
358,4433,1,359,5117,
19,2170,1,359,4433,
1,360,5118,19,2165,
1,360,4433,1,361,
5119,19,2160,1,361,
4439,1,362,5120,19,
2155,1,362,4439,1,
363,5121,19,2149,1,
363,4445,1,364,5122,
19,2144,1,364,4445,
1,365,5123,19,2004,
1,365,4445,1,366,
5124,19,2138,1,366,
4445,1,367,5125,19,
2133,1,367,4445,1,
368,5126,19,2128,1,
368,4445,1,369,5127,
19,1997,1,369,4445,
1,370,5128,19,2122,
1,370,4445,1,371,
5129,19,2049,1,371,
4445,1,372,5130,19,
2117,1,372,4445,1,
373,5131,19,2112,1,
373,4451,1,374,5132,
19,2107,1,374,4451,
1,375,5133,19,2102,
1,375,4451,1,376,
5134,19,2096,1,376,
4457,1,377,5135,19,
2090,1,377,4463,1,
378,5136,19,2084,1,
378,4469,1,379,5137,
19,5138,4,50,65,
0,114,0,103,0,
117,0,109,0,101,
0,110,0,116,0,
68,0,101,0,99,
0,108,0,97,0,
114,0,97,0,116,
0,105,0,111,0,
110,0,76,0,105,
0,115,0,116,0,
95,0,51,0,1,
379,4345,1,380,5139,
19,5140,4,28,65,
0,114,0,103,0,
117,0,109,0,101,
0,110,0,116,0,
76,0,105,0,115,
0,116,0,95,0,
51,0,1,380,4752,
1,381,5141,19,5142,
4,28,65,0,114,
0,103,0,117,0,
109,0,101,0,110,
0,116,0,76,0,
105,0,115,0,116,
0,95,0,52,0,
1,381,4752,1,382,
5143,19,5144,4,50,
65,0,114,0,103,
0,117,0,109,0,
101,0,110,0,116,
0,68,0,101,0,
99,0,108,0,97,
0,114,0,97,0,
116,0,105,0,111,
0,110,0,76,0,
105,0,115,0,116,
0,95,0,52,0,
1,382,4345,1,383,
5145,19,5146,4,50,
65,0,114,0,103,
0,117,0,109,0,
101,0,110,0,116,
0,68,0,101,0,
99,0,108,0,97,
0,114,0,97,0,
116,0,105,0,111,
0,110,0,76,0,
105,0,115,0,116,
0,95,0,53,0,
1,383,4345,2,0,0};
new Sfactory(this,"ExpressionArgument_1",new SCreator(ExpressionArgument_1_factory));
new Sfactory(this,"VectorArgStateEvent",new SCreator(VectorArgStateEvent_factory));
new Sfactory(this,"IntVecVecArgStateEvent",new SCreator(IntVecVecArgStateEvent_factory));
new Sfactory(this,"IntArgStateEvent_1",new SCreator(IntArgStateEvent_1_factory));
new Sfactory(this,"SimpleAssignment_9",new SCreator(SimpleAssignment_9_factory));
new Sfactory(this,"StatementList_1",new SCreator(StatementList_1_factory));
new Sfactory(this,"RotDeclaration_1",new SCreator(RotDeclaration_1_factory));
new Sfactory(this,"IntRotRotArgEvent_1",new SCreator(IntRotRotArgEvent_1_factory));
new Sfactory(this,"StateChange_1",new SCreator(StateChange_1_factory));
new Sfactory(this,"EmptyStatement",new SCreator(EmptyStatement_factory));
new Sfactory(this,"Declaration",new SCreator(Declaration_factory));
new Sfactory(this,"IdentExpression",new SCreator(IdentExpression_factory));
new Sfactory(this,"error",new SCreator(error_factory));
new Sfactory(this,"BinaryExpression_2",new SCreator(BinaryExpression_2_factory));
new Sfactory(this,"BinaryExpression_3",new SCreator(BinaryExpression_3_factory));
new Sfactory(this,"BinaryExpression_4",new SCreator(BinaryExpression_4_factory));
new Sfactory(this,"BinaryExpression_5",new SCreator(BinaryExpression_5_factory));
new Sfactory(this,"ReturnStatement_2",new SCreator(ReturnStatement_2_factory));
new Sfactory(this,"SimpleAssignment_19",new SCreator(SimpleAssignment_19_factory));
new Sfactory(this,"BinaryExpression_9",new SCreator(BinaryExpression_9_factory));
new Sfactory(this,"VectorConstant_1",new SCreator(VectorConstant_1_factory));
new Sfactory(this,"ParenthesisExpression",new SCreator(ParenthesisExpression_factory));
new Sfactory(this,"StatementList",new SCreator(StatementList_factory));
new Sfactory(this,"IntRotRotArgEvent",new SCreator(IntRotRotArgEvent_factory));
new Sfactory(this,"UnaryExpression",new SCreator(UnaryExpression_factory));
new Sfactory(this,"IdentDotExpression_1",new SCreator(IdentDotExpression_1_factory));
new Sfactory(this,"ArgumentList_4",new SCreator(ArgumentList_4_factory));
new Sfactory(this,"Typename",new SCreator(Typename_factory));
new Sfactory(this,"IfStatement_1",new SCreator(IfStatement_1_factory));
new Sfactory(this,"RotationConstant_1",new SCreator(RotationConstant_1_factory));
new Sfactory(this,"Assignment",new SCreator(Assignment_factory));
new Sfactory(this,"IfStatement_4",new SCreator(IfStatement_4_factory));
new Sfactory(this,"CompoundStatement_1",new SCreator(CompoundStatement_1_factory));
new Sfactory(this,"CompoundStatement_2",new SCreator(CompoundStatement_2_factory));
new Sfactory(this,"KeyIntIntArgumentDeclarationList_1",new SCreator(KeyIntIntArgumentDeclarationList_1_factory));
new Sfactory(this,"BinaryExpression_8",new SCreator(BinaryExpression_8_factory));
new Sfactory(this,"VectorArgEvent",new SCreator(VectorArgEvent_factory));
new Sfactory(this,"ReturnStatement_1",new SCreator(ReturnStatement_1_factory));
new Sfactory(this,"IdentDotExpression",new SCreator(IdentDotExpression_factory));
new Sfactory(this,"Argument",new SCreator(Argument_factory));
new Sfactory(this,"State_2",new SCreator(State_2_factory));
new Sfactory(this,"GlobalDefinitions_3",new SCreator(GlobalDefinitions_3_factory));
new Sfactory(this,"GlobalDefinitions_4",new SCreator(GlobalDefinitions_4_factory));
new Sfactory(this,"Event_1",new SCreator(Event_1_factory));
new Sfactory(this,"ListConstant",new SCreator(ListConstant_factory));
new Sfactory(this,"Event_3",new SCreator(Event_3_factory));
new Sfactory(this,"Event_4",new SCreator(Event_4_factory));
new Sfactory(this,"Event_5",new SCreator(Event_5_factory));
new Sfactory(this,"SimpleAssignment_5",new SCreator(SimpleAssignment_5_factory));
new Sfactory(this,"Typename_1",new SCreator(Typename_1_factory));
new Sfactory(this,"VoidArgStateEvent_1",new SCreator(VoidArgStateEvent_1_factory));
new Sfactory(this,"Typename_3",new SCreator(Typename_3_factory));
new Sfactory(this,"IntRotRotArgStateEvent",new SCreator(IntRotRotArgStateEvent_factory));
new Sfactory(this,"Typename_5",new SCreator(Typename_5_factory));
new Sfactory(this,"Typename_6",new SCreator(Typename_6_factory));
new Sfactory(this,"Typename_7",new SCreator(Typename_7_factory));
new Sfactory(this,"ArgumentDeclarationList",new SCreator(ArgumentDeclarationList_factory));
new Sfactory(this,"ConstantExpression",new SCreator(ConstantExpression_factory));
new Sfactory(this,"LSLProgramRoot_1",new SCreator(LSLProgramRoot_1_factory));
new Sfactory(this,"LSLProgramRoot_2",new SCreator(LSLProgramRoot_2_factory));
new Sfactory(this,"KeyIntIntArgEvent_1",new SCreator(KeyIntIntArgEvent_1_factory));
new Sfactory(this,"States_1",new SCreator(States_1_factory));
new Sfactory(this,"States_2",new SCreator(States_2_factory));
new Sfactory(this,"FunctionCallExpression_1",new SCreator(FunctionCallExpression_1_factory));
new Sfactory(this,"KeyArgEvent_1",new SCreator(KeyArgEvent_1_factory));
new Sfactory(this,"ForLoopStatement",new SCreator(ForLoopStatement_factory));
new Sfactory(this,"IntArgStateEvent",new SCreator(IntArgStateEvent_factory));
new Sfactory(this,"StateBody_15",new SCreator(StateBody_15_factory));
new Sfactory(this,"IntRotRotArgumentDeclarationList_1",new SCreator(IntRotRotArgumentDeclarationList_1_factory));
new Sfactory(this,"IntArgEvent_9",new SCreator(IntArgEvent_9_factory));
new Sfactory(this,"DoWhileStatement_1",new SCreator(DoWhileStatement_1_factory));
new Sfactory(this,"DoWhileStatement_2",new SCreator(DoWhileStatement_2_factory));
new Sfactory(this,"ForLoopStatement_4",new SCreator(ForLoopStatement_4_factory));
new Sfactory(this,"SimpleAssignment_11",new SCreator(SimpleAssignment_11_factory));
new Sfactory(this,"SimpleAssignment_12",new SCreator(SimpleAssignment_12_factory));
new Sfactory(this,"SimpleAssignment_13",new SCreator(SimpleAssignment_13_factory));
new Sfactory(this,"JumpLabel",new SCreator(JumpLabel_factory));
new Sfactory(this,"SimpleAssignment_15",new SCreator(SimpleAssignment_15_factory));
new Sfactory(this,"IntVecVecArgEvent",new SCreator(IntVecVecArgEvent_factory));
new Sfactory(this,"VecDeclaration",new SCreator(VecDeclaration_factory));
new Sfactory(this,"StateBody_14",new SCreator(StateBody_14_factory));
new Sfactory(this,"GlobalDefinitions",new SCreator(GlobalDefinitions_factory));
new Sfactory(this,"StateBody_16",new SCreator(StateBody_16_factory));
new Sfactory(this,"KeyIntIntArgumentDeclarationList",new SCreator(KeyIntIntArgumentDeclarationList_factory));
new Sfactory(this,"ConstantExpression_1",new SCreator(ConstantExpression_1_factory));
new Sfactory(this,"VoidArgEvent_4",new SCreator(VoidArgEvent_4_factory));
new Sfactory(this,"FunctionCall_1",new SCreator(FunctionCall_1_factory));
new Sfactory(this,"Assignment_1",new SCreator(Assignment_1_factory));
new Sfactory(this,"Assignment_2",new SCreator(Assignment_2_factory));
new Sfactory(this,"IntVecVecArgEvent_1",new SCreator(IntVecVecArgEvent_1_factory));
new Sfactory(this,"TypecastExpression_1",new SCreator(TypecastExpression_1_factory));
new Sfactory(this,"SimpleAssignment_21",new SCreator(SimpleAssignment_21_factory));
new Sfactory(this,"SimpleAssignment_22",new SCreator(SimpleAssignment_22_factory));
new Sfactory(this,"KeyIntIntArgStateEvent",new SCreator(KeyIntIntArgStateEvent_factory));
new Sfactory(this,"TypecastExpression_9",new SCreator(TypecastExpression_9_factory));
new Sfactory(this,"VoidArgEvent_2",new SCreator(VoidArgEvent_2_factory));
new Sfactory(this,"Event_9",new SCreator(Event_9_factory));
new Sfactory(this,"ArgumentDeclarationList_1",new SCreator(ArgumentDeclarationList_1_factory));
new Sfactory(this,"ArgumentDeclarationList_2",new SCreator(ArgumentDeclarationList_2_factory));
new Sfactory(this,"GlobalDefinitions_1",new SCreator(GlobalDefinitions_1_factory));
new Sfactory(this,"GlobalDefinitions_2",new SCreator(GlobalDefinitions_2_factory));
new Sfactory(this,"IncrementDecrementExpression",new SCreator(IncrementDecrementExpression_factory));
new Sfactory(this,"GlobalVariableDeclaration",new SCreator(GlobalVariableDeclaration_factory));
new Sfactory(this,"IntArgumentDeclarationList_1",new SCreator(IntArgumentDeclarationList_1_factory));
new Sfactory(this,"IntDeclaration_1",new SCreator(IntDeclaration_1_factory));
new Sfactory(this,"ArgumentDeclarationList_5",new SCreator(ArgumentDeclarationList_5_factory));
new Sfactory(this,"IntVecVecArgumentDeclarationList",new SCreator(IntVecVecArgumentDeclarationList_factory));
new Sfactory(this,"VectorArgumentDeclarationList_1",new SCreator(VectorArgumentDeclarationList_1_factory));
new Sfactory(this,"KeyArgumentDeclarationList",new SCreator(KeyArgumentDeclarationList_factory));
new Sfactory(this,"TypecastExpression_2",new SCreator(TypecastExpression_2_factory));
new Sfactory(this,"KeyArgStateEvent",new SCreator(KeyArgStateEvent_factory));
new Sfactory(this,"TypecastExpression_5",new SCreator(TypecastExpression_5_factory));
new Sfactory(this,"TypecastExpression_8",new SCreator(TypecastExpression_8_factory));
new Sfactory(this,"Constant_1",new SCreator(Constant_1_factory));
new Sfactory(this,"Expression",new SCreator(Expression_factory));
new Sfactory(this,"Constant_3",new SCreator(Constant_3_factory));
new Sfactory(this,"Constant_4",new SCreator(Constant_4_factory));
new Sfactory(this,"IntArgEvent_5",new SCreator(IntArgEvent_5_factory));
new Sfactory(this,"BinaryExpression_1",new SCreator(BinaryExpression_1_factory));
new Sfactory(this,"IfStatement_2",new SCreator(IfStatement_2_factory));
new Sfactory(this,"IfStatement_3",new SCreator(IfStatement_3_factory));
new Sfactory(this,"KeyArgEvent",new SCreator(KeyArgEvent_factory));
new Sfactory(this,"Event_2",new SCreator(Event_2_factory));
new Sfactory(this,"JumpLabel_1",new SCreator(JumpLabel_1_factory));
new Sfactory(this,"RotationConstant",new SCreator(RotationConstant_factory));
new Sfactory(this,"Statement_12",new SCreator(Statement_12_factory));
new Sfactory(this,"Statement_13",new SCreator(Statement_13_factory));
new Sfactory(this,"UnaryExpression_1",new SCreator(UnaryExpression_1_factory));
new Sfactory(this,"UnaryExpression_2",new SCreator(UnaryExpression_2_factory));
new Sfactory(this,"UnaryExpression_3",new SCreator(UnaryExpression_3_factory));
new Sfactory(this,"ArgumentList_1",new SCreator(ArgumentList_1_factory));
new Sfactory(this,"KeyIntIntArgEvent",new SCreator(KeyIntIntArgEvent_factory));
new Sfactory(this,"ArgumentList_3",new SCreator(ArgumentList_3_factory));
new Sfactory(this,"Constant",new SCreator(Constant_factory));
new Sfactory(this,"State",new SCreator(State_factory));
new Sfactory(this,"StateBody_13",new SCreator(StateBody_13_factory));
new Sfactory(this,"KeyArgStateEvent_1",new SCreator(KeyArgStateEvent_1_factory));
new Sfactory(this,"SimpleAssignment_8",new SCreator(SimpleAssignment_8_factory));
new Sfactory(this,"LSLProgramRoot",new SCreator(LSLProgramRoot_factory));
new Sfactory(this,"StateChange",new SCreator(StateChange_factory));
new Sfactory(this,"VecDeclaration_1",new SCreator(VecDeclaration_1_factory));
new Sfactory(this,"GlobalVariableDeclaration_1",new SCreator(GlobalVariableDeclaration_1_factory));
new Sfactory(this,"GlobalVariableDeclaration_2",new SCreator(GlobalVariableDeclaration_2_factory));
new Sfactory(this,"IncrementDecrementExpression_5",new SCreator(IncrementDecrementExpression_5_factory));
new Sfactory(this,"ReturnStatement",new SCreator(ReturnStatement_factory));
new Sfactory(this,"StateBody_10",new SCreator(StateBody_10_factory));
new Sfactory(this,"StateBody_11",new SCreator(StateBody_11_factory));
new Sfactory(this,"StateBody_12",new SCreator(StateBody_12_factory));
new Sfactory(this,"IntVecVecArgStateEvent_1",new SCreator(IntVecVecArgStateEvent_1_factory));
new Sfactory(this,"KeyDeclaration",new SCreator(KeyDeclaration_factory));
new Sfactory(this,"IntArgEvent_6",new SCreator(IntArgEvent_6_factory));
new Sfactory(this,"ArgumentDeclarationList_3",new SCreator(ArgumentDeclarationList_3_factory));
new Sfactory(this,"ArgumentList_2",new SCreator(ArgumentList_2_factory));
new Sfactory(this,"IntArgEvent_10",new SCreator(IntArgEvent_10_factory));
new Sfactory(this,"CompoundStatement",new SCreator(CompoundStatement_factory));
new Sfactory(this,"TypecastExpression_3",new SCreator(TypecastExpression_3_factory));
new Sfactory(this,"IntArgumentDeclarationList",new SCreator(IntArgumentDeclarationList_factory));
new Sfactory(this,"ArgumentDeclarationList_4",new SCreator(ArgumentDeclarationList_4_factory));
new Sfactory(this,"SimpleAssignment_3",new SCreator(SimpleAssignment_3_factory));
new Sfactory(this,"SimpleAssignment_4",new SCreator(SimpleAssignment_4_factory));
new Sfactory(this,"Statement_1",new SCreator(Statement_1_factory));
new Sfactory(this,"Statement_2",new SCreator(Statement_2_factory));
new Sfactory(this,"Statement_4",new SCreator(Statement_4_factory));
new Sfactory(this,"Statement_5",new SCreator(Statement_5_factory));
new Sfactory(this,"Statement_6",new SCreator(Statement_6_factory));
new Sfactory(this,"Statement_8",new SCreator(Statement_8_factory));
new Sfactory(this,"Statement_9",new SCreator(Statement_9_factory));
new Sfactory(this,"ExpressionArgument",new SCreator(ExpressionArgument_factory));
new Sfactory(this,"GlobalFunctionDefinition",new SCreator(GlobalFunctionDefinition_factory));
new Sfactory(this,"State_1",new SCreator(State_1_factory));
new Sfactory(this,"DoWhileStatement",new SCreator(DoWhileStatement_factory));
new Sfactory(this,"ParenthesisExpression_1",new SCreator(ParenthesisExpression_1_factory));
new Sfactory(this,"ParenthesisExpression_2",new SCreator(ParenthesisExpression_2_factory));
new Sfactory(this,"StateBody",new SCreator(StateBody_factory));
new Sfactory(this,"Event_7",new SCreator(Event_7_factory));
new Sfactory(this,"Event_8",new SCreator(Event_8_factory));
new Sfactory(this,"IncrementDecrementExpression_1",new SCreator(IncrementDecrementExpression_1_factory));
new Sfactory(this,"IncrementDecrementExpression_2",new SCreator(IncrementDecrementExpression_2_factory));
new Sfactory(this,"IntVecVecArgumentDeclarationList_1",new SCreator(IntVecVecArgumentDeclarationList_1_factory));
new Sfactory(this,"IncrementDecrementExpression_4",new SCreator(IncrementDecrementExpression_4_factory));
new Sfactory(this,"IncrementDecrementExpression_6",new SCreator(IncrementDecrementExpression_6_factory));
new Sfactory(this,"IncrementDecrementExpression_7",new SCreator(IncrementDecrementExpression_7_factory));
new Sfactory(this,"StateEvent",new SCreator(StateEvent_factory));
new Sfactory(this,"IntArgEvent_3",new SCreator(IntArgEvent_3_factory));
new Sfactory(this,"IntArgEvent_4",new SCreator(IntArgEvent_4_factory));
new Sfactory(this,"KeyDeclaration_1",new SCreator(KeyDeclaration_1_factory));
new Sfactory(this,"Statement_3",new SCreator(Statement_3_factory));
new Sfactory(this,"IntArgEvent_7",new SCreator(IntArgEvent_7_factory));
new Sfactory(this,"IntArgEvent_8",new SCreator(IntArgEvent_8_factory));
new Sfactory(this,"SimpleAssignment_10",new SCreator(SimpleAssignment_10_factory));
new Sfactory(this,"StatementList_2",new SCreator(StatementList_2_factory));
new Sfactory(this,"IntRotRotArgStateEvent_1",new SCreator(IntRotRotArgStateEvent_1_factory));
new Sfactory(this,"VectorArgEvent_2",new SCreator(VectorArgEvent_2_factory));
new Sfactory(this,"Event",new SCreator(Event_factory));
new Sfactory(this,"SimpleAssignment_14",new SCreator(SimpleAssignment_14_factory));
new Sfactory(this,"SimpleAssignment_16",new SCreator(SimpleAssignment_16_factory));
new Sfactory(this,"SimpleAssignment_17",new SCreator(SimpleAssignment_17_factory));
new Sfactory(this,"SimpleAssignment_18",new SCreator(SimpleAssignment_18_factory));
new Sfactory(this,"Statement_10",new SCreator(Statement_10_factory));
new Sfactory(this,"Statement_11",new SCreator(Statement_11_factory));
new Sfactory(this,"SimpleAssignment",new SCreator(SimpleAssignment_factory));
new Sfactory(this,"TypecastExpression",new SCreator(TypecastExpression_factory));
new Sfactory(this,"JumpStatement_1",new SCreator(JumpStatement_1_factory));
new Sfactory(this,"SimpleAssignment_20",new SCreator(SimpleAssignment_20_factory));
new Sfactory(this,"Statement_7",new SCreator(Statement_7_factory));
new Sfactory(this,"SimpleAssignment_23",new SCreator(SimpleAssignment_23_factory));
new Sfactory(this,"SimpleAssignment_24",new SCreator(SimpleAssignment_24_factory));
new Sfactory(this,"SimpleAssignment_1",new SCreator(SimpleAssignment_1_factory));
new Sfactory(this,"SimpleAssignment_2",new SCreator(SimpleAssignment_2_factory));
new Sfactory(this,"BinaryExpression",new SCreator(BinaryExpression_factory));
new Sfactory(this,"FunctionCallExpression",new SCreator(FunctionCallExpression_factory));
new Sfactory(this,"SimpleAssignment_6",new SCreator(SimpleAssignment_6_factory));
new Sfactory(this,"StateBody_1",new SCreator(StateBody_1_factory));
new Sfactory(this,"StateBody_2",new SCreator(StateBody_2_factory));
new Sfactory(this,"StateBody_3",new SCreator(StateBody_3_factory));
new Sfactory(this,"StateBody_4",new SCreator(StateBody_4_factory));
new Sfactory(this,"StateBody_5",new SCreator(StateBody_5_factory));
new Sfactory(this,"StateBody_6",new SCreator(StateBody_6_factory));
new Sfactory(this,"StateBody_7",new SCreator(StateBody_7_factory));
new Sfactory(this,"StateBody_8",new SCreator(StateBody_8_factory));
new Sfactory(this,"StateBody_9",new SCreator(StateBody_9_factory));
new Sfactory(this,"Statement",new SCreator(Statement_factory));
new Sfactory(this,"IncrementDecrementExpression_3",new SCreator(IncrementDecrementExpression_3_factory));
new Sfactory(this,"JumpStatement",new SCreator(JumpStatement_factory));
new Sfactory(this,"BinaryExpression_11",new SCreator(BinaryExpression_11_factory));
new Sfactory(this,"IntArgEvent",new SCreator(IntArgEvent_factory));
new Sfactory(this,"IncrementDecrementExpression_8",new SCreator(IncrementDecrementExpression_8_factory));
new Sfactory(this,"BinaryExpression_14",new SCreator(BinaryExpression_14_factory));
new Sfactory(this,"BinaryExpression_15",new SCreator(BinaryExpression_15_factory));
new Sfactory(this,"BinaryExpression_16",new SCreator(BinaryExpression_16_factory));
new Sfactory(this,"BinaryExpression_6",new SCreator(BinaryExpression_6_factory));
new Sfactory(this,"BinaryExpression_7",new SCreator(BinaryExpression_7_factory));
new Sfactory(this,"Typename_2",new SCreator(Typename_2_factory));
new Sfactory(this,"Typename_4",new SCreator(Typename_4_factory));
new Sfactory(this,"ArgumentList",new SCreator(ArgumentList_factory));
new Sfactory(this,"BinaryExpression_12",new SCreator(BinaryExpression_12_factory));
new Sfactory(this,"BinaryExpression_13",new SCreator(BinaryExpression_13_factory));
new Sfactory(this,"GlobalFunctionDefinition_2",new SCreator(GlobalFunctionDefinition_2_factory));
new Sfactory(this,"StateChange_2",new SCreator(StateChange_2_factory));
new Sfactory(this,"VoidArgEvent_1",new SCreator(VoidArgEvent_1_factory));
new Sfactory(this,"VoidArgEvent_3",new SCreator(VoidArgEvent_3_factory));
new Sfactory(this,"BinaryExpression_10",new SCreator(BinaryExpression_10_factory));
new Sfactory(this,"VoidArgEvent_5",new SCreator(VoidArgEvent_5_factory));
new Sfactory(this,"VoidArgEvent_6",new SCreator(VoidArgEvent_6_factory));
new Sfactory(this,"VoidArgEvent_7",new SCreator(VoidArgEvent_7_factory));
new Sfactory(this,"VoidArgEvent_8",new SCreator(VoidArgEvent_8_factory));
new Sfactory(this,"BinaryExpression_17",new SCreator(BinaryExpression_17_factory));
new Sfactory(this,"StateEvent_1",new SCreator(StateEvent_1_factory));
new Sfactory(this,"VectorConstant",new SCreator(VectorConstant_factory));
new Sfactory(this,"VectorArgEvent_1",new SCreator(VectorArgEvent_1_factory));
new Sfactory(this,"IntDeclaration",new SCreator(IntDeclaration_factory));
new Sfactory(this,"VectorArgEvent_3",new SCreator(VectorArgEvent_3_factory));
new Sfactory(this,"TypecastExpression_4",new SCreator(TypecastExpression_4_factory));
new Sfactory(this,"TypecastExpression_6",new SCreator(TypecastExpression_6_factory));
new Sfactory(this,"TypecastExpression_7",new SCreator(TypecastExpression_7_factory));
new Sfactory(this,"FunctionCall",new SCreator(FunctionCall_factory));
new Sfactory(this,"ListConstant_1",new SCreator(ListConstant_1_factory));
new Sfactory(this,"BinaryExpression_18",new SCreator(BinaryExpression_18_factory));
new Sfactory(this,"Event_6",new SCreator(Event_6_factory));
new Sfactory(this,"KeyArgEvent_2",new SCreator(KeyArgEvent_2_factory));
new Sfactory(this,"Declaration_1",new SCreator(Declaration_1_factory));
new Sfactory(this,"EmptyStatement_1",new SCreator(EmptyStatement_1_factory));
new Sfactory(this,"SimpleAssignment_7",new SCreator(SimpleAssignment_7_factory));
new Sfactory(this,"ForLoop",new SCreator(ForLoop_factory));
new Sfactory(this,"ForLoop_2",new SCreator(ForLoop_2_factory));
new Sfactory(this,"KeyIntIntArgStateEvent_1",new SCreator(KeyIntIntArgStateEvent_1_factory));
new Sfactory(this,"KeyArgumentDeclarationList_1",new SCreator(KeyArgumentDeclarationList_1_factory));
new Sfactory(this,"GlobalFunctionDefinition_1",new SCreator(GlobalFunctionDefinition_1_factory));
new Sfactory(this,"IfStatement",new SCreator(IfStatement_factory));
new Sfactory(this,"ForLoopStatement_1",new SCreator(ForLoopStatement_1_factory));
new Sfactory(this,"ForLoopStatement_2",new SCreator(ForLoopStatement_2_factory));
new Sfactory(this,"ForLoopStatement_3",new SCreator(ForLoopStatement_3_factory));
new Sfactory(this,"IntRotRotArgumentDeclarationList",new SCreator(IntRotRotArgumentDeclarationList_factory));
new Sfactory(this,"IntArgEvent_1",new SCreator(IntArgEvent_1_factory));
new Sfactory(this,"IntArgEvent_2",new SCreator(IntArgEvent_2_factory));
new Sfactory(this,"WhileStatement",new SCreator(WhileStatement_factory));
new Sfactory(this,"ForLoop_1",new SCreator(ForLoop_1_factory));
new Sfactory(this,"Constant_2",new SCreator(Constant_2_factory));
new Sfactory(this,"VoidArgEvent",new SCreator(VoidArgEvent_factory));
new Sfactory(this,"RotDeclaration",new SCreator(RotDeclaration_factory));
new Sfactory(this,"WhileStatement_1",new SCreator(WhileStatement_1_factory));
new Sfactory(this,"WhileStatement_2",new SCreator(WhileStatement_2_factory));
new Sfactory(this,"VectorArgStateEvent_1",new SCreator(VectorArgStateEvent_1_factory));
new Sfactory(this,"IdentExpression_1",new SCreator(IdentExpression_1_factory));
new Sfactory(this,"VectorArgumentDeclarationList",new SCreator(VectorArgumentDeclarationList_factory));
new Sfactory(this,"States",new SCreator(States_factory));
new Sfactory(this,"VoidArgStateEvent",new SCreator(VoidArgStateEvent_factory));
}
public static object ExpressionArgument_1_factory(Parser yyp) { return new ExpressionArgument_1(yyp); }
public static object VectorArgStateEvent_factory(Parser yyp) { return new VectorArgStateEvent(yyp); }
public static object IntVecVecArgStateEvent_factory(Parser yyp) { return new IntVecVecArgStateEvent(yyp); }
public static object IntArgStateEvent_1_factory(Parser yyp) { return new IntArgStateEvent_1(yyp); }
public static object SimpleAssignment_9_factory(Parser yyp) { return new SimpleAssignment_9(yyp); }
public static object StatementList_1_factory(Parser yyp) { return new StatementList_1(yyp); }
public static object RotDeclaration_1_factory(Parser yyp) { return new RotDeclaration_1(yyp); }
public static object IntRotRotArgEvent_1_factory(Parser yyp) { return new IntRotRotArgEvent_1(yyp); }
public static object StateChange_1_factory(Parser yyp) { return new StateChange_1(yyp); }
public static object EmptyStatement_factory(Parser yyp) { return new EmptyStatement(yyp); }
public static object Declaration_factory(Parser yyp) { return new Declaration(yyp); }
public static object IdentExpression_factory(Parser yyp) { return new IdentExpression(yyp); }
public static object error_factory(Parser yyp) { return new error(yyp); }
public static object BinaryExpression_2_factory(Parser yyp) { return new BinaryExpression_2(yyp); }
public static object BinaryExpression_3_factory(Parser yyp) { return new BinaryExpression_3(yyp); }
public static object BinaryExpression_4_factory(Parser yyp) { return new BinaryExpression_4(yyp); }
public static object BinaryExpression_5_factory(Parser yyp) { return new BinaryExpression_5(yyp); }
public static object ReturnStatement_2_factory(Parser yyp) { return new ReturnStatement_2(yyp); }
public static object SimpleAssignment_19_factory(Parser yyp) { return new SimpleAssignment_19(yyp); }
public static object BinaryExpression_9_factory(Parser yyp) { return new BinaryExpression_9(yyp); }
public static object VectorConstant_1_factory(Parser yyp) { return new VectorConstant_1(yyp); }
public static object ParenthesisExpression_factory(Parser yyp) { return new ParenthesisExpression(yyp); }
public static object StatementList_factory(Parser yyp) { return new StatementList(yyp); }
public static object IntRotRotArgEvent_factory(Parser yyp) { return new IntRotRotArgEvent(yyp); }
public static object UnaryExpression_factory(Parser yyp) { return new UnaryExpression(yyp); }
public static object IdentDotExpression_1_factory(Parser yyp) { return new IdentDotExpression_1(yyp); }
public static object ArgumentList_4_factory(Parser yyp) { return new ArgumentList_4(yyp); }
public static object Typename_factory(Parser yyp) { return new Typename(yyp); }
public static object IfStatement_1_factory(Parser yyp) { return new IfStatement_1(yyp); }
public static object RotationConstant_1_factory(Parser yyp) { return new RotationConstant_1(yyp); }
public static object Assignment_factory(Parser yyp) { return new Assignment(yyp); }
public static object IfStatement_4_factory(Parser yyp) { return new IfStatement_4(yyp); }
public static object CompoundStatement_1_factory(Parser yyp) { return new CompoundStatement_1(yyp); }
public static object CompoundStatement_2_factory(Parser yyp) { return new CompoundStatement_2(yyp); }
public static object KeyIntIntArgumentDeclarationList_1_factory(Parser yyp) { return new KeyIntIntArgumentDeclarationList_1(yyp); }
public static object BinaryExpression_8_factory(Parser yyp) { return new BinaryExpression_8(yyp); }
public static object VectorArgEvent_factory(Parser yyp) { return new VectorArgEvent(yyp); }
public static object ReturnStatement_1_factory(Parser yyp) { return new ReturnStatement_1(yyp); }
public static object IdentDotExpression_factory(Parser yyp) { return new IdentDotExpression(yyp); }
public static object Argument_factory(Parser yyp) { return new Argument(yyp); }
public static object State_2_factory(Parser yyp) { return new State_2(yyp); }
public static object GlobalDefinitions_3_factory(Parser yyp) { return new GlobalDefinitions_3(yyp); }
public static object GlobalDefinitions_4_factory(Parser yyp) { return new GlobalDefinitions_4(yyp); }
public static object Event_1_factory(Parser yyp) { return new Event_1(yyp); }
public static object ListConstant_factory(Parser yyp) { return new ListConstant(yyp); }
public static object Event_3_factory(Parser yyp) { return new Event_3(yyp); }
public static object Event_4_factory(Parser yyp) { return new Event_4(yyp); }
public static object Event_5_factory(Parser yyp) { return new Event_5(yyp); }
public static object SimpleAssignment_5_factory(Parser yyp) { return new SimpleAssignment_5(yyp); }
public static object Typename_1_factory(Parser yyp) { return new Typename_1(yyp); }
public static object VoidArgStateEvent_1_factory(Parser yyp) { return new VoidArgStateEvent_1(yyp); }
public static object Typename_3_factory(Parser yyp) { return new Typename_3(yyp); }
public static object IntRotRotArgStateEvent_factory(Parser yyp) { return new IntRotRotArgStateEvent(yyp); }
public static object Typename_5_factory(Parser yyp) { return new Typename_5(yyp); }
public static object Typename_6_factory(Parser yyp) { return new Typename_6(yyp); }
public static object Typename_7_factory(Parser yyp) { return new Typename_7(yyp); }
public static object ArgumentDeclarationList_factory(Parser yyp) { return new ArgumentDeclarationList(yyp); }
public static object ConstantExpression_factory(Parser yyp) { return new ConstantExpression(yyp); }
public static object LSLProgramRoot_1_factory(Parser yyp) { return new LSLProgramRoot_1(yyp); }
public static object LSLProgramRoot_2_factory(Parser yyp) { return new LSLProgramRoot_2(yyp); }
public static object KeyIntIntArgEvent_1_factory(Parser yyp) { return new KeyIntIntArgEvent_1(yyp); }
public static object States_1_factory(Parser yyp) { return new States_1(yyp); }
public static object States_2_factory(Parser yyp) { return new States_2(yyp); }
public static object FunctionCallExpression_1_factory(Parser yyp) { return new FunctionCallExpression_1(yyp); }
public static object KeyArgEvent_1_factory(Parser yyp) { return new KeyArgEvent_1(yyp); }
public static object ForLoopStatement_factory(Parser yyp) { return new ForLoopStatement(yyp); }
public static object IntArgStateEvent_factory(Parser yyp) { return new IntArgStateEvent(yyp); }
public static object StateBody_15_factory(Parser yyp) { return new StateBody_15(yyp); }
public static object IntRotRotArgumentDeclarationList_1_factory(Parser yyp) { return new IntRotRotArgumentDeclarationList_1(yyp); }
public static object IntArgEvent_9_factory(Parser yyp) { return new IntArgEvent_9(yyp); }
public static object DoWhileStatement_1_factory(Parser yyp) { return new DoWhileStatement_1(yyp); }
public static object DoWhileStatement_2_factory(Parser yyp) { return new DoWhileStatement_2(yyp); }
public static object ForLoopStatement_4_factory(Parser yyp) { return new ForLoopStatement_4(yyp); }
public static object SimpleAssignment_11_factory(Parser yyp) { return new SimpleAssignment_11(yyp); }
public static object SimpleAssignment_12_factory(Parser yyp) { return new SimpleAssignment_12(yyp); }
public static object SimpleAssignment_13_factory(Parser yyp) { return new SimpleAssignment_13(yyp); }
public static object JumpLabel_factory(Parser yyp) { return new JumpLabel(yyp); }
public static object SimpleAssignment_15_factory(Parser yyp) { return new SimpleAssignment_15(yyp); }
public static object IntVecVecArgEvent_factory(Parser yyp) { return new IntVecVecArgEvent(yyp); }
public static object VecDeclaration_factory(Parser yyp) { return new VecDeclaration(yyp); }
public static object StateBody_14_factory(Parser yyp) { return new StateBody_14(yyp); }
public static object GlobalDefinitions_factory(Parser yyp) { return new GlobalDefinitions(yyp); }
public static object StateBody_16_factory(Parser yyp) { return new StateBody_16(yyp); }
public static object KeyIntIntArgumentDeclarationList_factory(Parser yyp) { return new KeyIntIntArgumentDeclarationList(yyp); }
public static object ConstantExpression_1_factory(Parser yyp) { return new ConstantExpression_1(yyp); }
public static object VoidArgEvent_4_factory(Parser yyp) { return new VoidArgEvent_4(yyp); }
public static object FunctionCall_1_factory(Parser yyp) { return new FunctionCall_1(yyp); }
public static object Assignment_1_factory(Parser yyp) { return new Assignment_1(yyp); }
public static object Assignment_2_factory(Parser yyp) { return new Assignment_2(yyp); }
public static object IntVecVecArgEvent_1_factory(Parser yyp) { return new IntVecVecArgEvent_1(yyp); }
public static object TypecastExpression_1_factory(Parser yyp) { return new TypecastExpression_1(yyp); }
public static object SimpleAssignment_21_factory(Parser yyp) { return new SimpleAssignment_21(yyp); }
public static object SimpleAssignment_22_factory(Parser yyp) { return new SimpleAssignment_22(yyp); }
public static object KeyIntIntArgStateEvent_factory(Parser yyp) { return new KeyIntIntArgStateEvent(yyp); }
public static object TypecastExpression_9_factory(Parser yyp) { return new TypecastExpression_9(yyp); }
public static object VoidArgEvent_2_factory(Parser yyp) { return new VoidArgEvent_2(yyp); }
public static object Event_9_factory(Parser yyp) { return new Event_9(yyp); }
public static object ArgumentDeclarationList_1_factory(Parser yyp) { return new ArgumentDeclarationList_1(yyp); }
public static object ArgumentDeclarationList_2_factory(Parser yyp) { return new ArgumentDeclarationList_2(yyp); }
public static object GlobalDefinitions_1_factory(Parser yyp) { return new GlobalDefinitions_1(yyp); }
public static object GlobalDefinitions_2_factory(Parser yyp) { return new GlobalDefinitions_2(yyp); }
public static object IncrementDecrementExpression_factory(Parser yyp) { return new IncrementDecrementExpression(yyp); }
public static object GlobalVariableDeclaration_factory(Parser yyp) { return new GlobalVariableDeclaration(yyp); }
public static object IntArgumentDeclarationList_1_factory(Parser yyp) { return new IntArgumentDeclarationList_1(yyp); }
public static object IntDeclaration_1_factory(Parser yyp) { return new IntDeclaration_1(yyp); }
public static object ArgumentDeclarationList_5_factory(Parser yyp) { return new ArgumentDeclarationList_5(yyp); }
public static object IntVecVecArgumentDeclarationList_factory(Parser yyp) { return new IntVecVecArgumentDeclarationList(yyp); }
public static object VectorArgumentDeclarationList_1_factory(Parser yyp) { return new VectorArgumentDeclarationList_1(yyp); }
public static object KeyArgumentDeclarationList_factory(Parser yyp) { return new KeyArgumentDeclarationList(yyp); }
public static object TypecastExpression_2_factory(Parser yyp) { return new TypecastExpression_2(yyp); }
public static object KeyArgStateEvent_factory(Parser yyp) { return new KeyArgStateEvent(yyp); }
public static object TypecastExpression_5_factory(Parser yyp) { return new TypecastExpression_5(yyp); }
public static object TypecastExpression_8_factory(Parser yyp) { return new TypecastExpression_8(yyp); }
public static object Constant_1_factory(Parser yyp) { return new Constant_1(yyp); }
public static object Expression_factory(Parser yyp) { return new Expression(yyp); }
public static object Constant_3_factory(Parser yyp) { return new Constant_3(yyp); }
public static object Constant_4_factory(Parser yyp) { return new Constant_4(yyp); }
public static object IntArgEvent_5_factory(Parser yyp) { return new IntArgEvent_5(yyp); }
public static object BinaryExpression_1_factory(Parser yyp) { return new BinaryExpression_1(yyp); }
public static object IfStatement_2_factory(Parser yyp) { return new IfStatement_2(yyp); }
public static object IfStatement_3_factory(Parser yyp) { return new IfStatement_3(yyp); }
public static object KeyArgEvent_factory(Parser yyp) { return new KeyArgEvent(yyp); }
public static object Event_2_factory(Parser yyp) { return new Event_2(yyp); }
public static object JumpLabel_1_factory(Parser yyp) { return new JumpLabel_1(yyp); }
public static object RotationConstant_factory(Parser yyp) { return new RotationConstant(yyp); }
public static object Statement_12_factory(Parser yyp) { return new Statement_12(yyp); }
public static object Statement_13_factory(Parser yyp) { return new Statement_13(yyp); }
public static object UnaryExpression_1_factory(Parser yyp) { return new UnaryExpression_1(yyp); }
public static object UnaryExpression_2_factory(Parser yyp) { return new UnaryExpression_2(yyp); }
public static object UnaryExpression_3_factory(Parser yyp) { return new UnaryExpression_3(yyp); }
public static object ArgumentList_1_factory(Parser yyp) { return new ArgumentList_1(yyp); }
public static object KeyIntIntArgEvent_factory(Parser yyp) { return new KeyIntIntArgEvent(yyp); }
public static object ArgumentList_3_factory(Parser yyp) { return new ArgumentList_3(yyp); }
public static object Constant_factory(Parser yyp) { return new Constant(yyp); }
public static object State_factory(Parser yyp) { return new State(yyp); }
public static object StateBody_13_factory(Parser yyp) { return new StateBody_13(yyp); }
public static object KeyArgStateEvent_1_factory(Parser yyp) { return new KeyArgStateEvent_1(yyp); }
public static object SimpleAssignment_8_factory(Parser yyp) { return new SimpleAssignment_8(yyp); }
public static object LSLProgramRoot_factory(Parser yyp) { return new LSLProgramRoot(yyp); }
public static object StateChange_factory(Parser yyp) { return new StateChange(yyp); }
public static object VecDeclaration_1_factory(Parser yyp) { return new VecDeclaration_1(yyp); }
public static object GlobalVariableDeclaration_1_factory(Parser yyp) { return new GlobalVariableDeclaration_1(yyp); }
public static object GlobalVariableDeclaration_2_factory(Parser yyp) { return new GlobalVariableDeclaration_2(yyp); }
public static object IncrementDecrementExpression_5_factory(Parser yyp) { return new IncrementDecrementExpression_5(yyp); }
public static object ReturnStatement_factory(Parser yyp) { return new ReturnStatement(yyp); }
public static object StateBody_10_factory(Parser yyp) { return new StateBody_10(yyp); }
public static object StateBody_11_factory(Parser yyp) { return new StateBody_11(yyp); }
public static object StateBody_12_factory(Parser yyp) { return new StateBody_12(yyp); }
public static object IntVecVecArgStateEvent_1_factory(Parser yyp) { return new IntVecVecArgStateEvent_1(yyp); }
public static object KeyDeclaration_factory(Parser yyp) { return new KeyDeclaration(yyp); }
public static object IntArgEvent_6_factory(Parser yyp) { return new IntArgEvent_6(yyp); }
public static object ArgumentDeclarationList_3_factory(Parser yyp) { return new ArgumentDeclarationList_3(yyp); }
public static object ArgumentList_2_factory(Parser yyp) { return new ArgumentList_2(yyp); }
public static object IntArgEvent_10_factory(Parser yyp) { return new IntArgEvent_10(yyp); }
public static object CompoundStatement_factory(Parser yyp) { return new CompoundStatement(yyp); }
public static object TypecastExpression_3_factory(Parser yyp) { return new TypecastExpression_3(yyp); }
public static object IntArgumentDeclarationList_factory(Parser yyp) { return new IntArgumentDeclarationList(yyp); }
public static object ArgumentDeclarationList_4_factory(Parser yyp) { return new ArgumentDeclarationList_4(yyp); }
public static object SimpleAssignment_3_factory(Parser yyp) { return new SimpleAssignment_3(yyp); }
public static object SimpleAssignment_4_factory(Parser yyp) { return new SimpleAssignment_4(yyp); }
public static object Statement_1_factory(Parser yyp) { return new Statement_1(yyp); }
public static object Statement_2_factory(Parser yyp) { return new Statement_2(yyp); }
public static object Statement_4_factory(Parser yyp) { return new Statement_4(yyp); }
public static object Statement_5_factory(Parser yyp) { return new Statement_5(yyp); }
public static object Statement_6_factory(Parser yyp) { return new Statement_6(yyp); }
public static object Statement_8_factory(Parser yyp) { return new Statement_8(yyp); }
public static object Statement_9_factory(Parser yyp) { return new Statement_9(yyp); }
public static object ExpressionArgument_factory(Parser yyp) { return new ExpressionArgument(yyp); }
public static object GlobalFunctionDefinition_factory(Parser yyp) { return new GlobalFunctionDefinition(yyp); }
public static object State_1_factory(Parser yyp) { return new State_1(yyp); }
public static object DoWhileStatement_factory(Parser yyp) { return new DoWhileStatement(yyp); }
public static object ParenthesisExpression_1_factory(Parser yyp) { return new ParenthesisExpression_1(yyp); }
public static object ParenthesisExpression_2_factory(Parser yyp) { return new ParenthesisExpression_2(yyp); }
public static object StateBody_factory(Parser yyp) { return new StateBody(yyp); }
public static object Event_7_factory(Parser yyp) { return new Event_7(yyp); }
public static object Event_8_factory(Parser yyp) { return new Event_8(yyp); }
public static object IncrementDecrementExpression_1_factory(Parser yyp) { return new IncrementDecrementExpression_1(yyp); }
public static object IncrementDecrementExpression_2_factory(Parser yyp) { return new IncrementDecrementExpression_2(yyp); }
public static object IntVecVecArgumentDeclarationList_1_factory(Parser yyp) { return new IntVecVecArgumentDeclarationList_1(yyp); }
public static object IncrementDecrementExpression_4_factory(Parser yyp) { return new IncrementDecrementExpression_4(yyp); }
public static object IncrementDecrementExpression_6_factory(Parser yyp) { return new IncrementDecrementExpression_6(yyp); }
public static object IncrementDecrementExpression_7_factory(Parser yyp) { return new IncrementDecrementExpression_7(yyp); }
public static object StateEvent_factory(Parser yyp) { return new StateEvent(yyp); }
public static object IntArgEvent_3_factory(Parser yyp) { return new IntArgEvent_3(yyp); }
public static object IntArgEvent_4_factory(Parser yyp) { return new IntArgEvent_4(yyp); }
public static object KeyDeclaration_1_factory(Parser yyp) { return new KeyDeclaration_1(yyp); }
public static object Statement_3_factory(Parser yyp) { return new Statement_3(yyp); }
public static object IntArgEvent_7_factory(Parser yyp) { return new IntArgEvent_7(yyp); }
public static object IntArgEvent_8_factory(Parser yyp) { return new IntArgEvent_8(yyp); }
public static object SimpleAssignment_10_factory(Parser yyp) { return new SimpleAssignment_10(yyp); }
public static object StatementList_2_factory(Parser yyp) { return new StatementList_2(yyp); }
public static object IntRotRotArgStateEvent_1_factory(Parser yyp) { return new IntRotRotArgStateEvent_1(yyp); }
public static object VectorArgEvent_2_factory(Parser yyp) { return new VectorArgEvent_2(yyp); }
public static object Event_factory(Parser yyp) { return new Event(yyp); }
public static object SimpleAssignment_14_factory(Parser yyp) { return new SimpleAssignment_14(yyp); }
public static object SimpleAssignment_16_factory(Parser yyp) { return new SimpleAssignment_16(yyp); }
public static object SimpleAssignment_17_factory(Parser yyp) { return new SimpleAssignment_17(yyp); }
public static object SimpleAssignment_18_factory(Parser yyp) { return new SimpleAssignment_18(yyp); }
public static object Statement_10_factory(Parser yyp) { return new Statement_10(yyp); }
public static object Statement_11_factory(Parser yyp) { return new Statement_11(yyp); }
public static object SimpleAssignment_factory(Parser yyp) { return new SimpleAssignment(yyp); }
public static object TypecastExpression_factory(Parser yyp) { return new TypecastExpression(yyp); }
public static object JumpStatement_1_factory(Parser yyp) { return new JumpStatement_1(yyp); }
public static object SimpleAssignment_20_factory(Parser yyp) { return new SimpleAssignment_20(yyp); }
public static object Statement_7_factory(Parser yyp) { return new Statement_7(yyp); }
public static object SimpleAssignment_23_factory(Parser yyp) { return new SimpleAssignment_23(yyp); }
public static object SimpleAssignment_24_factory(Parser yyp) { return new SimpleAssignment_24(yyp); }
public static object SimpleAssignment_1_factory(Parser yyp) { return new SimpleAssignment_1(yyp); }
public static object SimpleAssignment_2_factory(Parser yyp) { return new SimpleAssignment_2(yyp); }
public static object BinaryExpression_factory(Parser yyp) { return new BinaryExpression(yyp); }
public static object FunctionCallExpression_factory(Parser yyp) { return new FunctionCallExpression(yyp); }
public static object SimpleAssignment_6_factory(Parser yyp) { return new SimpleAssignment_6(yyp); }
public static object StateBody_1_factory(Parser yyp) { return new StateBody_1(yyp); }
public static object StateBody_2_factory(Parser yyp) { return new StateBody_2(yyp); }
public static object StateBody_3_factory(Parser yyp) { return new StateBody_3(yyp); }
public static object StateBody_4_factory(Parser yyp) { return new StateBody_4(yyp); }
public static object StateBody_5_factory(Parser yyp) { return new StateBody_5(yyp); }
public static object StateBody_6_factory(Parser yyp) { return new StateBody_6(yyp); }
public static object StateBody_7_factory(Parser yyp) { return new StateBody_7(yyp); }
public static object StateBody_8_factory(Parser yyp) { return new StateBody_8(yyp); }
public static object StateBody_9_factory(Parser yyp) { return new StateBody_9(yyp); }
public static object Statement_factory(Parser yyp) { return new Statement(yyp); }
public static object IncrementDecrementExpression_3_factory(Parser yyp) { return new IncrementDecrementExpression_3(yyp); }
public static object JumpStatement_factory(Parser yyp) { return new JumpStatement(yyp); }
public static object BinaryExpression_11_factory(Parser yyp) { return new BinaryExpression_11(yyp); }
public static object IntArgEvent_factory(Parser yyp) { return new IntArgEvent(yyp); }
public static object IncrementDecrementExpression_8_factory(Parser yyp) { return new IncrementDecrementExpression_8(yyp); }
public static object BinaryExpression_14_factory(Parser yyp) { return new BinaryExpression_14(yyp); }
public static object BinaryExpression_15_factory(Parser yyp) { return new BinaryExpression_15(yyp); }
public static object BinaryExpression_16_factory(Parser yyp) { return new BinaryExpression_16(yyp); }
public static object BinaryExpression_6_factory(Parser yyp) { return new BinaryExpression_6(yyp); }
public static object BinaryExpression_7_factory(Parser yyp) { return new BinaryExpression_7(yyp); }
public static object Typename_2_factory(Parser yyp) { return new Typename_2(yyp); }
public static object Typename_4_factory(Parser yyp) { return new Typename_4(yyp); }
public static object ArgumentList_factory(Parser yyp) { return new ArgumentList(yyp); }
public static object BinaryExpression_12_factory(Parser yyp) { return new BinaryExpression_12(yyp); }
public static object BinaryExpression_13_factory(Parser yyp) { return new BinaryExpression_13(yyp); }
public static object GlobalFunctionDefinition_2_factory(Parser yyp) { return new GlobalFunctionDefinition_2(yyp); }
public static object StateChange_2_factory(Parser yyp) { return new StateChange_2(yyp); }
public static object VoidArgEvent_1_factory(Parser yyp) { return new VoidArgEvent_1(yyp); }
public static object VoidArgEvent_3_factory(Parser yyp) { return new VoidArgEvent_3(yyp); }
public static object BinaryExpression_10_factory(Parser yyp) { return new BinaryExpression_10(yyp); }
public static object VoidArgEvent_5_factory(Parser yyp) { return new VoidArgEvent_5(yyp); }
public static object VoidArgEvent_6_factory(Parser yyp) { return new VoidArgEvent_6(yyp); }
public static object VoidArgEvent_7_factory(Parser yyp) { return new VoidArgEvent_7(yyp); }
public static object VoidArgEvent_8_factory(Parser yyp) { return new VoidArgEvent_8(yyp); }
public static object BinaryExpression_17_factory(Parser yyp) { return new BinaryExpression_17(yyp); }
public static object StateEvent_1_factory(Parser yyp) { return new StateEvent_1(yyp); }
public static object VectorConstant_factory(Parser yyp) { return new VectorConstant(yyp); }
public static object VectorArgEvent_1_factory(Parser yyp) { return new VectorArgEvent_1(yyp); }
public static object IntDeclaration_factory(Parser yyp) { return new IntDeclaration(yyp); }
public static object VectorArgEvent_3_factory(Parser yyp) { return new VectorArgEvent_3(yyp); }
public static object TypecastExpression_4_factory(Parser yyp) { return new TypecastExpression_4(yyp); }
public static object TypecastExpression_6_factory(Parser yyp) { return new TypecastExpression_6(yyp); }
public static object TypecastExpression_7_factory(Parser yyp) { return new TypecastExpression_7(yyp); }
public static object FunctionCall_factory(Parser yyp) { return new FunctionCall(yyp); }
public static object ListConstant_1_factory(Parser yyp) { return new ListConstant_1(yyp); }
public static object BinaryExpression_18_factory(Parser yyp) { return new BinaryExpression_18(yyp); }
public static object Event_6_factory(Parser yyp) { return new Event_6(yyp); }
public static object KeyArgEvent_2_factory(Parser yyp) { return new KeyArgEvent_2(yyp); }
public static object Declaration_1_factory(Parser yyp) { return new Declaration_1(yyp); }
public static object EmptyStatement_1_factory(Parser yyp) { return new EmptyStatement_1(yyp); }
public static object SimpleAssignment_7_factory(Parser yyp) { return new SimpleAssignment_7(yyp); }
public static object ForLoop_factory(Parser yyp) { return new ForLoop(yyp); }
public static object ForLoop_2_factory(Parser yyp) { return new ForLoop_2(yyp); }
public static object KeyIntIntArgStateEvent_1_factory(Parser yyp) { return new KeyIntIntArgStateEvent_1(yyp); }
public static object KeyArgumentDeclarationList_1_factory(Parser yyp) { return new KeyArgumentDeclarationList_1(yyp); }
public static object GlobalFunctionDefinition_1_factory(Parser yyp) { return new GlobalFunctionDefinition_1(yyp); }
public static object IfStatement_factory(Parser yyp) { return new IfStatement(yyp); }
public static object ForLoopStatement_1_factory(Parser yyp) { return new ForLoopStatement_1(yyp); }
public static object ForLoopStatement_2_factory(Parser yyp) { return new ForLoopStatement_2(yyp); }
public static object ForLoopStatement_3_factory(Parser yyp) { return new ForLoopStatement_3(yyp); }
public static object IntRotRotArgumentDeclarationList_factory(Parser yyp) { return new IntRotRotArgumentDeclarationList(yyp); }
public static object IntArgEvent_1_factory(Parser yyp) { return new IntArgEvent_1(yyp); }
public static object IntArgEvent_2_factory(Parser yyp) { return new IntArgEvent_2(yyp); }
public static object WhileStatement_factory(Parser yyp) { return new WhileStatement(yyp); }
public static object ForLoop_1_factory(Parser yyp) { return new ForLoop_1(yyp); }
public static object Constant_2_factory(Parser yyp) { return new Constant_2(yyp); }
public static object VoidArgEvent_factory(Parser yyp) { return new VoidArgEvent(yyp); }
public static object RotDeclaration_factory(Parser yyp) { return new RotDeclaration(yyp); }
public static object WhileStatement_1_factory(Parser yyp) { return new WhileStatement_1(yyp); }
public static object WhileStatement_2_factory(Parser yyp) { return new WhileStatement_2(yyp); }
public static object VectorArgStateEvent_1_factory(Parser yyp) { return new VectorArgStateEvent_1(yyp); }
public static object IdentExpression_1_factory(Parser yyp) { return new IdentExpression_1(yyp); }
public static object VectorArgumentDeclarationList_factory(Parser yyp) { return new VectorArgumentDeclarationList(yyp); }
public static object States_factory(Parser yyp) { return new States(yyp); }
public static object VoidArgStateEvent_factory(Parser yyp) { return new VoidArgStateEvent(yyp); }
}
public class LSLSyntax
: Parser {
public LSLSyntax
():base(new yyLSLSyntax
(),new LSLTokens()) {}
public LSLSyntax
(YyParser syms):base(syms,new LSLTokens()) {}
public LSLSyntax
(YyParser syms,ErrorHandler erh):base(syms,new LSLTokens(erh)) {}

 }
}
